/*
 * Decompiled with CFR 0.152.
 */
package org.intellij.markdown.parser.markerblocks.impl;

import kotlin.PreconditionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.KotlinClass;
import kotlin.jvm.internal.Reflection;
import kotlin.reflect.KClass;
import org.intellij.markdown.IElementType;
import org.intellij.markdown.MarkdownElementTypes;
import org.intellij.markdown.parser.LookaheadText;
import org.intellij.markdown.parser.ProductionHolder;
import org.intellij.markdown.parser.constraints.MarkdownConstraints;
import org.intellij.markdown.parser.markerblocks.MarkdownParserUtil;
import org.intellij.markdown.parser.markerblocks.MarkerBlock;
import org.intellij.markdown.parser.markerblocks.MarkerBlockImpl;
import org.jetbrains.annotations.NotNull;

@KotlinClass(version={0, 25, 0}, abiVersion=25, data={"(\n)yA*[:u\u001b\u0006\u00148.\u001a:CY>\u001c7NC\u0002pe\u001eT\u0001\"\u001b8uK2d\u0017N\u001b\u0006\t[\u0006\u00148\u000eZ8x]*1\u0001/\u0019:tKJTA\"\\1sW\u0016\u0014(\r\\8dWNTA![7qY*yQ*\u0019:lKJ\u0014En\\2l\u00136\u0004HN\u0003\u0004=S:LGO\u0010\u0006\u000e[f\u001cuN\\:ue\u0006Lg\u000e^:\u000b'5\u000b'o\u001b3po:\u001cuN\\:ue\u0006Lg\u000e^:\u000b\u0017\r|gn\u001d;sC&tGo\u001d\u0006\u0007[\u0006\u00148.\u001a:\u000b\r5\u000b'o[3s\u0015A\u0001&o\u001c3vGRLwN\u001c%pY\u0012,'O\u0003\u0005mSN$H+\u001f9f\u0015\u0011\u0019\u0005.\u0019:\u000b\r-|G\u000f\\5o\u0015]\u0001&o\u001c3vGRLwN\u001c%pY\u0012,'\u000fJ'be.,'OC\bbY2|wo]*vE\ncwnY6t\u0015\u001d\u0011un\u001c7fC:T\u0011dY1mG:+\u0007\u0010^%oi\u0016\u0014Xm\u001d;j]\u001e|eMZ:fi*\u0019\u0001o\\:\u000b\u0011A{7/\u001b;j_:TQ\u0002T8pW\u0006DW-\u00193UKb$(bA%oi*1Bj\\8lC\",\u0017\r\u001a+fqR$\u0003k\\:ji&|gN\u0003\be_B\u0013xnY3tgR{7.\u001a8\u000b%\r,(O]3oi\u000e{gn\u001d;sC&tGo\u001d\u0006\u0011!J|7-Z:tS:<'+Z:vYRT1\"T1sW\u0016\u0014(\t\\8dW*aR*\u0019:lKJ\u0014En\\2lIA\u0013xnY3tg&twMU3tk2$(\u0002E4fi\u0012+g-Y;mi\u0006\u001bG/[8o\u00155\u0019En\\:j]\u001e\f5\r^5p]*IR*\u0019:lKJ\u0014En\\2lI\rcwn]5oO\u0006\u001bG/[8o\u0015I9W\r\u001e#fM\u0006,H\u000e\u001e(pI\u0016$\u0016\u0010]3\u000b\u0019%+E.Z7f]R$\u0016\u0010]3\u000b'%\u001c\u0018J\u001c;fe\u0016\u001cH/\u001b8h\u001f\u001a47/\u001a;A\u0004)\u0011\u0001#\u0001\u0006\u0005\u0011\u0001\u0001\"A\u0003\u0003\t\u0003A\u0019!\u0002\u0002\u0005\u0003!\u0011QA\u0001C\u0002\u0011\u000b)!\u0001\u0002\u0002\t\u0007\u0015\u0019AQ\u0001\u0005\u0001\u0019\u0001)1\u0001\u0002\u0002\t\b1\u0001QA\u0001C\u0002\u0011\u0017)1\u0001\u0002\u0003\t\u000b1\u0001Qa\u0001C\u0002\u0011\u001da\u0001!B\u0002\u0005\u000b!5A\u0002A\u0003\u0002\u0011#)1\u0001\u0002\u0004\t\u00111\u0001QA\u0001\u0003\u0005\u0011\u0015)!\u0001b\u0001\t\u0013\u0015\u0019AA\u0002\u0005\u000b\u0019\u0001)1\u0001b\u0001\t\u00191\u0001Qa\u0001C\t\u0011/a\u0001!B\u0002\u0005\r!eA\u0002A\u0003\u0003\t\u0007AQ\"B\u0002\u0005\u0005!yA\u0002A\u0003\u0004\t+Ai\u0002\u0004\u0001\u0006\u0005\u0011\u0011\u0001rD\u0003\u0004\t+A\t\u0003\u0004\u0001\u0006\u0005\u0011\u0011\u0001\"E\u0003\u0004\t\u0005A!\u0003\u0004\u0001\u0006\u0005\u0011\t\u0001B\u0005\u0003\u0004\u0019\rI2!B\u0001\t\ba\u001dQ\u0006\u0004\u0003b\ta=\u0011eA\u0003\u0002\u0011\u001bAj!V\u0002\u0005\u000b\r!y!C\u0001\u0005\u00035VAa\u0003M\nC\r)\u0011\u0001\u0003\u0005\u0019\u0011E\u001b1\u0001b\u0005\n\u0003\u0011\u0005Q&\u0006\u0003\u000b1+iz\u0001\u0002\u0001\t\u00175\u0019Q!\u0001\u0005\n1%\u00016\u0001A\u0011\u0004\u000b\u0005A\u0019\u0002g\u0005R\u0007\u0015!)\"C\u0001\u0005\u00065\t\u0001BCW \t)AZ\"h\u0004\u0005\u0001!YQbA\u0003\u0002\u0011%A\u0012\u0002U\u0002\u0001;\u001f!\u0001\u0001\u0003\b\u000e\u0007\u0015\t\u0001\u0012\u0002M\u0005!\u000e\u0005\u0011eA\u0003\u0002\u0011-A2\"U\u0002\b\t7I\u0011\u0001c\u0006\u000e\u0003!QQ\"\u0001\u0005\b[+!!\u0002\u0007\t\"\u0007\u0015\t\u0001\u0002\u0004\r\r#\u000e\u0019A\u0001E\u0005\u0002\u00113i+\u0002B\u0006\u0019$\u0005\u001aQ!\u0001\u0005\u000e15\t6a\u0001C\u0012\u0013\u0005AY\"L\u000b\u0005\u0017a\u0015Rt\u0002\u0003\u0001\u0011-i1!B\u0001\t\u0013aI\u0001k\u0001\u0001\"\u0007\u0015\t\u0001\u0002\u0003\r\t#\u000e)AQE\u0005\u0002\t\u0003i\u0011\u0001\u0003\u00066X\u0015UCa9\u0001\u0019\tu=A\u0001\u0001E\u0005\u001b\r)\u0011\u0001#\u0003\u0019\nA\u001b\u0001!h\u0004\u0005\u0001!1QbA\u0003\u0002\u0011\u0017AZ\u0001UB\u0001;\u001f!\u0001\u0001c\u0004\u000e\u0007\u0015\t\u0001R\u0002M\u0007!\u000e\t\u0011eA\u0003\u0002\u0011\rA2!U\u0002\n\t\u0011I\u0011\u0001\u0002\u0001\u000e\u0003!9Q\"\u0001E\b\u001b\u0005!\u0011\u0001"})
public final class ListMarkerBlock
extends MarkerBlockImpl {
    public static final /* synthetic */ KClass $kotlinClass;
    private final char listType;

    static {
        $kotlinClass = Reflection.createKotlinClass(ListMarkerBlock.class);
    }

    @Override
    public boolean allowsSubBlocks() {
        return true;
    }

    @Override
    public boolean isInterestingOffset(@NotNull LookaheadText.Position pos) {
        Intrinsics.checkParameterIsNotNull((Object)pos, (String)"pos");
        return pos.getChar() == '\n';
    }

    @Override
    @NotNull
    protected MarkerBlock.ClosingAction getDefaultAction() {
        return MarkerBlock.ClosingAction.DONE;
    }

    @Override
    protected int calcNextInterestingOffset(@NotNull LookaheadText.Position pos) {
        Intrinsics.checkParameterIsNotNull((Object)pos, (String)"pos");
        Integer n = pos.getNextLineOffset();
        return n != null ? ((Number)n).intValue() : -1;
    }

    @Override
    @NotNull
    protected MarkerBlock.ProcessingResult doProcessToken(@NotNull LookaheadText.Position pos, @NotNull MarkdownConstraints currentConstraints) {
        Intrinsics.checkParameterIsNotNull((Object)pos, (String)"pos");
        Intrinsics.checkParameterIsNotNull((Object)currentConstraints, (String)"currentConstraints");
        PreconditionsKt.assert((pos.getChar() == '\n' ? 1 : 0) != 0);
        int eolN = MarkdownParserUtil.INSTANCE$.calcNumberOfConsequentEols(pos, this.getConstraints());
        if (eolN >= 3) {
            return MarkerBlock.ProcessingResult.Companion.getDEFAULT();
        }
        LookaheadText.Position position = MarkdownParserUtil.INSTANCE$.getFirstNonWhitespaceLinePos(pos, eolN);
        if (position == null) {
            return MarkerBlock.ProcessingResult.Companion.getDEFAULT();
        }
        LookaheadText.Position nonemptyPos = position;
        MarkdownConstraints nextLineConstraints = MarkdownConstraints.Companion.fromBase(nonemptyPos, this.getConstraints());
        if (!nextLineConstraints.extendsList(this.getConstraints())) {
            return MarkerBlock.ProcessingResult.Companion.getDEFAULT();
        }
        return MarkerBlock.ProcessingResult.Companion.getPASS();
    }

    @Override
    @NotNull
    public IElementType getDefaultNodeType() {
        return this.listType == '-' || this.listType == '*' || this.listType == '+' ? MarkdownElementTypes.Companion.getUNORDERED_LIST() : MarkdownElementTypes.Companion.getORDERED_LIST();
    }

    public ListMarkerBlock(@NotNull MarkdownConstraints myConstraints, @NotNull ProductionHolder.Marker marker, char listType) {
        Intrinsics.checkParameterIsNotNull((Object)myConstraints, (String)"myConstraints");
        Intrinsics.checkParameterIsNotNull((Object)marker, (String)"marker");
        super(myConstraints, marker);
        this.listType = listType;
    }
}

