/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.eval4j;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.CollectionsKt;
import kotlin.TypeCastException;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.KotlinClass;
import kotlin.jvm.internal.Reflection;
import kotlin.reflect.KClass;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.eval4j.Eval;
import org.jetbrains.eval4j.LabelValue;
import org.jetbrains.eval4j.MembersKt;
import org.jetbrains.eval4j.NOT_A_VALUE;
import org.jetbrains.eval4j.ObjectValue;
import org.jetbrains.eval4j.UnsupportedByteCodeException;
import org.jetbrains.eval4j.Value;
import org.jetbrains.eval4j.ValuesKt;
import org.jetbrains.org.objectweb.asm.Handle;
import org.jetbrains.org.objectweb.asm.Opcodes;
import org.jetbrains.org.objectweb.asm.Type;
import org.jetbrains.org.objectweb.asm.tree.AbstractInsnNode;
import org.jetbrains.org.objectweb.asm.tree.FieldInsnNode;
import org.jetbrains.org.objectweb.asm.tree.IincInsnNode;
import org.jetbrains.org.objectweb.asm.tree.IntInsnNode;
import org.jetbrains.org.objectweb.asm.tree.JumpInsnNode;
import org.jetbrains.org.objectweb.asm.tree.LabelNode;
import org.jetbrains.org.objectweb.asm.tree.LdcInsnNode;
import org.jetbrains.org.objectweb.asm.tree.MethodInsnNode;
import org.jetbrains.org.objectweb.asm.tree.MultiANewArrayInsnNode;
import org.jetbrains.org.objectweb.asm.tree.TypeInsnNode;
import org.jetbrains.org.objectweb.asm.tree.analysis.AnalyzerException;
import org.jetbrains.org.objectweb.asm.tree.analysis.Interpreter;

@KotlinClass(version={0, 25, 0}, abiVersion=25, data={"<\b)a2+\u001b8hY\u0016Len\u001d;sk\u000e$\u0018n\u001c8J]R,'\u000f\u001d:fi\u0016\u0014(bA8sO*I!.\u001a;ce\u0006Lgn\u001d\u0006\u0007KZ\fG\u000e\u000e6\u000b\u0017%sG/\u001a:qe\u0016$XM\u001d\u0006\n_\nTWm\u0019;xK\nT1!Y:n\u0015\u0011!(/Z3\u000b\u0011\u0005t\u0017\r\\=tSNTQAV1mk\u0016Ta\u0001P5oSRt$\u0002B3wC2TA!\u0012<bY*y!-\u001b8bef|\u0005/\u001a:bi&|gN\u0003\u0003j]Nt'\u0002E!cgR\u0014\u0018m\u0019;J]Ntgj\u001c3f\u0015\u00191\u0018\r\\;fc)1a/\u00197vKJRAc\u00195fG.\u0014\u0015N\\1ss\u000e{g\u000eZ5uS>t'BB8qG>$WMC\u0002J]RTaa[8uY&t'b\u0002\"p_2,\u0017M\u001c\u0006\u0014G\",7m[+oCJL8i\u001c8eSRLwN\u001c\u0006\u0006m\u0006dW/\u001a\u0006\u000eG>\u0004\u0018p\u00149fe\u0006$\u0018n\u001c8\u000b\u000b5,'oZ3\u000b\u0003YT\u0011a\u001e\u0006\u000e]\u0006\u0014\u0018p\u00149fe\u0006$\u0018n\u001c8\u000b\rY\fG.^3t\u0015\u0011a\u0015n\u001d;\u000b\t)\fg/\u0019\u0006\u0005kRLGN\u0003\u0007oK^|\u0005/\u001a:bi&|gN\u0003\u0005oK^4\u0016\r\\;f\u0015\u0011!\u0018\u0010]3\u000b\tQK\b/\u001a\u0006\u0010e\u0016$XO\u001d8Pa\u0016\u0014\u0018\r^5p]*AQ\r\u001f9fGR,GM\u0003\u0003V]&$(\u0002\u0005;fe:\f'/_(qKJ\fG/[8o\u0015\u00191\u0018\r\\;fg)qQO\\1ss>\u0003XM]1uS>t'6\u0001\u0006\u0003!\u0005QA\u0001\u0003\u0001\u0011\u0005)!\u0001\"\u0001\t\u0004\u0015\u0019A!\u0001\u0005\u0001\u0019\u0001)!\u0001\"\u0001\t\u0002\u0015\u0011AA\u0001E\u0003\u000b\t!)\u0001C\u0002\u0006\u0005\u0011\u0019\u0001rA\u0003\u0003\t\u000fAA!B\u0002\u0005\t!\u0011A\u0002A\u0003\u0004\t\u0005AI\u0001\u0004\u0001\u0006\u0007\u0011\t\u0001B\u0002\u0007\u0001\u000b\t!\u0011\u0001\u0003\u0004\u0006\u0007\u0011\u001d\u0001r\u0002\u0007\u0001\u000b\t!\u0011\u0001#\u0003\u0006\u0005\u0011\u001d\u0001rB\u0003\u0002\u0011+)1\u0001\u0002\u0005\t\u00151\u0001Qa\u0001\u0003\t\u0011-a\u0001!B\u0002\u0005\u0011!}A\u0002A\u0003\u0002\u0011A)!\u0001\u0002\u0006\t\"\u0015\u0011AQ\u0003E\u0010\u000b\r!1\u0001#\n\r\u0001\u0015\u0011Aa\u0001E\u0013\u000b\r!\u0001\u0002\u0003\u000b\r\u0001\u0011\u0019A2A\r\t\u000b\u0005AI!\u0003\u0003\n\u0007\u0015\t\u0001\"\u0002\r\u00061\u0013iC\u0002B1\u00051\u0017\t3!B\u0001\t\fa-Qk\u0001\u0003\u0006\u0007\u0011-\u0011\"\u0001\u0005\u0007[-\"1\u0002'\u0004\u001e\u0010\u0011\u0001\u0001bB\u0007\u0004\u000b\u0005Ai\u0001'\u0004Q\u0007\u0001iz\u0001\u0002\u0001\t\u00115\u0019Q!\u0001\u0005\u00061\u0015\u00016\u0011AO\b\t\u0001A\t\"D\u0002\u0006\u0003!)\u0001$\u0002)\u0004\u0003\u0005\"Q!\u0001\u0005\u0006\u0019\u0003AR!U\u0002\n\t\u001bI\u0011\u0001C\u0004\u000e\u0003!=Q\"\u0001\u0005\b\u001b\u0005Aq!\f\u0016\u0005\u0007aIQt\u0002\u0003\u0001\u0011!i1!B\u0001\t\u000ba)\u0001k\u0001\u0001\u001e\u0010\u0011\u0001\u0001\u0012C\u0007\u0004\u000b\u0005AQ\u0001G\u0003Q\u0007\u0003iz\u0001\u0002\u0001\t\u00145\u0019Q!\u0001E\t1#\u00016!A\u0011\u0004\u000b\u0005A\u0011\u0002G\u0005R\u0007%!\u0011\"C\u0001\u0005\u00025\t\u0001bB\u0007\u0002\u0011\u001di\u0011\u0001\"\u0002.@\u0011\u0019\u0001tCO\b\t\u0001AA\"D\u0002\u0006\u0003!)\u0001$\u0002)\u0004\u0001u=A\u0001\u0001E\n\u001b\r)\u0011\u0001#\u0005\u0019\u0012A\u001b\t!I\u0002\u0006\u0003!I\u0001$C)\u0004\u000f\u0011]\u0011\"\u0001C\u0001\u001b\u0005Aq!D\u0001\u0005\u00065~Ba\u0003M\r;\u001f!\u0001\u0001C\u0004\u000e\u0007\u0015\t\u0001R\u0002M\u0007!\u000e\u0001Qt\u0002\u0003\u0001\u00111i1!B\u0001\t\u000ba)\u0001k!\u0001\"\u0007\u0015\t\u0001\"\u0002\r\u0006#\u000e9A\u0011D\u0005\u0002\u0011\u001di\u0011\u0001c\u0004\u000e\u0003!9Qv\b\u0003\f15iz\u0001\u0002\u0001\t\u001c5\u0019Q!\u0001\u0005\u00061\u0015\u00016\u0001AO\b\t\u0001Aa\"D\u0002\u0006\u0003!)\u0001$\u0002)\u0004\u0002\u0005\u001aQ!\u0001\u0005\u00061\u0015\t6a\u0002\u0003\u000e\u0013\u0005Aq!D\u0001\t\u000f5\t\u0001bBW%\t-Aj\"h\u0004\u0005\u0001!9QbA\u0003\u0002\u0011\u001bAj\u0001U\u0002\u0001;3!\u0001\u0001C\b\u000e\u0011\u0015\t\u00012C\u0005\u0005\u0013\r)\u0011\u0001C\u0003\u0019\u000baM\u0001k!\u0001\"\u0007\u0015\t\u0001\"\u0002\r\u0006#\u000e9AQD\u0005\u0002\u0011\u001di\u0011\u0001c\u0004\u000e\u0003!YQF\u0006\u0003\f1Eiz\u0001\u0002\u0001\t\u000f5\u0019Q!\u0001E\u00071\u001b\u00016\u0001A\u0011\u0005\u000b\u0005AQ\u0001$\u0001\u0019\u000bE\u001bQ\u0001B\t\n\u0003!9Q\"\u0001E\b[]!1\u0002g\t\u001e\u0012\u0011\u0001\u0001BE\u0007\u0005\u000b\u0005A9\u0002$\u0001\u0019\u0018A\u001b\u0001!\t\u0003\u0006\u0003!)A\u0012\u0001\r\u0006#\u000e)A1E\u0005\u0002\u0011\u001di\u0011\u0001\u0003\u0007.U\u0011Y\u0001dEO\b\t\u0001Aq!D\u0002\u0006\u0003!5\u0001T\u0002)\u0004\u0001u=A\u0001\u0001\u0005\r\u001b\r)\u0011\u0001C\u0003\u0019\u000bA\u001b\t!h\u0004\u0005\u0001!\u001dRbA\u0003\u0002\u0011\u0015AR\u0001U\u0002\u0002C\r)\u0011\u0001#\u0007\u0019\u001aE\u001b\u0011\u0002B\n\n\u0003\u0011\u0001Q\"\u0001E\b\u001b\u0005Aq!D\u0001\t\u000f5.Da\u0003M\u0015;\u001f!\u0001\u0001C\u0004\u000e\u0007\u0015\t\u0001R\u0002M\u0007!\u000e\u0001Qt\u0002\u0003\u0001\u0011!i1!B\u0001\t\u000ba)\u0001k!\u0001\u001e\u0010\u0011\u0001\u0001\u0012C\u0007\u0004\u000b\u0005AQ\u0001G\u0003Q\u0007\u0005iz\u0001\u0002\u0001\t+5\u0019Q!\u0001\u0005\u00061\u0015\u000161A\u0011\u0005\u000b\u0005AQ\u0001$\u0001\u0019\u000bE\u001b1\u0002\"\u000b\n\u0003!9Q\"\u0001E\b\u001b\u0005Aq!D\u0001\t\u000f5\t\u0001bBW!\t-AZ#h\u0004\u0005\u0001!9QbA\u0003\u0002\u0011\u001bAj\u0001U\u0002\u0001;\u001f!\u0001\u0001\u0003\u0007\u000e\u0007\u0015\t\u0001\"\u0002\r\u0006!\u000e\u0005\u0011\u0005B\u0003\u0002\u0011\u0015a\t\u0001G\u0003R\u0007\u001d!Y#C\u0001\t\u000f5\t\u0001rB\u0007\u0002\u0011\u001d)l#b\u000b\u0005G\u0004AR!h\u0004\u0005\u0001!-QbA\u0003\u0002\u0011\u0017AZ\u0001U\u0002\u0001C\r)\u0011\u0001c\u0001\u0019\u0004E\u001bQ\u0001B\u0003\n\u0003\u0011\u0001Q\"\u0001\u0005\u0007"})
public final class SingleInstructionInterpreter
extends Interpreter<Value> {
    public static final /* synthetic */ KClass $kotlinClass;
    private final Eval eval;

    static {
        $kotlinClass = Reflection.createKotlinClass(SingleInstructionInterpreter.class);
    }

    @Nullable
    public Value newValue(@Nullable Type type2) {
        if (type2 == null) {
            return NOT_A_VALUE.INSTANCE$;
        }
        return ValuesKt.makeNotInitializedValue(type2);
    }

    /*
     * Enabled aggressive block sorting
     */
    @Nullable
    public Value newOperation(@NotNull AbstractInsnNode insn) {
        Value value2;
        Intrinsics.checkParameterIsNotNull((Object)insn, (String)"insn");
        int n = insn.getOpcode();
        if (n == Opcodes.ACONST_NULL) {
            return ValuesKt.getNULL_VALUE();
        }
        if (n == Opcodes.ICONST_M1) {
            value2 = ValuesKt.int(-1);
            return value2;
        }
        if (n == Opcodes.ICONST_0) {
            value2 = ValuesKt.int(0);
            return value2;
        }
        if (n == Opcodes.ICONST_1) {
            value2 = ValuesKt.int(1);
            return value2;
        }
        if (n == Opcodes.ICONST_2) {
            value2 = ValuesKt.int(2);
            return value2;
        }
        if (n == Opcodes.ICONST_3) {
            value2 = ValuesKt.int(3);
            return value2;
        }
        if (n == Opcodes.ICONST_4) {
            value2 = ValuesKt.int(4);
            return value2;
        }
        if (n == Opcodes.ICONST_5) {
            value2 = ValuesKt.int(5);
            return value2;
        }
        if (n == Opcodes.LCONST_0) {
            value2 = ValuesKt.long(0L);
            return value2;
        }
        if (n == Opcodes.LCONST_1) {
            value2 = ValuesKt.long(1L);
            return value2;
        }
        if (n == Opcodes.FCONST_0) {
            value2 = ValuesKt.float(0.0f);
            return value2;
        }
        if (n == Opcodes.FCONST_1) {
            value2 = ValuesKt.float(1.0f);
            return value2;
        }
        if (n == Opcodes.FCONST_2) {
            value2 = ValuesKt.float(2.0f);
            return value2;
        }
        if (n == Opcodes.DCONST_0) {
            value2 = ValuesKt.double(0.0);
            return value2;
        }
        if (n == Opcodes.DCONST_1) {
            value2 = ValuesKt.double(1.0);
            return value2;
        }
        if (n == Opcodes.BIPUSH || n == Opcodes.SIPUSH) {
            AbstractInsnNode abstractInsnNode = insn;
            if (abstractInsnNode == null) {
                throw new TypeCastException("null cannot be cast to non-null type org.jetbrains.org.objectweb.asm.tree.IntInsnNode");
            }
            value2 = ValuesKt.int(((IntInsnNode)abstractInsnNode).operand);
            return value2;
        }
        if (n == Opcodes.LDC) {
            AbstractInsnNode abstractInsnNode = insn;
            if (abstractInsnNode == null) {
                throw new TypeCastException("null cannot be cast to non-null type org.jetbrains.org.objectweb.asm.tree.LdcInsnNode");
            }
            Object cst = ((LdcInsnNode)abstractInsnNode).cst;
            Object object = cst;
            if (object instanceof Integer) {
                value2 = ValuesKt.int(((Number)cst).intValue());
                return value2;
            }
            if (object instanceof Float) {
                value2 = ValuesKt.float(((Number)cst).floatValue());
                return value2;
            }
            if (object instanceof Long) {
                value2 = ValuesKt.long(((Number)cst).longValue());
                return value2;
            }
            if (object instanceof Double) {
                value2 = ValuesKt.double(((Number)cst).doubleValue());
                return value2;
            }
            if (object instanceof String) {
                value2 = this.eval.loadString((String)cst);
                return value2;
            }
            if (!(object instanceof Type)) {
                if (!(object instanceof Handle)) throw (Throwable)new UnsupportedByteCodeException("Illegal LDC constant " + cst);
                throw (Throwable)new UnsupportedByteCodeException("Method handles are not supported");
            }
            int sort = ((Type)cst).getSort();
            switch (sort) {
                case 9: 
                case 10: {
                    value2 = this.eval.loadClass((Type)cst);
                    return value2;
                }
                case 11: {
                    throw (Throwable)new UnsupportedByteCodeException("Mothod handles are not supported");
                }
            }
            throw (Throwable)new UnsupportedByteCodeException("Illegal LDC constant " + cst);
        }
        if (n == Opcodes.JSR) {
            AbstractInsnNode abstractInsnNode = insn;
            if (abstractInsnNode == null) {
                throw new TypeCastException("null cannot be cast to non-null type org.jetbrains.org.objectweb.asm.tree.JumpInsnNode");
            }
            LabelNode labelNode = ((JumpInsnNode)abstractInsnNode).label;
            Intrinsics.checkExpressionValueIsNotNull((Object)labelNode, (String)"(insn as JumpInsnNode).label");
            value2 = new LabelValue(labelNode);
            return value2;
        }
        if (n == Opcodes.GETSTATIC) {
            AbstractInsnNode abstractInsnNode = insn;
            if (abstractInsnNode == null) {
                throw new TypeCastException("null cannot be cast to non-null type org.jetbrains.org.objectweb.asm.tree.FieldInsnNode");
            }
            value2 = this.eval.getStaticField(MembersKt.FieldDescription((FieldInsnNode)abstractInsnNode));
            return value2;
        }
        if (n != Opcodes.NEW) throw (Throwable)new UnsupportedByteCodeException(String.valueOf(insn));
        AbstractInsnNode abstractInsnNode = insn;
        if (abstractInsnNode == null) {
            throw new TypeCastException("null cannot be cast to non-null type org.jetbrains.org.objectweb.asm.tree.TypeInsnNode");
        }
        Type type2 = Type.getObjectType((String)((TypeInsnNode)abstractInsnNode).desc);
        Intrinsics.checkExpressionValueIsNotNull((Object)type2, (String)"Type.getObjectType((insn as TypeInsnNode).desc)");
        value2 = this.eval.newInstance(type2);
        return value2;
    }

    @NotNull
    public Value copyOperation(@NotNull AbstractInsnNode insn, @NotNull Value value2) {
        Intrinsics.checkParameterIsNotNull((Object)insn, (String)"insn");
        Intrinsics.checkParameterIsNotNull((Object)value2, (String)"value");
        return value2;
    }

    @Nullable
    public Value unaryOperation(@NotNull AbstractInsnNode insn, @NotNull Value value2) {
        Value value3;
        Intrinsics.checkParameterIsNotNull((Object)insn, (String)"insn");
        Intrinsics.checkParameterIsNotNull((Object)value2, (String)"value");
        int n = insn.getOpcode();
        if (n == Opcodes.INEG) {
            value3 = ValuesKt.int(-ValuesKt.getInt(value2));
        } else if (n == Opcodes.IINC) {
            AbstractInsnNode abstractInsnNode = insn;
            if (abstractInsnNode == null) {
                throw new TypeCastException("null cannot be cast to non-null type org.jetbrains.org.objectweb.asm.tree.IincInsnNode");
            }
            value3 = ValuesKt.int(ValuesKt.getInt(value2) + ((IincInsnNode)abstractInsnNode).incr);
        } else if (n == Opcodes.L2I) {
            value3 = ValuesKt.int((int)ValuesKt.getLong(value2));
        } else if (n == Opcodes.F2I) {
            value3 = ValuesKt.int((int)ValuesKt.getFloat(value2));
        } else if (n == Opcodes.D2I) {
            value3 = ValuesKt.int((int)ValuesKt.getDouble(value2));
        } else if (n == Opcodes.I2B) {
            value3 = ValuesKt.byte((byte)ValuesKt.getInt(value2));
        } else if (n == Opcodes.I2C) {
            value3 = ValuesKt.char((char)ValuesKt.getInt(value2));
        } else if (n == Opcodes.I2S) {
            value3 = ValuesKt.short((short)ValuesKt.getInt(value2));
        } else if (n == Opcodes.FNEG) {
            value3 = ValuesKt.float(-ValuesKt.getFloat(value2));
        } else if (n == Opcodes.I2F) {
            value3 = ValuesKt.float(ValuesKt.getInt(value2));
        } else if (n == Opcodes.L2F) {
            value3 = ValuesKt.float(ValuesKt.getLong(value2));
        } else if (n == Opcodes.D2F) {
            value3 = ValuesKt.float((float)ValuesKt.getDouble(value2));
        } else if (n == Opcodes.LNEG) {
            value3 = ValuesKt.long(-ValuesKt.getLong(value2));
        } else if (n == Opcodes.I2L) {
            value3 = ValuesKt.long(ValuesKt.getInt(value2));
        } else if (n == Opcodes.F2L) {
            value3 = ValuesKt.long((long)ValuesKt.getFloat(value2));
        } else if (n == Opcodes.D2L) {
            value3 = ValuesKt.long((long)ValuesKt.getDouble(value2));
        } else if (n == Opcodes.DNEG) {
            value3 = ValuesKt.double(-ValuesKt.getDouble(value2));
        } else if (n == Opcodes.I2D) {
            value3 = ValuesKt.double(ValuesKt.getInt(value2));
        } else if (n == Opcodes.L2D) {
            value3 = ValuesKt.double(ValuesKt.getLong(value2));
        } else if (n == Opcodes.F2D) {
            value3 = ValuesKt.double(ValuesKt.getFloat(value2));
        } else if (n == Opcodes.IFEQ || n == Opcodes.IFNE || n == Opcodes.IFLT || n == Opcodes.IFGE || n == Opcodes.IFGT || n == Opcodes.IFLE || n == Opcodes.IFNULL || n == Opcodes.IFNONNULL) {
            value3 = null;
        } else {
            if (n == Opcodes.TABLESWITCH || n == Opcodes.LOOKUPSWITCH) {
                throw (Throwable)new UnsupportedByteCodeException("Switch is not supported yet");
            }
            if (n == Opcodes.PUTSTATIC) {
                AbstractInsnNode abstractInsnNode = insn;
                if (abstractInsnNode == null) {
                    throw new TypeCastException("null cannot be cast to non-null type org.jetbrains.org.objectweb.asm.tree.FieldInsnNode");
                }
                this.eval.setStaticField(MembersKt.FieldDescription((FieldInsnNode)abstractInsnNode), value2);
                value3 = null;
            } else if (n == Opcodes.GETFIELD) {
                AbstractInsnNode abstractInsnNode = insn;
                if (abstractInsnNode == null) {
                    throw new TypeCastException("null cannot be cast to non-null type org.jetbrains.org.objectweb.asm.tree.FieldInsnNode");
                }
                value3 = this.eval.getField(value2, MembersKt.FieldDescription((FieldInsnNode)abstractInsnNode));
            } else if (n == Opcodes.NEWARRAY) {
                String string;
                AbstractInsnNode abstractInsnNode = insn;
                if (abstractInsnNode == null) {
                    throw new TypeCastException("null cannot be cast to non-null type org.jetbrains.org.objectweb.asm.tree.IntInsnNode");
                }
                int n2 = ((IntInsnNode)abstractInsnNode).operand;
                if (n2 == Opcodes.T_BOOLEAN) {
                    string = "[Z";
                } else if (n2 == Opcodes.T_CHAR) {
                    string = "[C";
                } else if (n2 == Opcodes.T_BYTE) {
                    string = "[B";
                } else if (n2 == Opcodes.T_SHORT) {
                    string = "[S";
                } else if (n2 == Opcodes.T_INT) {
                    string = "[I";
                } else if (n2 == Opcodes.T_FLOAT) {
                    string = "[F";
                } else if (n2 == Opcodes.T_DOUBLE) {
                    string = "[D";
                } else if (n2 == Opcodes.T_LONG) {
                    string = "[J";
                } else {
                    throw (Throwable)new AnalyzerException(insn, "Invalid array type");
                }
                String typeStr = string;
                Type type2 = Type.getType((String)typeStr);
                Intrinsics.checkExpressionValueIsNotNull((Object)type2, (String)"Type.getType(typeStr)");
                value3 = this.eval.newArray(type2, ValuesKt.getInt(value2));
            } else if (n == Opcodes.ANEWARRAY) {
                AbstractInsnNode abstractInsnNode = insn;
                if (abstractInsnNode == null) {
                    throw new TypeCastException("null cannot be cast to non-null type org.jetbrains.org.objectweb.asm.tree.TypeInsnNode");
                }
                String desc = ((TypeInsnNode)abstractInsnNode).desc;
                Type type3 = Type.getType((String)("[" + Type.getObjectType((String)desc)));
                Intrinsics.checkExpressionValueIsNotNull((Object)type3, (String)"Type.getType(\"[\" + Type.getObjectType(desc))");
                value3 = this.eval.newArray(type3, ValuesKt.getInt(value2));
            } else if (n == Opcodes.ARRAYLENGTH) {
                value3 = this.eval.getArrayLength(value2);
            } else if (n == Opcodes.ATHROW) {
                value3 = null;
            } else if (n == Opcodes.CHECKCAST) {
                ObjectValue objectValue;
                AbstractInsnNode abstractInsnNode = insn;
                if (abstractInsnNode == null) {
                    throw new TypeCastException("null cannot be cast to non-null type org.jetbrains.org.objectweb.asm.tree.TypeInsnNode");
                }
                Type targetType = Type.getObjectType((String)((TypeInsnNode)abstractInsnNode).desc);
                if (Intrinsics.areEqual((Object)value2, (Object)ValuesKt.getNULL_VALUE())) {
                    objectValue = ValuesKt.getNULL_VALUE();
                } else {
                    Type type4 = targetType;
                    Intrinsics.checkExpressionValueIsNotNull((Object)type4, (String)"targetType");
                    if (this.eval.isInstanceOf(value2, type4)) {
                        Object object = ValuesKt.obj$default(value2, null, 1);
                        Type type5 = targetType;
                        Intrinsics.checkExpressionValueIsNotNull((Object)type5, (String)"targetType");
                        objectValue = new ObjectValue(object, type5);
                    } else {
                        objectValue = (ObjectValue)((Object)ValuesKt.throwEvalException(new ClassCastException(value2.getAsmType().getClassName() + " cannot be cast to " + targetType.getClassName())));
                    }
                }
                value3 = objectValue;
            } else if (n == Opcodes.INSTANCEOF) {
                Type targetType;
                AbstractInsnNode abstractInsnNode = insn;
                if (abstractInsnNode == null) {
                    throw new TypeCastException("null cannot be cast to non-null type org.jetbrains.org.objectweb.asm.tree.TypeInsnNode");
                }
                Type type6 = targetType = Type.getObjectType((String)((TypeInsnNode)abstractInsnNode).desc);
                Intrinsics.checkExpressionValueIsNotNull((Object)type6, (String)"targetType");
                value3 = ValuesKt.boolean(this.eval.isInstanceOf(value2, type6));
            } else {
                if (n == Opcodes.MONITORENTER || n == Opcodes.MONITOREXIT) {
                    throw (Throwable)new UnsupportedByteCodeException("Monitor instructions are not supported");
                }
                throw (Throwable)new UnsupportedByteCodeException(String.valueOf(insn));
            }
        }
        return value3;
    }

    public final boolean checkUnaryCondition(@NotNull Value value2, int opcode) {
        boolean bl;
        Intrinsics.checkParameterIsNotNull((Object)value2, (String)"value");
        int n = opcode;
        if (n == Opcodes.IFEQ) {
            bl = ValuesKt.getInt(value2) == 0;
        } else if (n == Opcodes.IFNE) {
            bl = ValuesKt.getInt(value2) != 0;
        } else if (n == Opcodes.IFLT) {
            bl = ValuesKt.getInt(value2) < 0;
        } else if (n == Opcodes.IFGT) {
            bl = ValuesKt.getInt(value2) > 0;
        } else if (n == Opcodes.IFLE) {
            bl = ValuesKt.getInt(value2) <= 0;
        } else if (n == Opcodes.IFGE) {
            bl = ValuesKt.getInt(value2) >= 0;
        } else if (n == Opcodes.IFNULL) {
            bl = ValuesKt.obj$default(value2, null, 1) == null;
        } else if (n == Opcodes.IFNONNULL) {
            bl = ValuesKt.obj$default(value2, null, 1) != null;
        } else {
            throw (Throwable)new UnsupportedByteCodeException("Unknown opcode: " + opcode);
        }
        return bl;
    }

    @Nullable
    public Value binaryOperation(@NotNull AbstractInsnNode insn, @NotNull Value value1, @NotNull Value value2) {
        Value value3;
        Intrinsics.checkParameterIsNotNull((Object)insn, (String)"insn");
        Intrinsics.checkParameterIsNotNull((Object)value1, (String)"value1");
        Intrinsics.checkParameterIsNotNull((Object)value2, (String)"value2");
        int n = insn.getOpcode();
        if (n == Opcodes.IALOAD || n == Opcodes.BALOAD || n == Opcodes.CALOAD || n == Opcodes.SALOAD || n == Opcodes.FALOAD || n == Opcodes.LALOAD || n == Opcodes.DALOAD || n == Opcodes.AALOAD) {
            value3 = this.eval.getArrayElement(value1, value2);
        } else if (n == Opcodes.IADD) {
            value3 = ValuesKt.int(ValuesKt.getInt(value1) + ValuesKt.getInt(value2));
        } else if (n == Opcodes.ISUB) {
            value3 = ValuesKt.int(ValuesKt.getInt(value1) - ValuesKt.getInt(value2));
        } else if (n == Opcodes.IMUL) {
            value3 = ValuesKt.int(ValuesKt.getInt(value1) * ValuesKt.getInt(value2));
        } else if (n == Opcodes.IDIV) {
            value3 = ValuesKt.int(ValuesKt.getInt(value1) / ValuesKt.getInt(value2));
        } else if (n == Opcodes.IREM) {
            value3 = ValuesKt.int(ValuesKt.getInt(value1) % ValuesKt.getInt(value2));
        } else if (n == Opcodes.ISHL) {
            value3 = ValuesKt.int(ValuesKt.getInt(value1) << ValuesKt.getInt(value2));
        } else if (n == Opcodes.ISHR) {
            value3 = ValuesKt.int(ValuesKt.getInt(value1) >> ValuesKt.getInt(value2));
        } else if (n == Opcodes.IUSHR) {
            value3 = ValuesKt.int(ValuesKt.getInt(value1) >>> ValuesKt.getInt(value2));
        } else if (n == Opcodes.IAND) {
            value3 = ValuesKt.int(ValuesKt.getInt(value1) & ValuesKt.getInt(value2));
        } else if (n == Opcodes.IOR) {
            value3 = ValuesKt.int(ValuesKt.getInt(value1) | ValuesKt.getInt(value2));
        } else if (n == Opcodes.IXOR) {
            value3 = ValuesKt.int(ValuesKt.getInt(value1) ^ ValuesKt.getInt(value2));
        } else if (n == Opcodes.LADD) {
            value3 = ValuesKt.long(ValuesKt.getLong(value1) + ValuesKt.getLong(value2));
        } else if (n == Opcodes.LSUB) {
            value3 = ValuesKt.long(ValuesKt.getLong(value1) - ValuesKt.getLong(value2));
        } else if (n == Opcodes.LMUL) {
            value3 = ValuesKt.long(ValuesKt.getLong(value1) * ValuesKt.getLong(value2));
        } else if (n == Opcodes.LDIV) {
            value3 = ValuesKt.long(ValuesKt.getLong(value1) / ValuesKt.getLong(value2));
        } else if (n == Opcodes.LREM) {
            value3 = ValuesKt.long(ValuesKt.getLong(value1) % ValuesKt.getLong(value2));
        } else if (n == Opcodes.LSHL) {
            value3 = ValuesKt.long(ValuesKt.getLong(value1) << ValuesKt.getInt(value2));
        } else if (n == Opcodes.LSHR) {
            value3 = ValuesKt.long(ValuesKt.getLong(value1) >> ValuesKt.getInt(value2));
        } else if (n == Opcodes.LUSHR) {
            value3 = ValuesKt.long(ValuesKt.getLong(value1) >>> ValuesKt.getInt(value2));
        } else if (n == Opcodes.LAND) {
            value3 = ValuesKt.long(ValuesKt.getLong(value1) & ValuesKt.getLong(value2));
        } else if (n == Opcodes.LOR) {
            value3 = ValuesKt.long(ValuesKt.getLong(value1) | ValuesKt.getLong(value2));
        } else if (n == Opcodes.LXOR) {
            value3 = ValuesKt.long(ValuesKt.getLong(value1) ^ ValuesKt.getLong(value2));
        } else if (n == Opcodes.FADD) {
            value3 = ValuesKt.float(ValuesKt.getFloat(value1) + ValuesKt.getFloat(value2));
        } else if (n == Opcodes.FSUB) {
            value3 = ValuesKt.float(ValuesKt.getFloat(value1) - ValuesKt.getFloat(value2));
        } else if (n == Opcodes.FMUL) {
            value3 = ValuesKt.float(ValuesKt.getFloat(value1) * ValuesKt.getFloat(value2));
        } else if (n == Opcodes.FDIV) {
            value3 = ValuesKt.float(ValuesKt.getFloat(value1) / ValuesKt.getFloat(value2));
        } else if (n == Opcodes.FREM) {
            value3 = ValuesKt.float(ValuesKt.getFloat(value1) % ValuesKt.getFloat(value2));
        } else if (n == Opcodes.DADD) {
            value3 = ValuesKt.double(ValuesKt.getDouble(value1) + ValuesKt.getDouble(value2));
        } else if (n == Opcodes.DSUB) {
            value3 = ValuesKt.double(ValuesKt.getDouble(value1) - ValuesKt.getDouble(value2));
        } else if (n == Opcodes.DMUL) {
            value3 = ValuesKt.double(ValuesKt.getDouble(value1) * ValuesKt.getDouble(value2));
        } else if (n == Opcodes.DDIV) {
            value3 = ValuesKt.double(ValuesKt.getDouble(value1) / ValuesKt.getDouble(value2));
        } else if (n == Opcodes.DREM) {
            value3 = ValuesKt.double(ValuesKt.getDouble(value1) % ValuesKt.getDouble(value2));
        } else if (n == Opcodes.LCMP) {
            long l2;
            long l1 = ValuesKt.getLong(value1);
            value3 = ValuesKt.int(l1 > (l2 = ValuesKt.getLong(value2)) ? 1 : (l1 == l2 ? 0 : -1));
        } else if (n == Opcodes.FCMPL || n == Opcodes.FCMPG) {
            float l2;
            float l1 = ValuesKt.getFloat(value1);
            value3 = ValuesKt.int(l1 > (l2 = ValuesKt.getFloat(value2)) ? 1 : (l1 == l2 ? 0 : (l1 < l2 ? -1 : (insn.getOpcode() == Opcodes.FCMPG ? 1 : -1))));
        } else if (n == Opcodes.DCMPL || n == Opcodes.DCMPG) {
            double l2;
            double l1 = ValuesKt.getDouble(value1);
            value3 = ValuesKt.int(l1 > (l2 = ValuesKt.getDouble(value2)) ? 1 : (l1 == l2 ? 0 : (l1 < l2 ? -1 : (insn.getOpcode() == Opcodes.DCMPG ? 1 : -1))));
        } else if (n == Opcodes.IF_ICMPEQ || n == Opcodes.IF_ICMPNE || n == Opcodes.IF_ICMPLT || n == Opcodes.IF_ICMPGE || n == Opcodes.IF_ICMPGT || n == Opcodes.IF_ICMPLE || n == Opcodes.IF_ACMPEQ || n == Opcodes.IF_ACMPNE) {
            value3 = null;
        } else if (n == Opcodes.PUTFIELD) {
            AbstractInsnNode abstractInsnNode = insn;
            if (abstractInsnNode == null) {
                throw new TypeCastException("null cannot be cast to non-null type org.jetbrains.org.objectweb.asm.tree.FieldInsnNode");
            }
            this.eval.setField(value1, MembersKt.FieldDescription((FieldInsnNode)abstractInsnNode), value2);
            value3 = null;
        } else {
            throw (Throwable)new UnsupportedByteCodeException(String.valueOf(insn));
        }
        return value3;
    }

    public final boolean checkBinaryCondition(@NotNull Value value1, @NotNull Value value2, int opcode) {
        boolean bl;
        Intrinsics.checkParameterIsNotNull((Object)value1, (String)"value1");
        Intrinsics.checkParameterIsNotNull((Object)value2, (String)"value2");
        int n = opcode;
        if (n == Opcodes.IF_ICMPEQ) {
            bl = ValuesKt.getInt(value1) == ValuesKt.getInt(value2);
        } else if (n == Opcodes.IF_ICMPNE) {
            bl = ValuesKt.getInt(value1) != ValuesKt.getInt(value2);
        } else if (n == Opcodes.IF_ICMPLT) {
            bl = ValuesKt.getInt(value1) < ValuesKt.getInt(value2);
        } else if (n == Opcodes.IF_ICMPGT) {
            bl = ValuesKt.getInt(value1) > ValuesKt.getInt(value2);
        } else if (n == Opcodes.IF_ICMPLE) {
            bl = ValuesKt.getInt(value1) <= ValuesKt.getInt(value2);
        } else if (n == Opcodes.IF_ICMPGE) {
            bl = ValuesKt.getInt(value1) >= ValuesKt.getInt(value2);
        } else if (n == Opcodes.IF_ACMPEQ) {
            bl = Intrinsics.areEqual((Object)ValuesKt.obj$default(value1, null, 1), (Object)ValuesKt.obj$default(value2, null, 1));
        } else if (n == Opcodes.IF_ACMPNE) {
            bl = Intrinsics.areEqual((Object)ValuesKt.obj$default(value1, null, 1), (Object)ValuesKt.obj$default(value2, null, 1)) ^ true;
        } else {
            throw (Throwable)new UnsupportedByteCodeException("Unknown opcode: " + opcode);
        }
        return bl;
    }

    @Nullable
    public Value ternaryOperation(@NotNull AbstractInsnNode insn, @NotNull Value value1, @NotNull Value value2, @NotNull Value value3) {
        Intrinsics.checkParameterIsNotNull((Object)insn, (String)"insn");
        Intrinsics.checkParameterIsNotNull((Object)value1, (String)"value1");
        Intrinsics.checkParameterIsNotNull((Object)value2, (String)"value2");
        Intrinsics.checkParameterIsNotNull((Object)value3, (String)"value3");
        int n = insn.getOpcode();
        if (n != Opcodes.IASTORE && n != Opcodes.LASTORE && n != Opcodes.FASTORE && n != Opcodes.DASTORE && n != Opcodes.AASTORE && n != Opcodes.BASTORE && n != Opcodes.CASTORE && n != Opcodes.SASTORE) {
            throw (Throwable)new UnsupportedByteCodeException(String.valueOf(insn));
        }
        this.eval.setArrayElement(value1, value2, value3);
        return null;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public Value naryOperation(@NotNull AbstractInsnNode insn, @NotNull List<? extends Value> values) {
        Value value2;
        Intrinsics.checkParameterIsNotNull((Object)insn, (String)"insn");
        Intrinsics.checkParameterIsNotNull(values, (String)"values");
        int n = insn.getOpcode();
        if (n == Opcodes.MULTIANEWARRAY) {
            List list;
            void destination;
            void $receiver;
            void $receiver2;
            AbstractInsnNode abstractInsnNode = insn;
            if (abstractInsnNode == null) {
                throw new TypeCastException("null cannot be cast to non-null type org.jetbrains.org.objectweb.asm.tree.MultiANewArrayInsnNode");
            }
            MultiANewArrayInsnNode node = (MultiANewArrayInsnNode)abstractInsnNode;
            Type type2 = Type.getType((String)node.desc);
            Intrinsics.checkExpressionValueIsNotNull((Object)type2, (String)"Type.getType(node.desc)");
            Iterable iterable = values;
            Type type3 = type2;
            Eval eval = this.eval;
            void var6_8 = $receiver2;
            Collection collection = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$receiver2, (int)10));
            for (Object item : $receiver) {
                void v;
                Value value3 = (Value)item;
                list = destination;
                Integer n2 = ValuesKt.getInt((Value)v);
                list.add(n2);
            }
            list = (List)destination;
            value2 = eval.newMultiDimensionalArray(type3, list);
        } else if (n == Opcodes.INVOKEVIRTUAL || n == Opcodes.INVOKESPECIAL || n == Opcodes.INVOKEINTERFACE) {
            AbstractInsnNode abstractInsnNode = insn;
            if (abstractInsnNode == null) {
                throw new TypeCastException("null cannot be cast to non-null type org.jetbrains.org.objectweb.asm.tree.MethodInsnNode");
            }
            value2 = this.eval.invokeMethod(values.get(0), MembersKt.MethodDescription((MethodInsnNode)abstractInsnNode), values.subList(1, values.size()), ((MethodInsnNode)insn).getOpcode() == Opcodes.INVOKESPECIAL);
        } else if (n == Opcodes.INVOKESTATIC) {
            AbstractInsnNode abstractInsnNode = insn;
            if (abstractInsnNode == null) {
                throw new TypeCastException("null cannot be cast to non-null type org.jetbrains.org.objectweb.asm.tree.MethodInsnNode");
            }
            value2 = this.eval.invokeStaticMethod(MembersKt.MethodDescription((MethodInsnNode)abstractInsnNode), values);
        } else {
            if (n == Opcodes.INVOKEDYNAMIC) {
                throw (Throwable)new UnsupportedByteCodeException("INVOKEDYNAMIC is not supported");
            }
            throw (Throwable)new UnsupportedByteCodeException(String.valueOf(insn));
        }
        return value2;
    }

    public void returnOperation(@NotNull AbstractInsnNode insn, @NotNull Value value2, @NotNull Value expected) {
        Intrinsics.checkParameterIsNotNull((Object)insn, (String)"insn");
        Intrinsics.checkParameterIsNotNull((Object)value2, (String)"value");
        Intrinsics.checkParameterIsNotNull((Object)expected, (String)"expected");
        int n = insn.getOpcode();
        if (n != Opcodes.IRETURN && n != Opcodes.LRETURN && n != Opcodes.FRETURN && n != Opcodes.DRETURN && n != Opcodes.ARETURN) {
            throw (Throwable)new UnsupportedByteCodeException(String.valueOf(insn));
        }
    }

    @NotNull
    public Value merge(@NotNull Value v, @NotNull Value w) {
        Intrinsics.checkParameterIsNotNull((Object)v, (String)"v");
        Intrinsics.checkParameterIsNotNull((Object)w, (String)"w");
        return w;
    }

    public SingleInstructionInterpreter(@NotNull Eval eval) {
        Intrinsics.checkParameterIsNotNull((Object)eval, (String)"eval");
        super(Opcodes.ASM5);
        this.eval = eval;
    }
}

