/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.asJava;

import com.intellij.lang.Language;
import com.intellij.navigation.ItemPresentation;
import com.intellij.navigation.ItemPresentationProviders;
import com.intellij.navigation.NavigationItem;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiEnumConstant;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.ResolveState;
import com.intellij.psi.impl.PsiClassImplUtil;
import com.intellij.psi.impl.light.AbstractLightClass;
import com.intellij.psi.impl.source.ClassInnerStuffCache;
import com.intellij.psi.impl.source.PsiExtensibleClass;
import com.intellij.psi.scope.PsiScopeProcessor;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.Function;
import com.intellij.util.containers.ContainerUtil;
import java.util.List;
import kotlin.KotlinPackage;
import kotlin.jvm.functions.Function1;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.asJava.ClsWrapperStubPsiFactory;
import org.jetbrains.kotlin.asJava.KotlinLightClass;
import org.jetbrains.kotlin.asJava.KotlinLightClassForEnumEntry;
import org.jetbrains.kotlin.asJava.KotlinLightEnumConstant;
import org.jetbrains.kotlin.asJava.KotlinLightFieldForDeclaration;
import org.jetbrains.kotlin.asJava.KotlinLightMethodForDeclaration;
import org.jetbrains.kotlin.asJava.KotlinLightMethodForTraitFakeOverride;
import org.jetbrains.kotlin.asJava.KotlinNoOriginLightField;
import org.jetbrains.kotlin.asJava.KotlinNoOriginLightMethod;
import org.jetbrains.kotlin.idea.JetLanguage;
import org.jetbrains.kotlin.name.FqName;
import org.jetbrains.kotlin.psi.JetClassOrObject;
import org.jetbrains.kotlin.psi.JetDeclaration;
import org.jetbrains.kotlin.psi.JetEnumEntry;
import org.jetbrains.kotlin.psi.JetNamedFunction;
import org.jetbrains.kotlin.psi.JetProperty;
import org.jetbrains.kotlin.psi.JetPropertyAccessor;
import org.jetbrains.kotlin.psi.JetPsiUtil;
import org.jetbrains.kotlin.psi.psiUtil.PsiUtilPackage;

public abstract class KotlinWrappingLightClass
extends AbstractLightClass
implements KotlinLightClass,
PsiExtensibleClass {
    private final ClassInnerStuffCache myInnersCache = new ClassInnerStuffCache((PsiExtensibleClass)this);

    protected KotlinWrappingLightClass(PsiManager manager) {
        super(manager, (Language)JetLanguage.INSTANCE);
    }

    @Override
    @Nullable
    public abstract JetClassOrObject getOrigin();

    @Override
    @NotNull
    public abstract PsiClass getDelegate();

    @NotNull
    public PsiField[] getFields() {
        PsiField[] psiFieldArray = this.myInnersCache.getFields();
        if (psiFieldArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/asJava/KotlinWrappingLightClass", "getFields"));
        }
        return psiFieldArray;
    }

    @NotNull
    public PsiMethod[] getMethods() {
        PsiMethod[] psiMethodArray = this.myInnersCache.getMethods();
        if (psiMethodArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/asJava/KotlinWrappingLightClass", "getMethods"));
        }
        return psiMethodArray;
    }

    @NotNull
    public PsiMethod[] getConstructors() {
        PsiMethod[] psiMethodArray = this.myInnersCache.getConstructors();
        if (psiMethodArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/asJava/KotlinWrappingLightClass", "getConstructors"));
        }
        return psiMethodArray;
    }

    @NotNull
    public PsiClass[] getInnerClasses() {
        PsiClass[] psiClassArray = this.myInnersCache.getInnerClasses();
        if (psiClassArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/asJava/KotlinWrappingLightClass", "getInnerClasses"));
        }
        return psiClassArray;
    }

    @NotNull
    public PsiField[] getAllFields() {
        PsiField[] psiFieldArray = PsiClassImplUtil.getAllFields((PsiClass)this);
        if (psiFieldArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/asJava/KotlinWrappingLightClass", "getAllFields"));
        }
        return psiFieldArray;
    }

    @NotNull
    public PsiMethod[] getAllMethods() {
        PsiMethod[] psiMethodArray = PsiClassImplUtil.getAllMethods((PsiClass)this);
        if (psiMethodArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/asJava/KotlinWrappingLightClass", "getAllMethods"));
        }
        return psiMethodArray;
    }

    @NotNull
    public PsiClass[] getAllInnerClasses() {
        PsiClass[] psiClassArray = PsiClassImplUtil.getAllInnerClasses((PsiClass)this);
        if (psiClassArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/asJava/KotlinWrappingLightClass", "getAllInnerClasses"));
        }
        return psiClassArray;
    }

    public PsiField findFieldByName(String name2, boolean checkBases) {
        return this.myInnersCache.findFieldByName(name2, checkBases);
    }

    @NotNull
    public PsiMethod[] findMethodsByName(String name2, boolean checkBases) {
        PsiMethod[] psiMethodArray = this.myInnersCache.findMethodsByName(name2, checkBases);
        if (psiMethodArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/asJava/KotlinWrappingLightClass", "findMethodsByName"));
        }
        return psiMethodArray;
    }

    public PsiClass findInnerClassByName(String name2, boolean checkBases) {
        return this.myInnersCache.findInnerClassByName(name2, checkBases);
    }

    @NotNull
    public List<PsiField> getOwnFields() {
        List list = ContainerUtil.map((Object[])this.getDelegate().getFields(), (Function)new Function<PsiField, PsiField>(){

            public PsiField fun(PsiField field2) {
                JetDeclaration declaration = ClsWrapperStubPsiFactory.getOriginalDeclaration((PsiMember)field2);
                if (declaration instanceof JetEnumEntry) {
                    assert (field2 instanceof PsiEnumConstant) : "Field delegate should be an enum constant (" + field2.getName() + "):\n" + PsiUtilPackage.getElementTextWithContext(declaration);
                    JetEnumEntry enumEntry = (JetEnumEntry)declaration;
                    PsiEnumConstant enumConstant = (PsiEnumConstant)field2;
                    FqName enumConstantFqName = new FqName(KotlinWrappingLightClass.this.getFqName().asString() + "." + enumEntry.getName());
                    KotlinLightClassForEnumEntry initializingClass = enumEntry.getDeclarations().isEmpty() ? null : new KotlinLightClassForEnumEntry(KotlinWrappingLightClass.this.myManager, enumConstantFqName, enumEntry, enumConstant);
                    return new KotlinLightEnumConstant(KotlinWrappingLightClass.this.myManager, enumEntry, enumConstant, KotlinWrappingLightClass.this, initializingClass);
                }
                if (declaration != null) {
                    return new KotlinLightFieldForDeclaration(KotlinWrappingLightClass.this.myManager, declaration, field2, (PsiClass)KotlinWrappingLightClass.this);
                }
                return new KotlinNoOriginLightField(KotlinWrappingLightClass.this.myManager, field2, KotlinWrappingLightClass.this);
            }
        });
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/asJava/KotlinWrappingLightClass", "getOwnFields"));
        }
        return list;
    }

    @NotNull
    public List<PsiMethod> getOwnMethods() {
        List list = KotlinPackage.map((Object[])this.getDelegate().getMethods(), (Function1)new Function1<PsiMethod, PsiMethod>(){

            public PsiMethod invoke(PsiMethod method) {
                JetDeclaration declaration = ClsWrapperStubPsiFactory.getOriginalDeclaration((PsiMember)method);
                if (declaration instanceof JetPropertyAccessor) {
                    declaration = (JetDeclaration)PsiTreeUtil.getParentOfType((PsiElement)declaration, JetProperty.class);
                }
                if (declaration != null) {
                    return !KotlinWrappingLightClass.this.isTraitFakeOverride(declaration) ? new KotlinLightMethodForDeclaration(KotlinWrappingLightClass.this.myManager, method, declaration, KotlinWrappingLightClass.this) : new KotlinLightMethodForTraitFakeOverride(KotlinWrappingLightClass.this.myManager, method, declaration, KotlinWrappingLightClass.this);
                }
                return new KotlinNoOriginLightMethod(KotlinWrappingLightClass.this.myManager, method, KotlinWrappingLightClass.this);
            }
        });
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/asJava/KotlinWrappingLightClass", "getOwnMethods"));
        }
        return list;
    }

    public boolean processDeclarations(@NotNull PsiScopeProcessor processor2, @NotNull ResolveState state, PsiElement lastParent, @NotNull PsiElement place) {
        if (processor2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "processor", "org/jetbrains/kotlin/asJava/KotlinWrappingLightClass", "processDeclarations"));
        }
        if (state == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "state", "org/jetbrains/kotlin/asJava/KotlinWrappingLightClass", "processDeclarations"));
        }
        if (place == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "place", "org/jetbrains/kotlin/asJava/KotlinWrappingLightClass", "processDeclarations"));
        }
        if (this.isEnum() && !PsiClassImplUtil.processDeclarationsInEnum((PsiScopeProcessor)processor2, (ResolveState)state, (ClassInnerStuffCache)this.myInnersCache)) {
            return false;
        }
        return super.processDeclarations(processor2, state, lastParent, place);
    }

    public String getText() {
        JetClassOrObject origin = this.getOrigin();
        return origin == null ? null : origin.getText();
    }

    @NotNull
    public Language getLanguage() {
        JetLanguage jetLanguage = JetLanguage.INSTANCE;
        if (jetLanguage == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/asJava/KotlinWrappingLightClass", "getLanguage"));
        }
        return jetLanguage;
    }

    private boolean isTraitFakeOverride(@NotNull JetDeclaration originMethodDeclaration) {
        if (originMethodDeclaration == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "originMethodDeclaration", "org/jetbrains/kotlin/asJava/KotlinWrappingLightClass", "isTraitFakeOverride"));
        }
        if (!(originMethodDeclaration instanceof JetNamedFunction || originMethodDeclaration instanceof JetPropertyAccessor || originMethodDeclaration instanceof JetProperty)) {
            return false;
        }
        JetClassOrObject parentOfMethodOrigin = (JetClassOrObject)PsiTreeUtil.getParentOfType((PsiElement)originMethodDeclaration, JetClassOrObject.class);
        JetClassOrObject thisClassDeclaration = this.getOrigin();
        return parentOfMethodOrigin != null && thisClassDeclaration != parentOfMethodOrigin && JetPsiUtil.isTrait(parentOfMethodOrigin);
    }

    public ItemPresentation getPresentation() {
        return ItemPresentationProviders.getItemPresentation((NavigationItem)this);
    }

    public abstract boolean equals(Object var1);

    public abstract int hashCode();
}

