/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.cfg;

import com.google.common.collect.Lists;
import com.intellij.psi.PsiElement;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.SmartFMap;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import kotlin.KotlinPackage;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.builtins.KotlinBuiltIns;
import org.jetbrains.kotlin.cfg.GenerationTrigger;
import org.jetbrains.kotlin.cfg.JetControlFlowBuilder;
import org.jetbrains.kotlin.cfg.Label;
import org.jetbrains.kotlin.cfg.LoopInfo;
import org.jetbrains.kotlin.cfg.WhenChecker;
import org.jetbrains.kotlin.cfg.pseudocode.JetControlFlowInstructionsGenerator;
import org.jetbrains.kotlin.cfg.pseudocode.PseudoValue;
import org.jetbrains.kotlin.cfg.pseudocode.Pseudocode;
import org.jetbrains.kotlin.cfg.pseudocode.PseudocodeImpl;
import org.jetbrains.kotlin.cfg.pseudocode.instructions.eval.AccessTarget;
import org.jetbrains.kotlin.cfg.pseudocode.instructions.eval.CallInstruction;
import org.jetbrains.kotlin.cfg.pseudocode.instructions.eval.InstructionWithValue;
import org.jetbrains.kotlin.cfg.pseudocode.instructions.eval.MagicKind;
import org.jetbrains.kotlin.cfg.pseudocode.instructions.eval.ReadValueInstruction;
import org.jetbrains.kotlin.descriptors.CallableDescriptor;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.descriptors.FunctionDescriptor;
import org.jetbrains.kotlin.descriptors.ReceiverParameterDescriptor;
import org.jetbrains.kotlin.descriptors.ValueParameterDescriptor;
import org.jetbrains.kotlin.descriptors.VariableDescriptor;
import org.jetbrains.kotlin.descriptors.impl.AnonymousFunctionDescriptor;
import org.jetbrains.kotlin.diagnostics.Errors;
import org.jetbrains.kotlin.lexer.JetToken;
import org.jetbrains.kotlin.lexer.JetTokens;
import org.jetbrains.kotlin.name.Name;
import org.jetbrains.kotlin.psi.JetAnnotatedExpression;
import org.jetbrains.kotlin.psi.JetArrayAccessExpression;
import org.jetbrains.kotlin.psi.JetBinaryExpression;
import org.jetbrains.kotlin.psi.JetBinaryExpressionWithTypeRHS;
import org.jetbrains.kotlin.psi.JetBlockExpression;
import org.jetbrains.kotlin.psi.JetBreakExpression;
import org.jetbrains.kotlin.psi.JetCallElement;
import org.jetbrains.kotlin.psi.JetCallExpression;
import org.jetbrains.kotlin.psi.JetCatchClause;
import org.jetbrains.kotlin.psi.JetClass;
import org.jetbrains.kotlin.psi.JetClassInitializer;
import org.jetbrains.kotlin.psi.JetClassOrObject;
import org.jetbrains.kotlin.psi.JetConstantExpression;
import org.jetbrains.kotlin.psi.JetContinueExpression;
import org.jetbrains.kotlin.psi.JetDeclaration;
import org.jetbrains.kotlin.psi.JetDeclarationWithBody;
import org.jetbrains.kotlin.psi.JetDelegationSpecifier;
import org.jetbrains.kotlin.psi.JetDelegationSpecifierList;
import org.jetbrains.kotlin.psi.JetDelegatorByExpressionSpecifier;
import org.jetbrains.kotlin.psi.JetDelegatorToSuperCall;
import org.jetbrains.kotlin.psi.JetDelegatorToSuperClass;
import org.jetbrains.kotlin.psi.JetDoWhileExpression;
import org.jetbrains.kotlin.psi.JetDoubleColonExpression;
import org.jetbrains.kotlin.psi.JetElement;
import org.jetbrains.kotlin.psi.JetExpression;
import org.jetbrains.kotlin.psi.JetExpressionWithLabel;
import org.jetbrains.kotlin.psi.JetFile;
import org.jetbrains.kotlin.psi.JetFinallySection;
import org.jetbrains.kotlin.psi.JetForExpression;
import org.jetbrains.kotlin.psi.JetFunction;
import org.jetbrains.kotlin.psi.JetFunctionLiteral;
import org.jetbrains.kotlin.psi.JetFunctionLiteralExpression;
import org.jetbrains.kotlin.psi.JetIfExpression;
import org.jetbrains.kotlin.psi.JetIsExpression;
import org.jetbrains.kotlin.psi.JetLabeledExpression;
import org.jetbrains.kotlin.psi.JetLoopExpression;
import org.jetbrains.kotlin.psi.JetMultiDeclaration;
import org.jetbrains.kotlin.psi.JetMultiDeclarationEntry;
import org.jetbrains.kotlin.psi.JetNamedFunction;
import org.jetbrains.kotlin.psi.JetObjectDeclaration;
import org.jetbrains.kotlin.psi.JetObjectLiteralExpression;
import org.jetbrains.kotlin.psi.JetOperationExpression;
import org.jetbrains.kotlin.psi.JetParameter;
import org.jetbrains.kotlin.psi.JetParenthesizedExpression;
import org.jetbrains.kotlin.psi.JetPostfixExpression;
import org.jetbrains.kotlin.psi.JetProperty;
import org.jetbrains.kotlin.psi.JetPropertyAccessor;
import org.jetbrains.kotlin.psi.JetPsiUtil;
import org.jetbrains.kotlin.psi.JetQualifiedExpression;
import org.jetbrains.kotlin.psi.JetReturnExpression;
import org.jetbrains.kotlin.psi.JetSecondaryConstructor;
import org.jetbrains.kotlin.psi.JetSimpleNameExpression;
import org.jetbrains.kotlin.psi.JetStatementExpression;
import org.jetbrains.kotlin.psi.JetStringTemplateEntry;
import org.jetbrains.kotlin.psi.JetStringTemplateEntryWithExpression;
import org.jetbrains.kotlin.psi.JetStringTemplateExpression;
import org.jetbrains.kotlin.psi.JetThisExpression;
import org.jetbrains.kotlin.psi.JetThrowExpression;
import org.jetbrains.kotlin.psi.JetTryExpression;
import org.jetbrains.kotlin.psi.JetTypeProjection;
import org.jetbrains.kotlin.psi.JetUnaryExpression;
import org.jetbrains.kotlin.psi.JetValueArgument;
import org.jetbrains.kotlin.psi.JetVisitorVoid;
import org.jetbrains.kotlin.psi.JetWhenCondition;
import org.jetbrains.kotlin.psi.JetWhenConditionInRange;
import org.jetbrains.kotlin.psi.JetWhenConditionIsPattern;
import org.jetbrains.kotlin.psi.JetWhenConditionWithExpression;
import org.jetbrains.kotlin.psi.JetWhenEntry;
import org.jetbrains.kotlin.psi.JetWhenExpression;
import org.jetbrains.kotlin.psi.JetWhileExpression;
import org.jetbrains.kotlin.psi.ValueArgument;
import org.jetbrains.kotlin.psi.psiUtil.PsiUtilPackage;
import org.jetbrains.kotlin.resolve.BindingContext;
import org.jetbrains.kotlin.resolve.BindingContextUtils;
import org.jetbrains.kotlin.resolve.BindingTrace;
import org.jetbrains.kotlin.resolve.CompileTimeConstantUtils;
import org.jetbrains.kotlin.resolve.calls.callUtil.CallUtilPackage;
import org.jetbrains.kotlin.resolve.calls.model.ArgumentMapping;
import org.jetbrains.kotlin.resolve.calls.model.ArgumentMatch;
import org.jetbrains.kotlin.resolve.calls.model.ResolvedCall;
import org.jetbrains.kotlin.resolve.calls.model.ResolvedValueArgument;
import org.jetbrains.kotlin.resolve.calls.model.VariableAsFunctionResolvedCall;
import org.jetbrains.kotlin.resolve.calls.tasks.ExplicitReceiverKind;
import org.jetbrains.kotlin.resolve.constants.CompileTimeConstant;
import org.jetbrains.kotlin.resolve.constants.evaluate.ConstantExpressionEvaluator;
import org.jetbrains.kotlin.resolve.scopes.receivers.ExpressionReceiver;
import org.jetbrains.kotlin.resolve.scopes.receivers.ReceiverValue;
import org.jetbrains.kotlin.resolve.scopes.receivers.ThisReceiver;
import org.jetbrains.kotlin.resolve.scopes.receivers.TransientReceiver;
import org.jetbrains.kotlin.types.JetType;
import org.jetbrains.kotlin.types.expressions.OperatorConventions;

public class JetControlFlowProcessor {
    private final JetControlFlowBuilder builder = new JetControlFlowInstructionsGenerator();
    private final BindingTrace trace;

    public JetControlFlowProcessor(BindingTrace trace) {
        this.trace = trace;
    }

    @NotNull
    public Pseudocode generatePseudocode(@NotNull JetElement subroutine) {
        if (subroutine == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "subroutine", "org/jetbrains/kotlin/cfg/JetControlFlowProcessor", "generatePseudocode"));
        }
        Pseudocode pseudocode2 = this.generate(subroutine);
        ((PseudocodeImpl)pseudocode2).postProcess();
        Pseudocode pseudocode3 = pseudocode2;
        if (pseudocode3 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/cfg/JetControlFlowProcessor", "generatePseudocode"));
        }
        return pseudocode3;
    }

    @NotNull
    private Pseudocode generate(@NotNull JetElement subroutine) {
        if (subroutine == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "subroutine", "org/jetbrains/kotlin/cfg/JetControlFlowProcessor", "generate"));
        }
        this.builder.enterSubroutine(subroutine);
        CFPVisitor cfpVisitor = new CFPVisitor(this.builder);
        if (subroutine instanceof JetDeclarationWithBody && !(subroutine instanceof JetSecondaryConstructor)) {
            JetDeclarationWithBody declarationWithBody = (JetDeclarationWithBody)subroutine;
            List<JetParameter> valueParameters = declarationWithBody.getValueParameters();
            for (JetParameter valueParameter : valueParameters) {
                cfpVisitor.generateInstructions(valueParameter);
            }
            JetExpression bodyExpression = declarationWithBody.getBodyExpression();
            if (bodyExpression != null) {
                cfpVisitor.generateInstructions(bodyExpression);
                if (!declarationWithBody.hasBlockBody()) {
                    this.generateImplicitReturnValue(bodyExpression, subroutine);
                }
            }
        } else {
            cfpVisitor.generateInstructions(subroutine);
        }
        Pseudocode pseudocode2 = this.builder.exitSubroutine(subroutine);
        if (pseudocode2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/cfg/JetControlFlowProcessor", "generate"));
        }
        return pseudocode2;
    }

    private void generateImplicitReturnValue(@NotNull JetExpression bodyExpression, @NotNull JetElement subroutine) {
        if (bodyExpression == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "bodyExpression", "org/jetbrains/kotlin/cfg/JetControlFlowProcessor", "generateImplicitReturnValue"));
        }
        if (subroutine == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "subroutine", "org/jetbrains/kotlin/cfg/JetControlFlowProcessor", "generateImplicitReturnValue"));
        }
        CallableDescriptor subroutineDescriptor = (CallableDescriptor)this.trace.get(BindingContext.DECLARATION_TO_DESCRIPTOR, subroutine);
        if (subroutineDescriptor == null) {
            return;
        }
        JetType returnType2 = subroutineDescriptor.getReturnType();
        if (returnType2 != null && KotlinBuiltIns.isUnit(returnType2) && subroutineDescriptor instanceof AnonymousFunctionDescriptor) {
            return;
        }
        PseudoValue returnValue = this.builder.getBoundValue(bodyExpression);
        if (returnValue == null) {
            return;
        }
        this.builder.returnValue(bodyExpression, returnValue, subroutine);
    }

    private void processLocalDeclaration(@NotNull JetDeclaration subroutine) {
        if (subroutine == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "subroutine", "org/jetbrains/kotlin/cfg/JetControlFlowProcessor", "processLocalDeclaration"));
        }
        Label afterDeclaration = this.builder.createUnboundLabel("after local declaration");
        this.builder.nondeterministicJump(afterDeclaration, subroutine, null);
        this.generate(subroutine);
        this.builder.bindLabel(afterDeclaration);
    }

    private class CFPVisitor
    extends JetVisitorVoid {
        private final JetControlFlowBuilder builder;
        private final JetVisitorVoid conditionVisitor;

        private CFPVisitor(JetControlFlowBuilder builder) {
            if (builder == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "builder", "org/jetbrains/kotlin/cfg/JetControlFlowProcessor$CFPVisitor", "<init>"));
            }
            this.conditionVisitor = new JetVisitorVoid(){

                private JetExpression getSubjectExpression(JetWhenCondition condition2) {
                    JetWhenExpression whenExpression2 = (JetWhenExpression)PsiTreeUtil.getParentOfType((PsiElement)condition2, JetWhenExpression.class);
                    return whenExpression2 != null ? whenExpression2.getSubjectExpression() : null;
                }

                @Override
                public void visitWhenConditionInRange(@NotNull JetWhenConditionInRange condition2) {
                    if (condition2 == null) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "condition", "org/jetbrains/kotlin/cfg/JetControlFlowProcessor$CFPVisitor$1", "visitWhenConditionInRange"));
                    }
                    if (!CFPVisitor.this.generateCall(condition2.getOperationReference())) {
                        JetExpression rangeExpression = condition2.getRangeExpression();
                        CFPVisitor.this.generateInstructions(rangeExpression);
                        CFPVisitor.this.createNonSyntheticValue(condition2, MagicKind.UNRESOLVED_CALL, new JetElement[]{rangeExpression});
                    }
                }

                @Override
                public void visitWhenConditionIsPattern(@NotNull JetWhenConditionIsPattern condition2) {
                    if (condition2 == null) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "condition", "org/jetbrains/kotlin/cfg/JetControlFlowProcessor$CFPVisitor$1", "visitWhenConditionIsPattern"));
                    }
                    CFPVisitor.this.mark(condition2);
                    CFPVisitor.this.createNonSyntheticValue(condition2, MagicKind.IS, new JetElement[]{this.getSubjectExpression(condition2)});
                }

                @Override
                public void visitWhenConditionWithExpression(@NotNull JetWhenConditionWithExpression condition2) {
                    if (condition2 == null) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "condition", "org/jetbrains/kotlin/cfg/JetControlFlowProcessor$CFPVisitor$1", "visitWhenConditionWithExpression"));
                    }
                    CFPVisitor.this.mark(condition2);
                    JetExpression expression2 = condition2.getExpression();
                    CFPVisitor.this.generateInstructions(expression2);
                    JetExpression subjectExpression = this.getSubjectExpression(condition2);
                    if (subjectExpression != null) {
                        CFPVisitor.this.createNonSyntheticValue(condition2, MagicKind.EQUALS_IN_WHEN_CONDITION, new JetElement[]{subjectExpression, expression2});
                    } else {
                        CFPVisitor.this.copyValue(expression2, condition2);
                    }
                }

                @Override
                public void visitJetElement(@NotNull JetElement element2) {
                    if (element2 == null) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "org/jetbrains/kotlin/cfg/JetControlFlowProcessor$CFPVisitor$1", "visitJetElement"));
                    }
                    throw new UnsupportedOperationException("[JetControlFlowProcessor] " + element2.toString());
                }
            };
            this.builder = builder;
        }

        private void mark(JetElement element2) {
            this.builder.mark(element2);
        }

        public void generateInstructions(@Nullable JetElement element2) {
            if (element2 == null) {
                return;
            }
            element2.accept(this);
            this.checkNothingType(element2);
        }

        private void checkNothingType(JetElement element2) {
            if (!(element2 instanceof JetExpression)) {
                return;
            }
            JetExpression expression2 = JetPsiUtil.deparenthesize((JetExpression)element2);
            if (expression2 == null) {
                return;
            }
            if (expression2 instanceof JetStatementExpression || expression2 instanceof JetTryExpression || expression2 instanceof JetIfExpression || expression2 instanceof JetWhenExpression) {
                return;
            }
            JetType type2 = JetControlFlowProcessor.this.trace.getBindingContext().getType(expression2);
            if (type2 != null && KotlinBuiltIns.isNothing(type2)) {
                this.builder.jumpToError(expression2);
            }
        }

        @NotNull
        private PseudoValue createSyntheticValue(@NotNull JetElement instructionElement, @NotNull MagicKind kind2, JetElement ... from) {
            if (instructionElement == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "instructionElement", "org/jetbrains/kotlin/cfg/JetControlFlowProcessor$CFPVisitor", "createSyntheticValue"));
            }
            if (kind2 == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "kind", "org/jetbrains/kotlin/cfg/JetControlFlowProcessor$CFPVisitor", "createSyntheticValue"));
            }
            List<PseudoValue> values = this.elementsToValues(from.length > 0 ? Arrays.asList(from) : Collections.emptyList());
            PseudoValue pseudoValue = this.builder.magic(instructionElement, null, values, kind2).getOutputValue();
            if (pseudoValue == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/cfg/JetControlFlowProcessor$CFPVisitor", "createSyntheticValue"));
            }
            return pseudoValue;
        }

        @NotNull
        private PseudoValue createNonSyntheticValue(@NotNull JetElement to, @NotNull List<? extends JetElement> from, @NotNull MagicKind kind2) {
            if (to == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "to", "org/jetbrains/kotlin/cfg/JetControlFlowProcessor$CFPVisitor", "createNonSyntheticValue"));
            }
            if (from == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "from", "org/jetbrains/kotlin/cfg/JetControlFlowProcessor$CFPVisitor", "createNonSyntheticValue"));
            }
            if (kind2 == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "kind", "org/jetbrains/kotlin/cfg/JetControlFlowProcessor$CFPVisitor", "createNonSyntheticValue"));
            }
            List<PseudoValue> values = this.elementsToValues(from);
            PseudoValue pseudoValue = this.builder.magic(to, to, values, kind2).getOutputValue();
            if (pseudoValue == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/cfg/JetControlFlowProcessor$CFPVisitor", "createNonSyntheticValue"));
            }
            return pseudoValue;
        }

        @NotNull
        private PseudoValue createNonSyntheticValue(@NotNull JetElement to, @NotNull MagicKind kind2, JetElement ... from) {
            if (to == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "to", "org/jetbrains/kotlin/cfg/JetControlFlowProcessor$CFPVisitor", "createNonSyntheticValue"));
            }
            if (kind2 == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "kind", "org/jetbrains/kotlin/cfg/JetControlFlowProcessor$CFPVisitor", "createNonSyntheticValue"));
            }
            PseudoValue pseudoValue = this.createNonSyntheticValue(to, Arrays.asList(from), kind2);
            if (pseudoValue == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/cfg/JetControlFlowProcessor$CFPVisitor", "createNonSyntheticValue"));
            }
            return pseudoValue;
        }

        private void mergeValues(@NotNull List<JetExpression> from, @NotNull JetExpression to) {
            if (from == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "from", "org/jetbrains/kotlin/cfg/JetControlFlowProcessor$CFPVisitor", "mergeValues"));
            }
            if (to == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "to", "org/jetbrains/kotlin/cfg/JetControlFlowProcessor$CFPVisitor", "mergeValues"));
            }
            this.builder.merge(to, this.elementsToValues(from));
        }

        private void copyValue(@Nullable JetElement from, @NotNull JetElement to) {
            if (to == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "to", "org/jetbrains/kotlin/cfg/JetControlFlowProcessor$CFPVisitor", "copyValue"));
            }
            PseudoValue value2 = this.getBoundOrUnreachableValue(from);
            if (value2 != null) {
                this.builder.bindValue(value2, to);
            }
        }

        @Nullable
        private PseudoValue getBoundOrUnreachableValue(@Nullable JetElement element2) {
            if (element2 == null) {
                return null;
            }
            PseudoValue value2 = this.builder.getBoundValue(element2);
            return value2 != null || element2 instanceof JetDeclaration ? value2 : this.builder.newValue(element2);
        }

        private List<PseudoValue> elementsToValues(List<? extends JetElement> from) {
            if (from.isEmpty()) {
                return Collections.emptyList();
            }
            return KotlinPackage.filterNotNull((Iterable)KotlinPackage.map(from, (Function1)new Function1<JetElement, PseudoValue>(){

                public PseudoValue invoke(JetElement element2) {
                    return CFPVisitor.this.getBoundOrUnreachableValue(element2);
                }
            }));
        }

        private void generateInitializer(@NotNull JetDeclaration declaration, @NotNull PseudoValue initValue) {
            if (declaration == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "declaration", "org/jetbrains/kotlin/cfg/JetControlFlowProcessor$CFPVisitor", "generateInitializer"));
            }
            if (initValue == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "initValue", "org/jetbrains/kotlin/cfg/JetControlFlowProcessor$CFPVisitor", "generateInitializer"));
            }
            this.builder.write(declaration, declaration, initValue, this.getDeclarationAccessTarget(declaration), Collections.<PseudoValue, ReceiverValue>emptyMap());
        }

        @NotNull
        private AccessTarget getResolvedCallAccessTarget(JetElement element2) {
            ResolvedCall<? extends CallableDescriptor> resolvedCall = CallUtilPackage.getResolvedCall(element2, JetControlFlowProcessor.this.trace.getBindingContext());
            AccessTarget accessTarget = resolvedCall != null ? new AccessTarget.Call(resolvedCall) : AccessTarget.BlackBox.INSTANCE$;
            if (accessTarget == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/cfg/JetControlFlowProcessor$CFPVisitor", "getResolvedCallAccessTarget"));
            }
            return accessTarget;
        }

        @NotNull
        private AccessTarget getDeclarationAccessTarget(JetElement element2) {
            DeclarationDescriptor descriptor2 = JetControlFlowProcessor.this.trace.get(BindingContext.DECLARATION_TO_DESCRIPTOR, element2);
            AccessTarget accessTarget = descriptor2 instanceof VariableDescriptor ? new AccessTarget.Declaration((VariableDescriptor)descriptor2) : AccessTarget.BlackBox.INSTANCE$;
            if (accessTarget == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/cfg/JetControlFlowProcessor$CFPVisitor", "getDeclarationAccessTarget"));
            }
            return accessTarget;
        }

        @Override
        public void visitParenthesizedExpression(@NotNull JetParenthesizedExpression expression2) {
            if (expression2 == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "org/jetbrains/kotlin/cfg/JetControlFlowProcessor$CFPVisitor", "visitParenthesizedExpression"));
            }
            this.mark(expression2);
            JetExpression innerExpression = expression2.getExpression();
            if (innerExpression != null) {
                this.generateInstructions(innerExpression);
                this.copyValue(innerExpression, expression2);
            }
        }

        @Override
        public void visitAnnotatedExpression(@NotNull JetAnnotatedExpression expression2) {
            if (expression2 == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "org/jetbrains/kotlin/cfg/JetControlFlowProcessor$CFPVisitor", "visitAnnotatedExpression"));
            }
            JetExpression baseExpression = expression2.getBaseExpression();
            if (baseExpression != null) {
                this.generateInstructions(baseExpression);
                this.copyValue(baseExpression, expression2);
            }
        }

        @Override
        public void visitThisExpression(@NotNull JetThisExpression expression2) {
            if (expression2 == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "org/jetbrains/kotlin/cfg/JetControlFlowProcessor$CFPVisitor", "visitThisExpression"));
            }
            ResolvedCall<? extends CallableDescriptor> resolvedCall = CallUtilPackage.getResolvedCall(expression2, JetControlFlowProcessor.this.trace.getBindingContext());
            if (resolvedCall == null) {
                this.createNonSyntheticValue((JetElement)expression2, MagicKind.UNRESOLVED_CALL, new JetElement[0]);
                return;
            }
            CallableDescriptor resultingDescriptor = resolvedCall.getResultingDescriptor();
            if (resultingDescriptor instanceof ReceiverParameterDescriptor) {
                this.builder.readVariable(expression2, resolvedCall, this.getReceiverValues(resolvedCall));
            }
            this.copyValue(expression2, expression2.getInstanceReference());
        }

        @Override
        public void visitConstantExpression(@NotNull JetConstantExpression expression2) {
            if (expression2 == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "org/jetbrains/kotlin/cfg/JetControlFlowProcessor$CFPVisitor", "visitConstantExpression"));
            }
            CompileTimeConstant<?> constant = ConstantExpressionEvaluator.getConstant(expression2, JetControlFlowProcessor.this.trace.getBindingContext());
            this.builder.loadConstant(expression2, constant);
        }

        @Override
        public void visitSimpleNameExpression(@NotNull JetSimpleNameExpression expression2) {
            if (expression2 == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "org/jetbrains/kotlin/cfg/JetControlFlowProcessor$CFPVisitor", "visitSimpleNameExpression"));
            }
            ResolvedCall<? extends CallableDescriptor> resolvedCall = CallUtilPackage.getResolvedCall(expression2, JetControlFlowProcessor.this.trace.getBindingContext());
            if (resolvedCall instanceof VariableAsFunctionResolvedCall) {
                VariableAsFunctionResolvedCall variableAsFunctionResolvedCall = (VariableAsFunctionResolvedCall)((Object)resolvedCall);
                this.generateCall(variableAsFunctionResolvedCall.getVariableCall());
            } else if (!this.generateCall(expression2) && !(expression2.getParent() instanceof JetCallExpression)) {
                this.createNonSyntheticValue((JetElement)expression2, MagicKind.UNRESOLVED_CALL, this.generateAndGetReceiverIfAny(expression2));
            }
        }

        @Override
        public void visitLabeledExpression(@NotNull JetLabeledExpression expression2) {
            if (expression2 == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "org/jetbrains/kotlin/cfg/JetControlFlowProcessor$CFPVisitor", "visitLabeledExpression"));
            }
            this.mark(expression2);
            JetExpression baseExpression = expression2.getBaseExpression();
            if (baseExpression != null) {
                this.generateInstructions(baseExpression);
                this.copyValue(baseExpression, expression2);
            }
        }

        @Override
        public void visitBinaryExpression(@NotNull JetBinaryExpression expression2) {
            if (expression2 == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "org/jetbrains/kotlin/cfg/JetControlFlowProcessor$CFPVisitor", "visitBinaryExpression"));
            }
            JetSimpleNameExpression operationReference = expression2.getOperationReference();
            IElementType operationType = operationReference.getReferencedNameElementType();
            JetExpression left = expression2.getLeft();
            JetExpression right = expression2.getRight();
            if (operationType == JetTokens.ANDAND || operationType == JetTokens.OROR) {
                this.generateBooleanOperation(expression2);
            } else if (operationType == JetTokens.EQ) {
                this.visitAssignment(left, this.getDeferredValue(right), expression2);
            } else if (OperatorConventions.ASSIGNMENT_OPERATIONS.containsKey((Object)operationType)) {
                ResolvedCall<? extends CallableDescriptor> resolvedCall = CallUtilPackage.getResolvedCall(expression2, JetControlFlowProcessor.this.trace.getBindingContext());
                if (resolvedCall != null) {
                    PseudoValue rhsValue = this.generateCall(resolvedCall).getOutputValue();
                    Name assignMethodName = OperatorConventions.getNameForOperationSymbol((JetToken)expression2.getOperationToken());
                    if (!resolvedCall.getResultingDescriptor().getName().equals(assignMethodName)) {
                        this.visitAssignment(left, this.getValueAsFunction(rhsValue), expression2);
                    }
                } else {
                    this.generateBothArgumentsAndMark(expression2);
                }
            } else if (operationType == JetTokens.ELVIS) {
                this.generateInstructions(left);
                this.mark(expression2);
                Label afterElvis = this.builder.createUnboundLabel("after elvis operator");
                this.builder.jumpOnTrue(afterElvis, expression2, this.builder.getBoundValue(left));
                if (right != null) {
                    this.generateInstructions(right);
                }
                this.builder.bindLabel(afterElvis);
                this.mergeValues(Arrays.asList(left, right), expression2);
            } else if (!this.generateCall(expression2)) {
                this.generateBothArgumentsAndMark(expression2);
            }
        }

        private void generateBooleanOperation(JetBinaryExpression expression2) {
            IElementType operationType = expression2.getOperationReference().getReferencedNameElementType();
            JetExpression left = expression2.getLeft();
            JetExpression right = expression2.getRight();
            Label resultLabel = this.builder.createUnboundLabel("result of boolean operation");
            this.generateInstructions(left);
            if (operationType == JetTokens.ANDAND) {
                this.builder.jumpOnFalse(resultLabel, expression2, this.builder.getBoundValue(left));
            } else {
                this.builder.jumpOnTrue(resultLabel, expression2, this.builder.getBoundValue(left));
            }
            if (right != null) {
                this.generateInstructions(right);
            }
            this.builder.bindLabel(resultLabel);
            JetControlFlowBuilder.PredefinedOperation operation = operationType == JetTokens.ANDAND ? JetControlFlowBuilder.PredefinedOperation.AND : JetControlFlowBuilder.PredefinedOperation.OR;
            this.builder.predefinedOperation(expression2, operation, this.elementsToValues(Arrays.asList(left, right)));
        }

        private Function0<PseudoValue> getValueAsFunction(final PseudoValue value2) {
            return new Function0<PseudoValue>(){

                public PseudoValue invoke() {
                    return value2;
                }
            };
        }

        private Function0<PseudoValue> getDeferredValue(final JetExpression expression2) {
            return new Function0<PseudoValue>(){

                public PseudoValue invoke() {
                    CFPVisitor.this.generateInstructions(expression2);
                    return CFPVisitor.this.getBoundOrUnreachableValue(expression2);
                }
            };
        }

        private void generateBothArgumentsAndMark(JetBinaryExpression expression2) {
            JetExpression right;
            JetExpression left = JetPsiUtil.deparenthesize(expression2.getLeft());
            if (left != null) {
                this.generateInstructions(left);
            }
            if ((right = expression2.getRight()) != null) {
                this.generateInstructions(right);
            }
            this.mark(expression2);
            this.createNonSyntheticValue((JetElement)expression2, MagicKind.UNRESOLVED_CALL, left, right);
        }

        private void visitAssignment(JetExpression lhs, @NotNull Function0<PseudoValue> rhsDeferredValue, JetExpression parentExpression) {
            PseudoValue rightValue;
            if (rhsDeferredValue == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "rhsDeferredValue", "org/jetbrains/kotlin/cfg/JetControlFlowProcessor$CFPVisitor", "visitAssignment"));
            }
            JetExpression left = JetPsiUtil.deparenthesize(lhs);
            if (left == null) {
                List<Object> arguments2 = Collections.singletonList(rhsDeferredValue.invoke());
                this.builder.magic(parentExpression, parentExpression, arguments2, MagicKind.UNSUPPORTED_ELEMENT);
                return;
            }
            if (left instanceof JetArrayAccessExpression) {
                this.generateArrayAssignment((JetArrayAccessExpression)left, rhsDeferredValue, parentExpression);
                return;
            }
            Object receiverValues = SmartFMap.emptyMap();
            AccessTarget accessTarget = AccessTarget.BlackBox.INSTANCE$;
            if (left instanceof JetSimpleNameExpression || left instanceof JetQualifiedExpression) {
                accessTarget = this.getResolvedCallAccessTarget(PsiUtilPackage.getQualifiedElementSelector(left));
                if (accessTarget instanceof AccessTarget.Call) {
                    receiverValues = this.getReceiverValues(((AccessTarget.Call)accessTarget).getResolvedCall());
                }
            } else if (left instanceof JetProperty) {
                accessTarget = this.getDeclarationAccessTarget(left);
            }
            if (accessTarget == AccessTarget.BlackBox.INSTANCE$ && !(left instanceof JetProperty)) {
                this.generateInstructions(left);
                this.createSyntheticValue(left, MagicKind.VALUE_CONSUMER, left);
            }
            PseudoValue rValue = (rightValue = (PseudoValue)rhsDeferredValue.invoke()) != null ? rightValue : this.createSyntheticValue(parentExpression, MagicKind.UNRECOGNIZED_WRITE_RHS, new JetElement[0]);
            this.builder.write(parentExpression, left, rValue, accessTarget, (Map<PseudoValue, ReceiverValue>)receiverValues);
        }

        private void generateArrayAssignment(JetArrayAccessExpression lhs, @NotNull Function0<PseudoValue> rhsDeferredValue, @NotNull JetExpression parentExpression) {
            if (rhsDeferredValue == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "rhsDeferredValue", "org/jetbrains/kotlin/cfg/JetControlFlowProcessor$CFPVisitor", "generateArrayAssignment"));
            }
            if (parentExpression == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parentExpression", "org/jetbrains/kotlin/cfg/JetControlFlowProcessor$CFPVisitor", "generateArrayAssignment"));
            }
            ResolvedCall<FunctionDescriptor> setResolvedCall = JetControlFlowProcessor.this.trace.get(BindingContext.INDEXED_LVALUE_SET, lhs);
            if (setResolvedCall == null) {
                this.generateArrayAccess(lhs, null);
                List arguments2 = KotlinPackage.filterNotNull(Arrays.asList(this.getBoundOrUnreachableValue(lhs), (PseudoValue)rhsDeferredValue.invoke()));
                this.builder.magic(parentExpression, parentExpression, arguments2, MagicKind.UNRESOLVED_CALL);
                return;
            }
            if (((JetOperationExpression)parentExpression).getOperationReference().getReferencedNameElementType() == JetTokens.EQ) {
                this.mark(lhs);
            }
            this.generateInstructions(lhs.getArrayExpression());
            Map<PseudoValue, ReceiverValue> receiverValues = this.getReceiverValues(setResolvedCall);
            SmartFMap<PseudoValue, ValueParameterDescriptor> argumentValues = this.getArraySetterArguments(rhsDeferredValue, setResolvedCall);
            this.builder.call(parentExpression, setResolvedCall, receiverValues, (Map<PseudoValue, ValueParameterDescriptor>)argumentValues);
        }

        private SmartFMap<PseudoValue, ValueParameterDescriptor> getArraySetterArguments(Function0<PseudoValue> rhsDeferredValue, final ResolvedCall<FunctionDescriptor> setResolvedCall) {
            List valueArguments2 = (List)KotlinPackage.flatMapTo(setResolvedCall.getResultingDescriptor().getValueParameters(), new ArrayList(), (Function1)new Function1<ValueParameterDescriptor, Iterable<? extends ValueArgument>>(){

                public Iterable<? extends ValueArgument> invoke(ValueParameterDescriptor descriptor2) {
                    ResolvedValueArgument resolvedValueArgument = setResolvedCall.getValueArguments().get(descriptor2);
                    return resolvedValueArgument != null ? resolvedValueArgument.getArguments() : Collections.emptyList();
                }
            });
            ValueArgument rhsArgument = (ValueArgument)KotlinPackage.lastOrNull((List)valueArguments2);
            SmartFMap argumentValues = SmartFMap.emptyMap();
            for (ValueArgument valueArgument : valueArguments2) {
                ArgumentMapping argumentMapping = setResolvedCall.getArgumentMapping(valueArgument);
                if (argumentMapping.isError() || !(argumentMapping instanceof ArgumentMatch)) continue;
                ValueParameterDescriptor parameterDescriptor = ((ArgumentMatch)argumentMapping).getValueParameter();
                if (valueArgument != rhsArgument) {
                    argumentValues = this.generateValueArgument(valueArgument, parameterDescriptor, (SmartFMap<PseudoValue, ValueParameterDescriptor>)argumentValues);
                    continue;
                }
                PseudoValue rhsValue = (PseudoValue)rhsDeferredValue.invoke();
                if (rhsValue == null) continue;
                argumentValues = argumentValues.plus((Object)rhsValue, (Object)parameterDescriptor);
            }
            return argumentValues;
        }

        private void generateArrayAccess(JetArrayAccessExpression arrayAccessExpression, @Nullable ResolvedCall<?> resolvedCall) {
            if (this.builder.getBoundValue(arrayAccessExpression) != null) {
                return;
            }
            this.mark(arrayAccessExpression);
            if (!this.checkAndGenerateCall(resolvedCall)) {
                this.generateArrayAccessWithoutCall(arrayAccessExpression);
            }
        }

        private void generateArrayAccessWithoutCall(JetArrayAccessExpression arrayAccessExpression) {
            this.createNonSyntheticValue((JetElement)arrayAccessExpression, this.generateArrayAccessArguments(arrayAccessExpression), MagicKind.UNRESOLVED_CALL);
        }

        private List<JetExpression> generateArrayAccessArguments(JetArrayAccessExpression arrayAccessExpression) {
            ArrayList<JetExpression> inputExpressions = new ArrayList<JetExpression>();
            JetExpression arrayExpression = arrayAccessExpression.getArrayExpression();
            inputExpressions.add(arrayExpression);
            this.generateInstructions(arrayExpression);
            for (JetExpression index2 : arrayAccessExpression.getIndexExpressions()) {
                this.generateInstructions(index2);
                inputExpressions.add(index2);
            }
            return inputExpressions;
        }

        @Override
        public void visitUnaryExpression(@NotNull JetUnaryExpression expression2) {
            PseudoValue rhsValue;
            if (expression2 == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "org/jetbrains/kotlin/cfg/JetControlFlowProcessor$CFPVisitor", "visitUnaryExpression"));
            }
            JetSimpleNameExpression operationSign = expression2.getOperationReference();
            IElementType operationType = operationSign.getReferencedNameElementType();
            JetExpression baseExpression = expression2.getBaseExpression();
            if (baseExpression == null) {
                return;
            }
            if (JetTokens.EXCLEXCL == operationType) {
                this.generateInstructions(baseExpression);
                this.builder.predefinedOperation(expression2, JetControlFlowBuilder.PredefinedOperation.NOT_NULL_ASSERTION, this.elementsToValues(Collections.singletonList(baseExpression)));
                return;
            }
            boolean incrementOrDecrement = this.isIncrementOrDecrement(operationType);
            ResolvedCall<? extends CallableDescriptor> resolvedCall = CallUtilPackage.getResolvedCall(expression2, JetControlFlowProcessor.this.trace.getBindingContext());
            if (resolvedCall != null) {
                rhsValue = this.generateCall(resolvedCall).getOutputValue();
            } else {
                this.generateInstructions(baseExpression);
                rhsValue = this.createNonSyntheticValue((JetElement)expression2, MagicKind.UNRESOLVED_CALL, baseExpression);
            }
            if (incrementOrDecrement) {
                this.visitAssignment(baseExpression, this.getValueAsFunction(rhsValue), expression2);
                if (expression2 instanceof JetPostfixExpression) {
                    this.copyValue(baseExpression, expression2);
                }
            }
        }

        private boolean isIncrementOrDecrement(IElementType operationType) {
            return operationType == JetTokens.PLUSPLUS || operationType == JetTokens.MINUSMINUS;
        }

        @Override
        public void visitIfExpression(@NotNull JetIfExpression expression2) {
            if (expression2 == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "org/jetbrains/kotlin/cfg/JetControlFlowProcessor$CFPVisitor", "visitIfExpression"));
            }
            this.mark(expression2);
            ArrayList<JetExpression> branches = new ArrayList<JetExpression>(2);
            JetExpression condition2 = expression2.getCondition();
            if (condition2 != null) {
                this.generateInstructions(condition2);
            }
            Label elseLabel = this.builder.createUnboundLabel("else branch");
            this.builder.jumpOnFalse(elseLabel, expression2, this.builder.getBoundValue(condition2));
            JetExpression thenBranch = expression2.getThen();
            if (thenBranch != null) {
                branches.add(thenBranch);
                this.generateInstructions(thenBranch);
            } else {
                this.builder.loadUnit(expression2);
            }
            Label resultLabel = this.builder.createUnboundLabel("'if' expression result");
            this.builder.jump(resultLabel, expression2);
            this.builder.bindLabel(elseLabel);
            JetExpression elseBranch = expression2.getElse();
            if (elseBranch != null) {
                branches.add(elseBranch);
                this.generateInstructions(elseBranch);
            } else {
                this.builder.loadUnit(expression2);
            }
            this.builder.bindLabel(resultLabel);
            this.mergeValues(branches, expression2);
        }

        @Override
        public void visitTryExpression(@NotNull JetTryExpression expression2) {
            boolean hasFinally;
            if (expression2 == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "org/jetbrains/kotlin/cfg/JetControlFlowProcessor$CFPVisitor", "visitTryExpression"));
            }
            this.mark(expression2);
            JetFinallySection finallyBlock = expression2.getFinallyBlock();
            final FinallyBlockGenerator finallyBlockGenerator = new FinallyBlockGenerator(finallyBlock);
            boolean bl = hasFinally = finallyBlock != null;
            if (hasFinally) {
                this.builder.enterTryFinally(new GenerationTrigger(){
                    private boolean working = false;

                    @Override
                    public void generate() {
                        if (this.working) {
                            return;
                        }
                        this.working = true;
                        finallyBlockGenerator.generate();
                        this.working = false;
                    }
                });
            }
            Label onExceptionToFinallyBlock = this.generateTryAndCatches(expression2);
            if (hasFinally) {
                assert (onExceptionToFinallyBlock != null) : "No finally lable generated: " + expression2.getText();
                this.builder.exitTryFinally();
                Label skipFinallyToErrorBlock = this.builder.createUnboundLabel("skipFinallyToErrorBlock");
                this.builder.jump(skipFinallyToErrorBlock, expression2);
                this.builder.bindLabel(onExceptionToFinallyBlock);
                finallyBlockGenerator.generate();
                this.builder.jumpToError(expression2);
                this.builder.bindLabel(skipFinallyToErrorBlock);
                finallyBlockGenerator.generate();
            }
            ArrayList<JetExpression> branches = new ArrayList<JetExpression>();
            branches.add(expression2.getTryBlock());
            for (JetCatchClause catchClause : expression2.getCatchClauses()) {
                branches.add(catchClause.getCatchBody());
            }
            this.mergeValues(branches, expression2);
        }

        @Nullable
        private Label generateTryAndCatches(@NotNull JetTryExpression expression2) {
            if (expression2 == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "org/jetbrains/kotlin/cfg/JetControlFlowProcessor$CFPVisitor", "generateTryAndCatches"));
            }
            List<JetCatchClause> catchClauses = expression2.getCatchClauses();
            boolean hasCatches = !catchClauses.isEmpty();
            Label onException = null;
            if (hasCatches) {
                onException = this.builder.createUnboundLabel("onException");
                this.builder.nondeterministicJump(onException, expression2, null);
            }
            Label onExceptionToFinallyBlock = null;
            if (expression2.getFinallyBlock() != null) {
                onExceptionToFinallyBlock = this.builder.createUnboundLabel("onExceptionToFinallyBlock");
                this.builder.nondeterministicJump(onExceptionToFinallyBlock, expression2, null);
            }
            JetBlockExpression tryBlock2 = expression2.getTryBlock();
            this.generateInstructions(tryBlock2);
            if (hasCatches) {
                Label afterCatches = this.builder.createUnboundLabel("afterCatches");
                this.builder.jump(afterCatches, expression2);
                this.builder.bindLabel(onException);
                LinkedList catchLabels = Lists.newLinkedList();
                int catchClausesSize = catchClauses.size();
                for (int i = 0; i < catchClausesSize - 1; ++i) {
                    catchLabels.add(this.builder.createUnboundLabel("catch " + i));
                }
                if (!catchLabels.isEmpty()) {
                    this.builder.nondeterministicJump(catchLabels, expression2);
                }
                boolean isFirst = true;
                for (JetCatchClause catchClause : catchClauses) {
                    JetExpression catchBody;
                    this.builder.enterLexicalScope(catchClause);
                    if (!isFirst) {
                        this.builder.bindLabel((Label)catchLabels.remove());
                    } else {
                        isFirst = false;
                    }
                    JetParameter catchParameter = catchClause.getCatchParameter();
                    if (catchParameter != null) {
                        this.builder.declareParameter(catchParameter);
                        this.generateInitializer(catchParameter, this.createSyntheticValue(catchParameter, MagicKind.FAKE_INITIALIZER, new JetElement[0]));
                    }
                    if ((catchBody = catchClause.getCatchBody()) != null) {
                        this.generateInstructions(catchBody);
                    }
                    this.builder.jump(afterCatches, expression2);
                    this.builder.exitLexicalScope(catchClause);
                }
                this.builder.bindLabel(afterCatches);
            }
            return onExceptionToFinallyBlock;
        }

        @Override
        public void visitWhileExpression(@NotNull JetWhileExpression expression2) {
            if (expression2 == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "org/jetbrains/kotlin/cfg/JetControlFlowProcessor$CFPVisitor", "visitWhileExpression"));
            }
            LoopInfo loopInfo = this.builder.enterLoop(expression2);
            this.builder.bindLabel(loopInfo.getConditionEntryPoint());
            JetExpression condition2 = expression2.getCondition();
            if (condition2 != null) {
                this.generateInstructions(condition2);
            }
            this.mark(expression2);
            boolean conditionIsTrueConstant = CompileTimeConstantUtils.canBeReducedToBooleanConstant(condition2, JetControlFlowProcessor.this.trace, true);
            if (!conditionIsTrueConstant) {
                this.builder.jumpOnFalse(loopInfo.getExitPoint(), expression2, this.builder.getBoundValue(condition2));
            } else {
                assert (condition2 != null) : "Invalid while condition: " + expression2.getText();
                this.createSyntheticValue(condition2, MagicKind.VALUE_CONSUMER, condition2);
            }
            this.builder.enterLoopBody(expression2);
            JetExpression body2 = expression2.getBody();
            if (body2 != null) {
                this.generateInstructions(body2);
            }
            this.builder.jump(loopInfo.getEntryPoint(), expression2);
            this.builder.exitLoopBody(expression2);
            this.builder.bindLabel(loopInfo.getExitPoint());
            this.builder.loadUnit(expression2);
        }

        @Override
        public void visitDoWhileExpression(@NotNull JetDoWhileExpression expression2) {
            if (expression2 == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "org/jetbrains/kotlin/cfg/JetControlFlowProcessor$CFPVisitor", "visitDoWhileExpression"));
            }
            this.builder.enterLexicalScope(expression2);
            this.mark(expression2);
            LoopInfo loopInfo = this.builder.enterLoop(expression2);
            this.builder.enterLoopBody(expression2);
            JetExpression body2 = expression2.getBody();
            if (body2 != null) {
                this.generateInstructions(body2);
            }
            this.builder.exitLoopBody(expression2);
            this.builder.bindLabel(loopInfo.getConditionEntryPoint());
            JetExpression condition2 = expression2.getCondition();
            if (condition2 != null) {
                this.generateInstructions(condition2);
            }
            this.builder.jumpOnTrue(loopInfo.getEntryPoint(), expression2, this.builder.getBoundValue(condition2));
            this.builder.bindLabel(loopInfo.getExitPoint());
            this.builder.loadUnit(expression2);
            this.builder.exitLexicalScope(expression2);
        }

        @Override
        public void visitForExpression(@NotNull JetForExpression expression2) {
            if (expression2 == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "org/jetbrains/kotlin/cfg/JetControlFlowProcessor$CFPVisitor", "visitForExpression"));
            }
            this.builder.enterLexicalScope(expression2);
            JetExpression loopRange = expression2.getLoopRange();
            if (loopRange != null) {
                this.generateInstructions(loopRange);
            }
            this.declareLoopParameter(expression2);
            LoopInfo loopInfo = this.builder.enterLoop(expression2);
            this.builder.bindLabel(loopInfo.getConditionEntryPoint());
            this.builder.nondeterministicJump(loopInfo.getExitPoint(), expression2, null);
            this.writeLoopParameterAssignment(expression2);
            this.mark(expression2);
            this.builder.enterLoopBody(expression2);
            JetExpression body2 = expression2.getBody();
            if (body2 != null) {
                this.generateInstructions(body2);
            }
            this.builder.jump(loopInfo.getEntryPoint(), expression2);
            this.builder.exitLoopBody(expression2);
            this.builder.bindLabel(loopInfo.getExitPoint());
            this.builder.loadUnit(expression2);
            this.builder.exitLexicalScope(expression2);
        }

        private void declareLoopParameter(JetForExpression expression2) {
            JetParameter loopParameter = expression2.getLoopParameter();
            JetMultiDeclaration multiDeclaration = expression2.getMultiParameter();
            if (loopParameter != null) {
                this.builder.declareParameter(loopParameter);
            } else if (multiDeclaration != null) {
                this.visitMultiDeclaration(multiDeclaration, false);
            }
        }

        private void writeLoopParameterAssignment(JetForExpression expression2) {
            JetParameter loopParameter = expression2.getLoopParameter();
            JetMultiDeclaration multiDeclaration = expression2.getMultiParameter();
            JetExpression loopRange = expression2.getLoopRange();
            PseudoValue value2 = this.builder.magic(loopRange != null ? loopRange : expression2, null, ContainerUtil.createMaybeSingletonList((Object)this.builder.getBoundValue(loopRange)), MagicKind.LOOP_RANGE_ITERATION).getOutputValue();
            if (loopParameter != null) {
                this.generateInitializer(loopParameter, value2);
            } else if (multiDeclaration != null) {
                for (JetMultiDeclarationEntry entry : multiDeclaration.getEntries()) {
                    this.generateInitializer(entry, value2);
                }
            }
        }

        @Override
        public void visitBreakExpression(@NotNull JetBreakExpression expression2) {
            if (expression2 == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "org/jetbrains/kotlin/cfg/JetControlFlowProcessor$CFPVisitor", "visitBreakExpression"));
            }
            JetElement loop = this.getCorrespondingLoop(expression2);
            if (loop != null) {
                this.checkJumpDoesNotCrossFunctionBoundary(expression2, loop);
                this.builder.jump(this.builder.getExitPoint(loop), expression2);
            }
        }

        @Override
        public void visitContinueExpression(@NotNull JetContinueExpression expression2) {
            if (expression2 == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "org/jetbrains/kotlin/cfg/JetControlFlowProcessor$CFPVisitor", "visitContinueExpression"));
            }
            JetElement loop = this.getCorrespondingLoop(expression2);
            if (loop != null) {
                this.checkJumpDoesNotCrossFunctionBoundary(expression2, loop);
                this.builder.jump(this.builder.getConditionEntryPoint(loop), expression2);
            }
        }

        @Nullable
        private JetElement getCorrespondingLoop(JetExpressionWithLabel expression2) {
            JetLoopExpression loop;
            String labelName = expression2.getLabelName();
            if (labelName != null) {
                JetSimpleNameExpression targetLabel = expression2.getTargetLabel();
                assert (targetLabel != null);
                PsiElement labeledElement = JetControlFlowProcessor.this.trace.get(BindingContext.LABEL_TARGET, targetLabel);
                if (labeledElement instanceof JetLoopExpression) {
                    loop = (JetLoopExpression)labeledElement;
                } else {
                    JetControlFlowProcessor.this.trace.report(Errors.NOT_A_LOOP_LABEL.on(expression2, targetLabel.getText()));
                    loop = null;
                }
            } else {
                loop = this.builder.getCurrentLoop();
                if (loop == null) {
                    JetControlFlowProcessor.this.trace.report(Errors.BREAK_OR_CONTINUE_OUTSIDE_A_LOOP.on(expression2));
                } else {
                    JetWhenExpression whenExpression2 = (JetWhenExpression)PsiTreeUtil.getParentOfType((PsiElement)expression2, JetWhenExpression.class, (boolean)true, (Class[])new Class[]{JetLoopExpression.class});
                    if (whenExpression2 != null) {
                        JetControlFlowProcessor.this.trace.report(Errors.BREAK_OR_CONTINUE_IN_WHEN.on(expression2));
                    }
                }
            }
            if (loop != null && loop.getBody() != null && !loop.getBody().getTextRange().contains(expression2.getTextRange())) {
                JetControlFlowProcessor.this.trace.report(Errors.BREAK_OR_CONTINUE_OUTSIDE_A_LOOP.on(expression2));
                return null;
            }
            return loop;
        }

        private void checkJumpDoesNotCrossFunctionBoundary(@NotNull JetExpressionWithLabel jumpExpression, @NotNull JetElement jumpTarget) {
            FunctionDescriptor labelTargetEnclosingFunc;
            if (jumpExpression == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "jumpExpression", "org/jetbrains/kotlin/cfg/JetControlFlowProcessor$CFPVisitor", "checkJumpDoesNotCrossFunctionBoundary"));
            }
            if (jumpTarget == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "jumpTarget", "org/jetbrains/kotlin/cfg/JetControlFlowProcessor$CFPVisitor", "checkJumpDoesNotCrossFunctionBoundary"));
            }
            BindingContext bindingContext2 = JetControlFlowProcessor.this.trace.getBindingContext();
            FunctionDescriptor labelExprEnclosingFunc = BindingContextUtils.getEnclosingFunctionDescriptor(bindingContext2, jumpExpression);
            if (labelExprEnclosingFunc != (labelTargetEnclosingFunc = BindingContextUtils.getEnclosingFunctionDescriptor(bindingContext2, jumpTarget))) {
                JetControlFlowProcessor.this.trace.report(Errors.BREAK_OR_CONTINUE_JUMPS_ACROSS_FUNCTION_BOUNDARY.on(jumpExpression));
            }
        }

        @Override
        public void visitReturnExpression(@NotNull JetReturnExpression expression2) {
            JetElement subroutine;
            if (expression2 == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "org/jetbrains/kotlin/cfg/JetControlFlowProcessor$CFPVisitor", "visitReturnExpression"));
            }
            JetExpression returnedExpression = expression2.getReturnedExpression();
            if (returnedExpression != null) {
                this.generateInstructions(returnedExpression);
            }
            JetSimpleNameExpression labelElement = expression2.getTargetLabel();
            String labelName = expression2.getLabelName();
            if (labelElement != null && labelName != null) {
                PsiElement labeledElement = JetControlFlowProcessor.this.trace.get(BindingContext.LABEL_TARGET, labelElement);
                if (labeledElement != null) {
                    assert (labeledElement instanceof JetElement);
                    subroutine = (JetElement)labeledElement;
                } else {
                    subroutine = null;
                }
            } else {
                subroutine = this.builder.getReturnSubroutine();
            }
            if (subroutine instanceof JetFunction || subroutine instanceof JetPropertyAccessor) {
                PseudoValue returnValue;
                PseudoValue pseudoValue = returnValue = returnedExpression != null ? this.builder.getBoundValue(returnedExpression) : null;
                if (returnValue == null) {
                    this.builder.returnNoValue(expression2, subroutine);
                } else {
                    this.builder.returnValue(expression2, returnValue, subroutine);
                }
            } else {
                this.createNonSyntheticValue((JetElement)expression2, MagicKind.UNSUPPORTED_ELEMENT, returnedExpression);
            }
        }

        @Override
        public void visitParameter(@NotNull JetParameter parameter) {
            if (parameter == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parameter", "org/jetbrains/kotlin/cfg/JetControlFlowProcessor$CFPVisitor", "visitParameter"));
            }
            this.builder.declareParameter(parameter);
            JetExpression defaultValue = parameter.getDefaultValue();
            if (defaultValue != null) {
                Label skipDefaultValue = this.builder.createUnboundLabel("after default value for parameter " + parameter.getName());
                this.builder.nondeterministicJump(skipDefaultValue, defaultValue, null);
                this.generateInstructions(defaultValue);
                this.builder.bindLabel(skipDefaultValue);
            }
            this.generateInitializer(parameter, this.computePseudoValueForParameter(parameter));
        }

        @NotNull
        private PseudoValue computePseudoValueForParameter(@NotNull JetParameter parameter) {
            if (parameter == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parameter", "org/jetbrains/kotlin/cfg/JetControlFlowProcessor$CFPVisitor", "computePseudoValueForParameter"));
            }
            PseudoValue syntheticValue = this.createSyntheticValue(parameter, MagicKind.FAKE_INITIALIZER, new JetElement[0]);
            PseudoValue defaultValue = this.builder.getBoundValue(parameter.getDefaultValue());
            if (defaultValue == null) {
                PseudoValue pseudoValue = syntheticValue;
                if (pseudoValue == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/cfg/JetControlFlowProcessor$CFPVisitor", "computePseudoValueForParameter"));
                }
                return pseudoValue;
            }
            PseudoValue pseudoValue = this.builder.merge(parameter, Lists.newArrayList((Object[])new PseudoValue[]{defaultValue, syntheticValue})).getOutputValue();
            if (pseudoValue == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/cfg/JetControlFlowProcessor$CFPVisitor", "computePseudoValueForParameter"));
            }
            return pseudoValue;
        }

        @Override
        public void visitBlockExpression(@NotNull JetBlockExpression expression2) {
            boolean declareLexicalScope;
            if (expression2 == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "org/jetbrains/kotlin/cfg/JetControlFlowProcessor$CFPVisitor", "visitBlockExpression"));
            }
            boolean bl = declareLexicalScope = !this.isBlockInDoWhile(expression2);
            if (declareLexicalScope) {
                this.builder.enterLexicalScope(expression2);
            }
            this.mark(expression2);
            List<JetExpression> statements = expression2.getStatements();
            for (JetExpression statement : statements) {
                this.generateInstructions(statement);
            }
            if (statements.isEmpty()) {
                this.builder.loadUnit(expression2);
            } else {
                this.copyValue((JetElement)KotlinPackage.lastOrNull(statements), expression2);
            }
            if (declareLexicalScope) {
                this.builder.exitLexicalScope(expression2);
            }
        }

        private boolean isBlockInDoWhile(@NotNull JetBlockExpression expression2) {
            if (expression2 == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "org/jetbrains/kotlin/cfg/JetControlFlowProcessor$CFPVisitor", "isBlockInDoWhile"));
            }
            PsiElement parent2 = expression2.getParent();
            if (parent2 == null) {
                return false;
            }
            return parent2.getParent() instanceof JetDoWhileExpression;
        }

        private void visitFunction(@NotNull JetFunction function2) {
            boolean isAnonymousFunction;
            if (function2 == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "function", "org/jetbrains/kotlin/cfg/JetControlFlowProcessor$CFPVisitor", "visitFunction"));
            }
            JetControlFlowProcessor.this.processLocalDeclaration(function2);
            boolean bl = isAnonymousFunction = function2 instanceof JetFunctionLiteral || function2.getName() == null;
            if (isAnonymousFunction || function2.isLocal() && !(function2.getParent() instanceof JetBlockExpression)) {
                this.builder.createLambda(function2);
            }
        }

        @Override
        public void visitNamedFunction(@NotNull JetNamedFunction function2) {
            if (function2 == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "function", "org/jetbrains/kotlin/cfg/JetControlFlowProcessor$CFPVisitor", "visitNamedFunction"));
            }
            this.visitFunction(function2);
        }

        @Override
        public void visitFunctionLiteralExpression(@NotNull JetFunctionLiteralExpression expression2) {
            if (expression2 == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "org/jetbrains/kotlin/cfg/JetControlFlowProcessor$CFPVisitor", "visitFunctionLiteralExpression"));
            }
            this.mark(expression2);
            JetFunctionLiteral functionLiteral = expression2.getFunctionLiteral();
            this.visitFunction(functionLiteral);
            this.copyValue(functionLiteral, expression2);
        }

        @Override
        public void visitQualifiedExpression(@NotNull JetQualifiedExpression expression2) {
            if (expression2 == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "org/jetbrains/kotlin/cfg/JetControlFlowProcessor$CFPVisitor", "visitQualifiedExpression"));
            }
            this.mark(expression2);
            JetExpression selectorExpression = expression2.getSelectorExpression();
            JetExpression receiverExpression = expression2.getReceiverExpression();
            if (selectorExpression instanceof JetCallExpression || selectorExpression instanceof JetSimpleNameExpression) {
                this.generateInstructions(selectorExpression);
                this.copyValue(selectorExpression, expression2);
            } else {
                this.generateInstructions(receiverExpression);
                this.createNonSyntheticValue((JetElement)expression2, MagicKind.UNSUPPORTED_ELEMENT, receiverExpression);
            }
        }

        @Override
        public void visitCallExpression(@NotNull JetCallExpression expression2) {
            if (expression2 == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "org/jetbrains/kotlin/cfg/JetControlFlowProcessor$CFPVisitor", "visitCallExpression"));
            }
            if (!this.generateCall(expression2)) {
                ArrayList<JetExpression> inputExpressions = new ArrayList<JetExpression>();
                for (JetValueArgument argument : expression2.getValueArguments()) {
                    JetExpression argumentExpression = argument.getArgumentExpression();
                    if (argumentExpression == null) continue;
                    this.generateInstructions(argumentExpression);
                    inputExpressions.add(argumentExpression);
                }
                JetExpression calleeExpression = expression2.getCalleeExpression();
                this.generateInstructions(calleeExpression);
                inputExpressions.add(calleeExpression);
                inputExpressions.add(this.generateAndGetReceiverIfAny(expression2));
                this.mark(expression2);
                this.createNonSyntheticValue((JetElement)expression2, inputExpressions, MagicKind.UNRESOLVED_CALL);
            }
        }

        @Nullable
        private JetExpression generateAndGetReceiverIfAny(JetExpression expression2) {
            PsiElement parent2 = expression2.getParent();
            if (!(parent2 instanceof JetQualifiedExpression)) {
                return null;
            }
            JetQualifiedExpression qualifiedExpression = (JetQualifiedExpression)parent2;
            if (qualifiedExpression.getSelectorExpression() != expression2) {
                return null;
            }
            JetExpression receiverExpression = qualifiedExpression.getReceiverExpression();
            this.generateInstructions(receiverExpression);
            return receiverExpression;
        }

        @Override
        public void visitProperty(@NotNull JetProperty property2) {
            JetExpression delegate2;
            if (property2 == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "property", "org/jetbrains/kotlin/cfg/JetControlFlowProcessor$CFPVisitor", "visitProperty"));
            }
            this.builder.declareVariable(property2);
            JetExpression initializer = property2.getInitializer();
            if (initializer != null) {
                this.visitAssignment(property2, this.getDeferredValue(initializer), property2);
            }
            if ((delegate2 = property2.getDelegateExpression()) != null) {
                this.generateInstructions(delegate2);
                if (this.builder.getBoundValue(delegate2) != null) {
                    this.createSyntheticValue(property2, MagicKind.VALUE_CONSUMER, delegate2);
                }
            }
            if (JetPsiUtil.isLocal(property2)) {
                for (JetPropertyAccessor accessor : property2.getAccessors()) {
                    this.generateInstructions(accessor);
                }
            }
        }

        @Override
        public void visitMultiDeclaration(@NotNull JetMultiDeclaration declaration) {
            if (declaration == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "declaration", "org/jetbrains/kotlin/cfg/JetControlFlowProcessor$CFPVisitor", "visitMultiDeclaration"));
            }
            this.visitMultiDeclaration(declaration, true);
        }

        @Override
        private void visitMultiDeclaration(@NotNull JetMultiDeclaration declaration, boolean generateWriteForEntries) {
            if (declaration == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "declaration", "org/jetbrains/kotlin/cfg/JetControlFlowProcessor$CFPVisitor", "visitMultiDeclaration"));
            }
            JetExpression initializer = declaration.getInitializer();
            this.generateInstructions(initializer);
            for (JetMultiDeclarationEntry entry : declaration.getEntries()) {
                this.builder.declareVariable(entry);
                ResolvedCall<FunctionDescriptor> resolvedCall = JetControlFlowProcessor.this.trace.get(BindingContext.COMPONENT_RESOLVED_CALL, entry);
                PseudoValue writtenValue = resolvedCall != null ? this.builder.call(entry, resolvedCall, this.getReceiverValues(resolvedCall), Collections.<PseudoValue, ValueParameterDescriptor>emptyMap()).getOutputValue() : this.createSyntheticValue(entry, MagicKind.UNRESOLVED_CALL, initializer);
                if (!generateWriteForEntries) continue;
                this.generateInitializer(entry, writtenValue != null ? writtenValue : this.createSyntheticValue(entry, MagicKind.FAKE_INITIALIZER, new JetElement[0]));
            }
        }

        @Override
        public void visitPropertyAccessor(@NotNull JetPropertyAccessor accessor) {
            if (accessor == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "accessor", "org/jetbrains/kotlin/cfg/JetControlFlowProcessor$CFPVisitor", "visitPropertyAccessor"));
            }
            JetControlFlowProcessor.this.processLocalDeclaration(accessor);
        }

        @Override
        public void visitBinaryWithTypeRHSExpression(@NotNull JetBinaryExpressionWithTypeRHS expression2) {
            if (expression2 == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "org/jetbrains/kotlin/cfg/JetControlFlowProcessor$CFPVisitor", "visitBinaryWithTypeRHSExpression"));
            }
            this.mark(expression2);
            IElementType operationType = expression2.getOperationReference().getReferencedNameElementType();
            JetExpression left = expression2.getLeft();
            if (operationType == JetTokens.COLON || operationType == JetTokens.AS_KEYWORD || operationType == JetTokens.AS_SAFE) {
                this.generateInstructions(left);
                if (this.getBoundOrUnreachableValue(left) != null) {
                    this.createNonSyntheticValue((JetElement)expression2, MagicKind.CAST, left);
                }
            } else {
                this.visitJetElement(expression2);
                this.createNonSyntheticValue((JetElement)expression2, MagicKind.UNSUPPORTED_ELEMENT, left);
            }
        }

        @Override
        public void visitThrowExpression(@NotNull JetThrowExpression expression2) {
            if (expression2 == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "org/jetbrains/kotlin/cfg/JetControlFlowProcessor$CFPVisitor", "visitThrowExpression"));
            }
            this.mark(expression2);
            JetExpression thrownExpression = expression2.getThrownExpression();
            if (thrownExpression == null) {
                return;
            }
            this.generateInstructions(thrownExpression);
            PseudoValue thrownValue = this.builder.getBoundValue(thrownExpression);
            if (thrownValue == null) {
                return;
            }
            this.builder.throwException(expression2, thrownValue);
        }

        @Override
        public void visitArrayAccessExpression(@NotNull JetArrayAccessExpression expression2) {
            if (expression2 == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "org/jetbrains/kotlin/cfg/JetControlFlowProcessor$CFPVisitor", "visitArrayAccessExpression"));
            }
            this.generateArrayAccess(expression2, JetControlFlowProcessor.this.trace.get(BindingContext.INDEXED_LVALUE_GET, expression2));
        }

        @Override
        public void visitIsExpression(@NotNull JetIsExpression expression2) {
            if (expression2 == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "org/jetbrains/kotlin/cfg/JetControlFlowProcessor$CFPVisitor", "visitIsExpression"));
            }
            this.mark(expression2);
            JetExpression left = expression2.getLeftHandSide();
            this.generateInstructions(left);
            this.createNonSyntheticValue((JetElement)expression2, MagicKind.IS, left);
        }

        @Override
        public void visitWhenExpression(@NotNull JetWhenExpression expression2) {
            if (expression2 == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "org/jetbrains/kotlin/cfg/JetControlFlowProcessor$CFPVisitor", "visitWhenExpression"));
            }
            this.mark(expression2);
            JetExpression subjectExpression = expression2.getSubjectExpression();
            if (subjectExpression != null) {
                this.generateInstructions(subjectExpression);
            }
            ArrayList<JetExpression> branches = new ArrayList<JetExpression>();
            Label doneLabel = this.builder.createUnboundLabel("after 'when' expression");
            Label nextLabel = null;
            Iterator<JetWhenEntry> iterator2 = expression2.getEntries().iterator();
            while (iterator2.hasNext()) {
                JetWhenEntry whenEntry = iterator2.next();
                this.mark(whenEntry);
                boolean isElse = whenEntry.isElse();
                if (isElse && iterator2.hasNext()) {
                    JetControlFlowProcessor.this.trace.report(Errors.ELSE_MISPLACED_IN_WHEN.on(whenEntry));
                }
                Label bodyLabel = this.builder.createUnboundLabel("'when' entry body");
                Object[] conditions = whenEntry.getConditions();
                for (int i = 0; i < conditions.length; ++i) {
                    JetWhenCondition condition2 = conditions[i];
                    condition2.accept(this.conditionVisitor);
                    if (i + 1 >= conditions.length) continue;
                    this.builder.nondeterministicJump(bodyLabel, expression2, this.builder.getBoundValue(condition2));
                }
                if (!isElse) {
                    nextLabel = this.builder.createUnboundLabel("next 'when' entry");
                    JetWhenCondition lastCondition = (JetWhenCondition)KotlinPackage.lastOrNull((Object[])conditions);
                    this.builder.nondeterministicJump(nextLabel, expression2, this.builder.getBoundValue(lastCondition));
                }
                this.builder.bindLabel(bodyLabel);
                JetExpression whenEntryExpression = whenEntry.getExpression();
                if (whenEntryExpression != null) {
                    this.generateInstructions(whenEntryExpression);
                    branches.add(whenEntryExpression);
                }
                this.builder.jump(doneLabel, expression2);
                if (isElse) continue;
                this.builder.bindLabel(nextLabel);
                if (iterator2.hasNext() || !WhenChecker.isWhenExhaustive(expression2, JetControlFlowProcessor.this.trace)) continue;
                this.builder.jumpToError(expression2);
            }
            this.builder.bindLabel(doneLabel);
            this.mergeValues(branches, expression2);
        }

        @Override
        public void visitObjectLiteralExpression(@NotNull JetObjectLiteralExpression expression2) {
            if (expression2 == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "org/jetbrains/kotlin/cfg/JetControlFlowProcessor$CFPVisitor", "visitObjectLiteralExpression"));
            }
            this.mark(expression2);
            JetObjectDeclaration declaration = expression2.getObjectDeclaration();
            this.generateInstructions(declaration);
            this.builder.createAnonymousObject(expression2);
        }

        @Override
        public void visitObjectDeclaration(@NotNull JetObjectDeclaration objectDeclaration) {
            if (objectDeclaration == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "objectDeclaration", "org/jetbrains/kotlin/cfg/JetControlFlowProcessor$CFPVisitor", "visitObjectDeclaration"));
            }
            this.generateHeaderDelegationSpecifiers(objectDeclaration);
            this.generateClassOrObjectInitializers(objectDeclaration);
            this.generateDeclarationForLocalClassOrObjectIfNeeded(objectDeclaration);
        }

        @Override
        public void visitStringTemplateExpression(@NotNull JetStringTemplateExpression expression2) {
            if (expression2 == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "org/jetbrains/kotlin/cfg/JetControlFlowProcessor$CFPVisitor", "visitStringTemplateExpression"));
            }
            this.mark(expression2);
            ArrayList<JetExpression> inputExpressions = new ArrayList<JetExpression>();
            for (JetStringTemplateEntry entry : expression2.getEntries()) {
                if (!(entry instanceof JetStringTemplateEntryWithExpression)) continue;
                JetExpression entryExpression = entry.getExpression();
                this.generateInstructions(entryExpression);
                inputExpressions.add(entryExpression);
            }
            this.builder.loadStringTemplate(expression2, this.elementsToValues(inputExpressions));
        }

        @Override
        public void visitTypeProjection(@NotNull JetTypeProjection typeProjection) {
            if (typeProjection == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "typeProjection", "org/jetbrains/kotlin/cfg/JetControlFlowProcessor$CFPVisitor", "visitTypeProjection"));
            }
        }

        @Override
        public void visitAnonymousInitializer(@NotNull JetClassInitializer classInitializer) {
            if (classInitializer == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "classInitializer", "org/jetbrains/kotlin/cfg/JetControlFlowProcessor$CFPVisitor", "visitAnonymousInitializer"));
            }
            this.generateInstructions(classInitializer.getBody());
        }

        private void generateHeaderDelegationSpecifiers(@NotNull JetClassOrObject classOrObject) {
            if (classOrObject == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "classOrObject", "org/jetbrains/kotlin/cfg/JetControlFlowProcessor$CFPVisitor", "generateHeaderDelegationSpecifiers"));
            }
            for (JetDelegationSpecifier specifier : classOrObject.getDelegationSpecifiers()) {
                this.generateInstructions(specifier);
            }
        }

        private void generateClassOrObjectInitializers(@NotNull JetClassOrObject classOrObject) {
            if (classOrObject == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "classOrObject", "org/jetbrains/kotlin/cfg/JetControlFlowProcessor$CFPVisitor", "generateClassOrObjectInitializers"));
            }
            for (JetDeclaration declaration : classOrObject.getDeclarations()) {
                if (!(declaration instanceof JetProperty) && !(declaration instanceof JetClassInitializer)) continue;
                this.generateInstructions(declaration);
            }
        }

        @Override
        public void visitClass(@NotNull JetClass klass) {
            if (klass == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "klass", "org/jetbrains/kotlin/cfg/JetControlFlowProcessor$CFPVisitor", "visitClass"));
            }
            if (klass.hasPrimaryConstructor()) {
                this.processParameters(klass.getPrimaryConstructorParameters());
                this.generateHeaderDelegationSpecifiers(klass);
                this.generateClassOrObjectInitializers(klass);
            }
            this.generateDeclarationForLocalClassOrObjectIfNeeded(klass);
        }

        private void generateDeclarationForLocalClassOrObjectIfNeeded(@NotNull JetClassOrObject classOrObject) {
            if (classOrObject == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "classOrObject", "org/jetbrains/kotlin/cfg/JetControlFlowProcessor$CFPVisitor", "generateDeclarationForLocalClassOrObjectIfNeeded"));
            }
            if (classOrObject.isLocal()) {
                for (JetDeclaration declaration : classOrObject.getDeclarations()) {
                    if (declaration instanceof JetSecondaryConstructor || declaration instanceof JetProperty || declaration instanceof JetClassInitializer) continue;
                    this.generateInstructions(declaration);
                }
            }
        }

        private void processParameters(@NotNull List<JetParameter> parameters2) {
            if (parameters2 == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parameters", "org/jetbrains/kotlin/cfg/JetControlFlowProcessor$CFPVisitor", "processParameters"));
            }
            for (JetParameter parameter : parameters2) {
                this.generateInstructions(parameter);
            }
        }

        @Override
        public void visitSecondaryConstructor(@NotNull JetSecondaryConstructor constructor) {
            if (constructor == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "constructor", "org/jetbrains/kotlin/cfg/JetControlFlowProcessor$CFPVisitor", "visitSecondaryConstructor"));
            }
            JetClassOrObject classOrObject = (JetClassOrObject)PsiTreeUtil.getParentOfType((PsiElement)constructor, JetClassOrObject.class);
            assert (classOrObject != null) : "Guaranteed by parsing contract";
            this.processParameters(constructor.getValueParameters());
            this.generateCallOrMarkUnresolved(constructor.getDelegationCall());
            if (!constructor.getDelegationCall().isCallToThis()) {
                this.generateClassOrObjectInitializers(classOrObject);
            }
            this.generateInstructions(constructor.getBodyExpression());
        }

        @Override
        public void visitDelegationToSuperCallSpecifier(@NotNull JetDelegatorToSuperCall call) {
            if (call == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "call", "org/jetbrains/kotlin/cfg/JetControlFlowProcessor$CFPVisitor", "visitDelegationToSuperCallSpecifier"));
            }
            this.generateCallOrMarkUnresolved(call);
        }

        private void generateCallOrMarkUnresolved(@Nullable JetCallElement call) {
            if (call == null) {
                return;
            }
            if (!this.generateCall(call)) {
                List arguments2 = KotlinPackage.map(call.getValueArguments(), (Function1)new Function1<ValueArgument, JetExpression>(){

                    public JetExpression invoke(ValueArgument valueArgument) {
                        return valueArgument.getArgumentExpression();
                    }
                });
                for (JetExpression argument : arguments2) {
                    this.generateInstructions(argument);
                }
                this.createNonSyntheticValue((JetElement)call, arguments2, MagicKind.UNRESOLVED_CALL);
            }
        }

        @Override
        public void visitDelegationByExpressionSpecifier(@NotNull JetDelegatorByExpressionSpecifier specifier) {
            if (specifier == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "specifier", "org/jetbrains/kotlin/cfg/JetControlFlowProcessor$CFPVisitor", "visitDelegationByExpressionSpecifier"));
            }
            JetExpression delegateExpression = specifier.getDelegateExpression();
            this.generateInstructions(delegateExpression);
            this.createSyntheticValue(specifier, MagicKind.VALUE_CONSUMER, delegateExpression);
        }

        @Override
        public void visitDelegationToSuperClassSpecifier(@NotNull JetDelegatorToSuperClass specifier) {
            if (specifier == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "specifier", "org/jetbrains/kotlin/cfg/JetControlFlowProcessor$CFPVisitor", "visitDelegationToSuperClassSpecifier"));
            }
        }

        @Override
        public void visitDelegationSpecifierList(@NotNull JetDelegationSpecifierList list) {
            if (list == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "list", "org/jetbrains/kotlin/cfg/JetControlFlowProcessor$CFPVisitor", "visitDelegationSpecifierList"));
            }
            list.acceptChildren(this);
        }

        @Override
        public void visitJetFile(@NotNull JetFile file) {
            if (file == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "org/jetbrains/kotlin/cfg/JetControlFlowProcessor$CFPVisitor", "visitJetFile"));
            }
            for (JetDeclaration declaration : file.getDeclarations()) {
                if (!(declaration instanceof JetProperty)) continue;
                this.generateInstructions(declaration);
            }
        }

        @Override
        public void visitDoubleColonExpression(@NotNull JetDoubleColonExpression expression2) {
            if (expression2 == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "org/jetbrains/kotlin/cfg/JetControlFlowProcessor$CFPVisitor", "visitDoubleColonExpression"));
            }
            this.mark(expression2);
            this.createNonSyntheticValue((JetElement)expression2, MagicKind.CALLABLE_REFERENCE, new JetElement[0]);
        }

        @Override
        public void visitJetElement(@NotNull JetElement element2) {
            if (element2 == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "org/jetbrains/kotlin/cfg/JetControlFlowProcessor$CFPVisitor", "visitJetElement"));
            }
            this.createNonSyntheticValue(element2, MagicKind.UNSUPPORTED_ELEMENT, new JetElement[0]);
        }

        private boolean generateCall(@Nullable JetElement callElement2) {
            if (callElement2 == null) {
                return false;
            }
            return this.checkAndGenerateCall(CallUtilPackage.getResolvedCall(callElement2, JetControlFlowProcessor.this.trace.getBindingContext()));
        }

        private boolean checkAndGenerateCall(@Nullable ResolvedCall<?> resolvedCall) {
            if (resolvedCall == null) {
                return false;
            }
            this.generateCall(resolvedCall);
            return true;
        }

        @NotNull
        private InstructionWithValue generateCall(@NotNull ResolvedCall<?> resolvedCall) {
            if (resolvedCall == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "resolvedCall", "org/jetbrains/kotlin/cfg/JetControlFlowProcessor$CFPVisitor", "generateCall"));
            }
            JetElement callElement2 = resolvedCall.getCall().getCallElement();
            Map<PseudoValue, ReceiverValue> receivers = this.getReceiverValues(resolvedCall);
            SmartFMap<PseudoValue, ValueParameterDescriptor> parameterValues = SmartFMap.emptyMap();
            for (ValueArgument valueArgument : resolvedCall.getCall().getValueArguments()) {
                ArgumentMapping argumentMapping = resolvedCall.getArgumentMapping(valueArgument);
                JetExpression argumentExpression = valueArgument.getArgumentExpression();
                if (argumentMapping instanceof ArgumentMatch) {
                    parameterValues = this.generateValueArgument(valueArgument, ((ArgumentMatch)argumentMapping).getValueParameter(), parameterValues);
                    continue;
                }
                if (argumentExpression == null) continue;
                this.generateInstructions(argumentExpression);
                this.createSyntheticValue(argumentExpression, MagicKind.VALUE_CONSUMER, argumentExpression);
            }
            if (resolvedCall.getResultingDescriptor() instanceof VariableDescriptor) {
                JetExpression callExpression;
                JetExpression jetExpression = callExpression = callElement2 instanceof JetExpression ? (JetExpression)callElement2 : null;
                assert (callExpression != null) : "Variable-based call without callee expression: " + callElement2.getText();
                assert (parameterValues.isEmpty()) : "Variable-based call with non-empty argument list: " + callElement2.getText();
                ReadValueInstruction readValueInstruction = this.builder.readVariable(callExpression, resolvedCall, receivers);
                if (readValueInstruction == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/cfg/JetControlFlowProcessor$CFPVisitor", "generateCall"));
                }
                return readValueInstruction;
            }
            this.mark(resolvedCall.getCall().getCallElement());
            CallInstruction callInstruction = this.builder.call(callElement2, resolvedCall, receivers, (Map<PseudoValue, ValueParameterDescriptor>)parameterValues);
            if (callInstruction == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/cfg/JetControlFlowProcessor$CFPVisitor", "generateCall"));
            }
            return callInstruction;
        }

        @NotNull
        private Map<PseudoValue, ReceiverValue> getReceiverValues(ResolvedCall<?> resolvedCall) {
            PseudoValue varCallResult = null;
            ReceiverValue explicitReceiver = ReceiverValue.NO_RECEIVER;
            if (resolvedCall instanceof VariableAsFunctionResolvedCall) {
                varCallResult = this.generateCall(((VariableAsFunctionResolvedCall)((Object)resolvedCall)).getVariableCall()).getOutputValue();
                ExplicitReceiverKind kind2 = resolvedCall.getExplicitReceiverKind();
                switch (kind2) {
                    case DISPATCH_RECEIVER: {
                        explicitReceiver = resolvedCall.getDispatchReceiver();
                        break;
                    }
                    case EXTENSION_RECEIVER: 
                    case BOTH_RECEIVERS: {
                        explicitReceiver = resolvedCall.getExtensionReceiver();
                    }
                }
            }
            SmartFMap<PseudoValue, ReceiverValue> receiverValues = SmartFMap.emptyMap();
            if (explicitReceiver.exists() && varCallResult != null) {
                receiverValues = receiverValues.plus((Object)varCallResult, (Object)explicitReceiver);
            }
            JetElement callElement2 = resolvedCall.getCall().getCallElement();
            receiverValues = this.getReceiverValues(callElement2, resolvedCall.getDispatchReceiver(), receiverValues);
            SmartFMap<PseudoValue, ReceiverValue> smartFMap = receiverValues = this.getReceiverValues(callElement2, resolvedCall.getExtensionReceiver(), receiverValues);
            if (smartFMap == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/cfg/JetControlFlowProcessor$CFPVisitor", "getReceiverValues"));
            }
            return smartFMap;
        }

        @NotNull
        private SmartFMap<PseudoValue, ReceiverValue> getReceiverValues(JetElement callElement2, ReceiverValue receiver, SmartFMap<PseudoValue, ReceiverValue> receiverValues) {
            if (!receiver.exists() || receiverValues.containsValue((Object)receiver)) {
                SmartFMap smartFMap = receiverValues;
                if (smartFMap == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/cfg/JetControlFlowProcessor$CFPVisitor", "getReceiverValues"));
                }
                return smartFMap;
            }
            if (receiver instanceof ThisReceiver) {
                receiverValues = receiverValues.plus((Object)this.createSyntheticValue(callElement2, MagicKind.IMPLICIT_RECEIVER, new JetElement[0]), (Object)receiver);
            } else if (receiver instanceof ExpressionReceiver) {
                PseudoValue receiverPseudoValue;
                JetExpression expression2 = ((ExpressionReceiver)receiver).getExpression();
                if (this.builder.getBoundValue(expression2) == null) {
                    this.generateInstructions(expression2);
                }
                if ((receiverPseudoValue = this.getBoundOrUnreachableValue(expression2)) != null) {
                    receiverValues = receiverValues.plus((Object)receiverPseudoValue, (Object)receiver);
                }
            } else if (!(receiver instanceof TransientReceiver)) {
                throw new IllegalArgumentException("Unknown receiver kind: " + receiver);
            }
            SmartFMap smartFMap = receiverValues;
            if (smartFMap == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/cfg/JetControlFlowProcessor$CFPVisitor", "getReceiverValues"));
            }
            return smartFMap;
        }

        @NotNull
        private SmartFMap<PseudoValue, ValueParameterDescriptor> generateValueArgument(ValueArgument valueArgument, ValueParameterDescriptor parameterDescriptor, SmartFMap<PseudoValue, ValueParameterDescriptor> parameterValues) {
            JetExpression expression2 = valueArgument.getArgumentExpression();
            if (expression2 != null) {
                PseudoValue argValue;
                if (!valueArgument.isExternal()) {
                    this.generateInstructions(expression2);
                }
                if ((argValue = this.getBoundOrUnreachableValue(expression2)) != null) {
                    parameterValues = parameterValues.plus((Object)argValue, (Object)parameterDescriptor);
                }
            }
            SmartFMap smartFMap = parameterValues;
            if (smartFMap == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/cfg/JetControlFlowProcessor$CFPVisitor", "generateValueArgument"));
            }
            return smartFMap;
        }

        private class FinallyBlockGenerator {
            private final JetFinallySection finallyBlock;
            private Label startFinally = null;
            private Label finishFinally = null;

            private FinallyBlockGenerator(JetFinallySection block) {
                this.finallyBlock = block;
            }

            public void generate() {
                JetBlockExpression finalExpression = this.finallyBlock.getFinalExpression();
                if (finalExpression == null) {
                    return;
                }
                if (this.startFinally != null) {
                    assert (this.finishFinally != null);
                    CFPVisitor.this.builder.repeatPseudocode(this.startFinally, this.finishFinally);
                    return;
                }
                this.startFinally = CFPVisitor.this.builder.createUnboundLabel("start finally");
                CFPVisitor.this.builder.bindLabel(this.startFinally);
                CFPVisitor.this.generateInstructions(finalExpression);
                this.finishFinally = CFPVisitor.this.builder.createUnboundLabel("finish finally");
                CFPVisitor.this.builder.bindLabel(this.finishFinally);
            }
        }
    }
}

