/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.cfg;

import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.cfg.InstructionDataMergeStrategy;
import org.jetbrains.kotlin.cfg.LexicalScopeVariableInfo;
import org.jetbrains.kotlin.cfg.PseudocodeVariableDataCollector;
import org.jetbrains.kotlin.cfg.pseudocode.Pseudocode;
import org.jetbrains.kotlin.cfg.pseudocode.PseudocodeUtil;
import org.jetbrains.kotlin.cfg.pseudocode.instructions.Instruction;
import org.jetbrains.kotlin.cfg.pseudocode.instructions.LexicalScope;
import org.jetbrains.kotlin.cfg.pseudocode.instructions.eval.ReadValueInstruction;
import org.jetbrains.kotlin.cfg.pseudocode.instructions.eval.WriteValueInstruction;
import org.jetbrains.kotlin.cfg.pseudocode.instructions.special.LocalFunctionDeclarationInstruction;
import org.jetbrains.kotlin.cfg.pseudocode.instructions.special.VariableDeclarationInstruction;
import org.jetbrains.kotlin.cfg.pseudocodeTraverser.Edges;
import org.jetbrains.kotlin.cfg.pseudocodeTraverser.TraversalOrder;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.descriptors.VariableDescriptor;
import org.jetbrains.kotlin.psi.JetDeclaration;
import org.jetbrains.kotlin.psi.JetProperty;
import org.jetbrains.kotlin.resolve.BindingContext;

public class PseudocodeVariablesData {
    private final Pseudocode pseudocode;
    private final BindingContext bindingContext;
    private final PseudocodeVariableDataCollector pseudocodeVariableDataCollector;
    private final Map<Pseudocode, Set<VariableDescriptor>> declaredVariablesForDeclaration;
    private Map<Instruction, Edges<Map<VariableDescriptor, VariableControlFlowState>>> variableInitializers;

    public PseudocodeVariablesData(@NotNull Pseudocode pseudocode2, @NotNull BindingContext bindingContext2) {
        if (pseudocode2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "pseudocode", "org/jetbrains/kotlin/cfg/PseudocodeVariablesData", "<init>"));
        }
        if (bindingContext2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "bindingContext", "org/jetbrains/kotlin/cfg/PseudocodeVariablesData", "<init>"));
        }
        this.declaredVariablesForDeclaration = Maps.newHashMap();
        this.pseudocode = pseudocode2;
        this.bindingContext = bindingContext2;
        this.pseudocodeVariableDataCollector = new PseudocodeVariableDataCollector(bindingContext2, pseudocode2);
    }

    @NotNull
    public Pseudocode getPseudocode() {
        Pseudocode pseudocode2 = this.pseudocode;
        if (pseudocode2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/cfg/PseudocodeVariablesData", "getPseudocode"));
        }
        return pseudocode2;
    }

    @NotNull
    public LexicalScopeVariableInfo getLexicalScopeVariableInfo() {
        LexicalScopeVariableInfo lexicalScopeVariableInfo = this.pseudocodeVariableDataCollector.getLexicalScopeVariableInfo();
        if (lexicalScopeVariableInfo == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/cfg/PseudocodeVariablesData", "getLexicalScopeVariableInfo"));
        }
        return lexicalScopeVariableInfo;
    }

    @NotNull
    public Set<VariableDescriptor> getDeclaredVariables(@NotNull Pseudocode pseudocode2, boolean includeInsideLocalDeclarations) {
        if (pseudocode2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "pseudocode", "org/jetbrains/kotlin/cfg/PseudocodeVariablesData", "getDeclaredVariables"));
        }
        if (!includeInsideLocalDeclarations) {
            Set<VariableDescriptor> set = this.getUpperLevelDeclaredVariables(pseudocode2);
            if (set == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/cfg/PseudocodeVariablesData", "getDeclaredVariables"));
            }
            return set;
        }
        HashSet declaredVariables = Sets.newHashSet();
        declaredVariables.addAll(this.getUpperLevelDeclaredVariables(pseudocode2));
        for (LocalFunctionDeclarationInstruction localFunctionDeclarationInstruction : pseudocode2.getLocalDeclarations()) {
            Pseudocode localPseudocode = localFunctionDeclarationInstruction.getBody();
            declaredVariables.addAll(this.getUpperLevelDeclaredVariables(localPseudocode));
        }
        HashSet hashSet = declaredVariables;
        if (hashSet == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/cfg/PseudocodeVariablesData", "getDeclaredVariables"));
        }
        return hashSet;
    }

    @NotNull
    private Set<VariableDescriptor> getUpperLevelDeclaredVariables(@NotNull Pseudocode pseudocode2) {
        if (pseudocode2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "pseudocode", "org/jetbrains/kotlin/cfg/PseudocodeVariablesData", "getUpperLevelDeclaredVariables"));
        }
        Set<VariableDescriptor> declaredVariables = this.declaredVariablesForDeclaration.get(pseudocode2);
        if (declaredVariables == null) {
            declaredVariables = this.computeDeclaredVariablesForPseudocode(pseudocode2);
            this.declaredVariablesForDeclaration.put(pseudocode2, declaredVariables);
        }
        Set<VariableDescriptor> set = declaredVariables;
        if (set == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/cfg/PseudocodeVariablesData", "getUpperLevelDeclaredVariables"));
        }
        return set;
    }

    @NotNull
    private Set<VariableDescriptor> computeDeclaredVariablesForPseudocode(Pseudocode pseudocode2) {
        HashSet declaredVariables = Sets.newHashSet();
        for (Instruction instruction : pseudocode2.getInstructions()) {
            JetDeclaration variableDeclarationElement;
            DeclarationDescriptor descriptor2;
            if (!(instruction instanceof VariableDeclarationInstruction) || (descriptor2 = this.bindingContext.get(BindingContext.DECLARATION_TO_DESCRIPTOR, variableDeclarationElement = ((VariableDeclarationInstruction)instruction).getVariableDeclarationElement())) == null) continue;
            assert (descriptor2 instanceof VariableDescriptor);
            declaredVariables.add((VariableDescriptor)descriptor2);
        }
        Set<VariableDescriptor> set = Collections.unmodifiableSet(declaredVariables);
        if (set == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/cfg/PseudocodeVariablesData", "computeDeclaredVariablesForPseudocode"));
        }
        return set;
    }

    @NotNull
    public Map<Instruction, Edges<Map<VariableDescriptor, VariableControlFlowState>>> getVariableInitializers() {
        if (this.variableInitializers == null) {
            this.variableInitializers = this.computeVariableInitializers();
        }
        Map<Instruction, Edges<Map<VariableDescriptor, VariableControlFlowState>>> map2 = this.variableInitializers;
        if (map2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/cfg/PseudocodeVariablesData", "getVariableInitializers"));
        }
        return map2;
    }

    @NotNull
    private Map<Instruction, Edges<Map<VariableDescriptor, VariableControlFlowState>>> computeVariableInitializers() {
        final LexicalScopeVariableInfo lexicalScopeVariableInfo = this.pseudocodeVariableDataCollector.getLexicalScopeVariableInfo();
        Map<Instruction, Edges<Map<VariableDescriptor, VariableControlFlowState>>> map2 = this.pseudocodeVariableDataCollector.collectData(TraversalOrder.FORWARD, false, new InstructionDataMergeStrategy<VariableControlFlowState>(){

            @NotNull
            public Edges<Map<VariableDescriptor, VariableControlFlowState>> invoke(@NotNull Instruction instruction, @NotNull Collection<? extends Map<VariableDescriptor, VariableControlFlowState>> incomingEdgesData) {
                if (instruction == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "instruction", "org/jetbrains/kotlin/cfg/PseudocodeVariablesData$1", "invoke"));
                }
                if (incomingEdgesData == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "incomingEdgesData", "org/jetbrains/kotlin/cfg/PseudocodeVariablesData$1", "invoke"));
                }
                Map enterInstructionData = PseudocodeVariablesData.mergeIncomingEdgesDataForInitializers(incomingEdgesData);
                Map exitInstructionData = PseudocodeVariablesData.this.addVariableInitStateFromCurrentInstructionIfAny(instruction, enterInstructionData, lexicalScopeVariableInfo);
                Edges<Map<VariableDescriptor, VariableControlFlowState>> edges = new Edges<Map<VariableDescriptor, VariableControlFlowState>>(enterInstructionData, exitInstructionData);
                if (edges == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/cfg/PseudocodeVariablesData$1", "invoke"));
                }
                return edges;
            }
        });
        if (map2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/cfg/PseudocodeVariablesData", "computeVariableInitializers"));
        }
        return map2;
    }

    public static VariableControlFlowState getDefaultValueForInitializers(@NotNull VariableDescriptor variable, @NotNull Instruction instruction, @NotNull LexicalScopeVariableInfo lexicalScopeVariableInfo) {
        if (variable == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "variable", "org/jetbrains/kotlin/cfg/PseudocodeVariablesData", "getDefaultValueForInitializers"));
        }
        if (instruction == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "instruction", "org/jetbrains/kotlin/cfg/PseudocodeVariablesData", "getDefaultValueForInitializers"));
        }
        if (lexicalScopeVariableInfo == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "lexicalScopeVariableInfo", "org/jetbrains/kotlin/cfg/PseudocodeVariablesData", "getDefaultValueForInitializers"));
        }
        LexicalScope declaredIn = lexicalScopeVariableInfo.getDeclaredIn().get(variable);
        boolean declaredOutsideThisDeclaration = declaredIn == null || declaredIn.getLexicalScopeForContainingDeclaration() != instruction.getLexicalScope().getLexicalScopeForContainingDeclaration();
        return VariableControlFlowState.create(declaredOutsideThisDeclaration);
    }

    @NotNull
    private static Map<VariableDescriptor, VariableControlFlowState> mergeIncomingEdgesDataForInitializers(@NotNull Collection<? extends Map<VariableDescriptor, VariableControlFlowState>> incomingEdgesData) {
        if (incomingEdgesData == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "incomingEdgesData", "org/jetbrains/kotlin/cfg/PseudocodeVariablesData", "mergeIncomingEdgesDataForInitializers"));
        }
        HashSet variablesInScope = Sets.newHashSet();
        for (Map<VariableDescriptor, VariableControlFlowState> map2 : incomingEdgesData) {
            variablesInScope.addAll(map2.keySet());
        }
        HashMap enterInstructionData = Maps.newHashMap();
        for (VariableDescriptor variable : variablesInScope) {
            TriInitState initState = null;
            boolean isDeclared = true;
            for (Map<VariableDescriptor, VariableControlFlowState> map3 : incomingEdgesData) {
                VariableControlFlowState varControlFlowState = map3.get(variable);
                if (varControlFlowState == null) continue;
                TriInitState triInitState = initState = initState != null ? initState.merge(varControlFlowState.initState) : varControlFlowState.initState;
                if (varControlFlowState.isDeclared) continue;
                isDeclared = false;
            }
            if (initState == null) {
                throw new AssertionError((Object)"An empty set of incoming edges data");
            }
            enterInstructionData.put(variable, VariableControlFlowState.create(initState, isDeclared));
        }
        HashMap hashMap = enterInstructionData;
        if (hashMap == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/cfg/PseudocodeVariablesData", "mergeIncomingEdgesDataForInitializers"));
        }
        return hashMap;
    }

    @NotNull
    private Map<VariableDescriptor, VariableControlFlowState> addVariableInitStateFromCurrentInstructionIfAny(@NotNull Instruction instruction, @NotNull Map<VariableDescriptor, VariableControlFlowState> enterInstructionData, @NotNull LexicalScopeVariableInfo lexicalScopeVariableInfo) {
        if (instruction == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "instruction", "org/jetbrains/kotlin/cfg/PseudocodeVariablesData", "addVariableInitStateFromCurrentInstructionIfAny"));
        }
        if (enterInstructionData == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "enterInstructionData", "org/jetbrains/kotlin/cfg/PseudocodeVariablesData", "addVariableInitStateFromCurrentInstructionIfAny"));
        }
        if (lexicalScopeVariableInfo == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "lexicalScopeVariableInfo", "org/jetbrains/kotlin/cfg/PseudocodeVariablesData", "addVariableInitStateFromCurrentInstructionIfAny"));
        }
        if (!(instruction instanceof WriteValueInstruction) && !(instruction instanceof VariableDeclarationInstruction)) {
            Map<VariableDescriptor, VariableControlFlowState> map2 = enterInstructionData;
            if (map2 == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/cfg/PseudocodeVariablesData", "addVariableInitStateFromCurrentInstructionIfAny"));
            }
            return map2;
        }
        VariableDescriptor variable = PseudocodeUtil.extractVariableDescriptorIfAny(instruction, false, this.bindingContext);
        if (variable == null) {
            Map<VariableDescriptor, VariableControlFlowState> map3 = enterInstructionData;
            if (map3 == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/cfg/PseudocodeVariablesData", "addVariableInitStateFromCurrentInstructionIfAny"));
            }
            return map3;
        }
        HashMap exitInstructionData = Maps.newHashMap(enterInstructionData);
        if (instruction instanceof WriteValueInstruction) {
            if (!PseudocodeUtil.isThisOrNoDispatchReceiver((WriteValueInstruction)instruction, this.bindingContext)) {
                Map<VariableDescriptor, VariableControlFlowState> map4 = enterInstructionData;
                if (map4 == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/cfg/PseudocodeVariablesData", "addVariableInitStateFromCurrentInstructionIfAny"));
                }
                return map4;
            }
            VariableControlFlowState enterInitState = enterInstructionData.get(variable);
            VariableControlFlowState initializationAtThisElement = VariableControlFlowState.create(((WriteValueInstruction)instruction).getElement() instanceof JetProperty, enterInitState);
            exitInstructionData.put(variable, initializationAtThisElement);
        } else {
            VariableControlFlowState enterInitState = enterInstructionData.get(variable);
            if (enterInitState == null) {
                enterInitState = PseudocodeVariablesData.getDefaultValueForInitializers(variable, instruction, lexicalScopeVariableInfo);
            }
            if (enterInitState == null || !enterInitState.mayBeInitialized() || !enterInitState.isDeclared) {
                boolean isInitialized = enterInitState != null && enterInitState.mayBeInitialized();
                VariableControlFlowState variableDeclarationInfo = VariableControlFlowState.create(isInitialized, true);
                exitInstructionData.put(variable, variableDeclarationInfo);
            }
        }
        HashMap hashMap = exitInstructionData;
        if (hashMap == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/cfg/PseudocodeVariablesData", "addVariableInitStateFromCurrentInstructionIfAny"));
        }
        return hashMap;
    }

    @NotNull
    public Map<Instruction, Edges<Map<VariableDescriptor, VariableUseState>>> getVariableUseStatusData() {
        Map<Instruction, Edges<Map<VariableDescriptor, VariableUseState>>> map2 = this.pseudocodeVariableDataCollector.collectData(TraversalOrder.BACKWARD, true, new InstructionDataMergeStrategy<VariableUseState>(){

            @NotNull
            public Edges<Map<VariableDescriptor, VariableUseState>> invoke(@NotNull Instruction instruction, @NotNull Collection<? extends Map<VariableDescriptor, VariableUseState>> incomingEdgesData) {
                if (instruction == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "instruction", "org/jetbrains/kotlin/cfg/PseudocodeVariablesData$2", "invoke"));
                }
                if (incomingEdgesData == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "incomingEdgesData", "org/jetbrains/kotlin/cfg/PseudocodeVariablesData$2", "invoke"));
                }
                HashMap enterResult = Maps.newHashMap();
                for (Map<VariableDescriptor, VariableUseState> map2 : incomingEdgesData) {
                    for (Map.Entry<VariableDescriptor, VariableUseState> entry : map2.entrySet()) {
                        VariableDescriptor variableDescriptor = entry.getKey();
                        VariableUseState variableUseState = entry.getValue();
                        enterResult.put(variableDescriptor, variableUseState.merge((VariableUseState)((Object)enterResult.get(variableDescriptor))));
                    }
                }
                VariableDescriptor variableDescriptor = PseudocodeUtil.extractVariableDescriptorIfAny(instruction, true, PseudocodeVariablesData.this.bindingContext);
                if (variableDescriptor == null || !(instruction instanceof ReadValueInstruction) && !(instruction instanceof WriteValueInstruction)) {
                    Edges<Map<VariableDescriptor, VariableUseState>> edges = new Edges<Map<VariableDescriptor, VariableUseState>>(enterResult, enterResult);
                    if (edges == null) {
                        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/cfg/PseudocodeVariablesData$2", "invoke"));
                    }
                    return edges;
                }
                HashMap hashMap = Maps.newHashMap((Map)enterResult);
                if (instruction instanceof ReadValueInstruction) {
                    hashMap.put(variableDescriptor, VariableUseState.READ);
                } else {
                    VariableUseState variableUseState = (VariableUseState)((Object)enterResult.get(variableDescriptor));
                    if (variableUseState == null) {
                        variableUseState = VariableUseState.UNUSED;
                    }
                    switch (variableUseState) {
                        case UNUSED: 
                        case ONLY_WRITTEN_NEVER_READ: {
                            hashMap.put(variableDescriptor, VariableUseState.ONLY_WRITTEN_NEVER_READ);
                            break;
                        }
                        case WRITTEN_AFTER_READ: 
                        case READ: {
                            hashMap.put(variableDescriptor, VariableUseState.WRITTEN_AFTER_READ);
                        }
                    }
                }
                Edges<Map<VariableDescriptor, VariableUseState>> edges = new Edges<Map<VariableDescriptor, VariableUseState>>(enterResult, hashMap);
                if (edges == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/cfg/PseudocodeVariablesData$2", "invoke"));
                }
                return edges;
            }
        });
        if (map2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/cfg/PseudocodeVariablesData", "getVariableUseStatusData"));
        }
        return map2;
    }

    public static enum VariableUseState {
        READ(3),
        WRITTEN_AFTER_READ(2),
        ONLY_WRITTEN_NEVER_READ(1),
        UNUSED(0);

        private final int priority;

        private VariableUseState(int priority) {
            this.priority = priority;
        }

        private VariableUseState merge(@Nullable VariableUseState variableUseState) {
            if (variableUseState == null || this.priority > variableUseState.priority) {
                return this;
            }
            return variableUseState;
        }

        public static boolean isUsed(@Nullable VariableUseState variableUseState) {
            return variableUseState != null && variableUseState != UNUSED;
        }
    }

    public static class VariableControlFlowState {
        public final TriInitState initState;
        public final boolean isDeclared;
        private static final VariableControlFlowState VS_IT = new VariableControlFlowState(TriInitState.INITIALIZED, true);
        private static final VariableControlFlowState VS_IF = new VariableControlFlowState(TriInitState.INITIALIZED, false);
        private static final VariableControlFlowState VS_UT = new VariableControlFlowState(TriInitState.UNKNOWN, true);
        private static final VariableControlFlowState VS_UF = new VariableControlFlowState(TriInitState.UNKNOWN, false);
        private static final VariableControlFlowState VS_NT = new VariableControlFlowState(TriInitState.NOT_INITIALIZED, true);
        private static final VariableControlFlowState VS_NF = new VariableControlFlowState(TriInitState.NOT_INITIALIZED, false);

        private VariableControlFlowState(TriInitState initState, boolean isDeclared) {
            this.initState = initState;
            this.isDeclared = isDeclared;
        }

        private static VariableControlFlowState create(TriInitState initState, boolean isDeclared) {
            switch (initState) {
                case INITIALIZED: {
                    return isDeclared ? VS_IT : VS_IF;
                }
                case UNKNOWN: {
                    return isDeclared ? VS_UT : VS_UF;
                }
            }
            return isDeclared ? VS_NT : VS_NF;
        }

        private static VariableControlFlowState create(boolean isInitialized, boolean isDeclared) {
            return VariableControlFlowState.create(isInitialized ? TriInitState.INITIALIZED : TriInitState.NOT_INITIALIZED, isDeclared);
        }

        private static VariableControlFlowState create(boolean isInitialized) {
            return VariableControlFlowState.create(isInitialized, false);
        }

        private static VariableControlFlowState create(boolean isDeclaredHere, @Nullable VariableControlFlowState mergedEdgesData) {
            return VariableControlFlowState.create(true, isDeclaredHere || mergedEdgesData != null && mergedEdgesData.isDeclared);
        }

        public boolean definitelyInitialized() {
            return this.initState == TriInitState.INITIALIZED;
        }

        public boolean mayBeInitialized() {
            return this.initState != TriInitState.NOT_INITIALIZED;
        }

        public String toString() {
            if (this.initState == TriInitState.NOT_INITIALIZED && !this.isDeclared) {
                return "-";
            }
            return (Object)((Object)this.initState) + (this.isDeclared ? "D" : "");
        }
    }

    private static enum TriInitState {
        INITIALIZED("I"),
        UNKNOWN("I?"),
        NOT_INITIALIZED("");

        private final String s;

        private TriInitState(String s) {
            this.s = s;
        }

        private TriInitState merge(@NotNull TriInitState other) {
            if (other == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "other", "org/jetbrains/kotlin/cfg/PseudocodeVariablesData$TriInitState", "merge"));
            }
            if (this == other) {
                return this;
            }
            return UNKNOWN;
        }

        public String toString() {
            return this.s;
        }
    }
}

