/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.cfg;

import java.util.HashSet;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.builtins.KotlinBuiltIns;
import org.jetbrains.kotlin.descriptors.ClassDescriptor;
import org.jetbrains.kotlin.descriptors.ClassKind;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.descriptors.Modality;
import org.jetbrains.kotlin.psi.JetExpression;
import org.jetbrains.kotlin.psi.JetQualifiedExpression;
import org.jetbrains.kotlin.psi.JetSimpleNameExpression;
import org.jetbrains.kotlin.psi.JetWhenCondition;
import org.jetbrains.kotlin.psi.JetWhenConditionIsPattern;
import org.jetbrains.kotlin.psi.JetWhenConditionWithExpression;
import org.jetbrains.kotlin.psi.JetWhenEntry;
import org.jetbrains.kotlin.psi.JetWhenExpression;
import org.jetbrains.kotlin.resolve.BindingContext;
import org.jetbrains.kotlin.resolve.BindingTrace;
import org.jetbrains.kotlin.resolve.CompileTimeConstantUtils;
import org.jetbrains.kotlin.resolve.DescriptorUtils;
import org.jetbrains.kotlin.resolve.bindingContextUtil.BindingContextUtilPackage;
import org.jetbrains.kotlin.types.JetType;
import org.jetbrains.kotlin.types.TypeUtils;
import org.jetbrains.kotlin.types.TypesPackage;

public final class WhenChecker {
    private WhenChecker() {
    }

    public static boolean mustHaveElse(@NotNull JetWhenExpression expression2, @NotNull BindingTrace trace) {
        if (expression2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "org/jetbrains/kotlin/cfg/WhenChecker", "mustHaveElse"));
        }
        if (trace == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "trace", "org/jetbrains/kotlin/cfg/WhenChecker", "mustHaveElse"));
        }
        JetType expectedType = trace.get(BindingContext.EXPECTED_EXPRESSION_TYPE, expression2);
        boolean isUnit = expectedType != null && KotlinBuiltIns.isUnit(expectedType);
        boolean isStatement = BindingContextUtilPackage.isUsedAsStatement(expression2, trace.getBindingContext()) && expectedType == null;
        return !isUnit && !isStatement && !WhenChecker.isWhenExhaustive(expression2, trace);
    }

    public static boolean isWhenByEnum(@NotNull JetWhenExpression expression2, @NotNull BindingContext context) {
        if (expression2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "org/jetbrains/kotlin/cfg/WhenChecker", "isWhenByEnum"));
        }
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "org/jetbrains/kotlin/cfg/WhenChecker", "isWhenByEnum"));
        }
        return WhenChecker.getClassDescriptorOfTypeIfEnum(WhenChecker.whenSubjectType(expression2, context)) != null;
    }

    @Nullable
    public static ClassDescriptor getClassDescriptorOfTypeIfEnum(@Nullable JetType type2) {
        if (type2 == null) {
            return null;
        }
        ClassDescriptor classDescriptor = TypeUtils.getClassDescriptor(type2);
        if (classDescriptor == null) {
            return null;
        }
        if (classDescriptor.getKind() != ClassKind.ENUM_CLASS || classDescriptor.getModality().isOverridable()) {
            return null;
        }
        return classDescriptor;
    }

    @Nullable
    private static JetType whenSubjectType(@NotNull JetWhenExpression expression2, @NotNull BindingContext context) {
        if (expression2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "org/jetbrains/kotlin/cfg/WhenChecker", "whenSubjectType"));
        }
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "org/jetbrains/kotlin/cfg/WhenChecker", "whenSubjectType"));
        }
        JetExpression subjectExpression = expression2.getSubjectExpression();
        return subjectExpression == null ? null : context.getType(subjectExpression);
    }

    private static boolean isWhenOnBooleanExhaustive(@NotNull JetWhenExpression expression2, @NotNull BindingTrace trace) {
        if (expression2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "org/jetbrains/kotlin/cfg/WhenChecker", "isWhenOnBooleanExhaustive"));
        }
        if (trace == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "trace", "org/jetbrains/kotlin/cfg/WhenChecker", "isWhenOnBooleanExhaustive"));
        }
        boolean containsFalse = false;
        boolean containsTrue = false;
        for (JetWhenEntry whenEntry : expression2.getEntries()) {
            for (JetWhenCondition whenCondition : whenEntry.getConditions()) {
                if (!(whenCondition instanceof JetWhenConditionWithExpression)) continue;
                JetExpression whenExpression2 = ((JetWhenConditionWithExpression)whenCondition).getExpression();
                if (CompileTimeConstantUtils.canBeReducedToBooleanConstant(whenExpression2, trace, true)) {
                    containsTrue = true;
                }
                if (!CompileTimeConstantUtils.canBeReducedToBooleanConstant(whenExpression2, trace, false)) continue;
                containsFalse = true;
            }
        }
        return containsFalse && containsTrue;
    }

    public static boolean isWhenOnEnumExhaustive(@NotNull JetWhenExpression expression2, @NotNull BindingTrace trace, @NotNull ClassDescriptor enumClassDescriptor) {
        if (expression2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "org/jetbrains/kotlin/cfg/WhenChecker", "isWhenOnEnumExhaustive"));
        }
        if (trace == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "trace", "org/jetbrains/kotlin/cfg/WhenChecker", "isWhenOnEnumExhaustive"));
        }
        if (enumClassDescriptor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "enumClassDescriptor", "org/jetbrains/kotlin/cfg/WhenChecker", "isWhenOnEnumExhaustive"));
        }
        assert (DescriptorUtils.isEnumClass(enumClassDescriptor)) : "isWhenOnEnumExhaustive should be called with an enum class descriptor";
        HashSet<ClassDescriptor> entryDescriptors = new HashSet<ClassDescriptor>();
        for (DeclarationDescriptor descriptor2 : enumClassDescriptor.getUnsubstitutedInnerClassesScope().getAllDescriptors()) {
            if (!DescriptorUtils.isEnumEntry(descriptor2)) continue;
            entryDescriptors.add((ClassDescriptor)descriptor2);
        }
        return !entryDescriptors.isEmpty() && WhenChecker.containsAllClassCases(expression2, entryDescriptors, trace);
    }

    private static void collectNestedSubclasses(@NotNull ClassDescriptor baseDescriptor, @NotNull ClassDescriptor currentDescriptor, @NotNull Set<ClassDescriptor> subclasses) {
        if (baseDescriptor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "baseDescriptor", "org/jetbrains/kotlin/cfg/WhenChecker", "collectNestedSubclasses"));
        }
        if (currentDescriptor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "currentDescriptor", "org/jetbrains/kotlin/cfg/WhenChecker", "collectNestedSubclasses"));
        }
        if (subclasses == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "subclasses", "org/jetbrains/kotlin/cfg/WhenChecker", "collectNestedSubclasses"));
        }
        for (DeclarationDescriptor descriptor2 : currentDescriptor.getUnsubstitutedInnerClassesScope().getAllDescriptors()) {
            if (!(descriptor2 instanceof ClassDescriptor)) continue;
            ClassDescriptor memberClassDescriptor = (ClassDescriptor)descriptor2;
            if (DescriptorUtils.isDirectSubclass(memberClassDescriptor, baseDescriptor)) {
                subclasses.add(memberClassDescriptor);
            }
            WhenChecker.collectNestedSubclasses(baseDescriptor, memberClassDescriptor, subclasses);
        }
    }

    private static boolean isWhenOnSealedClassExhaustive(@NotNull JetWhenExpression expression2, @NotNull BindingTrace trace, @NotNull ClassDescriptor classDescriptor) {
        if (expression2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "org/jetbrains/kotlin/cfg/WhenChecker", "isWhenOnSealedClassExhaustive"));
        }
        if (trace == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "trace", "org/jetbrains/kotlin/cfg/WhenChecker", "isWhenOnSealedClassExhaustive"));
        }
        if (classDescriptor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "classDescriptor", "org/jetbrains/kotlin/cfg/WhenChecker", "isWhenOnSealedClassExhaustive"));
        }
        assert (classDescriptor.getModality() == Modality.SEALED) : "isWhenOnSealedClassExhaustive should be called with a sealed class descriptor";
        HashSet<ClassDescriptor> memberClassDescriptors = new HashSet<ClassDescriptor>();
        WhenChecker.collectNestedSubclasses(classDescriptor, classDescriptor, memberClassDescriptors);
        return !memberClassDescriptors.isEmpty() && WhenChecker.containsAllClassCases(expression2, memberClassDescriptors, trace);
    }

    private static boolean isNullableTypeWithoutPossibleSmartCast(@Nullable JetExpression expression2, @NotNull JetType type2, @NotNull BindingContext context) {
        if (type2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "org/jetbrains/kotlin/cfg/WhenChecker", "isNullableTypeWithoutPossibleSmartCast"));
        }
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "org/jetbrains/kotlin/cfg/WhenChecker", "isNullableTypeWithoutPossibleSmartCast"));
        }
        if (expression2 == null) {
            return false;
        }
        if (!TypeUtils.isNullableType(type2)) {
            return false;
        }
        return context.get(BindingContext.SMARTCAST, expression2) == null;
    }

    public static boolean isWhenExhaustive(@NotNull JetWhenExpression expression2, @NotNull BindingTrace trace) {
        ClassDescriptor classDescriptor;
        if (expression2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "org/jetbrains/kotlin/cfg/WhenChecker", "isWhenExhaustive"));
        }
        if (trace == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "trace", "org/jetbrains/kotlin/cfg/WhenChecker", "isWhenExhaustive"));
        }
        JetType type2 = WhenChecker.whenSubjectType(expression2, trace.getBindingContext());
        if (type2 == null) {
            return false;
        }
        ClassDescriptor enumClassDescriptor = WhenChecker.getClassDescriptorOfTypeIfEnum(type2);
        boolean exhaustive = enumClassDescriptor == null ? (KotlinBuiltIns.isBoolean(TypeUtils.makeNotNullable(type2)) ? WhenChecker.isWhenOnBooleanExhaustive(expression2, trace) : (classDescriptor = TypeUtils.getClassDescriptor(type2)) != null && classDescriptor.getModality() == Modality.SEALED && WhenChecker.isWhenOnSealedClassExhaustive(expression2, trace, classDescriptor)) : WhenChecker.isWhenOnEnumExhaustive(expression2, trace, enumClassDescriptor);
        if (exhaustive && (enumClassDescriptor != null && TypesPackage.isFlexible(type2) || WhenChecker.containsNullCase(expression2, trace) || !WhenChecker.isNullableTypeWithoutPossibleSmartCast(expression2.getSubjectExpression(), type2, trace.getBindingContext()))) {
            trace.record(BindingContext.EXHAUSTIVE_WHEN, expression2);
            return true;
        }
        return false;
    }

    private static boolean containsAllClassCases(@NotNull JetWhenExpression whenExpression2, @NotNull Set<ClassDescriptor> memberDescriptors2, @NotNull BindingTrace trace) {
        if (whenExpression2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "whenExpression", "org/jetbrains/kotlin/cfg/WhenChecker", "containsAllClassCases"));
        }
        if (memberDescriptors2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "memberDescriptors", "org/jetbrains/kotlin/cfg/WhenChecker", "containsAllClassCases"));
        }
        if (trace == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "trace", "org/jetbrains/kotlin/cfg/WhenChecker", "containsAllClassCases"));
        }
        HashSet<ClassDescriptor> checkedDescriptors = new HashSet<ClassDescriptor>();
        for (JetWhenEntry whenEntry : whenExpression2.getEntries()) {
            for (JetWhenCondition condition2 : whenEntry.getConditions()) {
                DeclarationDescriptor target;
                JetSimpleNameExpression reference;
                JetWhenConditionWithExpression conditionWithExpression;
                boolean negated = false;
                ClassDescriptor checkedDescriptor = null;
                if (condition2 instanceof JetWhenConditionIsPattern) {
                    JetWhenConditionIsPattern conditionIsPattern = (JetWhenConditionIsPattern)condition2;
                    JetType checkedType = trace.get(BindingContext.TYPE, conditionIsPattern.getTypeReference());
                    if (checkedType != null) {
                        checkedDescriptor = TypeUtils.getClassDescriptor(checkedType);
                    }
                    negated = conditionIsPattern.isNegated();
                } else if (condition2 instanceof JetWhenConditionWithExpression && (conditionWithExpression = (JetWhenConditionWithExpression)condition2).getExpression() != null && (reference = WhenChecker.getReference(conditionWithExpression.getExpression())) != null && (target = trace.get(BindingContext.REFERENCE_TARGET, reference)) instanceof ClassDescriptor) {
                    checkedDescriptor = (ClassDescriptor)target;
                }
                if (checkedDescriptor == null || !memberDescriptors2.contains(checkedDescriptor) || condition2 instanceof JetWhenConditionWithExpression && !DescriptorUtils.isObject(checkedDescriptor) && !DescriptorUtils.isEnumEntry(checkedDescriptor)) continue;
                if (negated) {
                    if (checkedDescriptors.contains(checkedDescriptor)) {
                        return true;
                    }
                    checkedDescriptors.addAll(memberDescriptors2);
                    checkedDescriptors.remove(checkedDescriptor);
                    continue;
                }
                checkedDescriptors.add(checkedDescriptor);
            }
        }
        return checkedDescriptors.containsAll(memberDescriptors2);
    }

    public static boolean containsNullCase(@NotNull JetWhenExpression expression2, @NotNull BindingTrace trace) {
        if (expression2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "org/jetbrains/kotlin/cfg/WhenChecker", "containsNullCase"));
        }
        if (trace == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "trace", "org/jetbrains/kotlin/cfg/WhenChecker", "containsNullCase"));
        }
        for (JetWhenEntry entry : expression2.getEntries()) {
            for (JetWhenCondition condition2 : entry.getConditions()) {
                JetType type2;
                JetWhenConditionWithExpression conditionWithExpression;
                if (!(condition2 instanceof JetWhenConditionWithExpression) || (conditionWithExpression = (JetWhenConditionWithExpression)condition2).getExpression() == null || (type2 = trace.getBindingContext().getType(conditionWithExpression.getExpression())) == null || !KotlinBuiltIns.isNothingOrNullableNothing(type2)) continue;
                return true;
            }
        }
        return false;
    }

    @Nullable
    private static JetSimpleNameExpression getReference(@Nullable JetExpression expression2) {
        if (expression2 == null) {
            return null;
        }
        if (expression2 instanceof JetSimpleNameExpression) {
            return (JetSimpleNameExpression)expression2;
        }
        if (expression2 instanceof JetQualifiedExpression) {
            return WhenChecker.getReference(((JetQualifiedExpression)expression2).getSelectorExpression());
        }
        return null;
    }
}

