/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.codegen.state;

import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.builtins.BuiltinsPackageFragment;
import org.jetbrains.kotlin.builtins.KotlinBuiltIns;
import org.jetbrains.kotlin.builtins.PrimitiveType;
import org.jetbrains.kotlin.builtins.functions.FunctionClassDescriptor;
import org.jetbrains.kotlin.codegen.AccessorForCallableDescriptor;
import org.jetbrains.kotlin.codegen.AccessorForConstructorDescriptor;
import org.jetbrains.kotlin.codegen.AccessorForPropertyDescriptor;
import org.jetbrains.kotlin.codegen.AsmUtil;
import org.jetbrains.kotlin.codegen.CallableMethod;
import org.jetbrains.kotlin.codegen.ClassBuilderMode;
import org.jetbrains.kotlin.codegen.JvmCodegenUtil;
import org.jetbrains.kotlin.codegen.OwnerKind;
import org.jetbrains.kotlin.codegen.SamCodegenUtil;
import org.jetbrains.kotlin.codegen.SamType;
import org.jetbrains.kotlin.codegen.StackValue;
import org.jetbrains.kotlin.codegen.binding.CodegenBinding;
import org.jetbrains.kotlin.codegen.binding.MutableClosure;
import org.jetbrains.kotlin.codegen.binding.PsiCodegenPredictor;
import org.jetbrains.kotlin.codegen.signature.BothSignatureWriter;
import org.jetbrains.kotlin.descriptors.CallableDescriptor;
import org.jetbrains.kotlin.descriptors.CallableMemberDescriptor;
import org.jetbrains.kotlin.descriptors.ClassDescriptor;
import org.jetbrains.kotlin.descriptors.ClassKind;
import org.jetbrains.kotlin.descriptors.ClassifierDescriptor;
import org.jetbrains.kotlin.descriptors.ConstructorDescriptor;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.descriptors.FunctionDescriptor;
import org.jetbrains.kotlin.descriptors.PackageFragmentDescriptor;
import org.jetbrains.kotlin.descriptors.PropertyAccessorDescriptor;
import org.jetbrains.kotlin.descriptors.PropertyDescriptor;
import org.jetbrains.kotlin.descriptors.PropertyGetterDescriptor;
import org.jetbrains.kotlin.descriptors.ReceiverParameterDescriptor;
import org.jetbrains.kotlin.descriptors.ScriptDescriptor;
import org.jetbrains.kotlin.descriptors.SimpleFunctionDescriptor;
import org.jetbrains.kotlin.descriptors.TypeParameterDescriptor;
import org.jetbrains.kotlin.descriptors.ValueParameterDescriptor;
import org.jetbrains.kotlin.descriptors.VariableDescriptor;
import org.jetbrains.kotlin.descriptors.Visibilities;
import org.jetbrains.kotlin.descriptors.Visibility;
import org.jetbrains.kotlin.fileClasses.FileClassesPackage;
import org.jetbrains.kotlin.fileClasses.JvmFileClassUtil;
import org.jetbrains.kotlin.fileClasses.JvmFileClassesProvider;
import org.jetbrains.kotlin.load.java.JvmAbi;
import org.jetbrains.kotlin.load.java.descriptors.JavaCallableMemberDescriptor;
import org.jetbrains.kotlin.load.java.descriptors.JavaClassDescriptor;
import org.jetbrains.kotlin.load.java.lazy.descriptors.LazyJavaPackageScope;
import org.jetbrains.kotlin.load.kotlin.PackageClassUtils;
import org.jetbrains.kotlin.name.ClassId;
import org.jetbrains.kotlin.name.FqName;
import org.jetbrains.kotlin.name.FqNameUnsafe;
import org.jetbrains.kotlin.name.Name;
import org.jetbrains.kotlin.name.SpecialNames;
import org.jetbrains.kotlin.platform.JavaToKotlinClassMap;
import org.jetbrains.kotlin.psi.JetExpression;
import org.jetbrains.kotlin.psi.JetFile;
import org.jetbrains.kotlin.psi.JetFunctionLiteral;
import org.jetbrains.kotlin.psi.JetFunctionLiteralExpression;
import org.jetbrains.kotlin.resolve.BindingContext;
import org.jetbrains.kotlin.resolve.BindingContextUtils;
import org.jetbrains.kotlin.resolve.DescriptorToSourceUtils;
import org.jetbrains.kotlin.resolve.DescriptorUtils;
import org.jetbrains.kotlin.resolve.annotations.AnnotationsPackage;
import org.jetbrains.kotlin.resolve.calls.model.DefaultValueArgument;
import org.jetbrains.kotlin.resolve.calls.model.ResolvedCall;
import org.jetbrains.kotlin.resolve.calls.model.ResolvedValueArgument;
import org.jetbrains.kotlin.resolve.descriptorUtil.DescriptorUtilPackage;
import org.jetbrains.kotlin.resolve.jvm.AsmTypes;
import org.jetbrains.kotlin.resolve.jvm.JvmClassName;
import org.jetbrains.kotlin.resolve.jvm.JvmPrimitiveType;
import org.jetbrains.kotlin.resolve.jvm.jvmSignature.JvmMethodParameterKind;
import org.jetbrains.kotlin.resolve.jvm.jvmSignature.JvmMethodParameterSignature;
import org.jetbrains.kotlin.resolve.jvm.jvmSignature.JvmMethodSignature;
import org.jetbrains.kotlin.resolve.scopes.AbstractScopeAdapter;
import org.jetbrains.kotlin.resolve.scopes.JetScope;
import org.jetbrains.kotlin.serialization.deserialization.DeserializedType;
import org.jetbrains.kotlin.serialization.deserialization.descriptors.DeserializedCallableMemberDescriptor;
import org.jetbrains.kotlin.types.CommonSupertypes;
import org.jetbrains.kotlin.types.ErrorUtils;
import org.jetbrains.kotlin.types.IntersectionTypeConstructor;
import org.jetbrains.kotlin.types.JetType;
import org.jetbrains.kotlin.types.TypeConstructor;
import org.jetbrains.kotlin.types.TypeProjection;
import org.jetbrains.kotlin.types.TypeUtils;
import org.jetbrains.kotlin.types.TypesPackage;
import org.jetbrains.kotlin.types.Variance;
import org.jetbrains.kotlin.types.expressions.OperatorConventions;
import org.jetbrains.org.objectweb.asm.Type;
import org.jetbrains.org.objectweb.asm.commons.Method;

public class JetTypeMapper {
    private final BindingContext bindingContext;
    private final ClassBuilderMode classBuilderMode;
    private final JvmFileClassesProvider fileClassesProvider;

    public JetTypeMapper(@NotNull BindingContext bindingContext2, @NotNull ClassBuilderMode classBuilderMode, @NotNull JvmFileClassesProvider fileClassesProvider) {
        if (bindingContext2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "bindingContext", "org/jetbrains/kotlin/codegen/state/JetTypeMapper", "<init>"));
        }
        if (classBuilderMode == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "classBuilderMode", "org/jetbrains/kotlin/codegen/state/JetTypeMapper", "<init>"));
        }
        if (fileClassesProvider == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fileClassesProvider", "org/jetbrains/kotlin/codegen/state/JetTypeMapper", "<init>"));
        }
        this.bindingContext = bindingContext2;
        this.classBuilderMode = classBuilderMode;
        this.fileClassesProvider = fileClassesProvider;
    }

    @NotNull
    public BindingContext getBindingContext() {
        BindingContext bindingContext2 = this.bindingContext;
        if (bindingContext2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/codegen/state/JetTypeMapper", "getBindingContext"));
        }
        return bindingContext2;
    }

    @NotNull
    public Type mapOwner(@NotNull DeclarationDescriptor descriptor2) {
        if (descriptor2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptor", "org/jetbrains/kotlin/codegen/state/JetTypeMapper", "mapOwner"));
        }
        if (DescriptorUtils.isLocalFunction(descriptor2)) {
            Type type2 = CodegenBinding.asmTypeForAnonymousClass(this.bindingContext, (FunctionDescriptor)descriptor2);
            if (type2 == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/codegen/state/JetTypeMapper", "mapOwner"));
            }
            return type2;
        }
        DeclarationDescriptor container2 = descriptor2.getContainingDeclaration();
        if (container2 instanceof PackageFragmentDescriptor) {
            Type type3 = Type.getObjectType((String)this.internalNameForPackage((CallableMemberDescriptor)descriptor2));
            if (type3 == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/codegen/state/JetTypeMapper", "mapOwner"));
            }
            return type3;
        }
        if (container2 instanceof ClassDescriptor) {
            Type type4 = this.mapClass((ClassDescriptor)container2);
            if (type4 == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/codegen/state/JetTypeMapper", "mapOwner"));
            }
            return type4;
        }
        if (container2 instanceof ScriptDescriptor) {
            Type type5 = CodegenBinding.asmTypeForScriptDescriptor(this.bindingContext, (ScriptDescriptor)container2);
            if (type5 == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/codegen/state/JetTypeMapper", "mapOwner"));
            }
            return type5;
        }
        throw new UnsupportedOperationException("Don't know how to map owner for " + descriptor2);
    }

    @NotNull
    private String internalNameForPackage(@NotNull CallableMemberDescriptor descriptor2) {
        String facadeFqName;
        if (descriptor2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptor", "org/jetbrains/kotlin/codegen/state/JetTypeMapper", "internalNameForPackage"));
        }
        JetFile file = DescriptorToSourceUtils.getContainingFile(descriptor2);
        if (file != null) {
            Visibility visibility = descriptor2.getVisibility();
            if (descriptor2 instanceof PropertyDescriptor || Visibilities.isPrivate(visibility)) {
                String string = FileClassesPackage.getFileClassInternalName(this.fileClassesProvider, file);
                if (string == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/codegen/state/JetTypeMapper", "internalNameForPackage"));
                }
                return string;
            }
            String string = FileClassesPackage.getFacadeClassInternalName(this.fileClassesProvider, file);
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/codegen/state/JetTypeMapper", "internalNameForPackage"));
            }
            return string;
        }
        CallableMemberDescriptor directMember = JvmCodegenUtil.getDirectMember(descriptor2);
        if (directMember instanceof DeserializedCallableMemberDescriptor && (facadeFqName = JetTypeMapper.getPackageMemberOwnerInternalName((DeserializedCallableMemberDescriptor)directMember)) != null) {
            String string = facadeFqName;
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/codegen/state/JetTypeMapper", "internalNameForPackage"));
            }
            return string;
        }
        throw new RuntimeException("Unreachable state");
    }

    @Nullable
    private static String getPackageMemberOwnerInternalName(@NotNull DeserializedCallableMemberDescriptor descriptor2) {
        if (descriptor2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptor", "org/jetbrains/kotlin/codegen/state/JetTypeMapper", "getPackageMemberOwnerInternalName"));
        }
        DeclarationDescriptor containingDeclaration = descriptor2.getContainingDeclaration();
        assert (containingDeclaration instanceof PackageFragmentDescriptor) : "Not a top-level member: " + descriptor2;
        PackageFragmentDescriptor packageFragmentDescriptor = (PackageFragmentDescriptor)containingDeclaration;
        String facadeShortName = JetTypeMapper.getPackageMemberOwnerShortName(descriptor2);
        if (facadeShortName == null) {
            return null;
        }
        FqName facadeFqName = packageFragmentDescriptor.getFqName().child(Name.identifier(facadeShortName));
        return AsmUtil.internalNameByFqNameWithoutInnerClasses(facadeFqName);
    }

    @Nullable
    private static String getPackageMemberOwnerShortName(@NotNull DeserializedCallableMemberDescriptor descriptor2) {
        if (descriptor2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptor", "org/jetbrains/kotlin/codegen/state/JetTypeMapper", "getPackageMemberOwnerShortName"));
        }
        DeclarationDescriptor containingDeclaration = descriptor2.getContainingDeclaration();
        if (containingDeclaration instanceof PackageFragmentDescriptor) {
            PackageFragmentDescriptor packageFragmentDescriptor = (PackageFragmentDescriptor)containingDeclaration;
            JetScope scope2 = packageFragmentDescriptor.getMemberScope();
            if (scope2 instanceof AbstractScopeAdapter) {
                scope2 = ((AbstractScopeAdapter)scope2).getActualScope();
            }
            if (scope2 instanceof LazyJavaPackageScope) {
                Name implClassName = JvmFileClassUtil.getImplClassName(descriptor2);
                return ((LazyJavaPackageScope)scope2).getFacadeSimpleNameForPartSimpleName(implClassName.asString());
            }
            if (packageFragmentDescriptor instanceof BuiltinsPackageFragment) {
                return PackageClassUtils.getPackageClassFqName(packageFragmentDescriptor.getFqName()).shortName().asString();
            }
            Name implClassName = JvmFileClassUtil.getImplClassName(descriptor2);
            return implClassName.asString();
        }
        return null;
    }

    @NotNull
    public Type mapReturnType(@NotNull CallableDescriptor descriptor2) {
        if (descriptor2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptor", "org/jetbrains/kotlin/codegen/state/JetTypeMapper", "mapReturnType"));
        }
        Type type2 = this.mapReturnType(descriptor2, null);
        if (type2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/codegen/state/JetTypeMapper", "mapReturnType"));
        }
        return type2;
    }

    @NotNull
    private Type mapReturnType(@NotNull CallableDescriptor descriptor2, @Nullable BothSignatureWriter sw) {
        if (descriptor2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptor", "org/jetbrains/kotlin/codegen/state/JetTypeMapper", "mapReturnType"));
        }
        JetType returnType2 = descriptor2.getReturnType();
        assert (returnType2 != null) : "Function has no return type: " + descriptor2;
        if (descriptor2 instanceof ConstructorDescriptor) {
            Type type2 = Type.VOID_TYPE;
            if (type2 == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/codegen/state/JetTypeMapper", "mapReturnType"));
            }
            return type2;
        }
        if (KotlinBuiltIns.isUnit(returnType2) && !TypeUtils.isNullableType(returnType2) && !(descriptor2 instanceof PropertyGetterDescriptor)) {
            if (sw != null) {
                sw.writeAsmType(Type.VOID_TYPE);
            }
            Type type3 = Type.VOID_TYPE;
            if (type3 == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/codegen/state/JetTypeMapper", "mapReturnType"));
            }
            return type3;
        }
        if (descriptor2 instanceof FunctionDescriptor && JetTypeMapper.forceBoxedReturnType((FunctionDescriptor)descriptor2)) {
            Type type4 = this.mapType(descriptor2.getReturnType(), sw, JetTypeMapperMode.TYPE_PARAMETER);
            if (type4 == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/codegen/state/JetTypeMapper", "mapReturnType"));
            }
            return type4;
        }
        if (DescriptorUtils.isAnnotationClass(descriptor2.getContainingDeclaration())) {
            Type type5 = this.mapType(descriptor2.getReturnType(), sw, JetTypeMapperMode.VALUE_FOR_ANNOTATION);
            if (type5 == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/codegen/state/JetTypeMapper", "mapReturnType"));
            }
            return type5;
        }
        Type type6 = this.mapType(returnType2, sw, JetTypeMapperMode.VALUE, Variance.OUT_VARIANCE);
        if (type6 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/codegen/state/JetTypeMapper", "mapReturnType"));
        }
        return type6;
    }

    @NotNull
    private Type mapType(@NotNull JetType jetType, @NotNull JetTypeMapperMode mode) {
        if (jetType == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "jetType", "org/jetbrains/kotlin/codegen/state/JetTypeMapper", "mapType"));
        }
        if (mode == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "mode", "org/jetbrains/kotlin/codegen/state/JetTypeMapper", "mapType"));
        }
        Type type2 = this.mapType(jetType, null, mode);
        if (type2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/codegen/state/JetTypeMapper", "mapType"));
        }
        return type2;
    }

    @NotNull
    public Type mapSupertype(@NotNull JetType jetType, @Nullable BothSignatureWriter signatureVisitor) {
        if (jetType == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "jetType", "org/jetbrains/kotlin/codegen/state/JetTypeMapper", "mapSupertype"));
        }
        Type type2 = this.mapType(jetType, signatureVisitor, JetTypeMapperMode.SUPER_TYPE);
        if (type2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/codegen/state/JetTypeMapper", "mapSupertype"));
        }
        return type2;
    }

    @NotNull
    public Type mapTypeParameter(@NotNull JetType jetType, @Nullable BothSignatureWriter signatureVisitor) {
        if (jetType == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "jetType", "org/jetbrains/kotlin/codegen/state/JetTypeMapper", "mapTypeParameter"));
        }
        Type type2 = this.mapType(jetType, signatureVisitor, JetTypeMapperMode.TYPE_PARAMETER);
        if (type2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/codegen/state/JetTypeMapper", "mapTypeParameter"));
        }
        return type2;
    }

    @NotNull
    public Type mapClass(@NotNull ClassifierDescriptor classifier2) {
        if (classifier2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "classifier", "org/jetbrains/kotlin/codegen/state/JetTypeMapper", "mapClass"));
        }
        Type type2 = this.mapType(classifier2.getDefaultType(), null, JetTypeMapperMode.IMPL);
        if (type2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/codegen/state/JetTypeMapper", "mapClass"));
        }
        return type2;
    }

    @NotNull
    public Type mapType(@NotNull JetType jetType) {
        if (jetType == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "jetType", "org/jetbrains/kotlin/codegen/state/JetTypeMapper", "mapType"));
        }
        Type type2 = this.mapType(jetType, null, JetTypeMapperMode.VALUE);
        if (type2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/codegen/state/JetTypeMapper", "mapType"));
        }
        return type2;
    }

    @NotNull
    public Type mapType(@NotNull CallableDescriptor descriptor2) {
        if (descriptor2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptor", "org/jetbrains/kotlin/codegen/state/JetTypeMapper", "mapType"));
        }
        Type type2 = this.mapType(descriptor2.getReturnType());
        if (type2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/codegen/state/JetTypeMapper", "mapType"));
        }
        return type2;
    }

    @NotNull
    public JvmMethodSignature mapAnnotationParameterSignature(@NotNull PropertyDescriptor descriptor2) {
        if (descriptor2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptor", "org/jetbrains/kotlin/codegen/state/JetTypeMapper", "mapAnnotationParameterSignature"));
        }
        BothSignatureWriter sw = new BothSignatureWriter(BothSignatureWriter.Mode.METHOD);
        sw.writeReturnType();
        this.mapType(descriptor2.getType(), sw, JetTypeMapperMode.VALUE_FOR_ANNOTATION);
        sw.writeReturnTypeEnd();
        JvmMethodSignature jvmMethodSignature = sw.makeJvmMethodSignature(descriptor2.getName().asString());
        if (jvmMethodSignature == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/codegen/state/JetTypeMapper", "mapAnnotationParameterSignature"));
        }
        return jvmMethodSignature;
    }

    @NotNull
    public Type mapType(@NotNull ClassifierDescriptor descriptor2) {
        if (descriptor2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptor", "org/jetbrains/kotlin/codegen/state/JetTypeMapper", "mapType"));
        }
        Type type2 = this.mapType(descriptor2.getDefaultType());
        if (type2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/codegen/state/JetTypeMapper", "mapType"));
        }
        return type2;
    }

    @NotNull
    private Type mapType(@NotNull JetType jetType, @Nullable BothSignatureWriter signatureVisitor, @NotNull JetTypeMapperMode mode) {
        if (jetType == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "jetType", "org/jetbrains/kotlin/codegen/state/JetTypeMapper", "mapType"));
        }
        if (mode == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "mode", "org/jetbrains/kotlin/codegen/state/JetTypeMapper", "mapType"));
        }
        Type type2 = this.mapType(jetType, signatureVisitor, mode, Variance.INVARIANT);
        if (type2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/codegen/state/JetTypeMapper", "mapType"));
        }
        return type2;
    }

    @NotNull
    private Type mapType(@NotNull JetType jetType, @Nullable BothSignatureWriter signatureVisitor, @NotNull JetTypeMapperMode kind2, @NotNull Variance howThisTypeIsUsed) {
        boolean projectionsAllowed;
        if (jetType == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "jetType", "org/jetbrains/kotlin/codegen/state/JetTypeMapper", "mapType"));
        }
        if (kind2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "kind", "org/jetbrains/kotlin/codegen/state/JetTypeMapper", "mapType"));
        }
        if (howThisTypeIsUsed == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "howThisTypeIsUsed", "org/jetbrains/kotlin/codegen/state/JetTypeMapper", "mapType"));
        }
        Type known = JetTypeMapper.mapBuiltinType(jetType);
        boolean bl = projectionsAllowed = kind2 != JetTypeMapperMode.SUPER_TYPE;
        if (known != null) {
            if (kind2 == JetTypeMapperMode.VALUE || kind2 == JetTypeMapperMode.VALUE_FOR_ANNOTATION) {
                Type type2 = this.mapKnownAsmType(jetType, known, signatureVisitor, howThisTypeIsUsed);
                if (type2 == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/codegen/state/JetTypeMapper", "mapType"));
                }
                return type2;
            }
            if (kind2 == JetTypeMapperMode.TYPE_PARAMETER || kind2 == JetTypeMapperMode.SUPER_TYPE || kind2 == JetTypeMapperMode.TYPE_PARAMETER_FOR_ANNOTATION) {
                Type type3 = this.mapKnownAsmType(jetType, AsmUtil.boxType(known), signatureVisitor, howThisTypeIsUsed, projectionsAllowed);
                if (type3 == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/codegen/state/JetTypeMapper", "mapType"));
                }
                return type3;
            }
            if (kind2 == JetTypeMapperMode.IMPL) {
                Type type4 = this.mapKnownAsmType(jetType, known, signatureVisitor, howThisTypeIsUsed);
                if (type4 == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/codegen/state/JetTypeMapper", "mapType"));
                }
                return type4;
            }
            throw new IllegalStateException("unknown kind: " + (Object)((Object)kind2));
        }
        TypeConstructor constructor = jetType.getConstructor();
        ClassifierDescriptor descriptor2 = constructor.getDeclarationDescriptor();
        if (constructor instanceof IntersectionTypeConstructor) {
            jetType = CommonSupertypes.commonSupertype(new ArrayList<JetType>(constructor.getSupertypes()));
        }
        if (descriptor2 == null) {
            throw new UnsupportedOperationException("no descriptor for type constructor of " + jetType);
        }
        if (ErrorUtils.isError(descriptor2)) {
            if (this.classBuilderMode != ClassBuilderMode.LIGHT_CLASSES) {
                throw new IllegalStateException(JetTypeMapper.generateErrorMessageForErrorType(jetType, descriptor2));
            }
            Type asmType = Type.getObjectType((String)"error/NonExistentClass");
            if (signatureVisitor != null) {
                signatureVisitor.writeAsmType(asmType);
            }
            Type type5 = asmType;
            if (type5 == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/codegen/state/JetTypeMapper", "mapType"));
            }
            return type5;
        }
        if (descriptor2 instanceof ClassDescriptor && KotlinBuiltIns.isArray(jetType)) {
            Type arrayElementType;
            if (jetType.getArguments().size() != 1) {
                throw new UnsupportedOperationException("arrays must have one type argument");
            }
            TypeProjection memberProjection = jetType.getArguments().get(0);
            JetType memberType = memberProjection.getType();
            if (memberProjection.getProjectionKind() == Variance.IN_VARIANCE) {
                arrayElementType = AsmTypes.OBJECT_TYPE;
                if (signatureVisitor != null) {
                    signatureVisitor.writeArrayType();
                    signatureVisitor.writeAsmType(arrayElementType);
                    signatureVisitor.writeArrayEnd();
                }
            } else {
                arrayElementType = AsmUtil.boxType(this.mapType(memberType, kind2));
                if (signatureVisitor != null) {
                    signatureVisitor.writeArrayType();
                    JetTypeMapperMode newMode = kind2.isForAnnotation() ? JetTypeMapperMode.TYPE_PARAMETER_FOR_ANNOTATION : JetTypeMapperMode.TYPE_PARAMETER;
                    this.mapType(memberType, signatureVisitor, newMode, memberProjection.getProjectionKind());
                    signatureVisitor.writeArrayEnd();
                }
            }
            Type type6 = Type.getType((String)("[" + arrayElementType.getDescriptor()));
            if (type6 == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/codegen/state/JetTypeMapper", "mapType"));
            }
            return type6;
        }
        if (descriptor2 instanceof ClassDescriptor) {
            Type asmType = kind2.isForAnnotation() && KotlinBuiltIns.isKClass((ClassDescriptor)descriptor2) ? AsmTypes.JAVA_CLASS_TYPE : this.computeAsmType((ClassDescriptor)descriptor2.getOriginal());
            this.writeGenericType(signatureVisitor, asmType, jetType, howThisTypeIsUsed, projectionsAllowed);
            Type type7 = asmType;
            if (type7 == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/codegen/state/JetTypeMapper", "mapType"));
            }
            return type7;
        }
        if (descriptor2 instanceof TypeParameterDescriptor) {
            TypeParameterDescriptor typeParameterDescriptor = (TypeParameterDescriptor)descriptor2;
            Type type8 = this.mapType(typeParameterDescriptor.getUpperBounds().iterator().next(), kind2);
            if (signatureVisitor != null) {
                signatureVisitor.writeTypeVariable(typeParameterDescriptor.getName(), type8);
            }
            Type type9 = type8;
            if (type9 == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/codegen/state/JetTypeMapper", "mapType"));
            }
            return type9;
        }
        throw new UnsupportedOperationException("Unknown type " + jetType);
    }

    @Nullable
    private static Type mapBuiltinType(@NotNull JetType type2) {
        if (type2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "org/jetbrains/kotlin/codegen/state/JetTypeMapper", "mapBuiltinType"));
        }
        ClassifierDescriptor descriptor2 = type2.getConstructor().getDeclarationDescriptor();
        if (!(descriptor2 instanceof ClassDescriptor)) {
            return null;
        }
        FqNameUnsafe fqName2 = DescriptorUtils.getFqName(descriptor2);
        PrimitiveType primitiveType = KotlinBuiltIns.getPrimitiveTypeByFqName(fqName2);
        if (primitiveType != null) {
            Type asmType = Type.getType((String)JvmPrimitiveType.get(primitiveType).getDesc());
            return TypeUtils.isNullableType(type2) ? AsmUtil.boxType(asmType) : asmType;
        }
        PrimitiveType arrayElementType = KotlinBuiltIns.getPrimitiveTypeByArrayClassFqName(fqName2);
        if (arrayElementType != null) {
            return Type.getType((String)("[" + JvmPrimitiveType.get(arrayElementType).getDesc()));
        }
        ClassId classId = JavaToKotlinClassMap.INSTANCE.mapKotlinToJava(fqName2);
        if (classId != null) {
            return Type.getObjectType((String)JvmClassName.byClassId(classId).getInternalName());
        }
        return null;
    }

    @NotNull
    private Type computeAsmType(@NotNull ClassDescriptor klass) {
        if (klass == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "klass", "org/jetbrains/kotlin/codegen/state/JetTypeMapper", "computeAsmType"));
        }
        Type alreadyComputedType = this.bindingContext.get(CodegenBinding.ASM_TYPE, klass);
        if (alreadyComputedType != null) {
            Type type2 = alreadyComputedType;
            if (type2 == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/codegen/state/JetTypeMapper", "computeAsmType"));
            }
            return type2;
        }
        Type asmType = Type.getObjectType((String)this.computeAsmTypeImpl(klass));
        assert (PsiCodegenPredictor.checkPredictedNameFromPsi(klass, asmType, this.fileClassesProvider));
        Type type3 = asmType;
        if (type3 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/codegen/state/JetTypeMapper", "computeAsmType"));
        }
        return type3;
    }

    @NotNull
    private String computeAsmTypeImpl(@NotNull ClassDescriptor klass) {
        if (klass == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "klass", "org/jetbrains/kotlin/codegen/state/JetTypeMapper", "computeAsmTypeImpl"));
        }
        DeclarationDescriptor container2 = klass.getContainingDeclaration();
        String name2 = SpecialNames.safeIdentifier(klass.getName()).getIdentifier();
        if (container2 instanceof PackageFragmentDescriptor) {
            FqName fqName2 = ((PackageFragmentDescriptor)container2).getFqName();
            String string = fqName2.isRoot() ? name2 : fqName2.asString().replace('.', '/') + '/' + name2;
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/codegen/state/JetTypeMapper", "computeAsmTypeImpl"));
            }
            return string;
        }
        if (container2 instanceof ScriptDescriptor) {
            String string = CodegenBinding.asmTypeForScriptDescriptor(this.bindingContext, (ScriptDescriptor)container2).getInternalName() + "$" + name2;
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/codegen/state/JetTypeMapper", "computeAsmTypeImpl"));
            }
            return string;
        }
        assert (container2 instanceof ClassDescriptor) : "Unexpected container: " + container2 + " for " + klass;
        String containerInternalName = this.computeAsmTypeImpl((ClassDescriptor)container2);
        String string = klass.getKind() == ClassKind.ENUM_ENTRY ? containerInternalName : containerInternalName + "$" + name2;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/codegen/state/JetTypeMapper", "computeAsmTypeImpl"));
        }
        return string;
    }

    @NotNull
    public Type mapTraitImpl(@NotNull ClassDescriptor descriptor2) {
        if (descriptor2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptor", "org/jetbrains/kotlin/codegen/state/JetTypeMapper", "mapTraitImpl"));
        }
        Type type2 = Type.getObjectType((String)(this.mapType(descriptor2).getInternalName() + "$$TImpl"));
        if (type2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/codegen/state/JetTypeMapper", "mapTraitImpl"));
        }
        return type2;
    }

    @NotNull
    private static String generateErrorMessageForErrorType(@NotNull JetType type2, @NotNull DeclarationDescriptor descriptor2) {
        if (type2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "org/jetbrains/kotlin/codegen/state/JetTypeMapper", "generateErrorMessageForErrorType"));
        }
        if (descriptor2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptor", "org/jetbrains/kotlin/codegen/state/JetTypeMapper", "generateErrorMessageForErrorType"));
        }
        PsiElement declarationElement = DescriptorToSourceUtils.descriptorToDeclaration(descriptor2);
        if (declarationElement == null) {
            String message = "Error type encountered: %s (%s).";
            if (TypesPackage.upperIfFlexible(type2) instanceof DeserializedType) {
                message = message + " One of the possible reasons may be that this type is not directly accessible from this module. To workaround this error, try adding an explicit dependency on the module or library which contains this type to the classpath";
            }
            String string = String.format(message, type2, type2.getClass().getSimpleName());
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/codegen/state/JetTypeMapper", "generateErrorMessageForErrorType"));
            }
            return string;
        }
        DeclarationDescriptor containingDeclaration = descriptor2.getContainingDeclaration();
        PsiElement parentDeclarationElement = containingDeclaration != null ? DescriptorToSourceUtils.descriptorToDeclaration(containingDeclaration) : null;
        String string = String.format("Error type encountered: %s (%s). Descriptor: %s. For declaration %s:%s in %s:%s", type2, type2.getClass().getSimpleName(), descriptor2, declarationElement, declarationElement.getText(), parentDeclarationElement, parentDeclarationElement != null ? parentDeclarationElement.getText() : "null");
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/codegen/state/JetTypeMapper", "generateErrorMessageForErrorType"));
        }
        return string;
    }

    private void writeGenericType(BothSignatureWriter signatureVisitor, Type asmType, JetType jetType, Variance howThisTypeIsUsed, boolean projectionsAllowed) {
        if (signatureVisitor != null) {
            signatureVisitor.writeClassBegin(asmType);
            List<TypeProjection> arguments2 = jetType.getArguments();
            for (TypeParameterDescriptor parameter : jetType.getConstructor().getParameters()) {
                TypeProjection argument = arguments2.get(parameter.getIndex());
                if (projectionsAllowed && argument.isStarProjection()) {
                    signatureVisitor.writeUnboundedWildcard();
                    continue;
                }
                Variance projectionKind = projectionsAllowed ? JetTypeMapper.getEffectiveVariance(parameter.getVariance(), argument.getProjectionKind(), howThisTypeIsUsed) : Variance.INVARIANT;
                signatureVisitor.writeTypeArgument(projectionKind);
                this.mapType(argument.getType(), signatureVisitor, JetTypeMapperMode.TYPE_PARAMETER);
                signatureVisitor.writeTypeArgumentEnd();
            }
            signatureVisitor.writeClassEnd();
        }
    }

    private static Variance getEffectiveVariance(Variance parameterVariance, Variance projectionKind, Variance howThisTypeIsUsed) {
        if (howThisTypeIsUsed == Variance.OUT_VARIANCE) {
            return projectionKind;
        }
        if (parameterVariance == Variance.INVARIANT) {
            return projectionKind;
        }
        if (projectionKind == Variance.INVARIANT) {
            return parameterVariance;
        }
        if (parameterVariance == projectionKind) {
            return parameterVariance;
        }
        return Variance.OUT_VARIANCE;
    }

    private Type mapKnownAsmType(JetType jetType, Type asmType, @Nullable BothSignatureWriter signatureVisitor, @NotNull Variance howThisTypeIsUsed) {
        if (howThisTypeIsUsed == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "howThisTypeIsUsed", "org/jetbrains/kotlin/codegen/state/JetTypeMapper", "mapKnownAsmType"));
        }
        return this.mapKnownAsmType(jetType, asmType, signatureVisitor, howThisTypeIsUsed, true);
    }

    private Type mapKnownAsmType(JetType jetType, Type asmType, @Nullable BothSignatureWriter signatureVisitor, @NotNull Variance howThisTypeIsUsed, boolean allowProjections) {
        if (howThisTypeIsUsed == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "howThisTypeIsUsed", "org/jetbrains/kotlin/codegen/state/JetTypeMapper", "mapKnownAsmType"));
        }
        if (signatureVisitor != null) {
            if (jetType.getArguments().isEmpty()) {
                signatureVisitor.writeAsmType(asmType);
            } else {
                this.writeGenericType(signatureVisitor, asmType, jetType, howThisTypeIsUsed, allowProjections);
            }
        }
        return asmType;
    }

    @NotNull
    public CallableMethod mapToCallableMethod(@NotNull FunctionDescriptor descriptor2, boolean superCall) {
        Type owner;
        JvmMethodSignature signature;
        int invokeOpcode;
        Type thisClass;
        Type ownerForDefaultImpl;
        Type ownerForDefaultParam;
        if (descriptor2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptor", "org/jetbrains/kotlin/codegen/state/JetTypeMapper", "mapToCallableMethod"));
        }
        if (descriptor2 instanceof ConstructorDescriptor) {
            JvmMethodSignature method = this.mapSignature(descriptor2);
            Type owner2 = this.mapClass(((ConstructorDescriptor)descriptor2).getContainingDeclaration());
            CallableMethod callableMethod = new CallableMethod(owner2, owner2, owner2, method, 183, null, null, null);
            if (callableMethod == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/codegen/state/JetTypeMapper", "mapToCallableMethod"));
            }
            return callableMethod;
        }
        DeclarationDescriptor functionParent = descriptor2.getOriginal().getContainingDeclaration();
        FunctionDescriptor functionDescriptor = DescriptorUtils.unwrapFakeOverride(descriptor2.getOriginal());
        if (functionParent instanceof ClassDescriptor) {
            FunctionDescriptor declarationFunctionDescriptor = JetTypeMapper.findAnyDeclaration(functionDescriptor);
            ClassDescriptor currentOwner = (ClassDescriptor)functionParent;
            ClassDescriptor declarationOwner = (ClassDescriptor)declarationFunctionDescriptor.getContainingDeclaration();
            boolean originalIsInterface = JvmCodegenUtil.isInterface(declarationOwner);
            boolean currentIsInterface = JvmCodegenUtil.isInterface(currentOwner);
            boolean isInterface = currentIsInterface && originalIsInterface;
            ClassDescriptor ownerForDefault = (ClassDescriptor)JetTypeMapper.findBaseDeclaration(functionDescriptor).getContainingDeclaration();
            ownerForDefaultParam = this.mapClass(ownerForDefault);
            Type type2 = ownerForDefaultImpl = JvmCodegenUtil.isInterface(ownerForDefault) ? this.mapTraitImpl(ownerForDefault) : ownerForDefaultParam;
            if (isInterface && (superCall || descriptor2.getVisibility() == Visibilities.PRIVATE)) {
                thisClass = this.mapClass(currentOwner);
                if (declarationOwner instanceof JavaClassDescriptor) {
                    invokeOpcode = 183;
                    signature = this.mapSignature(functionDescriptor);
                    owner = thisClass;
                } else {
                    invokeOpcode = 184;
                    signature = this.mapSignature(descriptor2.getOriginal(), OwnerKind.TRAIT_IMPL);
                    owner = this.mapTraitImpl(currentOwner);
                }
            } else {
                if (DescriptorUtils.isStaticDeclaration(functionDescriptor) || JetTypeMapper.isStaticAccessor(functionDescriptor) || AnnotationsPackage.isPlatformStaticInObjectOrClass(functionDescriptor)) {
                    invokeOpcode = 184;
                } else if (isInterface) {
                    invokeOpcode = 185;
                } else {
                    boolean isPrivateFunInvocation = Visibilities.isPrivate(functionDescriptor.getVisibility());
                    invokeOpcode = superCall || isPrivateFunInvocation ? 183 : 182;
                }
                signature = this.mapSignature(functionDescriptor.getOriginal());
                ClassDescriptor receiver = currentIsInterface && !originalIsInterface || currentOwner instanceof FunctionClassDescriptor ? declarationOwner : currentOwner;
                thisClass = owner = this.mapClass(receiver);
            }
        } else {
            signature = this.mapSignature(functionDescriptor.getOriginal());
            ownerForDefaultParam = owner = this.mapOwner(functionDescriptor);
            ownerForDefaultImpl = owner;
            if (functionParent instanceof PackageFragmentDescriptor) {
                invokeOpcode = 184;
                thisClass = null;
            } else if (functionDescriptor instanceof ConstructorDescriptor) {
                invokeOpcode = 183;
                thisClass = null;
            } else {
                invokeOpcode = 182;
                thisClass = owner;
            }
        }
        Type calleeType = DescriptorUtils.isLocalFunction(functionDescriptor) ? owner : null;
        ReceiverParameterDescriptor receiverParameter = functionDescriptor.getOriginal().getExtensionReceiverParameter();
        Type receiverParameterType = receiverParameter != null ? this.mapType(receiverParameter.getType()) : null;
        CallableMethod callableMethod = new CallableMethod(owner, ownerForDefaultImpl, ownerForDefaultParam, signature, invokeOpcode, thisClass, receiverParameterType, calleeType);
        if (callableMethod == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/codegen/state/JetTypeMapper", "mapToCallableMethod"));
        }
        return callableMethod;
    }

    public static boolean isAccessor(@NotNull CallableMemberDescriptor descriptor2) {
        if (descriptor2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptor", "org/jetbrains/kotlin/codegen/state/JetTypeMapper", "isAccessor"));
        }
        return descriptor2 instanceof AccessorForCallableDescriptor;
    }

    public static boolean isStaticAccessor(@NotNull CallableMemberDescriptor descriptor2) {
        if (descriptor2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptor", "org/jetbrains/kotlin/codegen/state/JetTypeMapper", "isStaticAccessor"));
        }
        if (descriptor2 instanceof AccessorForConstructorDescriptor) {
            return false;
        }
        return JetTypeMapper.isAccessor(descriptor2);
    }

    @NotNull
    private static FunctionDescriptor findAnyDeclaration(@NotNull FunctionDescriptor function2) {
        if (function2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "function", "org/jetbrains/kotlin/codegen/state/JetTypeMapper", "findAnyDeclaration"));
        }
        if (function2.getKind() == CallableMemberDescriptor.Kind.DECLARATION) {
            FunctionDescriptor functionDescriptor = function2;
            if (functionDescriptor == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/codegen/state/JetTypeMapper", "findAnyDeclaration"));
            }
            return functionDescriptor;
        }
        FunctionDescriptor functionDescriptor = JetTypeMapper.findBaseDeclaration(function2);
        if (functionDescriptor == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/codegen/state/JetTypeMapper", "findAnyDeclaration"));
        }
        return functionDescriptor;
    }

    @NotNull
    private static FunctionDescriptor findBaseDeclaration(@NotNull FunctionDescriptor function2) {
        if (function2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "function", "org/jetbrains/kotlin/codegen/state/JetTypeMapper", "findBaseDeclaration"));
        }
        if (function2.getOverriddenDescriptors().isEmpty()) {
            FunctionDescriptor functionDescriptor = function2;
            if (functionDescriptor == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/codegen/state/JetTypeMapper", "findBaseDeclaration"));
            }
            return functionDescriptor;
        }
        FunctionDescriptor functionDescriptor = JetTypeMapper.findBaseDeclaration(function2.getOverriddenDescriptors().iterator().next());
        if (functionDescriptor == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/codegen/state/JetTypeMapper", "findBaseDeclaration"));
        }
        return functionDescriptor;
    }

    @NotNull
    private String mapFunctionName(@NotNull FunctionDescriptor descriptor2) {
        String platformName;
        if (descriptor2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptor", "org/jetbrains/kotlin/codegen/state/JetTypeMapper", "mapFunctionName"));
        }
        if (!(descriptor2 instanceof JavaCallableMemberDescriptor) && (platformName = DescriptorUtils.getJvmName(descriptor2)) != null) {
            String string = platformName;
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/codegen/state/JetTypeMapper", "mapFunctionName"));
            }
            return string;
        }
        if (descriptor2 instanceof PropertyAccessorDescriptor) {
            PropertyDescriptor property2 = ((PropertyAccessorDescriptor)descriptor2).getCorrespondingProperty();
            if (DescriptorUtils.isAnnotationClass(property2.getContainingDeclaration())) {
                String string = property2.getName().asString();
                if (string == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/codegen/state/JetTypeMapper", "mapFunctionName"));
                }
                return string;
            }
            boolean isAccessor = property2 instanceof AccessorForPropertyDescriptor;
            String propertyName = isAccessor ? ((AccessorForPropertyDescriptor)property2).getIndexedAccessorSuffix() : property2.getName().asString();
            String accessorName = descriptor2 instanceof PropertyGetterDescriptor ? JvmAbi.getterName(propertyName) : JvmAbi.setterName(propertyName);
            String string = isAccessor ? "access$" + accessorName : accessorName;
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/codegen/state/JetTypeMapper", "mapFunctionName"));
            }
            return string;
        }
        if (DescriptorUtils.isFunctionLiteral(descriptor2)) {
            SamType samType;
            PsiElement expression2;
            PsiElement element2 = DescriptorToSourceUtils.getSourceFromDescriptor(descriptor2);
            if (element2 instanceof JetFunctionLiteral && (expression2 = element2.getParent()) instanceof JetFunctionLiteralExpression && (samType = this.bindingContext.get(CodegenBinding.SAM_VALUE, (JetExpression)expression2)) != null) {
                String string = samType.getAbstractMethod().getName().asString();
                if (string == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/codegen/state/JetTypeMapper", "mapFunctionName"));
                }
                return string;
            }
            String string = OperatorConventions.INVOKE.asString();
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/codegen/state/JetTypeMapper", "mapFunctionName"));
            }
            return string;
        }
        if (DescriptorUtils.isLocalFunction(descriptor2) || DescriptorUtils.isFunctionExpression(descriptor2)) {
            String string = OperatorConventions.INVOKE.asString();
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/codegen/state/JetTypeMapper", "mapFunctionName"));
            }
            return string;
        }
        String string = descriptor2.getName().asString();
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/codegen/state/JetTypeMapper", "mapFunctionName"));
        }
        return string;
    }

    @NotNull
    public JvmMethodSignature mapSignature(@NotNull FunctionDescriptor descriptor2) {
        if (descriptor2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptor", "org/jetbrains/kotlin/codegen/state/JetTypeMapper", "mapSignature"));
        }
        JvmMethodSignature jvmMethodSignature = this.mapSignature(descriptor2, OwnerKind.IMPLEMENTATION);
        if (jvmMethodSignature == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/codegen/state/JetTypeMapper", "mapSignature"));
        }
        return jvmMethodSignature;
    }

    @NotNull
    public JvmMethodSignature mapSignature(@NotNull FunctionDescriptor f, @NotNull OwnerKind kind2) {
        if (f == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "f", "org/jetbrains/kotlin/codegen/state/JetTypeMapper", "mapSignature"));
        }
        if (kind2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "kind", "org/jetbrains/kotlin/codegen/state/JetTypeMapper", "mapSignature"));
        }
        if (f instanceof ConstructorDescriptor) {
            JvmMethodSignature jvmMethodSignature = this.mapSignature(f, kind2, f.getOriginal().getValueParameters());
            if (jvmMethodSignature == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/codegen/state/JetTypeMapper", "mapSignature"));
            }
            return jvmMethodSignature;
        }
        JvmMethodSignature jvmMethodSignature = this.mapSignature(f, kind2, f.getValueParameters());
        if (jvmMethodSignature == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/codegen/state/JetTypeMapper", "mapSignature"));
        }
        return jvmMethodSignature;
    }

    @NotNull
    public JvmMethodSignature mapSignature(@NotNull FunctionDescriptor f, @NotNull OwnerKind kind2, List<ValueParameterDescriptor> valueParameters) {
        if (f == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "f", "org/jetbrains/kotlin/codegen/state/JetTypeMapper", "mapSignature"));
        }
        if (kind2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "kind", "org/jetbrains/kotlin/codegen/state/JetTypeMapper", "mapSignature"));
        }
        BothSignatureWriter sw = new BothSignatureWriter(BothSignatureWriter.Mode.METHOD);
        if (f instanceof ConstructorDescriptor) {
            sw.writeParametersStart();
            this.writeAdditionalConstructorParameters((ConstructorDescriptor)f, sw);
            for (ValueParameterDescriptor parameter : valueParameters) {
                this.writeParameter(sw, parameter.getType());
            }
            if (f instanceof AccessorForConstructorDescriptor) {
                JetTypeMapper.writeParameter(sw, JvmMethodParameterKind.CONSTRUCTOR_MARKER, AsmTypes.DEFAULT_CONSTRUCTOR_MARKER);
            }
            JetTypeMapper.writeVoidReturn(sw);
        } else {
            this.writeFormalTypeParameters(JvmCodegenUtil.getDirectMember(f).getTypeParameters(), sw);
            sw.writeParametersStart();
            this.writeThisIfNeeded(f, kind2, sw);
            ReceiverParameterDescriptor receiverParameter = f.getExtensionReceiverParameter();
            if (receiverParameter != null) {
                this.writeParameter(sw, JvmMethodParameterKind.RECEIVER, receiverParameter.getType());
            }
            for (ValueParameterDescriptor parameter : valueParameters) {
                this.writeParameter(sw, parameter.getType());
            }
            sw.writeReturnType();
            this.mapReturnType(f, sw);
            sw.writeReturnTypeEnd();
        }
        JvmMethodSignature jvmMethodSignature = sw.makeJvmMethodSignature(this.mapFunctionName(f));
        if (jvmMethodSignature == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/codegen/state/JetTypeMapper", "mapSignature"));
        }
        return jvmMethodSignature;
    }

    @NotNull
    public static String getDefaultDescriptor(@NotNull Method method, @Nullable String dispatchReceiverDescriptor, boolean isExtension) {
        if (method == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "method", "org/jetbrains/kotlin/codegen/state/JetTypeMapper", "getDefaultDescriptor"));
        }
        String descriptor2 = method.getDescriptor();
        int argumentsCount = Type.getArgumentTypes((String)descriptor2).length;
        if (isExtension) {
            --argumentsCount;
        }
        int maskArgumentsCount = (argumentsCount + 32 - 1) / 32;
        String additionalArgs = StringUtil.repeat((String)Type.INT_TYPE.getDescriptor(), (int)maskArgumentsCount);
        if (JetTypeMapper.isConstructor(method)) {
            additionalArgs = additionalArgs + AsmTypes.DEFAULT_CONSTRUCTOR_MARKER.getDescriptor();
        }
        String result2 = descriptor2.replace(")", additionalArgs + ")");
        if (dispatchReceiverDescriptor != null && !JetTypeMapper.isConstructor(method)) {
            String string = result2.replace("(", "(" + dispatchReceiverDescriptor);
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/codegen/state/JetTypeMapper", "getDefaultDescriptor"));
            }
            return string;
        }
        String string = result2;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/codegen/state/JetTypeMapper", "getDefaultDescriptor"));
        }
        return string;
    }

    public ClassBuilderMode getClassBuilderMode() {
        return this.classBuilderMode;
    }

    private static boolean isConstructor(@NotNull Method method) {
        if (method == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "method", "org/jetbrains/kotlin/codegen/state/JetTypeMapper", "isConstructor"));
        }
        return "<init>".equals(method.getName());
    }

    @NotNull
    public Method mapDefaultMethod(@NotNull FunctionDescriptor functionDescriptor, @NotNull OwnerKind kind2) {
        if (functionDescriptor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "functionDescriptor", "org/jetbrains/kotlin/codegen/state/JetTypeMapper", "mapDefaultMethod"));
        }
        if (kind2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "kind", "org/jetbrains/kotlin/codegen/state/JetTypeMapper", "mapDefaultMethod"));
        }
        Method jvmSignature = this.mapSignature(functionDescriptor, kind2).getAsmMethod();
        Type ownerType = this.mapOwner(functionDescriptor);
        boolean isConstructor = JetTypeMapper.isConstructor(jvmSignature);
        String descriptor2 = JetTypeMapper.getDefaultDescriptor(jvmSignature, AsmUtil.isStaticMethod(kind2, functionDescriptor) || isConstructor ? null : ownerType.getDescriptor(), functionDescriptor.getExtensionReceiverParameter() != null);
        Method method = new Method(isConstructor ? "<init>" : jvmSignature.getName() + "$default", descriptor2);
        if (method == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/codegen/state/JetTypeMapper", "mapDefaultMethod"));
        }
        return method;
    }

    private static boolean forceBoxedReturnType(@NotNull FunctionDescriptor descriptor2) {
        if (descriptor2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptor", "org/jetbrains/kotlin/codegen/state/JetTypeMapper", "forceBoxedReturnType"));
        }
        if (!KotlinBuiltIns.isPrimitiveType(descriptor2.getReturnType())) {
            return false;
        }
        for (FunctionDescriptor overridden : DescriptorUtils.getAllOverriddenDescriptors(descriptor2)) {
            if (KotlinBuiltIns.isPrimitiveType(overridden.getOriginal().getReturnType())) continue;
            return true;
        }
        return false;
    }

    private static void writeVoidReturn(@NotNull BothSignatureWriter sw) {
        if (sw == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "sw", "org/jetbrains/kotlin/codegen/state/JetTypeMapper", "writeVoidReturn"));
        }
        sw.writeReturnType();
        sw.writeAsmType(Type.VOID_TYPE);
        sw.writeReturnTypeEnd();
    }

    @Nullable
    public String mapFieldSignature(@NotNull JetType backingFieldType) {
        if (backingFieldType == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "backingFieldType", "org/jetbrains/kotlin/codegen/state/JetTypeMapper", "mapFieldSignature"));
        }
        BothSignatureWriter sw = new BothSignatureWriter(BothSignatureWriter.Mode.TYPE);
        this.mapType(backingFieldType, sw, JetTypeMapperMode.VALUE);
        return sw.makeJavaGenericSignature();
    }

    private void writeThisIfNeeded(@NotNull CallableMemberDescriptor descriptor2, @NotNull OwnerKind kind2, @NotNull BothSignatureWriter sw) {
        ClassDescriptor thisType;
        if (descriptor2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptor", "org/jetbrains/kotlin/codegen/state/JetTypeMapper", "writeThisIfNeeded"));
        }
        if (kind2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "kind", "org/jetbrains/kotlin/codegen/state/JetTypeMapper", "writeThisIfNeeded"));
        }
        if (sw == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "sw", "org/jetbrains/kotlin/codegen/state/JetTypeMapper", "writeThisIfNeeded"));
        }
        if (kind2 == OwnerKind.TRAIT_IMPL) {
            thisType = JetTypeMapper.getTraitImplThisParameterClass((ClassDescriptor)descriptor2.getContainingDeclaration());
        } else if (JetTypeMapper.isAccessor(descriptor2) && descriptor2.getDispatchReceiverParameter() != null) {
            thisType = (ClassDescriptor)descriptor2.getContainingDeclaration();
        } else {
            return;
        }
        this.writeParameter(sw, JvmMethodParameterKind.THIS, thisType.getDefaultType());
    }

    @NotNull
    private static ClassDescriptor getTraitImplThisParameterClass(@NotNull ClassDescriptor traitDescriptor) {
        if (traitDescriptor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "traitDescriptor", "org/jetbrains/kotlin/codegen/state/JetTypeMapper", "getTraitImplThisParameterClass"));
        }
        for (ClassDescriptor descriptor2 : DescriptorUtils.getSuperclassDescriptors(traitDescriptor)) {
            if (descriptor2.getKind() == ClassKind.INTERFACE) continue;
            ClassDescriptor classDescriptor = descriptor2;
            if (classDescriptor == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/codegen/state/JetTypeMapper", "getTraitImplThisParameterClass"));
            }
            return classDescriptor;
        }
        ClassDescriptor classDescriptor = traitDescriptor;
        if (classDescriptor == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/codegen/state/JetTypeMapper", "getTraitImplThisParameterClass"));
        }
        return classDescriptor;
    }

    public void writeFormalTypeParameters(@NotNull List<TypeParameterDescriptor> typeParameters, @NotNull BothSignatureWriter sw) {
        if (typeParameters == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "typeParameters", "org/jetbrains/kotlin/codegen/state/JetTypeMapper", "writeFormalTypeParameters"));
        }
        if (sw == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "sw", "org/jetbrains/kotlin/codegen/state/JetTypeMapper", "writeFormalTypeParameters"));
        }
        for (TypeParameterDescriptor typeParameter : typeParameters) {
            this.writeFormalTypeParameter(typeParameter, sw);
        }
    }

    private void writeFormalTypeParameter(@NotNull TypeParameterDescriptor typeParameterDescriptor, @NotNull BothSignatureWriter sw) {
        if (typeParameterDescriptor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "typeParameterDescriptor", "org/jetbrains/kotlin/codegen/state/JetTypeMapper", "writeFormalTypeParameter"));
        }
        if (sw == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "sw", "org/jetbrains/kotlin/codegen/state/JetTypeMapper", "writeFormalTypeParameter"));
        }
        if (this.classBuilderMode == ClassBuilderMode.LIGHT_CLASSES && typeParameterDescriptor.getName().isSpecial()) {
            return;
        }
        sw.writeFormalTypeParameter(typeParameterDescriptor.getName().asString());
        sw.writeClassBound();
        for (JetType jetType : typeParameterDescriptor.getUpperBounds()) {
            if (!(jetType.getConstructor().getDeclarationDescriptor() instanceof ClassDescriptor) || JvmCodegenUtil.isInterface(jetType)) continue;
            this.mapType(jetType, sw, JetTypeMapperMode.TYPE_PARAMETER);
            break;
        }
        sw.writeClassBoundEnd();
        for (JetType jetType : typeParameterDescriptor.getUpperBounds()) {
            ClassifierDescriptor classifier2 = jetType.getConstructor().getDeclarationDescriptor();
            if (classifier2 instanceof ClassDescriptor) {
                if (!JvmCodegenUtil.isInterface(jetType)) continue;
                sw.writeInterfaceBound();
                this.mapType(jetType, sw, JetTypeMapperMode.TYPE_PARAMETER);
                sw.writeInterfaceBoundEnd();
                continue;
            }
            if (classifier2 instanceof TypeParameterDescriptor) {
                sw.writeInterfaceBound();
                this.mapType(jetType, sw, JetTypeMapperMode.TYPE_PARAMETER);
                sw.writeInterfaceBoundEnd();
                continue;
            }
            throw new UnsupportedOperationException("Unknown classifier: " + classifier2);
        }
    }

    private void writeParameter(@NotNull BothSignatureWriter sw, @NotNull JetType type2) {
        if (sw == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "sw", "org/jetbrains/kotlin/codegen/state/JetTypeMapper", "writeParameter"));
        }
        if (type2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "org/jetbrains/kotlin/codegen/state/JetTypeMapper", "writeParameter"));
        }
        this.writeParameter(sw, JvmMethodParameterKind.VALUE, type2);
    }

    private void writeParameter(@NotNull BothSignatureWriter sw, @NotNull JvmMethodParameterKind kind2, @NotNull JetType type2) {
        if (sw == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "sw", "org/jetbrains/kotlin/codegen/state/JetTypeMapper", "writeParameter"));
        }
        if (kind2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "kind", "org/jetbrains/kotlin/codegen/state/JetTypeMapper", "writeParameter"));
        }
        if (type2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "org/jetbrains/kotlin/codegen/state/JetTypeMapper", "writeParameter"));
        }
        sw.writeParameterType(kind2);
        this.mapType(type2, sw, JetTypeMapperMode.VALUE);
        sw.writeParameterTypeEnd();
    }

    private static void writeParameter(@NotNull BothSignatureWriter sw, @NotNull JvmMethodParameterKind kind2, @NotNull Type type2) {
        if (sw == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "sw", "org/jetbrains/kotlin/codegen/state/JetTypeMapper", "writeParameter"));
        }
        if (kind2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "kind", "org/jetbrains/kotlin/codegen/state/JetTypeMapper", "writeParameter"));
        }
        if (type2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "org/jetbrains/kotlin/codegen/state/JetTypeMapper", "writeParameter"));
        }
        sw.writeParameterType(kind2);
        sw.writeAsmType(type2);
        sw.writeParameterTypeEnd();
    }

    private void writeAdditionalConstructorParameters(@NotNull ConstructorDescriptor descriptor2, @NotNull BothSignatureWriter sw) {
        ClassDescriptor containingDeclaration;
        JetType captureReceiverType;
        if (descriptor2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptor", "org/jetbrains/kotlin/codegen/state/JetTypeMapper", "writeAdditionalConstructorParameters"));
        }
        if (sw == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "sw", "org/jetbrains/kotlin/codegen/state/JetTypeMapper", "writeAdditionalConstructorParameters"));
        }
        MutableClosure closure = this.bindingContext.get(CodegenBinding.CLOSURE, descriptor2.getContainingDeclaration());
        ClassDescriptor captureThis = JvmCodegenUtil.getDispatchReceiverParameterForConstructorCall(descriptor2, closure);
        if (captureThis != null) {
            this.writeParameter(sw, JvmMethodParameterKind.OUTER, captureThis.getDefaultType());
        }
        JetType jetType = captureReceiverType = closure != null ? closure.getCaptureReceiverType() : null;
        if (captureReceiverType != null) {
            this.writeParameter(sw, JvmMethodParameterKind.RECEIVER, captureReceiverType);
        }
        if ((containingDeclaration = descriptor2.getContainingDeclaration()).getKind() == ClassKind.ENUM_CLASS || containingDeclaration.getKind() == ClassKind.ENUM_ENTRY) {
            this.writeParameter(sw, JvmMethodParameterKind.ENUM_NAME_OR_ORDINAL, DescriptorUtilPackage.getBuiltIns(descriptor2).getStringType());
            this.writeParameter(sw, JvmMethodParameterKind.ENUM_NAME_OR_ORDINAL, DescriptorUtilPackage.getBuiltIns(descriptor2).getIntType());
        }
        if (closure == null) {
            return;
        }
        for (DeclarationDescriptor variableDescriptor : closure.getCaptureVariables().keySet()) {
            Type type2;
            if (variableDescriptor instanceof VariableDescriptor && !(variableDescriptor instanceof PropertyDescriptor)) {
                Type sharedVarType = this.getSharedVarType(variableDescriptor);
                if (sharedVarType == null) {
                    sharedVarType = this.mapType(((VariableDescriptor)variableDescriptor).getType());
                }
                type2 = sharedVarType;
            } else {
                type2 = DescriptorUtils.isLocalFunction(variableDescriptor) ? CodegenBinding.asmTypeForAnonymousClass(this.bindingContext, (FunctionDescriptor)variableDescriptor) : null;
            }
            if (type2 == null) continue;
            closure.setCapturedParameterOffsetInConstructor(variableDescriptor, sw.getCurrentSignatureSize() + 1);
            JetTypeMapper.writeParameter(sw, JvmMethodParameterKind.CAPTURED_LOCAL_VARIABLE, type2);
        }
        if (this.classBuilderMode == ClassBuilderMode.FULL) {
            ResolvedCall<ConstructorDescriptor> superCall = this.findFirstDelegatingSuperCall(descriptor2);
            if (superCall == null) {
                return;
            }
            this.writeSuperConstructorCallParameters(sw, descriptor2, superCall, captureThis != null);
        }
    }

    private void writeSuperConstructorCallParameters(@NotNull BothSignatureWriter sw, @NotNull ConstructorDescriptor descriptor2, @NotNull ResolvedCall<ConstructorDescriptor> superCall, boolean hasOuter) {
        int i;
        if (sw == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "sw", "org/jetbrains/kotlin/codegen/state/JetTypeMapper", "writeSuperConstructorCallParameters"));
        }
        if (descriptor2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptor", "org/jetbrains/kotlin/codegen/state/JetTypeMapper", "writeSuperConstructorCallParameters"));
        }
        if (superCall == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "superCall", "org/jetbrains/kotlin/codegen/state/JetTypeMapper", "writeSuperConstructorCallParameters"));
        }
        ConstructorDescriptor superDescriptor = (ConstructorDescriptor)SamCodegenUtil.resolveSamAdapter((FunctionDescriptor)superCall.getResultingDescriptor());
        List<ResolvedValueArgument> valueArguments2 = superCall.getValueArgumentsByIndex();
        assert (valueArguments2 != null) : "Failed to arrange value arguments by index: " + superDescriptor;
        List<JvmMethodParameterSignature> parameters2 = this.mapSignature(superDescriptor).getValueParameters();
        int params2 = parameters2.size();
        int args = valueArguments2.size();
        assert (params2 >= args) : String.format("Incorrect number of mapped parameters vs arguments: %d < %d for %s", params2, args, descriptor2);
        for (i = 0; i < params2 - args; ++i) {
            JvmMethodParameterSignature parameter = parameters2.get(i);
            JvmMethodParameterKind kind2 = parameter.getKind();
            if (kind2 == JvmMethodParameterKind.ENUM_NAME_OR_ORDINAL || hasOuter && kind2 == JvmMethodParameterKind.OUTER) continue;
            JetTypeMapper.writeParameter(sw, JvmMethodParameterKind.SUPER_CALL_PARAM, parameter.getAsmType());
        }
        if (DescriptorUtils.isAnonymousObject(descriptor2.getContainingDeclaration())) {
            for (i = 0; i < args; ++i) {
                ResolvedValueArgument valueArgument = valueArguments2.get(i);
                JvmMethodParameterSignature parameter = parameters2.get(params2 - args + i);
                if (valueArgument instanceof DefaultValueArgument) continue;
                JetTypeMapper.writeParameter(sw, JvmMethodParameterKind.SUPER_CALL_PARAM, parameter.getAsmType());
            }
        }
    }

    @Nullable
    private ResolvedCall<ConstructorDescriptor> findFirstDelegatingSuperCall(@NotNull ConstructorDescriptor descriptor2) {
        ResolvedCall<ConstructorDescriptor> next2;
        if (descriptor2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptor", "org/jetbrains/kotlin/codegen/state/JetTypeMapper", "findFirstDelegatingSuperCall"));
        }
        ClassDescriptor classDescriptor = descriptor2.getContainingDeclaration();
        do {
            if ((next2 = BindingContextUtils.getDelegationConstructorCall(this.bindingContext, descriptor2)) != null) continue;
            return null;
        } while ((descriptor2 = next2.getResultingDescriptor()).getContainingDeclaration() == classDescriptor);
        return next2;
    }

    @NotNull
    public JvmMethodSignature mapScriptSignature(@NotNull ScriptDescriptor script, @NotNull List<ScriptDescriptor> importedScripts) {
        if (script == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "script", "org/jetbrains/kotlin/codegen/state/JetTypeMapper", "mapScriptSignature"));
        }
        if (importedScripts == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "importedScripts", "org/jetbrains/kotlin/codegen/state/JetTypeMapper", "mapScriptSignature"));
        }
        BothSignatureWriter sw = new BothSignatureWriter(BothSignatureWriter.Mode.METHOD);
        sw.writeParametersStart();
        for (ScriptDescriptor importedScript : importedScripts) {
            ClassDescriptor descriptor2 = this.bindingContext.get(CodegenBinding.CLASS_FOR_SCRIPT, importedScript);
            assert (descriptor2 != null) : "Script not found: " + importedScript;
            this.writeParameter(sw, descriptor2.getDefaultType());
        }
        for (ValueParameterDescriptor valueParameter : script.getScriptCodeDescriptor().getValueParameters()) {
            this.writeParameter(sw, valueParameter.getType());
        }
        JetTypeMapper.writeVoidReturn(sw);
        JvmMethodSignature jvmMethodSignature = sw.makeJvmMethodSignature("<init>");
        if (jvmMethodSignature == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/codegen/state/JetTypeMapper", "mapScriptSignature"));
        }
        return jvmMethodSignature;
    }

    public Type getSharedVarType(DeclarationDescriptor descriptor2) {
        if (descriptor2 instanceof SimpleFunctionDescriptor && descriptor2.getContainingDeclaration() instanceof FunctionDescriptor) {
            return CodegenBinding.asmTypeForAnonymousClass(this.bindingContext, (FunctionDescriptor)descriptor2);
        }
        if (descriptor2 instanceof PropertyDescriptor || descriptor2 instanceof FunctionDescriptor) {
            ReceiverParameterDescriptor receiverParameter = ((CallableDescriptor)descriptor2).getExtensionReceiverParameter();
            assert (receiverParameter != null) : "Callable should have a receiver parameter: " + descriptor2;
            return StackValue.sharedTypeForType(this.mapType(receiverParameter.getType()));
        }
        if (descriptor2 instanceof VariableDescriptor && BindingContextUtils.isVarCapturedInClosure(this.bindingContext, descriptor2)) {
            return StackValue.sharedTypeForType(this.mapType(((VariableDescriptor)descriptor2).getType()));
        }
        return null;
    }

    private static enum JetTypeMapperMode {
        IMPL,
        VALUE,
        TYPE_PARAMETER,
        SUPER_TYPE,
        VALUE_FOR_ANNOTATION,
        TYPE_PARAMETER_FOR_ANNOTATION;


        boolean isForAnnotation() {
            return this == VALUE_FOR_ANNOTATION || this == TYPE_PARAMETER_FOR_ANNOTATION;
        }
    }
}

