/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.console;

import com.intellij.execution.console.LanguageConsoleView;
import com.intellij.execution.process.BaseOSProcessHandler;
import com.intellij.execution.process.ProcessHandler;
import com.intellij.openapi.command.WriteCommandAction;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import java.io.OutputStream;
import java.nio.charset.Charset;
import kotlin.Charsets;
import kotlin.StringsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.KotlinClass;
import kotlin.jvm.internal.Reflection;
import kotlin.reflect.KClass;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.console.KotlinConsoleExecutorKt;
import org.jetbrains.kotlin.console.KotlinConsoleHistoryManager;
import org.jetbrains.kotlin.console.KotlinConsoleRunner;
import org.jetbrains.kotlin.console.KotlinReplOutputHandlerKt;
import org.jetbrains.kotlin.console.actions.RunExecuteActionsKt;
import org.jetbrains.kotlin.console.highlight.KotlinHistoryHighlighter;

@KotlinClass(version={0, 25, 0}, abiVersion=25, data={"\u000b\u0006))2j\u001c;mS:\u001cuN\\:pY\u0016,\u00050Z2vi>\u0014(bA8sO*I!.\u001a;ce\u0006Lgn\u001d\u0006\u0007W>$H.\u001b8\u000b\u000f\r|gn]8mK*\u0019\u0011I\\=\u000b\rqJg.\u001b;?\u0015\u0019\u0011XO\u001c8fe*\u00192j\u001c;mS:\u001cuN\\:pY\u0016\u0014VO\u001c8fe*q\u0001.[:u_JLX*\u00198bO\u0016\u0014(bG&pi2LgnQ8og>dW\rS5ti>\u0014\u00180T1oC\u001e,'O\u0003\niSN$xN]=IS\u001eDG.[4ii\u0016\u0014(\u0002G&pi2Lg\u000eS5ti>\u0014\u0018\u0010S5hQ2Lw\r\u001b;fe*I\u0001.[4iY&<\u0007\u000e\u001e\u0006\u000fKb,7-\u001e;f\u0007>lW.\u00198e\u0015\u0011)f.\u001b;\u000b\u001bM,(-\\5u\u0007>lW.\u00198e\u0015\u001d\u0019w.\\7b]\u0012Taa\u0015;sS:<'\u0002\u00026bm\u0006TA\u0001\\1oOjT!\u0001E\u0001\u000b\t!\u0001\u0001C\u0001\u0006\u0005\u0011\u0005\u00012A\u0003\u0003\t\u0005A!!B\u0002\u0005\u0004!\u0001A\u0002A\u0003\u0002\u0011\u0007)1\u0001\"\u0002\t\u00061\u0001Qa\u0001C\u0002\u0011\u0011a\u0001!B\u0002\u0005\u0004!)A\u0002A\u0003\u0003\t\u0007Ai!B\u0002\u0005\n!1A\u0002A\u0003\u0003\t\u0007AA!\u0002\u0002\u0005\u0004!)QA\u0001C\u0005\u0011\u0019)1\u0001\"\u0002\t\u00101\u0001Qa\u0001C\u0003\u0011%a\u0001!B\u0001\t\u0014\u0015\u0011A\u0001\u0003\u0005\u000b\u000b\t!\t\u0002C\u0005\u0005\u00071\u0011\u0011dA\u0003\u0002\u0011\rA2!\f\u0007\u0005C\u0012AZ!I\u0002\u0006\u0003!)\u0001$B+\u0004\t\u0015\u0019A1B\u0005\u0002\u0011\u001biC\u0002B1\u00051\u0013\t3!B\u0001\t\ta!Qk\u0001\u0003\u0006\u0007\u0011%\u0011\"\u0001\u0005\u0007[1!\u0011\r\u0002M\u0004C\r)\u0011\u0001c\u0002\u0019\bU\u001bA!B\u0002\u0005\b%\t\u00012BW\u000b\t\rAr!I\u0002\u0006\u0003!9\u0001dB)\u0004\u0007\u00119\u0011\"\u0001\u0003\u0001[U!\u0011\u0001\u0007\u0005\u001e\u0010\u0011\u0001\u0001\u0012C\u0007\u0004\u000b\u0005Ay\u0001g\u0004Q\u0007\u0001\t3!B\u0001\t\u000fa9\u0011kA\u0003\u0005\u0011%\tA\u0001A\u0007\u0002\u0011%)<&\"\u0016\u0005G\u0004A2!h\u0004\u0005\u0001!\u001dQbA\u0003\u0002\u0011\u000fA:\u0001U\u0002\u0001;\u001f!\u0001\u0001#\u0003\u000e\u0007\u0015\t\u0001\u0002\u0002\r\u0005!\u000e\u0005Qt\u0002\u0003\u0001\u0011\u0017i1!B\u0001\t\u000ba)\u0001kA\u0001\"\u0007\u0015\t\u0001B\u0001\r\u0003#\u000eIAaA\u0005\u0002\t\u0001i\u0011\u0001c\u0003\u000e\u0003!1Q\"\u0001E\u0007"})
public final class KotlinConsoleExecutor {
    public static final /* synthetic */ KClass $kotlinClass;
    private final KotlinConsoleRunner runner;
    private final KotlinConsoleHistoryManager historyManager;
    private final KotlinHistoryHighlighter historyHighlighter;

    static {
        $kotlinClass = Reflection.createKotlinClass(KotlinConsoleExecutor.class);
    }

    public final void executeCommand() {
        WriteCommandAction.runWriteCommandAction((Project)this.runner.getProject(), (Runnable)new Runnable(this){
            final /* synthetic */ KotlinConsoleExecutor this$0;

            public final void run() {
                LanguageConsoleView consoleView2 = KotlinConsoleExecutor.access$getRunner$0(this.this$0).getConsoleView();
                Document document = consoleView2.getEditorDocument();
                String inputText = StringsKt.trim((String)document.getText());
                if (StringsKt.isNotEmpty((String)inputText)) {
                    KotlinConsoleExecutor.access$getHistoryHighlighter$1(this.this$0).printNewCommandInHistory(inputText);
                    KotlinConsoleExecutor.access$submitCommand$2(this.this$0, inputText);
                }
            }
            {
                this.this$0 = kotlinConsoleExecutor;
            }
        });
    }

    private final void submitCommand(String command) {
        Object object;
        this.historyManager.updateHistory(command);
        ProcessHandler processHandler = this.runner.getProcessHandler();
        OutputStream outputStream = processHandler.getProcessInput();
        if (outputStream == null) {
            RunExecuteActionsKt.logError(this.getClass(), "<p>Broken process stream</p>");
            return;
        }
        OutputStream processInputOS = outputStream;
        ProcessHandler processHandler2 = processHandler;
        if (!(processHandler2 instanceof BaseOSProcessHandler)) {
            processHandler2 = null;
        }
        if ((object = (BaseOSProcessHandler)processHandler2) == null || (object = object.getCharset()) == null) {
            object = Charsets.getUTF_8();
        }
        Object charset = object;
        String xmlRes = String.valueOf(KotlinConsoleExecutorKt.getXML_PREAMBLE()) + "<input>" + String.valueOf(StringUtil.escapeXml((String)StringUtil.replace((String)command, (String[])KotlinReplOutputHandlerKt.getSOURCE_CHARS(), (String[])KotlinReplOutputHandlerKt.getXML_REPLACEMENTS()))) + "</input>";
        String string = xmlRes + "\n";
        Object object2 = charset;
        Intrinsics.checkExpressionValueIsNotNull((Object)object2, (String)"charset");
        byte[] bytes2 = StringsKt.toByteArray((String)string, (Charset)object2);
        processInputOS.write(bytes2);
        processInputOS.flush();
    }

    public KotlinConsoleExecutor(@NotNull KotlinConsoleRunner runner, @NotNull KotlinConsoleHistoryManager historyManager, @NotNull KotlinHistoryHighlighter historyHighlighter) {
        Intrinsics.checkParameterIsNotNull((Object)((Object)runner), (String)"runner");
        Intrinsics.checkParameterIsNotNull((Object)historyManager, (String)"historyManager");
        Intrinsics.checkParameterIsNotNull((Object)historyHighlighter, (String)"historyHighlighter");
        this.runner = runner;
        this.historyManager = historyManager;
        this.historyHighlighter = historyHighlighter;
    }

    @NotNull
    public static final /* synthetic */ KotlinConsoleRunner access$getRunner$0(KotlinConsoleExecutor $this) {
        return $this.runner;
    }

    @NotNull
    public static final /* synthetic */ KotlinHistoryHighlighter access$getHistoryHighlighter$1(KotlinConsoleExecutor $this) {
        return $this.historyHighlighter;
    }

    public static final /* synthetic */ void access$submitCommand$2(KotlinConsoleExecutor $this, @NotNull String command) {
        $this.submitCommand(command);
    }
}

