/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.console;

import com.intellij.codeInsight.lookup.LookupManager;
import com.intellij.openapi.command.WriteCommandAction;
import com.intellij.openapi.editor.CaretModel;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.ex.DocumentEx;
import com.intellij.openapi.editor.ex.EditorEx;
import com.intellij.openapi.editor.ex.util.EditorUtil;
import com.intellij.openapi.project.Project;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.util.ArrayList;
import java.util.List;
import kotlin.CollectionsKt;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.PropertyMetadata;
import kotlin.PropertyMetadataImpl;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.KotlinClass;
import kotlin.jvm.internal.Reflection;
import kotlin.reflect.KClass;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.console.KotlinConsoleHistoryManager$WhenMappings;
import org.jetbrains.kotlin.console.KotlinConsoleRunner;

@KotlinClass(version={0, 25, 0}, abiVersion=25, data={"$\n)Y2j\u001c;mS:\u001cuN\\:pY\u0016D\u0015n\u001d;pefl\u0015M\\1hKJT1a\u001c:h\u0015%QW\r\u001e2sC&t7O\u0003\u0004l_Rd\u0017N\u001c\u0006\bG>t7o\u001c7f\u0015)YU-_!eCB$XM\u001d\u0006\u0005U\u00064\u0018MC\u0002boRTQ!\u001a<f]RTa\u0001P5oSRt$B\u0002:v]:,'OC\nL_Rd\u0017N\\\"p]N|G.\u001a*v]:,'OC\u0007d_:\u001cx\u000e\\3FI&$xN\u001d\u0006\t\u000b\u0012LGo\u001c:Fq*\u00191m\\7\u000b\u0011%tG/\u001a7mS*Tqa\u001c9f]\u0006\u0004\u0018N\u0003\u0004fI&$xN\u001d\u0006\u0003KbTacY8og>dW-\u00123ji>\u0014H\u0005Z3mK\u001e\fG/\u001a\u0006\u0005\u0019\u0006T\u0018P\u0003\thKR\u001cuN\\:pY\u0016,E-\u001b;pe*9\u0001.[:u_JL(\"C!se\u0006LH*[:u\u0015\u0011)H/\u001b7\u000b\rM#(/\u001b8h\u0015)A\u0017n\u001d;pef\u0004vn\u001d\u0006\u0004\u0013:$(\"\u00057bgR\u001cu.\\7b]\u0012dUM\\4uQ*!r-\u001a;MCN$8i\\7nC:$G*\u001a8hi\"Tq\u0002\u001d:fm\u000e\u000b'/\u001a;PM\u001a\u001cX\r\u001e\u0006\baJ|'.Z2u\u0015\u001d\u0001&o\u001c6fGRTqAT8u\u001dVdGNC\u0006b]:|G/\u0019;j_:\u001c(\"E;oM&t\u0017n\u001d5fI\u000e{W.\\1oI*!A.\u00198h\u0015-YW-\u001f*fY\u0016\f7/\u001a3\u000b\u0003\u0015T\u0001bS3z\u000bZ,g\u000e\u001e\u0006\u0005+:LGOC\tn_Z,\u0007*[:u_JL8)\u001e:t_JTA!\\8wK*Y\u0001*[:u_JLXj\u001c<f\u0015\u001dZu\u000e\u001e7j]\u000e{gn]8mK\"K7\u000f^8ss6\u000bg.Y4fe\u0012B\u0015n\u001d;pefluN^3\u000b\u001bU\u0004H-\u0019;f\u0011&\u001cHo\u001c:z\u0015\u001d\u0019w.\\7b]\u0012t\u001fA\u0003\u0002\u0011\u0003)!\u0001\u0002\u0001\t\u0003\u0015\u0011A\u0011\u0001E\u0002\u000b\t!\u0011\u0001\u0003\u0002\u0006\u0007\u0011\r\u0001\u0002\u0001\u0007\u0001\u000b\u0005A1!\u0002\u0002\u0005\u0006!\u001dQA\u0001\u0003\u0004\u0011\u0011)1\u0001b\u0002\t\u00061\u0001Qa\u0001C\u0002\u0011\u0017a\u0001!\u0002\u0002\u0005\u0004!-Q!\u0001\u0005\b\u000b\t!Y\u0001c\u0004\u0006\u0005\u00111\u0001\u0002C\u0003\u0003\t\u001bA\t\"\u0002\u0002\u0005\u000f!IQa\u0001C\b\u0011\u001ba\u0001!B\u0001\t\u0004\u0015\u0011A\u0011\u0003\u0005\u000b\u000b\t!y\u0001#\u0004\u0006\u0005\u0011\u0015\u0001\u0002D\u0003\u0004\t)A9\u0002\u0004\u0001\u0006\u0007\u0011E\u0001\u0012\u0004\u0007\u0001\u000b\t!!\u0002c\u0006\u0006\u0007\u0011E\u00012\u0004\u0007\u0001\u000b\t!i\u0001c\b\u0006\u0007\u0011e\u0001\u0002\u0005\u0007\u0001\u000b\t!\t\u0001C\t\u0006\u0007\u0011m\u0001\u0012\u0005\u0007\u0001\u000b\t!I\u0002\u0003\t\u0006\u0005\u0011\u0015\u0001BE\u0003\u0003\t=AI\"B\u0002\u0005\b!\u001dB\u0002A\u0003\u0004\t#AA\u0003\u0004\u0001\u0006\u0005\u0011\u001d\u0001rE\u0003\u0004\t\tAY\u0003\u0004\u0001\u0006\u0005\u0011\r\u0001B\u0006\u0003\u0004\u0019\tI2!B\u0001\t\ta!Q\u0014a\u000b.#\u0011\tG\u0001\u0007\u0004\"\u0007\u0015\t\u0001\u0002\u0003\r\tI\u0005*6\u0001C\u0003\u0004\t'I\u0011\u0001C\u0005\u000e\u0007\u0011U\u0011\"\u0001E\n[E!\u0011\r\u0002\r\fC!)\u0011\u0001#\u0006\n\t%\u0019Q!\u0001\u0005\f1-A*\"V\u0002\u0005\u000b\r!1\"C\u0001\t\u00185bA!1\u0007\u0019\u001b\u0005\u001aQ!\u0001\u0005\r11)6\u0001B\u0003\u0004\t5I\u0011\u0001\"\u0002.\u001b\u0011\u0019G\u0001\u0007\b\"\u0007\u0015\t\u0001\u0002\u0004\r\rI\r*6\u0001B\u0007\u0004\t;I\u0011\u0001\"\u0002.\u0019\u0011\tM\u0002G\b\"\u0007\u0015\t\u0001\u0002\u0004\r\r+\u000e!Qa\u0001\u0003\u0010\u0013\u0005!)!,\b\u0005C\u0012Az\"i\u0003\u0006\u0003!i\u0001$D)\u0004\u0003\u0011qQk\u0001\u0003\u0006\u0007\u0011}\u0011\"\u0001E\u000f[1!\u0011\r\u0002\r\u0006C\r)\u0011\u0001#\u0003\u0019\nU\u001bA!B\u0002\u0005\u000b%\t\u0001\"B\u0017\r\t\u0005g\u00014E\u0011\u0004\u000b\u0005A1\u0002G\u0006V\u0007\u0011)1\u0001b\t\n\u0003!}Q&\u0006\u0003\f1Kiz\u0001\u0002\u0001\t'5\u0019Q!\u0001\u0005\u00111A\u00016\u0001A\u0011\u0004\u000b\u0005A\t\u0003'\tR\u0007\u0015!)#C\u0001\u0005\u00015\t\u0001\"E\u0017\u0016\t\u0005AJ#h\u0004\u0005\u0001!)RbA\u0003\u0002\u0011GA\u001a\u0003U\u0002\u0001C\r)\u0011\u0001#\t\u0019\"E\u001bQ\u0001\"\u000b\n\u0003\u0011\u0001Q\"\u0001\u0005\u0013[U!1\u0001'\f\u001e\u0010\u0011\u0001\u0001bF\u0007\u0004\u000b\u0005A1\u0002G\u0006Q\u0007\u0001\t3!B\u0001\t\"a\u0005\u0012kA\u0003\u0005.%\tA\u0001A\u0007\u0002\u0011?)l#b\u000b\u0005G\u0004AJ!h\u0004\u0005\u0001!)QbA\u0003\u0002\u0011\u0013AJ\u0001U\u0002\u0001C\r)\u0011\u0001\u0003\u0002\u0019\u0005E\u001bQ\u0001\"\u0003\n\u0003\u0011\u0001Q\"\u0001\u0005\u0006"})
public final class KotlinConsoleHistoryManager
extends KeyAdapter {
    public static final /* synthetic */ KClass $kotlinClass;
    private final Project project;
    private final Lazy<? extends EditorEx> consoleEditor$delegate;
    private final ArrayList<String> history;
    private int historyPos;
    private int prevCaretOffset;
    private String unfinishedCommand;
    private final KotlinConsoleRunner runner;
    private static final /* synthetic */ PropertyMetadata[] $propertyMetadata;

    static {
        $kotlinClass = Reflection.createKotlinClass(KotlinConsoleHistoryManager.class);
        $propertyMetadata = new PropertyMetadata[]{new PropertyMetadataImpl("consoleEditor")};
    }

    private final EditorEx getConsoleEditor() {
        return (EditorEx)LazyKt.get(this.consoleEditor$delegate, (Object)this, (PropertyMetadata)$propertyMetadata[0]);
    }

    public final int getLastCommandLength() {
        return ((String)CollectionsKt.last((List)this.history)).length();
    }

    public final void updateHistory(@NotNull String command) {
        Intrinsics.checkParameterIsNotNull((Object)command, (String)"command");
        this.history.add(command);
        this.historyPos = this.history.size();
        this.prevCaretOffset = -1;
        this.unfinishedCommand = "";
    }

    @Override
    public void keyReleased(@NotNull KeyEvent e) {
        Intrinsics.checkParameterIsNotNull((Object)e, (String)"e");
        switch (e.getKeyCode()) {
            case 38: {
                this.moveHistoryCursor(HistoryMove.UP);
                break;
            }
            case 40: {
                this.moveHistoryCursor(HistoryMove.DOWN);
                break;
            }
            case 37: 
            case 39: {
                this.prevCaretOffset = this.getConsoleEditor().getCaretModel().getOffset();
            }
        }
    }

    private final void moveHistoryCursor(HistoryMove move2) {
        if (this.history.isEmpty()) {
            return;
        }
        if (LookupManager.getInstance((Project)this.project).getActiveLookup() != null) {
            return;
        }
        CaretModel caret = this.getConsoleEditor().getCaretModel();
        DocumentEx document = this.getConsoleEditor().getDocument();
        int curOffset = caret.getOffset();
        int curLine = document.getLineNumber(curOffset);
        int totalLines = document.getLineCount();
        boolean isMultiline = totalLines > 1;
        switch (KotlinConsoleHistoryManager$WhenMappings.$EnumSwitchMapping$0[move2.ordinal()]) {
            case 1: {
                if (curLine != 0 || isMultiline && this.prevCaretOffset != 0) {
                    this.prevCaretOffset = curOffset;
                    return;
                }
                if (this.historyPos == this.history.size()) {
                    String string = document.getText();
                    Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"document.text");
                    this.unfinishedCommand = string;
                }
                this.historyPos = Math.max(this.historyPos - 1, 0);
                WriteCommandAction.runWriteCommandAction((Project)this.project, (Runnable)new Runnable(this, document, caret){
                    final /* synthetic */ KotlinConsoleHistoryManager this$0;
                    final /* synthetic */ DocumentEx $document;
                    final /* synthetic */ CaretModel $caret;

                    public final void run() {
                        this.$document.setText((CharSequence)KotlinConsoleHistoryManager.access$getHistory$1(this.this$0).get(KotlinConsoleHistoryManager.access$getHistoryPos$2(this.this$0)));
                        EditorUtil.scrollToTheEnd((Editor)((Editor)KotlinConsoleHistoryManager.access$getConsoleEditor$0(this.this$0)));
                        KotlinConsoleHistoryManager.access$setPrevCaretOffset$3(this.this$0, 0);
                        this.$caret.moveToOffset(0);
                    }
                    {
                        this.this$0 = kotlinConsoleHistoryManager;
                        this.$document = documentEx;
                        this.$caret = caretModel;
                    }
                });
                break;
            }
            case 2: {
                if (this.historyPos == this.history.size()) {
                    return;
                }
                if (curLine != totalLines - 1 || isMultiline && this.prevCaretOffset != document.getTextLength()) {
                    this.prevCaretOffset = curOffset;
                    return;
                }
                this.historyPos = Math.min(this.historyPos + 1, this.history.size());
                WriteCommandAction.runWriteCommandAction((Project)this.project, (Runnable)new Runnable(this, document){
                    final /* synthetic */ KotlinConsoleHistoryManager this$0;
                    final /* synthetic */ DocumentEx $document;

                    public final void run() {
                        String string;
                        if (KotlinConsoleHistoryManager.access$getHistoryPos$2(this.this$0) == KotlinConsoleHistoryManager.access$getHistory$1(this.this$0).size()) {
                            string = KotlinConsoleHistoryManager.access$getUnfinishedCommand$4(this.this$0);
                        } else {
                            String string2 = KotlinConsoleHistoryManager.access$getHistory$1(this.this$0).get(KotlinConsoleHistoryManager.access$getHistoryPos$2(this.this$0));
                            string = string2;
                            Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"history[historyPos]");
                        }
                        this.$document.setText((CharSequence)string);
                        KotlinConsoleHistoryManager.access$setPrevCaretOffset$3(this.this$0, this.$document.getTextLength());
                        EditorUtil.scrollToTheEnd((Editor)((Editor)KotlinConsoleHistoryManager.access$getConsoleEditor$0(this.this$0)));
                    }
                    {
                        this.this$0 = kotlinConsoleHistoryManager;
                        this.$document = documentEx;
                    }
                });
            }
        }
    }

    public KotlinConsoleHistoryManager(@NotNull KotlinConsoleRunner runner) {
        Intrinsics.checkParameterIsNotNull((Object)((Object)runner), (String)"runner");
        this.runner = runner;
        this.project = this.runner.getProject();
        this.consoleEditor$delegate = LazyKt.lazy((Function0)((Function0)new Function0<EditorEx>(this){
            final /* synthetic */ KotlinConsoleHistoryManager this$0;

            @NotNull
            public final EditorEx invoke() {
                return KotlinConsoleHistoryManager.access$getRunner$5(this.this$0).getConsoleView().getConsoleEditor();
            }
            {
                this.this$0 = kotlinConsoleHistoryManager;
                super(0);
            }
        }));
        this.history = CollectionsKt.arrayListOf((Object[])new String[0]);
        this.prevCaretOffset = -1;
        this.unfinishedCommand = "";
    }

    @NotNull
    public static final /* synthetic */ EditorEx access$getConsoleEditor$0(KotlinConsoleHistoryManager $this) {
        return $this.getConsoleEditor();
    }

    @NotNull
    public static final /* synthetic */ ArrayList<String> access$getHistory$1(KotlinConsoleHistoryManager $this) {
        return $this.history;
    }

    public static final /* synthetic */ int access$getHistoryPos$2(KotlinConsoleHistoryManager $this) {
        return $this.historyPos;
    }

    public static final /* synthetic */ void access$setHistoryPos$2(KotlinConsoleHistoryManager $this, int n) {
        $this.historyPos = n;
    }

    public static final /* synthetic */ int access$getPrevCaretOffset$3(KotlinConsoleHistoryManager $this) {
        return $this.prevCaretOffset;
    }

    public static final /* synthetic */ void access$setPrevCaretOffset$3(KotlinConsoleHistoryManager $this, int n) {
        $this.prevCaretOffset = n;
    }

    @NotNull
    public static final /* synthetic */ String access$getUnfinishedCommand$4(KotlinConsoleHistoryManager $this) {
        return $this.unfinishedCommand;
    }

    public static final /* synthetic */ void access$setUnfinishedCommand$4(KotlinConsoleHistoryManager $this, @NotNull String string) {
        $this.unfinishedCommand = string;
    }

    @NotNull
    public static final /* synthetic */ KotlinConsoleRunner access$getRunner$5(KotlinConsoleHistoryManager $this) {
        return $this.runner;
    }

    @KotlinClass(version={0, 25, 0}, abiVersion=25, data={"x\u0015-A\u0015n\u001d;pefluN^3\u000b7-{G\u000f\\5o\u0007>t7o\u001c7f\u0011&\u001cHo\u001c:z\u001b\u0006t\u0017mZ3s\u0015\ry'o\u001a\u0006\nU\u0016$(M]1j]NTaa[8uY&t'bB2p]N|G.\u001a\u0006\u0005\u000b:,XN\u0003\u0004=S:LGO\u0010\u0006\u0005U\u00064\u0018M\u0003\u0003mC:<'BB*ue&twM\u0003\u0002V!*!AiT,O\u0005*\u0011\u0001C\u0001\u0006\u0005\u0011\u0001\u00012A\u0003\u0003\t\u0003A!!\u0002\u0002\u0005\u0003!\u0015Qa\u0001C\u0002\u0011\u0003a\u0001!B\u0002\u0005\u0005!\u0001A\u0002A\u0003\u0002\u0011\t)1\u0001B\u0002\t\u00071\u0001Q!\u0001\u0005\u0005\u000b\t!A\u0001#\u0003\u0006\u0005\u0011%\u0001\"\u0002\u0003B\u00021\u0015\u0011\u0004C\u0003\u0002\u0011\u000fIA!C\u0002\u0006\u0003!\u0015\u0001T\u0001M\u0004c\u0005-a!\u000e\t\u0006\u001f\u0011\t\u000f\u0001g\u0002\"\u0007\u0015\t\u0001R\u0001M\u0003#\u000e9AqA\u0005\u0002\t\u0001i\u0011\u0001C\u0003\u000e\u0003\u0011\u0015\u0001"})
    private static final class HistoryMove
    extends Enum<HistoryMove> {
        public static final /* synthetic */ KClass $kotlinClass;
        public static final /* enum */ HistoryMove UP;
        public static final /* enum */ HistoryMove DOWN;
        private static final /* synthetic */ HistoryMove[] $VALUES;

        static {
            $kotlinClass = Reflection.createKotlinClass(HistoryMove.class);
            HistoryMove[] historyMoveArray = new HistoryMove[2];
            HistoryMove[] historyMoveArray2 = historyMoveArray;
            historyMoveArray[0] = UP = new HistoryMove();
            historyMoveArray[1] = DOWN = new HistoryMove();
            $VALUES = historyMoveArray;
        }

        public static HistoryMove[] values() {
            return (HistoryMove[])$VALUES.clone();
        }

        public static HistoryMove valueOf(String string) {
            return Enum.valueOf(HistoryMove.class, string);
        }
    }
}

