/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.container;

import com.intellij.util.containers.MultiMap;
import java.io.Closeable;
import java.io.PrintStream;
import java.lang.reflect.Modifier;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import kotlin.CollectionsKt;
import kotlin.StringsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.KotlinClass;
import kotlin.jvm.internal.Reflection;
import kotlin.reflect.KClass;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.container.CacheKt;
import org.jetbrains.kotlin.container.ClassInfo;
import org.jetbrains.kotlin.container.ComponentDescriptor;
import org.jetbrains.kotlin.container.ComponentRegistry;
import org.jetbrains.kotlin.container.ComponentResolveContext;
import org.jetbrains.kotlin.container.ComponentStorageState;
import org.jetbrains.kotlin.container.ContainerConsistencyException;
import org.jetbrains.kotlin.container.DataStructuresKt;
import org.jetbrains.kotlin.container.ImplicitSingletonTypeComponentDescriptor;
import org.jetbrains.kotlin.container.InvalidCardinalityException;
import org.jetbrains.kotlin.container.MethodBinding;
import org.jetbrains.kotlin.container.ResolveKt;
import org.jetbrains.kotlin.container.SetterInfo;
import org.jetbrains.kotlin.container.ValueDescriptor;
import org.jetbrains.kotlin.container.ValueResolveContext;
import org.jetbrains.kotlin.container.ValueResolver;

@KotlinClass(version={0, 25, 0}, abiVersion=25, data={"p\u000e)\u00012i\\7q_:,g\u000e^*u_J\fw-\u001a\u0006\u0004_J<'\"\u00036fi\n\u0014\u0018-\u001b8t\u0015\u0019Yw\u000e\u001e7j]*I1m\u001c8uC&tWM\u001d\u0006\u000e-\u0006dW/\u001a*fg>dg/\u001a:\u000b\rqJg.\u001b;?\u0015\u0011i\u00170\u00133\u000b\rM#(/\u001b8h\u0015\u0011Q\u0017M^1\u000b\t1\fgn\u001a\u0006\rI\u0016\u0004XM\u001c3f]\u000eLWm\u001d\u0006\t\u001bVdG/['ba*\u00191m\\7\u000b\u0011%tG/\u001a7mS*TA!\u001e;jY*Q1m\u001c8uC&tWM]:\u000b'\r{W\u000e]8oK:$H)Z:de&\u0004Ho\u001c:\u000b/-|G\u000f\\5o])4XN\f)mCR4wN]7UsB,'\u0002\u0002+za\u0016TqA]3gY\u0016\u001cGOC\u0004O_RtU\u000f\u001c7\u000b\u0017\u0005tgn\u001c;bi&|gn\u001d\u0006\u0010O\u0016$H)\u001a9f]\u0012,gnY5fg*YA-Z:de&\u0004Ho\u001c:t\u00155a\u0015N\\6fI\"\u000b7\u000f[*fi*qq-\u001a;EKN\u001c'/\u001b9u_J\u001c(bB4fi6K\u0018\n\u001a\u0006\te\u0016<\u0017n\u001d;ss*\t2i\\7q_:,g\u000e\u001e*fO&\u001cHO]=\u000b\u0017\u001d,GOU3hSN$(/\u001f\u0006\u0006gR\fG/\u001a\u0006\u0016\u0007>l\u0007o\u001c8f]R\u001cFo\u001c:bO\u0016\u001cF/\u0019;f\u0015!9W\r^*uCR,'\u0002C:fiN#\u0018\r^3\u000b-\r|G\u000e\\3di\u0006#\u0007n\\2D_6\u0004xN\\3oiNTqaY8oi\u0016DHOC\fD_6\u0004xN\\3oiJ+7o\u001c7wK\u000e{g\u000e^3yi*QA-Z:de&\u0004Ho\u001c:\u000b\u0019YL7/\u001b;fIRK\b/Z:\u000b\u000f!\u000b7\u000f[*fi*\u0001\u0012\r\u001a5pG\u0012+7o\u0019:jaR|'o\u001d\u0006\u0005+:LGOC\u0004d_6\u0004xn]3\u000b%\r|W\u000e]8tK\u0012+7o\u0019:jaR|'o\u001d\u0006\u000b\u0007>dG.Z2uS>t'b\u00023jgB|7/\u001a\u0006\u0012I&\u001c\bo\\:f\t\u0016\u001c8M]5qi>\u0014(\u0002\u00023v[BTq\u0001\u001d:j]R,'OC\u0006Qe&tGo\u0015;sK\u0006l'BA5p\u0015q9W\r\u001e#fg\u000e\u0014\u0018\u000e\u001d;peNLe\u000eR5ta>\u001cXm\u0014:eKJTA\u0001T5ti*\u0001\u0012N\u001c6fGR\u0004&o\u001c9feRLWm\u001d\u0006\tS:\u001cH/\u00198dK*\u0019\u0011I\\=\u000b'Y\u000bG.^3SKN|GN^3D_:$X\r\u001f;\u000b\r=\u0013'.Z2u\u0015)\u0019w.\u001c9p]\u0016tGo\u001d\u0006$S:\u001c\b/Z2u\t\u0016\u0004XM\u001c3f]\u000eLWm]!oIJ+w-[:uKJ\fE\r[8d\u0015I\u0011XmZ5ti\u0016\u0014H)\u001a9f]\u0012,gnY=\u000b\u000fI,\u0017/^3ti*\u0019\"/Z4jgR,'\u000fR3tGJL\u0007\u000f^8sg*)\u0011\u000e^3ng*9!/Z:pYZ,'b\u0004,bYV,G)Z:de&\u0004Ho\u001c:\u000b\u001fI,7o\u001c7wK6+H\u000e^5qY\u0016T\u0001\"\u0013;fe\u0006\u0014G.\u001aj\u0003\u0015\t\u0001\u0012A\u0003\u0003\t\u0001A\u0011!\u0002\u0002\u0005\u0002!\rQA\u0001\u0003\u0002\u0011\t)1\u0001b\u0001\t\u00011\u0001Qa\u0001C\u0002\u0011\u000ba\u0001!B\u0001\t\u0004\u0015\u0019Aa\u0001\u0005\u0005\u0019\u0001)\u0011\u0001#\u0003\u0006\u0005\u0011!\u0001\"B\u0003\u0003\t\u0013AA!B\u0001\t\u000e\u0015\u0011A1\u0002\u0005\b\u000b\t!a\u0001c\u0004\u0006\u0005\u00115\u0001\u0002C\u0003\u0004\t\u001dAa\u0001\u0004\u0001\u0006\u0007\u0011\r\u0001\u0012\u0003\u0007\u0001\u000b\t!I\u0001\u0003\u0006\u0006\u0007\u0011E\u00012\u0003\u0007\u0001\u000b\t!\t\u0001C\u0006\u0006\u0007\u0011M\u0001R\u0003\u0007\u0001\u000b\t!q\u0001\u0003\u0004\u0006\u0005\u0011!\u0001rB\u0003\u0004\t-AI\u0002\u0004\u0001\u0006\u0005\u0011Y\u0001\u0012D\u0003\u0004\t\u0007Ai\u0002\u0004\u0001\u0006\u0005\u0011\r\u0001RD\u0003\u0004\t\u0007A\u0001\u0003\u0004\u0001\u0006\u0005\u0011\r\u0001\u0002E\u0003\u0004\t\u0007A)\u0003\u0004\u0001\u0006\u0007\u0011Y\u0001\u0002\u0006\u0007\u0001\u000b\r!1\u0001C\u000b\r\u0001\u0015\u0011A1\u0001E\u0013\u000b\t!\u0019\u0001#\u0005\u0006\u0005\u0011Y\u0001\u0002F\u0003\u0004\t\rAi\u0003\u0004\u0001\u0006\u0005\u0011Y\u0001RF\u0003\u0003\t\u0011A\u0019$B\u0002\u0005&!IB\u0002A\u0003\u0003\tKA\u0011$B\u0002\u0005\u0007!UB\u0002A\u0003\u0003\t-A)$B\u0002\u0005\u0007!aB\u0002A\u0003\u0004\t\u0007AI\u0004\u0004\u0001\u0006\u0005\u0011%\u0001\"H\u0003\u0003\t\u0007AI$\u0002\u0002\u0005\u0012!MQa\u0001C\u0002\u0011\u0005b\u0001!\u0002\u0002\u0005\u0004!\tSa\u0001\u0003\u0004\u0011\tb\u0001!\u0002\u0002\u0005\n!\u0011Ca\u0001\u0007\u00033\r)\u0011\u0001#\u0002\u0019\u00065FCa\u0019\u0003\u0019\f\u0005^R!\u0001E\b\u0013)I\u0011\"B\u0001\t\u0011AIQ\u0003B\u0003\u0002\u0011!a\t\u0001\u0007\u0005\u0019\u0011%Q\u0011\"C\u0003\u0002\u0011%\u0001\u0012\"\u0006\u0003\u0006\u0003!IA\u0012\u0001\r\n1%Az!U\u0002\u0002\t))6\u0001C\u0003\u0004\t\u0017I\u0011\u0001#\u0006\u000e\u0007\u0011]\u0011\"\u0001E\u000b[U!1\r\u0002\r\rC!)\u0011\u0001c\u0006\n\t%\u0019Q!\u0001\u0005\t1!A:\"V\u0002\t\u000b\r!A\"C\u0001\t\u00195\u0019A!D\u0005\u0002\u00111i\u0003\u0003B2\u00051\u000f\t3!B\u0001\t\ba\u001dQk\u0001\u0005\u0006\u0007\u0011\u001d\u0011\"\u0001\u0005\u0006\u001b\r!Y\"C\u0001\t\u000b5\u0002Ba\u0019\u0003\u0019\u001d\u0005\u001aQ!\u0001E\r13)6\u0001C\u0003\u0004\t9I\u0011\u0001C\u0007\u000e\u0007\u0011y\u0011\"\u0001\u0005\u000e[Y!1\u0019\u0004M\u0010C\r)\u0011\u0001c\u0007\u0019\u001cU\u001ba\"B\u0002\u0005 %\t\u0001BD\u0007\u0004\tCI\u0011\u0001\u0003\b\u0012\u000b\u0011\t\u0012\"\u0001\u0003\u0001\u001b\u0005Aa\", \u0005\u0003a\rRt\u0002\u0003\u0001\u0011Ii1!B\u0001\t\u001eau\u0001k\u0001\u0001\u001e\u0010\u0011\u0001\u0001bE\u0007\u0004\u000b\u0005A\u0001\u0002\u0007\u0005Q\u0007\u0003iJ\u0002\u0002\u0001\t(5AQ!\u0001\u0005\u0010\u0013\u0011I1!B\u0001\t\u0013aI\u0001d\u0004)\u0004\u0003ueA\u0001\u0001E\u0015\u001b!)\u0011\u0001c\u0006\n\t%\u0019Q!\u0001\u0005\t1!A:\u0002UB\u0002C\r)\u0011\u0001c\b\u0019 E\u001b1\u0002b\t\n\u0003\u0011\u0001Q\"\u0001\u0005\u0011\u001b\u0005A\t#D\u0001\t#5\t\u0001\u0002D\u0017\u0016\t\rAZ#h\u0004\u0005\u0001!\u0011RbA\u0003\u0002\u0011;Aj\u0002U\u0002\u0001C\r)\u0011\u0001c\b\u0019 E\u001bQ\u0001b\u000b\n\u0003\u0011\u0001Q\"\u0001\u0005\u0011[\u0013\"\u0011\u0001\u0007\f\u001e\u0010\u0011\u0001\u0001BE\u0007\u0004\u000b\u0005Ai\u0002'\bQ\u0007\u0001iJ\u0002\u0002\u0001\t\u00195AQ!\u0001E\u0012\u0013\u0011I1!B\u0001\t\u0011aA\u00014\u0005)\u0004\u0002\u0005\u001aQ!\u0001E\u00101?\t6a\u0002\u0003\u0017\u0013\u0005!\u0001!D\u0001\t!5\t\u0001BEW\u000b\t\rAr#I\u0002\u0006\u0003!}\u0001tD)\u0004\u0007\u00119\u0012\"\u0001\u0003\u0001[U!1\u0001g\f\u001e\u0010\u0011\u0001\u0001bE\u0007\u0004\u000b\u0005A\u0001\u0002\u0007\u0005Q\u0007\u0001\t3!B\u0001\t a}\u0011kA\u0003\u00050%\tA\u0001A\u0007\u0002\u0011CiS\u0003B\u0002\u00191u=A\u0001\u0001E\u0019\u001b\r)\u0011\u0001C\n\u0019'A\u001b\u0001!I\u0002\u0006\u0003!}\u0001tD)\u0004\u000b\u0011A\u0012\"\u0001\u0003\u0001\u001b\u0005A9#l\b\u0005\u0007aQ\u0012\u0005C\u0003\u0002\u0011QIA!C\u0002\u0006\u0003!A\u0001\u0004\u0003\r\u0015#\u000e\u0019AAG\u0005\u0002\u0011Si{\u0004B\u0001\u00197u=A\u0001\u0001E\u001c\u001b\r)\u0011\u0001C\u000b\u0019+A\u001b\u0001!h\u0004\u0005\u0001!\u0011RbA\u0003\u0002\u0011WAZ\u0003UB\u0001C\r)\u0011\u0001c\b\u0019 E\u001bq\u0001B\u000e\n\u0003\u0011\u0001Q\"\u0001\u0005\u0017\u001b\u0005Ai#,\u0013\u0005\u0003aYRt\u0002\u0003\u0001\u0011Ii1!B\u0001\t\u001eau\u0001k\u0001\u0001\u001e\u001a\u0011\u0001\u00012H\u0007\t\u000b\u0005A\u0019#\u0003\u0003\n\u0007\u0015\t\u0001\u0002\u0003\r\t1G\u00016\u0011A\u0011\u0004\u000b\u0005Ay\u0002g\bR\u0007\u001d!1$C\u0001\u0005\u00015\t\u0001\u0002E\u0007\u0002\u0011Ii\u001b\u0006B\u0001\u0019=u=A\u0001\u0001\u0005\u0013\u001b\r)\u0011\u0001#\b\u0019\u001eA\u001b\u0001!(\u0007\u0005\u0001!aQ\u0002C\u0003\u0002\u0011GIA!C\u0002\u0006\u0003!A\u0001\u0004\u0003M\u0012!\u000e\u0005\u0011\u0005C\u0003\u0002\u0011/IA!C\u0002\u0006\u0003!A\u0001\u0004\u0003M\f#\u000e9AAH\u0005\u0002\u00111i\u0011\u0001\u0003\t\u000e\u0003!\u0011Rv\b\u0003\u00021{iz\u0001\u0002\u0001\t?5\u0019Q!\u0001\u0005\n1%\u00016\u0001AO\b\t\u0001A!#D\u0002\u0006\u0003!-\u00024\u0006)\u0004\u0002\u0005\u001aQ!\u0001E\u00101?\t6a\u0002C\u001f\u0013\u0005!\u0001!D\u0001\t/5\t\u0001RFW%\t\rAz$h\u0004\u0005\u0001!\u0011RbA\u0003\u0002\u0011;Aj\u0002U\u0002\u0001;3!\u0001\u0001\u0003\u0011\u000e\u0011\u0015\t\u0001\u0002F\u0005\u0005\u0013\r)\u0011\u0001\u0003\u0005\u0019\u0011a!\u0002k!\u0001\"\u0007\u0015\t\u0001r\u0004M\u0010#\u000e9AqH\u0005\u0002\t\u0001i\u0011\u0001\u0003\t\u000e\u0003!%R\u0016\t\u0003\f1\u0003jz\u0001\u0002\u0001\t?5\u0019Q!\u0001\u0005\n1%\u00016\u0001AO\b\t\u0001A!#D\u0002\u0006\u0003!-\u00024\u0006)\u0004\u0002\u0005\"Q!\u0001E\u0018\u0019\u0003Az#U\u0002\b\t\u0003J\u0011\u0001\u0003\r\u000e\u0003!9R\"\u0001E\u0017[\u0013\"1\u0001g\u0011\u001e\u0010\u0011\u0001\u0001bH\u0007\u0004\u000b\u0005A\u0011\u0002G\u0005Q\u0007\u0001iz\u0001\u0002\u0001\t%5\u0019Q!\u0001E\u00161W\u00016\u0011A\u0011\t\u000b\u0005A\t$\u0003\u0003\n\u0007\u0015\t\u0001r\u0006M\u00181c\t6a\u0002C\"\u0013\u0005A\u0011$D\u0001\t/5\t\u0001RF[\u0017\u000bW!1\u001d\u0001\r\u0004;\u001f!\u0001\u0001c\u0002\u000e\u0007\u0015\t\u0001r\u0001M\u0004!\u000e\u0001\u0011eA\u0003\u0002\u0011\tA\"!U\u0002\u0006\t\rI\u0011\u0001\u0002\u0001\u000e\u0003!)\u0001"})
public final class ComponentStorage
implements ValueResolver {
    public static final /* synthetic */ KClass $kotlinClass;
    @NotNull
    private ComponentStorageState state;
    @NotNull
    private final ComponentRegistry registry;
    @NotNull
    private final LinkedHashSet<ComponentDescriptor> descriptors;
    @NotNull
    private final MultiMap<ComponentDescriptor, Type> dependencies;
    @NotNull
    private final String myId;

    static {
        $kotlinClass = Reflection.createKotlinClass(ComponentStorage.class);
    }

    @NotNull
    public final ComponentStorageState getState() {
        return this.state;
    }

    public final void setState(@NotNull ComponentStorageState componentStorageState) {
        Intrinsics.checkParameterIsNotNull((Object)((Object)componentStorageState), (String)"<set-?>");
        this.state = componentStorageState;
    }

    @NotNull
    public final ComponentRegistry getRegistry() {
        return this.registry;
    }

    @NotNull
    public final LinkedHashSet<ComponentDescriptor> getDescriptors() {
        return this.descriptors;
    }

    @NotNull
    public final MultiMap<ComponentDescriptor, Type> getDependencies() {
        return this.dependencies;
    }

    @Override
    @Nullable
    public ValueDescriptor resolve(@NotNull Type request, @NotNull ValueResolveContext context) {
        Intrinsics.checkParameterIsNotNull((Object)request, (String)"request");
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        if (Intrinsics.areEqual((Object)((Object)this.state), (Object)((Object)ComponentStorageState.Initial))) {
            throw (Throwable)new ContainerConsistencyException("Container was not composed before resolving");
        }
        Collection<ComponentDescriptor> entry = this.registry.tryGetEntry(request);
        if (CollectionsKt.isNotEmpty(entry)) {
            this.registerDependency(request, context);
            if (entry.size() > 1) {
                throw (Throwable)new InvalidCardinalityException("Request " + request + " cannot be satisfied because there is more than one type registered", entry);
            }
            return (ValueDescriptor)CollectionsKt.singleOrNull((Iterable)entry);
        }
        return null;
    }

    private final void registerDependency(Type request, ValueResolveContext context) {
        ValueDescriptor descriptor2;
        if (context instanceof ComponentResolveContext && (descriptor2 = ((ComponentResolveContext)context).getRequestingDescriptor()) instanceof ComponentDescriptor) {
            this.dependencies.putValue((Object)descriptor2, (Object)request);
        }
    }

    /*
     * WARNING - void declaration
     */
    public final void dump(@NotNull PrintStream printer) {
        void $receiver;
        Intrinsics.checkParameterIsNotNull((Object)printer, (String)"printer");
        PrintStream $receiver2 = printer;
        String heading = "Container: " + this.getMyId();
        $receiver2.println(heading);
        $receiver2.println(StringsKt.repeat((String)"=", (int)heading.length()));
        $receiver2.println();
        Iterable iterable = this.getDescriptorsInDisposeOrder();
        for (Object element2 : $receiver) {
            void $receiver3;
            ComponentDescriptor descriptor2 = (ComponentDescriptor)element2;
            $receiver2.println(descriptor2);
            Iterable iterable2 = this.getDependencies().get((Object)descriptor2);
            for (Object element3 : $receiver3) {
                Type it = (Type)element3;
                $receiver2.print("   -> ");
                String typeName = it.toString();
                $receiver2.print(StringsKt.substringBefore$default((String)typeName, (String)" ", null, (int)2));
                $receiver2.print(" ");
                $receiver2.print(StringsKt.substringAfterLast$default((String)typeName, (String)".", null, (int)2));
                ComponentRegistry componentRegistry = this.getRegistry();
                Type type2 = it;
                Intrinsics.checkExpressionValueIsNotNull((Object)type2, (String)"it");
                Collection<ComponentDescriptor> resolve2 = componentRegistry.tryGetEntry(type2);
                $receiver2.print(" as ");
                $receiver2.print(resolve2);
                $receiver2.println();
            }
            $receiver2.println();
        }
    }

    @NotNull
    public final Iterable<ValueDescriptor> resolveMultiple(@NotNull Type request, @NotNull ValueResolveContext context) {
        Intrinsics.checkParameterIsNotNull((Object)request, (String)"request");
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        this.registerDependency(request, context);
        return this.registry.tryGetEntry(request);
    }

    public final void registerDescriptors(@NotNull ComponentResolveContext context, @NotNull List<? extends ComponentDescriptor> items) {
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        Intrinsics.checkParameterIsNotNull(items, (String)"items");
        if (Intrinsics.areEqual((Object)((Object)this.state), (Object)((Object)ComponentStorageState.Disposed))) {
            throw (Throwable)new ContainerConsistencyException("Cannot register descriptors in " + (Object)((Object)this.state) + " state");
        }
        for (ComponentDescriptor componentDescriptor : items) {
            this.descriptors.add(componentDescriptor);
        }
        if (Intrinsics.areEqual((Object)((Object)this.state), (Object)((Object)ComponentStorageState.Initialized))) {
            this.composeDescriptors(context, (Collection<? extends ComponentDescriptor>)items);
        }
    }

    public final void compose(@NotNull ComponentResolveContext context) {
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        if (Intrinsics.areEqual((Object)((Object)this.state), (Object)((Object)ComponentStorageState.Initial)) ^ true) {
            throw (Throwable)new ContainerConsistencyException("Container " + this.myId + " was already composed.");
        }
        this.state = ComponentStorageState.Initialized;
        this.composeDescriptors(context, (Collection<? extends ComponentDescriptor>)this.descriptors);
    }

    private final void composeDescriptors(ComponentResolveContext context, Collection<? extends ComponentDescriptor> descriptors) {
        if (descriptors.isEmpty()) {
            return;
        }
        this.registry.addAll(descriptors);
        LinkedHashSet<ComponentDescriptor> implicits = this.inspectDependenciesAndRegisterAdhoc(context, descriptors);
        this.injectProperties(context, CollectionsKt.plus(descriptors, (Iterable)implicits));
    }

    private final void injectProperties(ComponentResolveContext context, Collection<? extends ComponentDescriptor> components) {
        for (ComponentDescriptor componentDescriptor : components) {
            if (!componentDescriptor.getShouldInjectProperties()) continue;
            this.injectProperties(componentDescriptor.getValue(), context.getContainer().createResolveContext(componentDescriptor));
        }
    }

    private final LinkedHashSet<ComponentDescriptor> inspectDependenciesAndRegisterAdhoc(ComponentResolveContext context, Collection<? extends ComponentDescriptor> descriptors) {
        LinkedHashSet<ComponentDescriptor> adhoc = new LinkedHashSet<ComponentDescriptor>();
        HashSet<Type> visitedTypes = new HashSet<Type>();
        for (ComponentDescriptor componentDescriptor : descriptors) {
            this.collectAdhocComponents(context, componentDescriptor, visitedTypes, adhoc);
        }
        this.registry.addAll((Collection<? extends ComponentDescriptor>)adhoc);
        return adhoc;
    }

    private final void collectAdhocComponents(ComponentResolveContext context, ComponentDescriptor descriptor2, HashSet<Type> visitedTypes, LinkedHashSet<ComponentDescriptor> adhocDescriptors) {
        Collection<Type> dependencies2 = descriptor2.getDependencies(context);
        for (Type type2 : dependencies2) {
            Class rawType;
            Class clazz;
            Collection<ComponentDescriptor> entry;
            if (!visitedTypes.add(type2) || !(entry = this.registry.tryGetEntry(type2)).isEmpty()) continue;
            Type type3 = type2;
            if (type3 instanceof Class) {
                clazz = (Class)type2;
            } else if (type3 instanceof ParameterizedType) {
                Type type4 = ((ParameterizedType)type2).getRawType();
                if (!(type4 instanceof Class)) {
                    type4 = null;
                }
                clazz = (Class)type4;
            } else {
                clazz = null;
            }
            if ((rawType = clazz) == null || Modifier.isAbstract(rawType.getModifiers()) || rawType.isPrimitive()) continue;
            ImplicitSingletonTypeComponentDescriptor implicitDescriptor = new ImplicitSingletonTypeComponentDescriptor(context.getContainer(), rawType);
            adhocDescriptors.add(implicitDescriptor);
            this.collectAdhocComponents(context, implicitDescriptor, visitedTypes, adhocDescriptors);
        }
    }

    /*
     * WARNING - void declaration
     */
    private final void injectProperties(Object instance, ValueResolveContext context) {
        void $receiver;
        ClassInfo classInfo = CacheKt.getInfo(instance.getClass());
        Iterable iterable = classInfo.getSetterInfos();
        for (Object element2 : $receiver) {
            SetterInfo setterInfo = (SetterInfo)element2;
            MethodBinding methodBinding = ResolveKt.bindToMethod(setterInfo.getMethod(), context);
            methodBinding.invoke(instance);
        }
    }

    public final void dispose() {
        if (Intrinsics.areEqual((Object)((Object)this.state), (Object)((Object)ComponentStorageState.Initialized)) ^ true) {
            if (Intrinsics.areEqual((Object)((Object)this.state), (Object)((Object)ComponentStorageState.Initial))) {
                return;
            }
            throw (Throwable)new ContainerConsistencyException("Component container cannot be disposed in the " + (Object)((Object)this.state) + " state.");
        }
        this.state = ComponentStorageState.Disposing;
        List<ComponentDescriptor> disposeList = this.getDescriptorsInDisposeOrder();
        for (ComponentDescriptor descriptor2 : disposeList) {
            this.disposeDescriptor(descriptor2);
        }
        this.state = ComponentStorageState.Disposed;
    }

    @NotNull
    public final List<ComponentDescriptor> getDescriptorsInDisposeOrder() {
        return DataStructuresKt.topologicalSort((Iterable)this.descriptors, (Function1)new Function1<ComponentDescriptor, ArrayList<ComponentDescriptor>>(this){
            final /* synthetic */ ComponentStorage this$0;

            /*
             * WARNING - void declaration
             */
            @NotNull
            public final ArrayList<ComponentDescriptor> invoke(@NotNull ComponentDescriptor it) {
                void var2_2;
                Intrinsics.checkParameterIsNotNull((Object)it, (String)"it");
                ArrayList<ComponentDescriptor> dependent = new ArrayList<ComponentDescriptor>();
                for (Type interfaceType : this.this$0.getDependencies().get((Object)it)) {
                    ComponentRegistry componentRegistry = this.this$0.getRegistry();
                    Type type2 = interfaceType;
                    Intrinsics.checkExpressionValueIsNotNull((Object)type2, (String)"interfaceType");
                    for (ComponentDescriptor dependency : componentRegistry.tryGetEntry(type2)) {
                        dependent.add(dependency);
                    }
                }
                return var2_2;
            }
            {
                this.this$0 = componentStorage;
                super(1);
            }
        });
    }

    public final void disposeDescriptor(@NotNull ComponentDescriptor descriptor2) {
        Intrinsics.checkParameterIsNotNull((Object)descriptor2, (String)"descriptor");
        if (descriptor2 instanceof Closeable) {
            ((Closeable)((Object)descriptor2)).close();
        }
    }

    @NotNull
    public final String getMyId() {
        return this.myId;
    }

    public ComponentStorage(@NotNull String myId) {
        Intrinsics.checkParameterIsNotNull((Object)myId, (String)"myId");
        this.myId = myId;
        this.state = ComponentStorageState.Initial;
        this.registry = new ComponentRegistry();
        this.descriptors = new LinkedHashSet();
        this.dependencies = MultiMap.createLinkedSet();
    }
}

