/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea;

import com.intellij.ide.plugins.IdeaPluginDescriptor;
import com.intellij.ide.plugins.PluginManager;
import com.intellij.ide.plugins.PluginManagerCore;
import com.intellij.openapi.extensions.PluginId;
import com.intellij.openapi.module.Module;
import java.util.Arrays;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.idea.configuration.JetModuleTypeManager;

public class JetPluginUtil {
    @NotNull
    public static String getPluginVersion() {
        IdeaPluginDescriptor plugin = PluginManager.getPlugin((PluginId)PluginId.getId((String)"org.jetbrains.kotlin"));
        assert (plugin != null) : "Kotlin plugin not found: " + Arrays.toString(PluginManagerCore.getPlugins());
        String string = plugin.getVersion();
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/idea/JetPluginUtil", "getPluginVersion"));
        }
        return string;
    }

    public static boolean isAndroidGradleModule(@NotNull Module module) {
        if (module == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "module", "org/jetbrains/kotlin/idea/JetPluginUtil", "isAndroidGradleModule"));
        }
        return JetModuleTypeManager.getInstance().isAndroidGradleModule(module);
    }

    public static boolean isGradleModule(@NotNull Module module) {
        if (module == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "module", "org/jetbrains/kotlin/idea/JetPluginUtil", "isGradleModule"));
        }
        return JetModuleTypeManager.getInstance().isGradleModule(module);
    }

    public static boolean isMavenModule(@NotNull Module module) {
        if (module == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "module", "org/jetbrains/kotlin/idea/JetPluginUtil", "isMavenModule"));
        }
        return "true".equals(module.getOptionValue("org.jetbrains.idea.maven.project.MavenProjectsManager.isMavenModule"));
    }
}

