/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.caches.resolve;

import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.IndexNotReadyException;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import kotlin.CollectionsKt;
import kotlin.MapsKt;
import kotlin.PreconditionsKt;
import kotlin.SetsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.KotlinClass;
import kotlin.jvm.internal.Reflection;
import kotlin.reflect.KClass;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.analyzer.AnalysisResult;
import org.jetbrains.kotlin.container.ComponentProvider;
import org.jetbrains.kotlin.diagnostics.DiagnosticUtils;
import org.jetbrains.kotlin.idea.caches.resolve.KotlinCacheServiceKt;
import org.jetbrains.kotlin.idea.caches.resolve.KotlinResolveDataProvider;
import org.jetbrains.kotlin.psi.JetElement;
import org.jetbrains.kotlin.psi.JetFile;
import org.jetbrains.kotlin.psi.psiUtil.PsiUtilsKt;
import org.jetbrains.kotlin.resolve.BindingContext;

@KotlinClass(version={0, 25, 0}, abiVersion=25, data={"U\u0006)!\u0002+\u001a:GS2,\u0017I\\1msNL7oQ1dQ\u0016T1a\u001c:h\u0015%QW\r\u001e2sC&t7O\u0003\u0004l_Rd\u0017N\u001c\u0006\u0005S\u0012,\u0017M\u0003\u0004dC\u000eDWm\u001d\u0006\be\u0016\u001cx\u000e\u001c<f\u0015\r\te.\u001f\u0006\u0007y%t\u0017\u000e\u001e \u000b\t\u0019LG.\u001a\u0006\b\u0015\u0016$h)\u001b7f\u0015\r\u00018/\u001b\u0006\u0012G>l\u0007o\u001c8f]R\u0004&o\u001c<jI\u0016\u0014(\"E\"p[B|g.\u001a8u!J|g/\u001b3fe*I1m\u001c8uC&tWM\u001d\u0006\u0006G\u0006\u001c\u0007.\u001a\u0006\b\u0011\u0006\u001c\b.T1q\u0015\u0011Q\u0017M^1\u000b\tU$\u0018\u000e\u001c\u0006\u000b!NLW\t\\3nK:$(bA2p[*A\u0011N\u001c;fY2L'N\u0003\bB]\u0006d\u0017p]5t%\u0016\u001cX\u000f\u001c;\u000b\u0011\u0005t\u0017\r\\={KJTAcZ3u\u0007>l\u0007o\u001c8f]R\u0004&o\u001c<jI\u0016\u0014(bB4fi\u001aKG.\u001a\u0006\bC:\fG.\u001f>f\u0015E\tg.\u00197zu\u0006\u0014G.Z#mK6,g\u000e\u001e\u0006\u000b\u0015\u0016$X\t\\3nK:$(BE4fi\u0006s\u0017\r\\=tSN\u0014Vm];miNTq!\u001a7f[\u0016tGO\u0003\u0004m_>\\W\u000b\u001dY\u0002\u0015\t\u0001\u0012A\u0003\u0003\t\u0001A\u0011!\u0002\u0002\u0005\u0002!\rQA\u0001\u0003\u0002\u0011\t)!\u0001b\u0001\t\u0006\u0015\u0011AA\u0001\u0005\u0004\u000b\r!)\u0001\u0003\u0001\r\u0001\u0015\t\u00012A\u0003\u0004\t\u000fA9\u0001\u0004\u0001\u0006\u0005\u0011\t\u00012B\u0003\u0004\t\u0013AQ\u0001\u0004\u0001\u0006\u0005\u0011\t\u0001bB\u0003\u0004\t\u0017Ai\u0001\u0004\u0001\u0006\u0005\u0011%\u0001\"B\u0003\u0003\t\u0017Ai!B\u0001\t\u0012\u0015\u0011Aq\u0002\u0005\n\u000b\r!\u0001\u0002\u0003\u0005\r\u0001\u0015\t\u0001BC\u0003\u0003\t%A)\"\u0002\u0002\u0005\u0014!-Qa\u0001\u0003\u000b\u0011'a\u0001!\u0002\u0002\u0005\u0003!]Qa\u0001\u0003\f\u0011-a\u0001!\u0002\u0002\u0005\u0011!AQa\u0001C\u0005\u00119a\u0001!\u0002\u0002\u0005\u0017!YQA\u0001C\u0005\u00119!\u0001\u0001D\u0002\u001a\u0007\u0015\t\u0001\u0002\u0002\r\u0005[Y!\u0011\r\u0002M\bC5)\u0011\u0001#\u0005\n\t%\u0019Q!\u0001E\u000b1+IA!C\u0002\u0006\u0003!]\u0001t\u0003M\t+\u000e!Qa\u0001C\b\u0013\u0005AA\"\f\t\u0005G\u0012Ab!I\u0002\u0006\u0003!1\u0001DB+\u0004\u0011\u0015\u0019AAB\u0005\u0002\u0011\u001di1\u0001\u0002\u0007\n\u0003!9Q\u0006\u0005\u0003d\ta%\u0011eA\u0003\u0002\u0011\u0015AR!V\u0002\t\u000b\r!I!C\u0001\t\u000e5\u0019A\u0011D\u0005\u0002\u0011\u001biS\u0003B\u0001\u0019\u001bu=A\u0001\u0001E\u000e\u001b\r)\u0011\u0001#\u0007\u0019\u001aA\u001b\u0001!I\u0002\u0006\u0003!]\u0001tC)\u0004\u000b\u0011i\u0011\"\u0001\u0005\u000e\u001b\u0005AY\"L\u000b\u0005\u0007auQt\u0002\u0003\u0001\u0011=i1!B\u0001\t\u001aae\u0001k\u0001\u0001\"\u0007\u0015\t\u0001r\u0003M\f#\u000e)AQD\u0005\u0002\u00115i\u0011\u0001c\u0007.-\u0011\t\u0001tDO\b\t\u0001AY\"D\u0002\u0006\u0003!e\u0001\u0014\u0004)\u0004\u0001\u0005\"Q!\u0001E\f\u0019\u0003A:\"U\u0002\u0006\t?I\u0011\u0001C\u0007\u000e\u0003!mQ'I\u0003!\t\r\b\u0001\u0004BO\b\t\u0001AI!D\u0002\u0006\u0003!)\u0001$\u0002)\u0004\u0001u=A\u0001\u0001\u0005\u0007\u001b\r)\u0011\u0001\u0003\u0004\u0019\rA\u001b\t!I\u0002\u0006\u0003!\u0019\u0001dA)\u0004\u000f\u0011!\u0011\"\u0001\u0003\u0001\u001b\u0005Ai!D\u0001\t\u000f\u0001"})
public final class PerFileAnalysisCache {
    public static final /* synthetic */ KClass $kotlinClass;
    private final HashMap<PsiElement, AnalysisResult> cache;
    @NotNull
    private final JetFile file;
    @NotNull
    private final ComponentProvider componentProvider;

    static {
        $kotlinClass = Reflection.createKotlinClass(PerFileAnalysisCache.class);
    }

    private final AnalysisResult lookUp(JetElement analyzableElement) {
        ArrayList descendantsOfCurrent = CollectionsKt.arrayListOf((Object[])new PsiElement[0]);
        HashSet toRemove = SetsKt.hashSetOf((Object[])new PsiElement[0]);
        AnalysisResult result2 = null;
        for (PsiElement current : PsiUtilsKt.getParentsWithSelf((PsiElement)analyzableElement)) {
            AnalysisResult cached = this.cache.get(current);
            if (cached != null) {
                result2 = cached;
                toRemove.addAll(descendantsOfCurrent);
                descendantsOfCurrent.clear();
            }
            descendantsOfCurrent.add(current);
        }
        this.cache.keySet().removeAll(toRemove);
        return result2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public final AnalysisResult getAnalysisResults(@NotNull JetElement element2) {
        AnalysisResult analysisResult;
        Intrinsics.checkParameterIsNotNull((Object)element2, (String)"element");
        boolean value2 = Intrinsics.areEqual((Object)element2.getContainingJetFile(), (Object)this.file);
        if (PreconditionsKt.getASSERTIONS_ENABLED() && !value2) {
            String message = "Wrong file. Expected " + this.getFile() + ", but was " + element2.getContainingJetFile();
            throw (Throwable)((Object)new AssertionError((Object)message));
        }
        JetElement analyzableParent = KotlinResolveDataProvider.INSTANCE$.findAnalyzableParent(element2);
        PerFileAnalysisCache lock = this;
        synchronized (lock) {
            AnalysisResult analysisResult2;
            AnalysisResult cached = this.lookUp(analyzableParent);
            if (cached != null) {
                analysisResult2 = cached;
            } else {
                AnalysisResult result2 = this.analyze(analyzableParent);
                MapsKt.set((Map)this.cache, (Object)analyzableParent, (Object)result2);
                analysisResult2 = result2;
            }
            analysisResult = analysisResult2;
        }
        return analysisResult;
    }

    private final AnalysisResult analyze(JetElement analyzableElement) {
        Project project = analyzableElement.getProject();
        if (DumbService.isDumb((Project)project)) {
            return AnalysisResult.Companion.getEMPTY();
        }
        try {
            Project project2 = project;
            Intrinsics.checkExpressionValueIsNotNull((Object)project2, (String)"project");
            return KotlinResolveDataProvider.INSTANCE$.analyze(project2, this.componentProvider, analyzableElement);
        }
        catch (ProcessCanceledException e) {
            throw (Throwable)e;
        }
        catch (IndexNotReadyException e) {
            throw (Throwable)e;
        }
        catch (Throwable e) {
            DiagnosticUtils.throwIfRunningOnServer(e);
            KotlinCacheServiceKt.getLOG().error(e);
            BindingContext bindingContext2 = BindingContext.EMPTY;
            Intrinsics.checkExpressionValueIsNotNull((Object)bindingContext2, (String)"BindingContext.EMPTY");
            return AnalysisResult.Companion.error(bindingContext2, e);
        }
    }

    @NotNull
    public final JetFile getFile() {
        return this.file;
    }

    @NotNull
    public final ComponentProvider getComponentProvider() {
        return this.componentProvider;
    }

    public PerFileAnalysisCache(@NotNull JetFile file, @NotNull ComponentProvider componentProvider) {
        Intrinsics.checkParameterIsNotNull((Object)file, (String)"file");
        Intrinsics.checkParameterIsNotNull((Object)componentProvider, (String)"componentProvider");
        this.file = file;
        this.componentProvider = componentProvider;
        this.cache = new HashMap();
    }
}

