/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.codeInsight;

import com.intellij.codeInsight.CodeInsightActionHandler;
import com.intellij.codeInsight.navigation.NavigationUtil;
import com.intellij.featureStatistics.FeatureUsageTracker;
import com.intellij.ide.util.EditSourceUtil;
import com.intellij.ide.util.PsiElementListCellRenderer;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.popup.JBPopup;
import com.intellij.pom.Navigatable;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.util.Function;
import com.intellij.util.containers.ContainerUtil;
import java.util.Collection;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.builtins.KotlinBuiltIns;
import org.jetbrains.kotlin.descriptors.CallableMemberDescriptor;
import org.jetbrains.kotlin.descriptors.ClassDescriptor;
import org.jetbrains.kotlin.descriptors.ClassifierDescriptor;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.descriptors.PropertyDescriptor;
import org.jetbrains.kotlin.descriptors.SimpleFunctionDescriptor;
import org.jetbrains.kotlin.idea.JetBundle;
import org.jetbrains.kotlin.idea.caches.resolve.ResolutionUtils;
import org.jetbrains.kotlin.idea.codeInsight.JetFunctionPsiElementCellRenderer;
import org.jetbrains.kotlin.psi.JetClass;
import org.jetbrains.kotlin.psi.JetDeclaration;
import org.jetbrains.kotlin.psi.JetNamedFunction;
import org.jetbrains.kotlin.psi.JetObjectDeclaration;
import org.jetbrains.kotlin.psi.JetProperty;
import org.jetbrains.kotlin.resolve.DescriptorToSourceUtils;
import org.jetbrains.kotlin.resolve.OverrideResolver;
import org.jetbrains.kotlin.types.JetType;

public class GotoSuperActionHandler
implements CodeInsightActionHandler {
    public void invoke(@NotNull Project project, @NotNull Editor editor, @NotNull PsiFile file) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "org/jetbrains/kotlin/idea/codeInsight/GotoSuperActionHandler", "invoke"));
        }
        if (editor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "editor", "org/jetbrains/kotlin/idea/codeInsight/GotoSuperActionHandler", "invoke"));
        }
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "org/jetbrains/kotlin/idea/codeInsight/GotoSuperActionHandler", "invoke"));
        }
        FeatureUsageTracker.getInstance().triggerFeatureUsed("navigation.goto.super");
        PsiElement element2 = file.findElementAt(editor.getCaretModel().getOffset());
        if (element2 == null) {
            return;
        }
        JetDeclaration declaration = (JetDeclaration)PsiTreeUtil.getParentOfType((PsiElement)element2, (Class[])new Class[]{JetNamedFunction.class, JetClass.class, JetProperty.class, JetObjectDeclaration.class});
        if (declaration == null) {
            return;
        }
        DeclarationDescriptor descriptor2 = ResolutionUtils.resolveToDescriptor(declaration);
        List<PsiElement> superDeclarations = GotoSuperActionHandler.findSuperDeclarations(descriptor2);
        if (superDeclarations.isEmpty()) {
            return;
        }
        if (superDeclarations.size() == 1) {
            Navigatable navigatable = EditSourceUtil.getDescriptor((PsiElement)superDeclarations.get(0));
            if (navigatable != null && navigatable.canNavigate()) {
                navigatable.navigate(true);
            }
        } else {
            String message = GotoSuperActionHandler.getTitle(descriptor2);
            PsiElement[] superDeclarationsArray = PsiUtilCore.toPsiElementArray(superDeclarations);
            JBPopup popup = descriptor2 instanceof ClassDescriptor ? NavigationUtil.getPsiElementPopup((PsiElement[])superDeclarationsArray, (String)message) : NavigationUtil.getPsiElementPopup((PsiElement[])superDeclarationsArray, (PsiElementListCellRenderer)new JetFunctionPsiElementCellRenderer(), (String)message);
            popup.showInBestPositionFor(editor);
        }
    }

    @Nullable
    private static String getTitle(DeclarationDescriptor descriptor2) {
        if (descriptor2 instanceof ClassDescriptor) {
            return JetBundle.message("goto.super.class.chooser.title", new Object[0]);
        }
        if (descriptor2 instanceof PropertyDescriptor) {
            return JetBundle.message("goto.super.property.chooser.title", new Object[0]);
        }
        if (descriptor2 instanceof SimpleFunctionDescriptor) {
            return JetBundle.message("goto.super.function.chooser.title", new Object[0]);
        }
        return null;
    }

    private static List<PsiElement> findSuperDeclarations(DeclarationDescriptor descriptor2) {
        List superDescriptors;
        if (descriptor2 instanceof ClassDescriptor) {
            Collection<JetType> supertypes2 = ((ClassDescriptor)descriptor2).getTypeConstructor().getSupertypes();
            List superclasses = ContainerUtil.mapNotNull(supertypes2, (Function)new Function<JetType, ClassDescriptor>(){

                public ClassDescriptor fun(JetType type2) {
                    ClassifierDescriptor descriptor2 = type2.getConstructor().getDeclarationDescriptor();
                    if (descriptor2 instanceof ClassDescriptor) {
                        return (ClassDescriptor)descriptor2;
                    }
                    return null;
                }
            });
            ContainerUtil.removeDuplicates((Collection)superclasses);
            superDescriptors = superclasses;
        } else if (descriptor2 instanceof CallableMemberDescriptor) {
            superDescriptors = OverrideResolver.getDirectlyOverriddenDeclarations((CallableMemberDescriptor)descriptor2);
        } else {
            return null;
        }
        return ContainerUtil.mapNotNull(superDescriptors, (Function)new Function<DeclarationDescriptor, PsiElement>(){

            public PsiElement fun(DeclarationDescriptor descriptor2) {
                if (descriptor2 instanceof ClassDescriptor && KotlinBuiltIns.isAny((ClassDescriptor)descriptor2)) {
                    return null;
                }
                return DescriptorToSourceUtils.descriptorToDeclaration(descriptor2);
            }
        });
    }

    public boolean startInWriteAction() {
        return false;
    }
}

