/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.codeInsight.surroundWith.statement;

import com.intellij.codeInsight.CodeInsightBundle;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiElement;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.idea.codeInsight.surroundWith.statement.KotlinTrySurrounderBase;
import org.jetbrains.kotlin.psi.JetExpression;
import org.jetbrains.kotlin.psi.JetFinallySection;
import org.jetbrains.kotlin.psi.JetTryExpression;

public class KotlinTryFinallySurrounder
extends KotlinTrySurrounderBase {
    @Override
    protected String getCodeTemplate() {
        return "try { \n} finally {\nb\n}";
    }

    @Override
    @Nullable
    protected TextRange surroundStatements(@NotNull Project project, @NotNull Editor editor, @NotNull PsiElement container2, @NotNull PsiElement[] statements) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "org/jetbrains/kotlin/idea/codeInsight/surroundWith/statement/KotlinTryFinallySurrounder", "surroundStatements"));
        }
        if (editor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "editor", "org/jetbrains/kotlin/idea/codeInsight/surroundWith/statement/KotlinTryFinallySurrounder", "surroundStatements"));
        }
        if (container2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "container", "org/jetbrains/kotlin/idea/codeInsight/surroundWith/statement/KotlinTryFinallySurrounder", "surroundStatements"));
        }
        if (statements == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "statements", "org/jetbrains/kotlin/idea/codeInsight/surroundWith/statement/KotlinTryFinallySurrounder", "surroundStatements"));
        }
        TextRange textRange = super.surroundStatements(project, editor, container2, statements);
        if (textRange == null) {
            return null;
        }
        editor.getDocument().deleteString(textRange.getStartOffset(), textRange.getEndOffset());
        return new TextRange(textRange.getStartOffset(), textRange.getStartOffset());
    }

    @Override
    @NotNull
    protected TextRange getTextRangeForCaret(@NotNull JetTryExpression expression2) {
        if (expression2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "org/jetbrains/kotlin/idea/codeInsight/surroundWith/statement/KotlinTryFinallySurrounder", "getTextRangeForCaret"));
        }
        JetFinallySection block = expression2.getFinallyBlock();
        assert (block != null) : "Finally block should exists for " + expression2.getText();
        JetExpression blockExpression = block.getFinalExpression().getStatements().get(0);
        TextRange textRange = blockExpression.getTextRange();
        if (textRange == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/idea/codeInsight/surroundWith/statement/KotlinTryFinallySurrounder", "getTextRangeForCaret"));
        }
        return textRange;
    }

    public String getTemplateDescription() {
        return CodeInsightBundle.message((String)"surround.with.try.finally.template", (Object[])new Object[0]);
    }
}

