/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.codeInsight.surroundWith.statement;

import com.intellij.codeInsight.CodeInsightUtilBase;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiElement;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.idea.codeInsight.surroundWith.KotlinSurrounderUtils;
import org.jetbrains.kotlin.idea.codeInsight.surroundWith.MoveDeclarationsOutHelper;
import org.jetbrains.kotlin.idea.codeInsight.surroundWith.statement.KotlinStatementsSurrounder;
import org.jetbrains.kotlin.psi.JetBlockExpression;
import org.jetbrains.kotlin.psi.JetParameter;
import org.jetbrains.kotlin.psi.JetTryExpression;
import org.jetbrains.kotlin.psi.JetTypeReference;
import org.jetbrains.kotlin.psi.PsiPackage;

public abstract class KotlinTrySurrounderBase
extends KotlinStatementsSurrounder {
    @Override
    @Nullable
    protected TextRange surroundStatements(@NotNull Project project, @NotNull Editor editor, @NotNull PsiElement container2, @NotNull PsiElement[] statements) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "org/jetbrains/kotlin/idea/codeInsight/surroundWith/statement/KotlinTrySurrounderBase", "surroundStatements"));
        }
        if (editor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "editor", "org/jetbrains/kotlin/idea/codeInsight/surroundWith/statement/KotlinTrySurrounderBase", "surroundStatements"));
        }
        if (container2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "container", "org/jetbrains/kotlin/idea/codeInsight/surroundWith/statement/KotlinTrySurrounderBase", "surroundStatements"));
        }
        if (statements == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "statements", "org/jetbrains/kotlin/idea/codeInsight/surroundWith/statement/KotlinTrySurrounderBase", "surroundStatements"));
        }
        if ((statements = MoveDeclarationsOutHelper.move(container2, statements, true)).length == 0) {
            KotlinSurrounderUtils.showErrorHint(project, editor, KotlinSurrounderUtils.SURROUND_WITH_ERROR);
            return null;
        }
        JetTryExpression tryExpression = (JetTryExpression)PsiPackage.JetPsiFactory(project).createExpression(this.getCodeTemplate());
        tryExpression = (JetTryExpression)container2.addAfter((PsiElement)tryExpression, statements[statements.length - 1]);
        JetBlockExpression tryBlock2 = tryExpression.getTryBlock();
        KotlinSurrounderUtils.addStatementsInBlock(tryBlock2, statements);
        container2.deleteChildRange(statements[0], statements[statements.length - 1]);
        tryExpression = (JetTryExpression)CodeInsightUtilBase.forcePsiPostprocessAndRestoreElement((PsiElement)tryExpression);
        return this.getTextRangeForCaret(tryExpression);
    }

    protected abstract String getCodeTemplate();

    @NotNull
    protected abstract TextRange getTextRangeForCaret(@NotNull JetTryExpression var1);

    protected static TextRange getCatchTypeParameterTextRange(@NotNull JetTryExpression expression2) {
        if (expression2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "org/jetbrains/kotlin/idea/codeInsight/surroundWith/statement/KotlinTrySurrounderBase", "getCatchTypeParameterTextRange"));
        }
        JetParameter parameter = expression2.getCatchClauses().get(0).getCatchParameter();
        assert (parameter != null) : "Catch parameter should exists for " + expression2.getText();
        JetTypeReference typeReference = parameter.getTypeReference();
        assert (typeReference != null) : "Type reference for parameter should exists for " + expression2.getText();
        return typeReference.getTextRange();
    }
}

