/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.configuration;

import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import com.intellij.notification.Notification;
import com.intellij.notification.NotificationType;
import com.intellij.notification.Notifications;
import com.intellij.openapi.extensions.Extensions;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.project.Project;
import com.intellij.psi.search.FileTypeIndex;
import com.intellij.psi.search.GlobalSearchScope;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.idea.JetFileType;
import org.jetbrains.kotlin.idea.configuration.ConfigureKotlinNotificationManager;
import org.jetbrains.kotlin.idea.configuration.KotlinProjectConfigurator;

public class ConfigureKotlinInProjectUtils {
    public static boolean isProjectConfigured(@NotNull Project project) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "org/jetbrains/kotlin/idea/configuration/ConfigureKotlinInProjectUtils", "isProjectConfigured"));
        }
        Collection<Module> modules = ConfigureKotlinInProjectUtils.getModulesWithKotlinFiles(project);
        for (Module module : modules) {
            if (ConfigureKotlinInProjectUtils.isModuleConfigured(module)) continue;
            return false;
        }
        return true;
    }

    public static boolean isModuleConfigured(@NotNull Module module) {
        if (module == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "module", "org/jetbrains/kotlin/idea/configuration/ConfigureKotlinInProjectUtils", "isModuleConfigured"));
        }
        Set<KotlinProjectConfigurator> configurators = ConfigureKotlinInProjectUtils.getApplicableConfigurators(module);
        for (KotlinProjectConfigurator configurator : configurators) {
            if (!configurator.isConfigured(module)) continue;
            return true;
        }
        return false;
    }

    public static Collection<Module> getModulesWithKotlinFiles(@NotNull Project project) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "org/jetbrains/kotlin/idea/configuration/ConfigureKotlinInProjectUtils", "getModulesWithKotlinFiles"));
        }
        if (project.isDisposed()) {
            return Collections.emptyList();
        }
        if (!FileTypeIndex.containsFileOfType((FileType)JetFileType.INSTANCE, (GlobalSearchScope)GlobalSearchScope.projectScope((Project)project))) {
            return Collections.emptyList();
        }
        ArrayList modulesWithKotlin = Lists.newArrayList();
        for (Module module : ModuleManager.getInstance((Project)project).getModules()) {
            if (!FileTypeIndex.containsFileOfType((FileType)JetFileType.INSTANCE, (GlobalSearchScope)module.getModuleScope(true))) continue;
            modulesWithKotlin.add(module);
        }
        return modulesWithKotlin;
    }

    public static void showConfigureKotlinNotificationIfNeeded(@NotNull Module module) {
        if (module == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "module", "org/jetbrains/kotlin/idea/configuration/ConfigureKotlinInProjectUtils", "showConfigureKotlinNotificationIfNeeded"));
        }
        if (ConfigureKotlinInProjectUtils.isModuleConfigured(module)) {
            return;
        }
        ConfigureKotlinInProjectUtils.showConfigureKotlinNotification(module.getProject());
    }

    public static void showConfigureKotlinNotificationIfNeeded(@NotNull Project project) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "org/jetbrains/kotlin/idea/configuration/ConfigureKotlinInProjectUtils", "showConfigureKotlinNotificationIfNeeded"));
        }
        if (ConfigureKotlinInProjectUtils.isProjectConfigured(project)) {
            return;
        }
        ConfigureKotlinInProjectUtils.showConfigureKotlinNotification(project);
    }

    private static void showConfigureKotlinNotification(@NotNull Project project) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "org/jetbrains/kotlin/idea/configuration/ConfigureKotlinInProjectUtils", "showConfigureKotlinNotification"));
        }
        ConfigureKotlinNotificationManager.INSTANCE$.notify(project);
    }

    @NotNull
    public static Collection<KotlinProjectConfigurator> getAbleToRunConfigurators(@NotNull Project project) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "org/jetbrains/kotlin/idea/configuration/ConfigureKotlinInProjectUtils", "getAbleToRunConfigurators"));
        }
        Collection<Module> modules = ConfigureKotlinInProjectUtils.getModulesWithKotlinFiles(project);
        LinkedHashSet canRunConfigurators = Sets.newLinkedHashSet();
        block0: for (KotlinProjectConfigurator configurator : (KotlinProjectConfigurator[])Extensions.getExtensions(KotlinProjectConfigurator.EP_NAME)) {
            for (Module module : modules) {
                if (!configurator.isApplicable(module) || configurator.isConfigured(module)) continue;
                canRunConfigurators.add(configurator);
                continue block0;
            }
        }
        LinkedHashSet linkedHashSet = canRunConfigurators;
        if (linkedHashSet == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/idea/configuration/ConfigureKotlinInProjectUtils", "getAbleToRunConfigurators"));
        }
        return linkedHashSet;
    }

    @NotNull
    public static Set<KotlinProjectConfigurator> getApplicableConfigurators(@NotNull Module module) {
        if (module == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "module", "org/jetbrains/kotlin/idea/configuration/ConfigureKotlinInProjectUtils", "getApplicableConfigurators"));
        }
        HashSet applicableConfigurators = Sets.newHashSet();
        for (KotlinProjectConfigurator configurator : (KotlinProjectConfigurator[])Extensions.getExtensions(KotlinProjectConfigurator.EP_NAME)) {
            if (!configurator.isApplicable(module)) continue;
            applicableConfigurators.add(configurator);
        }
        HashSet hashSet = applicableConfigurators;
        if (hashSet == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/idea/configuration/ConfigureKotlinInProjectUtils", "getApplicableConfigurators"));
        }
        return hashSet;
    }

    @Nullable
    public static KotlinProjectConfigurator getConfiguratorByName(@NotNull String name2) {
        if (name2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "org/jetbrains/kotlin/idea/configuration/ConfigureKotlinInProjectUtils", "getConfiguratorByName"));
        }
        for (KotlinProjectConfigurator configurator : (KotlinProjectConfigurator[])Extensions.getExtensions(KotlinProjectConfigurator.EP_NAME)) {
            if (!configurator.getName().equals(name2)) continue;
            return configurator;
        }
        return null;
    }

    public static List<Module> getNonConfiguredModules(@NotNull Project project, @NotNull KotlinProjectConfigurator configurator) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "org/jetbrains/kotlin/idea/configuration/ConfigureKotlinInProjectUtils", "getNonConfiguredModules"));
        }
        if (configurator == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "configurator", "org/jetbrains/kotlin/idea/configuration/ConfigureKotlinInProjectUtils", "getNonConfiguredModules"));
        }
        Collection<Module> modules = ConfigureKotlinInProjectUtils.getModulesWithKotlinFiles(project);
        ArrayList<Module> result2 = new ArrayList<Module>(modules.size());
        for (Module module : modules) {
            if (!configurator.isApplicable(module) || configurator.isConfigured(module)) continue;
            result2.add(module);
        }
        return result2;
    }

    @NotNull
    public static Collection<Module> getNonConfiguredModules(@NotNull Project project) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "org/jetbrains/kotlin/idea/configuration/ConfigureKotlinInProjectUtils", "getNonConfiguredModules"));
        }
        HashSet modules = Sets.newHashSet();
        Collection<Module> modulesWithKotlinFiles = ConfigureKotlinInProjectUtils.getModulesWithKotlinFiles(project);
        for (KotlinProjectConfigurator configurator : ConfigureKotlinInProjectUtils.getAbleToRunConfigurators(project)) {
            for (Module module : modulesWithKotlinFiles) {
                if (configurator.isConfigured(module)) continue;
                modules.add(module);
            }
        }
        HashSet hashSet = modules;
        if (hashSet == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/idea/configuration/ConfigureKotlinInProjectUtils", "getNonConfiguredModules"));
        }
        return hashSet;
    }

    private ConfigureKotlinInProjectUtils() {
    }

    public static void showInfoNotification(@NotNull String message) {
        if (message == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "message", "org/jetbrains/kotlin/idea/configuration/ConfigureKotlinInProjectUtils", "showInfoNotification"));
        }
        Notifications.Bus.notify((Notification)new Notification("Configure Kotlin: info notification", "Configure Kotlin", message, NotificationType.INFORMATION));
    }
}

