/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.debugger;

import com.intellij.debugger.SourcePosition;
import com.intellij.debugger.engine.evaluation.TextWithImports;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiFile;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.text.CharArrayUtil;
import java.util.LinkedHashSet;
import java.util.Set;
import kotlin.SetsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.KotlinFileFacade;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.idea.codeInsight.CodeInsightUtils;
import org.jetbrains.kotlin.idea.debugger.VariablesCollector;
import org.jetbrains.kotlin.psi.JetDeclaration;
import org.jetbrains.kotlin.psi.JetDeclarationWithBody;
import org.jetbrains.kotlin.psi.JetElement;
import org.jetbrains.kotlin.psi.JetProperty;

@KotlinFileFacade(version={0, 25, 0}, abiVersion=25, data={"\u0007\b)Ib-\u001b8e\u0003\u0012$\u0017\u000e^5p]\u0006dW\t\u001f9sKN\u001c\u0018n\u001c8t\u0015!\u0001xn]5uS>t'BD*pkJ\u001cW\rU8tSRLwN\u001c\u0006\u0004G>l'\u0002C5oi\u0016dG.\u001b6\u000b\u0011\u0011,'-^4hKJT1aU3u\u0015\u0019Yw\u000e\u001e7j]*yA+\u001a=u/&$\b.S7q_J$8O\u0003\u0004f]\u001eLg.\u001a\u0006\u000bKZ\fG.^1uS>t'\u0002\u00026bm\u0006TA!\u001e;jY*\u00193j\u001c;mS:4%/Y7f\u000bb$(/\u0019,be&\f'\r\\3t!J|g/\u001b3fe.#(\u0002F4fi\u000e{g\u000e^1j]&tw-\u00127f[\u0016tGOC\u0004fY\u0016lWM\u001c;\u000b\u0015A\u001b\u0018.\u00127f[\u0016tGOC\u0002qg&T!BS3u\u000b2,W.\u001a8u\u0015\ry'o\u001a\u0006\nU\u0016$(M]1j]NTacZ3u\u0019&tWMU1oO\u00164uN]#mK6,g\u000e\u001e\u0006\u0012G>tG/Y5oS:<W\t\\3nK:$(b\u00013pG*AAi\\2v[\u0016tGOC\u0004pa\u0016t\u0017\r]5\u000b\r\u0015$\u0017\u000e^8s\u0015%!V\r\u001f;SC:<WM\u0003\btQ>,H\u000eZ*lSBd\u0015N\\3\u000b\t\u0019LG.\u001a\u0006\b!NLg)\u001b7f\u0015\u0011a\u0017N\\3\u000b\u0007%sGOC\u0004C_>dW-\u00198S\u0004)\u0011\u0001c\u0001\u0006\u0005\u0011\u0001\u0001BA\u0003\u0003\t\u0003A)!B\u0002\u0005\u0003!\tA\u0002A\u0003\u0002\u0011\u000f)1\u0001\u0002\u0002\t\u00071\u0001QA\u0001\u0003\u0002\u0011\u0013)!\u0001B\u0002\t\u000b\u0015\u0019Aq\u0001\u0005\u0005\u0019\u0001)\u0011\u0001c\u0003\u0006\u0005\u0011%\u0001BB\u0003\u0003\t\u0015A1!\u0002\u0002\u0005\u0003!\tQA\u0001C\u0001\u0011#)1\u0001\"\u0004\t\u00111\u0001Q!\u0001E\n\u000b\t!y\u0001\u0003\u0006\u0006\u0005\u0011A\u0001rA\u0003\u0003\t#A\t\"B\u0002\u0005\u0013!IA\u0002A\u0003\u0003\t%A\u0011\"\u0002\u0002\u0005\u000e!AQA\u0001C\u0001\u00113)!\u0001B\u0006\t\u001b\u0015\u0019Aq\u0003\u0005\r\u0019\u0001)!\u0001B\u0006\t\r\u0015\u0019A\u0011\u0004E\u000e\u0019\u0001)!\u0001\"\u0007\t\u001c\u0015\u0011Aq\u0003\u0005\r\u000b\r!i\u0001C\b\r\u0001\u0015\u0019AA\u0001\u0005\u0011\u0019\u0001)1\u0001\u0002\u0002\t\"1\u0001QA\u0001C\u0007\u0011=)9\u0004B\u0001\u0019\u0001u=A\u0001\u0001E\u0001\u001b\r)\u0011\u0001c\u0001\u0019\u0004A\u001b\u0001!\t\u0005\u0006\u0003!\u0015\u0011\u0002B\u0005\u0004\u000b\u0005AA\u0001\u0007\u0003\u0019\u0006E\u001bQ\u0001\u0002\u0001\n\u0003!-Q\"\u0001\u0005\u00071\u000e5Qq\u0006\u0003\u00021\u001diz\u0001\u0002\u0001\t\u00105\u0019Q!\u0001\u0005\b1\u001d\u00016\u0001A\u0011\u0005\u000b\u0005A\u0019\u0002$\u0001\u0019\u0014E\u001bQ\u0001B\u0004\n\u0003!QQ\"\u0001E\u000b1\u000e5Q!\t\u0003\u00021+iz\u0001\u0002\u0001\t\u00175\u0019Q!\u0001\u0005\b1\u001d\u00016\u0001AO\b\t\u0001A9\"D\u0002\u0006\u0003!a\u0001\u0004\u0004)\u0004\u0002\u0005\u001aQ!\u0001\u0005\u000e15\t6a\u0002C\u000b\u0013\u0005AY\"D\u0001\t\u00165\t\u0001B\u0004-\u0004\u000e\u0015]C!\u0001\r\u000f;\u001f!\u0001\u0001#\b\u000e\u0007\u0015\t\u0001R\u0004M\u000f!\u000e\u0001Qt\u0002\u0003\u0001\u0011/i1!B\u0001\t\u0019aa\u0001k!\u0001\u001e\u0010\u0011\u0001\u0001rD\u0007\u0004\u000b\u0005Aq\u0002G\bQ\u0007\u0005\t3!B\u0001\t a}\u0011kA\u0005\u0005\u001d%\tA\u0011A\u0007\u0002\u0011Ai\u0011\u0001\u0003\b\u000e\u0003\u0011\u0015\u0001l!\u0004"})
public final class KotlinFrameExtraVariablesProviderKt {
    @NotNull
    public static final Set<TextWithImports> findAdditionalExpressions(@NotNull SourcePosition position) {
        int endOffset;
        int startOffset;
        PsiElement containingElement;
        PsiElement elem;
        Document doc;
        Intrinsics.checkParameterIsNotNull((Object)position, (String)"position");
        int line = position.getLine();
        PsiFile file = position.getFile();
        VirtualFile vFile = file.getVirtualFile();
        Document document = doc = vFile != null ? FileDocumentManager.getInstance().getDocument(vFile) : (Document)null;
        if (doc == null || doc.getLineCount() == 0 || line > doc.getLineCount() - 1) {
            return SetsKt.emptySet();
        }
        int offset2 = doc.getLineStartOffset(line);
        if (offset2 < 0) {
            return SetsKt.emptySet();
        }
        PsiElement psiElement2 = elem = file.findElementAt(offset2);
        if (psiElement2 == null) {
            Intrinsics.throwNpe();
        }
        Intrinsics.checkExpressionValueIsNotNull((Object)psiElement2, (String)"elem!!");
        JetElement jetElement = KotlinFrameExtraVariablesProviderKt.getContainingElement(psiElement2);
        PsiElement psiElement3 = containingElement = jetElement != null ? (PsiElement)jetElement : elem;
        if (containingElement == null) {
            return SetsKt.emptySet();
        }
        TextRange limit = KotlinFrameExtraVariablesProviderKt.getLineRangeForElement(containingElement, doc);
        int startLine = Math.max(limit.getStartOffset(), line);
        while (startLine - 1 > limit.getStartOffset()) {
            PsiFile psiFile = file;
            Intrinsics.checkExpressionValueIsNotNull((Object)psiFile, (String)"file");
            if (!KotlinFrameExtraVariablesProviderKt.shouldSkipLine(psiFile, doc, startLine - 1)) break;
            --startLine;
        }
        int endLine = Math.min(limit.getEndOffset(), line);
        while (endLine + 1 < limit.getEndOffset()) {
            PsiFile psiFile = file;
            Intrinsics.checkExpressionValueIsNotNull((Object)psiFile, (String)"file");
            if (!KotlinFrameExtraVariablesProviderKt.shouldSkipLine(psiFile, doc, endLine + 1)) break;
            ++endLine;
        }
        if ((startOffset = doc.getLineStartOffset(startLine)) >= (endOffset = doc.getLineEndOffset(endLine))) {
            return SetsKt.emptySet();
        }
        TextRange lineRange = new TextRange(startOffset, endOffset);
        if (lineRange.isEmpty()) {
            return SetsKt.emptySet();
        }
        LinkedHashSet expressions = new LinkedHashSet();
        VariablesCollector variablesCollector = new VariablesCollector(lineRange, expressions);
        containingElement.accept((PsiElementVisitor)variablesCollector);
        return expressions;
    }

    @Nullable
    public static final JetElement getContainingElement(@NotNull PsiElement element2) {
        PsiElement parent2;
        JetElement contElement;
        Intrinsics.checkParameterIsNotNull((Object)element2, (String)"element");
        JetDeclaration jetDeclaration = (JetDeclaration)PsiTreeUtil.getParentOfType((PsiElement)element2, JetDeclaration.class);
        JetElement jetElement = contElement = jetDeclaration != null ? (JetElement)jetDeclaration : (JetElement)PsiTreeUtil.getParentOfType((PsiElement)element2, JetElement.class);
        if (contElement instanceof JetProperty && ((JetProperty)contElement).isLocal() && (parent2 = ((JetProperty)contElement).getParent()) != null) {
            return KotlinFrameExtraVariablesProviderKt.getContainingElement(parent2);
        }
        if (contElement instanceof JetDeclarationWithBody) {
            return ((JetDeclarationWithBody)contElement).getBodyExpression();
        }
        return contElement;
    }

    @NotNull
    public static final TextRange getLineRangeForElement(@NotNull PsiElement containingElement, @NotNull Document doc) {
        Intrinsics.checkParameterIsNotNull((Object)containingElement, (String)"containingElement");
        Intrinsics.checkParameterIsNotNull((Object)doc, (String)"doc");
        TextRange elemRange = containingElement.getTextRange();
        return new TextRange(doc.getLineNumber(elemRange.getStartOffset()), doc.getLineNumber(elemRange.getEndOffset()));
    }

    public static final boolean shouldSkipLine(@NotNull PsiFile file, @NotNull Document doc, int line) {
        PsiElement topmostElementAtOffset;
        PsiElement elemAtOffset;
        Intrinsics.checkParameterIsNotNull((Object)file, (String)"file");
        Intrinsics.checkParameterIsNotNull((Object)doc, (String)"doc");
        int start = CharArrayUtil.shiftForward((CharSequence)doc.getCharsSequence(), (int)doc.getLineStartOffset(line), (String)" \n\t");
        int end = doc.getLineEndOffset(line);
        if (start >= end) {
            return true;
        }
        PsiElement psiElement2 = elemAtOffset = file.findElementAt(start);
        if (psiElement2 == null) {
            Intrinsics.throwNpe();
        }
        return !((topmostElementAtOffset = CodeInsightUtils.getTopmostElementAtOffset(psiElement2, start)) instanceof JetDeclaration);
    }
}

