/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.debugger;

import com.intellij.debugger.engine.evaluation.CodeFragmentKind;
import com.intellij.debugger.engine.evaluation.TextWithImports;
import com.intellij.debugger.engine.evaluation.TextWithImportsImpl;
import com.intellij.openapi.util.TextRange;
import java.util.Set;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.KotlinClass;
import kotlin.jvm.internal.Reflection;
import kotlin.reflect.KClass;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.descriptors.PropertyDescriptor;
import org.jetbrains.kotlin.descriptors.PropertyGetterDescriptor;
import org.jetbrains.kotlin.idea.caches.resolve.ResolutionUtils;
import org.jetbrains.kotlin.psi.JetClass;
import org.jetbrains.kotlin.psi.JetElement;
import org.jetbrains.kotlin.psi.JetExpression;
import org.jetbrains.kotlin.psi.JetFunctionLiteralExpression;
import org.jetbrains.kotlin.psi.JetNamedFunction;
import org.jetbrains.kotlin.psi.JetObjectLiteralExpression;
import org.jetbrains.kotlin.psi.JetQualifiedExpression;
import org.jetbrains.kotlin.psi.JetReferenceExpression;
import org.jetbrains.kotlin.psi.JetTreeVisitorVoid;
import org.jetbrains.kotlin.resolve.BindingContext;

@KotlinClass(version={0, 25, 0}, abiVersion=25, data={"q\n)\u0011b+\u0019:jC\ndWm]\"pY2,7\r^8s\u0015\ry'o\u001a\u0006\nU\u0016$(M]1j]NTaa[8uY&t'\u0002B5eK\u0006T\u0001\u0002Z3ck\u001e<WM\u001d\u0006\u0013\u0015\u0016$HK]3f-&\u001c\u0018\u000e^8s->LGMC\u0002qg&Ta\u0001P5oSRt$bC7z\u0019&tWMU1oO\u0016T\u0011\u0002V3yiJ\u000bgnZ3\u000b\u0007\r|WN\u0003\u0005j]R,G\u000e\\5k\u0015\u001dy\u0007/\u001a8ba&TA!\u001e;jY*iQ._#yaJ,7o]5p]NT!\"T;uC\ndWmU3u\u0015=!V\r\u001f;XSRD\u0017*\u001c9peR\u001c(BB3oO&tWM\u0003\u0006fm\u0006dW/\u0019;j_:TAA[1wC*\u00191+\u001a;\u000b\u001f%\u001c(+\u001a4U_B\u0013x\u000e]3sifT!\"\u001a=qe\u0016\u001c8/[8o\u0015YQU\r\u001e*fM\u0016\u0014XM\\2f\u000bb\u0004(/Z:tS>t'b\u0002\"p_2,\u0017M\u001c\u0006\u000bm&\u001c\u0018\u000e^\"mCN\u001c(\"B6mCN\u001c(\u0002\u0003&fi\u000ec\u0017m]:\u000b\tUs\u0017\u000e\u001e\u0006\u001fm&\u001c\u0018\u000e\u001e$v]\u000e$\u0018n\u001c8MSR,'/\u00197FqB\u0014Xm]:j_:TADS3u\rVt7\r^5p]2KG/\u001a:bY\u0016C\bO]3tg&|gNC\bwSNLGOS3u\u000b2,W.\u001a8u\u0015\u001d)G.Z7f]RT!BS3u\u000b2,W.\u001a8u\u0015I1\u0018n]5u\u001d\u0006lW\r\u001a$v]\u000e$\u0018n\u001c8\u000b\u0011\u0019,hn\u0019;j_:T\u0001CS3u\u001d\u0006lW\r\u001a$v]\u000e$\u0018n\u001c8\u000b9YL7/\u001b;PE*,7\r\u001e'ji\u0016\u0014\u0018\r\\#yaJ,7o]5p]*Q\"*\u001a;PE*,7\r\u001e'ji\u0016\u0014\u0018\r\\#yaJ,7o]5p]*Ab/[:jiF+\u0018\r\\5gS\u0016$W\t\u001f9sKN\u001c\u0018n\u001c8\u000b-)+G/U;bY&4\u0017.\u001a3FqB\u0014Xm]:j_:T\u0001D^5tSR\u0014VMZ3sK:\u001cW-\u0012=qe\u0016\u001c8/[8o\u0015)\u0019'/Z1uKR+\u0007\u0010\u001e\u0006\nSNLeNU1oO\u0016$)A\u0003\u0002\u0011\u0003)!\u0001\u0002\u0001\t\u0003\u0015\u0011A\u0011\u0001E\u0002\u000b\t!\u0011\u0001\u0003\u0002\u0006\u0005\u0011\r\u0001RA\u0003\u0004\t\tA\u0001\u0001\u0004\u0001\u0006\u0005\u0011\t\u0001rA\u0003\u0004\t\rA1\u0001\u0004\u0001\u0006\u0003!-QA\u0001\u0003\u0005\u0011\u0019)!\u0001\"\u0003\t\u000e\u0015\u0011A!\u0002\u0005\b\u000b\r!Y\u0001C\u0003\r\u0001\u0015\t\u00012A\u0003\u0004\t\u001bA\u0001\u0002\u0004\u0001\u0006\u0005\u0011%\u0001RA\u0003\u0003\t\u001fA\u0011\"\u0002\u0002\u0005\u0011!MQa\u0001C\t\u0011#a\u0001!\u0002\u0002\u0005\f!)Q!\u0001\u0005\u000b\u000b\t!!\u0002C\u0004\u0006\u0005\u0011U\u0001RC\u0003\u0004\t\rAA\u0002\u0004\u0001\u0006\u0007\u00115\u0001\u0012\u0004\u0007\u0001\u000b\t!1\u0001\u0003\u0007\u0006\u0007\u0011\u0019\u0001B\u0004\u0007\u0001\u000b\r!i\u0001#\b\r\u0001\u0015\u0011Aa\u0001\u0005\u000f\u000b\r!1\u0001c\b\r\u0001\u0015\u0011Aa\u0001E\u0010\u000b\r!1\u0001C\t\r\u0001\u0015\u0011Aa\u0001\u0005\u0012\u000b\r!1\u0001#\n\r\u0001\u0015\u0011Aa\u0001E\u0013\u000b\r!1\u0001c\n\r\u0001\u0015\u0011Aa\u0001E\u0014\u000b\r!1\u0001#\u000b\r\u0001\u0015\u0011Aa\u0001E\u0015\u000b\t!\t\u0002#\u0005\u0005\u00031\u0015\u0011dA\u0003\u0002\u0011\u000fA:!L\t\u0005C\u0012Az!\t\u0005\u0006\u0003!9\u0011\u0002B\u0005\u0004\u000b\u0005A\u0011\u0002G\u0005\u0019\u000fU\u001bA!B\u0002\u0005\u0010%\t\u0001bC\u0017\r\t\u0005$\u0001\u0014B\u0011\u0004\u000b\u0005Aa\u0001\u0007\u0004V\u0007\u0011)1\u0001\"\u0003\n\u0003!MQ&\u0006\u0003\u00021-iz\u0001\u0002\u0001\t\u00185\u0019Q!\u0001E\f1/\u00016\u0001A\u0011\u0004\u000b\u0005AA\u0002\u0007\u0007R\u0007\u0015!1\"C\u0001\u0005\u00025\t\u0001\u0012D\u0017\u0016\t-AR\"h\u0004\u0005\u0001!mQbA\u0003\u0002\u00115AR\u0002U\u0002\u0001C\r)\u0011\u0001c\u0007\u0019\u001cE\u001bQ\u0001B\u0007\n\u0003\u0011\u0001Q\"\u0001\u0005\u000f[U!1\u0002G\b\u001e\u0010\u0011\u0001\u0001rC\u0007\u0004\u000b\u0005Ai\u0002'\bQ\u0007\u0001\t3!B\u0001\t\u001cam\u0011kA\u0003\u0005\u001f%\tA\u0001A\u0007\u0002\u0011=iS\u0003B\u0006\u0019!u=A\u0001\u0001E\u0011\u001b\r)\u0011\u0001c\b\u0019 A\u001b\u0001!I\u0002\u0006\u0003!m\u00014D)\u0004\u000b\u0011\u0001\u0012\"\u0001\u0003\u0001\u001b\u0005A\u0001#L\u000b\u0005\u0017a\rRt\u0002\u0003\u0001\u0011Ii1!B\u0001\t\"a\u0005\u0002k\u0001\u0001\"\u0007\u0015\t\u00012\u0004M\u000e#\u000e)A1E\u0005\u0002\t\u0001i\u0011\u0001C\t.+\u0011Y\u0001dEO\b\t\u0001A9\"D\u0002\u0006\u0003!\r\u00024\u0005)\u0004\u0001\u0005\u001aQ!\u0001E\u000e17\t6!\u0002\u0003\u0014\u0013\u0005!\u0001!D\u0001\t%5*Ba\u0003\r\u0015;\u001f!\u0001\u0001c\u0006\u000e\u0007\u0015\t\u0001R\u0005M\u0013!\u000e\u0001\u0011eA\u0003\u0002\u00117AZ\"U\u0002\u0006\tQI\u0011\u0001\u0002\u0001\u000e\u0003!\u0019R&\u0006\u0003\f1Uiz\u0001\u0002\u0001\t\u00185\u0019Q!\u0001E\f1/\u00016\u0001A\u0011\u0004\u000b\u0005AY\u0002g\u0007R\u0007\u0015!Q#C\u0001\u0005\u00015\t\u0001\u0012DW\u0011\t\u0005)2!B\u0001\t a}\u00014F\u0011\u0004\u000b\u0005A\u0011\u0002G\u0005R\u0007\u0015!Y#C\u0001\t(5\t\u0001\u0002EW\u0011\t\u0005)2!B\u0001\t a}\u0001DF\u0011\u0004\u000b\u0005AA\u0002\u0007\u0007R\u0007\u0015!a#C\u0001\u0005\u00025\t\u0001\u0002E\u001b'\u000b\u0015\"1\u001d\u0001\r\u0005;\u001f!\u0001\u0001#\u0003\u000e\u0007\u0015\t\u0001B\u0002\r\u0007!\u000e\u0001Q\u0014\u0004\u0003\u0001\u0011\u001fi\u0001\"B\u0001\t\u000f%!\u0011bA\u0003\u0002\u0011%A\u0012\u0002G\u0004Q\u0007\u0003\t3!B\u0001\t\u0006a\u0015\u0011kA\u0004\u0005\t%\tA\u0001A\u0007\u0002\u0011'i\u0011\u0001C\u0006"})
public final class VariablesCollector
extends JetTreeVisitorVoid {
    public static final /* synthetic */ KClass $kotlinClass;
    private final TextRange myLineRange;
    private final Set<TextWithImports> myExpressions;

    static {
        $kotlinClass = Reflection.createKotlinClass(VariablesCollector.class);
    }

    @Override
    public void visitJetElement(@NotNull JetElement element2) {
        Intrinsics.checkParameterIsNotNull((Object)element2, (String)"element");
        if (this.isInRange(element2)) {
            super.visitJetElement(element2);
        }
    }

    @Override
    public void visitQualifiedExpression(@NotNull JetQualifiedExpression expression2) {
        JetExpression selector;
        Intrinsics.checkParameterIsNotNull((Object)expression2, (String)"expression");
        if (this.isInRange(expression2) && (selector = expression2.getSelectorExpression()) instanceof JetReferenceExpression && this.isRefToProperty((JetReferenceExpression)selector)) {
            this.myExpressions.add(this.createText(expression2));
            return;
        }
        super.visitQualifiedExpression(expression2);
    }

    private final boolean isRefToProperty(JetReferenceExpression expression2) {
        BindingContext context = ResolutionUtils.analyzeFully(expression2);
        DeclarationDescriptor descriptor2 = (DeclarationDescriptor)context.get(BindingContext.REFERENCE_TARGET, expression2);
        if (descriptor2 instanceof PropertyDescriptor) {
            PropertyGetterDescriptor getter = ((PropertyDescriptor)descriptor2).getGetter();
            return (getter == null || context.get(BindingContext.DELEGATED_PROPERTY_RESOLVED_CALL, getter) == null) && ((PropertyDescriptor)descriptor2).getCompileTimeInitializer() == null;
        }
        return false;
    }

    @Override
    public void visitReferenceExpression(@NotNull JetReferenceExpression expression2) {
        Intrinsics.checkParameterIsNotNull((Object)expression2, (String)"expression");
        if (this.isInRange(expression2) && this.isRefToProperty(expression2)) {
            this.myExpressions.add(this.createText(expression2));
        }
        super.visitReferenceExpression(expression2);
    }

    private final boolean isInRange(JetElement $receiver) {
        return this.myLineRange.intersects($receiver.getTextRange());
    }

    private final TextWithImports createText(JetElement $receiver) {
        return (TextWithImports)new TextWithImportsImpl(CodeFragmentKind.EXPRESSION, $receiver.getText());
    }

    @Override
    public void visitClass(@NotNull JetClass klass) {
        Intrinsics.checkParameterIsNotNull((Object)klass, (String)"klass");
    }

    @Override
    public void visitNamedFunction(@NotNull JetNamedFunction function2) {
        Intrinsics.checkParameterIsNotNull((Object)function2, (String)"function");
    }

    @Override
    public void visitObjectLiteralExpression(@NotNull JetObjectLiteralExpression expression2) {
        Intrinsics.checkParameterIsNotNull((Object)expression2, (String)"expression");
    }

    @Override
    public void visitFunctionLiteralExpression(@NotNull JetFunctionLiteralExpression expression2) {
        Intrinsics.checkParameterIsNotNull((Object)expression2, (String)"expression");
    }

    public VariablesCollector(@NotNull TextRange myLineRange, @NotNull Set<TextWithImports> myExpressions) {
        Intrinsics.checkParameterIsNotNull((Object)myLineRange, (String)"myLineRange");
        Intrinsics.checkParameterIsNotNull(myExpressions, (String)"myExpressions");
        this.myLineRange = myLineRange;
        this.myExpressions = myExpressions;
    }
}

