/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.debugger.breakpoints;

import com.intellij.debugger.DebuggerBundle;
import com.intellij.debugger.DebuggerManagerEx;
import com.intellij.debugger.SourcePosition;
import com.intellij.debugger.engine.DebugProcessImpl;
import com.intellij.debugger.engine.evaluation.EvaluationContextImpl;
import com.intellij.debugger.engine.requests.RequestManagerImpl;
import com.intellij.debugger.impl.PositionUtil;
import com.intellij.debugger.jdi.VirtualMachineProxyImpl;
import com.intellij.debugger.requests.Requestor;
import com.intellij.debugger.ui.breakpoints.Breakpoint;
import com.intellij.debugger.ui.breakpoints.BreakpointCategory;
import com.intellij.debugger.ui.breakpoints.BreakpointWithHighlighter;
import com.intellij.debugger.ui.breakpoints.FieldBreakpoint;
import com.intellij.debugger.ui.breakpoints.FilteredRequestor;
import com.intellij.icons.AllIcons;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.xdebugger.XSourcePosition;
import com.intellij.xdebugger.breakpoints.XBreakpoint;
import com.sun.jdi.AbsentInformationException;
import com.sun.jdi.Field;
import com.sun.jdi.Location;
import com.sun.jdi.Method;
import com.sun.jdi.ReferenceType;
import com.sun.jdi.event.AccessWatchpointEvent;
import com.sun.jdi.event.LocatableEvent;
import com.sun.jdi.event.MethodEntryEvent;
import com.sun.jdi.event.MethodExitEvent;
import com.sun.jdi.event.ModificationWatchpointEvent;
import com.sun.jdi.request.BreakpointRequest;
import com.sun.jdi.request.EventRequest;
import com.sun.jdi.request.MethodEntryRequest;
import com.sun.jdi.request.WatchpointRequest;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import javax.swing.Icon;
import kotlin.CollectionsKt;
import kotlin.StringsKt;
import kotlin.TypeCastException;
import kotlin.inline;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.KotlinClass;
import kotlin.jvm.internal.Reflection;
import kotlin.reflect.KClass;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.descriptors.PropertyDescriptor;
import org.jetbrains.kotlin.descriptors.ValueParameterDescriptor;
import org.jetbrains.kotlin.idea.caches.resolve.ResolutionUtils;
import org.jetbrains.kotlin.idea.debugger.breakpoints.KotlinFieldBreakpoint$WhenMappings;
import org.jetbrains.kotlin.idea.debugger.breakpoints.KotlinPropertyBreakpointProperties;
import org.jetbrains.kotlin.idea.util.application.ApplicationUtilsKt;
import org.jetbrains.kotlin.load.java.JvmAbi;
import org.jetbrains.kotlin.load.kotlin.PackageClassUtils;
import org.jetbrains.kotlin.name.FqName;
import org.jetbrains.kotlin.psi.JetCallableDeclaration;
import org.jetbrains.kotlin.psi.JetClassOrObject;
import org.jetbrains.kotlin.psi.JetParameter;
import org.jetbrains.kotlin.psi.JetProperty;
import org.jetbrains.kotlin.resolve.BindingContext;

@KotlinClass(version={0, 25, 0}, abiVersion=25, data={"'\u0014))2j\u001c;mS:4\u0015.\u001a7e\u0005J,\u0017m\u001b9pS:$(bA8sO*I!.\u001a;ce\u0006Lgn\u001d\u0006\u0007W>$H.\u001b8\u000b\t%$W-\u0019\u0006\tI\u0016\u0014WoZ4fe*Y!M]3bWB|\u0017N\u001c;t\u0015e\u0011%/Z1la>Lg\u000e^,ji\"D\u0015n\u001a5mS\u001eDG/\u001a:\u000b\u0007\r|WN\u0003\u0005j]R,G\u000e\\5k\u0015\t)\u0018N\u0003\u0012L_Rd\u0017N\u001c)s_B,'\u000f^=Ce\u0016\f7\u000e]8j]R\u0004&o\u001c9feRLWm\u001d\u0006\u0007y%t\u0017\u000e\u001e \u000b\u000fA\u0014xN[3di*9\u0001K]8kK\u000e$(bB8qK:\f\u0007/\u001b\u0006\u000bEJ,\u0017m\u001b9pS:$(b\u0003-Ce\u0016\f7\u000e]8j]RT\u0011\u0002\u001f3fEV<w-\u001a:\u000b\u001d\t\u0014X-Y6q_&tG\u000fV=qK*q!I]3bWB|\u0017N\u001c;UsB,'\u0002J&pi2LgNR5fY\u0012\u0014%/Z1la>Lg\u000e\u001e\u0013Ce\u0016\f7\u000e]8j]R$\u0016\u0010]3\u000b+\r|W\u000e];uK\n\u0013X-Y6q_&tG\u000fV=qK*A\u0001O]8qKJ$\u0018P\u0003\fKKR\u001c\u0015\r\u001c7bE2,G)Z2mCJ\fG/[8o\u0015\r\u00018/\u001b\u0006\u0017GJ,\u0017\r^3NKRDw\u000e\u001a\"sK\u0006\\\u0007o\\5oi*aA-\u001a2vOB\u0013xnY3tg*\u0001B)\u001a2vOB\u0013xnY3tg&k\u0007\u000f\u001c\u0006\u0007K:<\u0017N\\3\u000b\u000fI,g\rV=qK*i!+\u001a4fe\u0016t7-\u001a+za\u0016T1a];o\u0015\rQG-\u001b\u0006\tC\u000e\u001cWm]:pe*1Q*\u001a;i_\u0012TA!\u00168ji*i2M]3bi\u0016\u0014V-];fgR4uN\u001d)sKB\f'/\u001a3DY\u0006\u001c8OC\tfm\u0006dW/\u0019;f\u0007>tG-\u001b;j_:TqaY8oi\u0016DHOC\u000bFm\u0006dW/\u0019;j_:\u001cuN\u001c;fqRLU\u000e\u001d7\u000b\u0015\u00154\u0018\r\\;bi&|gNC\u0003fm\u0016tGO\u0003\bM_\u000e\fG/\u00192mK\u00163XM\u001c;\u000b\u000f\t{w\u000e\\3b]*\tAK\u0003\u0007Fm\u0016tGOU3rk\u0016\u001cHOC\u0004sKF,Xm\u001d;\u000b\u0017\u0019Lg\u000e\u001a*fcV,7\u000f\u001e\u0006\re\u0016\fX/Z:u\u00072\f7o\u001d\u0006\u0006\u00072\f7o\u001d\u0006\u0005U\u00064\u0018M\u0003\u0003mC:<'\"\u0003:fcV,7\u000f^8s\u0015%\u0011V-];fgR|'O\u0003\u0005sKF,Xm\u001d;t\u0015-9W\r^\"bi\u0016<wN]=\u000b\u0007-+\u0017P\u0003\u0003vi&d'b\u0004$jK2$'I]3bWB|\u0017N\u001c;\u000b\u001f\u001d,G\u000fR5tC\ndW\rZ%d_:Tq![:NkR,GM\u0003\u0003JG>t'\"\u00026bm\u0006D(\"B:xS:<'BD4fi\u0012K7\u000f\u001d7bs:\u000bW.\u001a\u0006\u0007'R\u0014\u0018N\\4\u000b)\u001d,G/\u0012<bYV\fG/[8o\u000b2,W.\u001a8u\u0015)\u00016/[#mK6,g\u000e\u001e\u0006\u0010O\u0016$XI^3oi6+7o]1hK*Aq-\u001a;GS\u0016dGM\u0003\u0007hKR4\u0015.\u001a7e\u001d\u0006lWM\u0003\bhKRLeN^1mS\u0012L5m\u001c8\u000b\u001d\u001d,G/T3uQ>$7OT1nK*!A*[:u\u0015-9W\r\u001e)s_B,'\u000f^=\u000b\u001dM|WO]2f!>\u001c\u0018\u000e^5p]*q1k\\;sG\u0016\u0004vn]5uS>t'BC4fiN+G/S2p]*yq-\u001a;WKJLg-[3e\u0013\u000e|gNC\fhKR4VM]5gS\u0016$w+\u0019:oS:<7/S2p]*9\u0011n\u001d,bY&$'\u0002D7bi\u000eDWm]#wK:$(B\u0002:fY>\fGMC\u0004qg&4\u0015\u000e\\3\u000b\u000fA\u001b\u0018NR5mK*a1/\u001a;GS\u0016dGMT1nK*Ia-[3mI:\u000bW.\u001a\u0006\u000fg\u0016$x+\u0019;dQ\u0006\u001b7-Z:t\u0015\u00151\u0018\r\\;f\u0015Y\u0019X\r^,bi\u000eD\u0017J\\5uS\u0006d\u0017N_1uS>t'\u0002F:fi^\u000bGo\u00195N_\u0012Lg-[2bi&|gNC\u0005D_6\u0004\u0018M\\5p]* !B\u0001\t\u0002\u0015\u0011A\u0001\u0001\u0005\u0002\u000b\t!\t\u0001c\u0001\u0006\u0005\u0011\t\u0001BA\u0003\u0003\t\u0007A)!\u0002\u0002\u0005\u0005!\u0019Qa\u0001C\u0003\u0011\u0001a\u0001!B\u0001\t\t\u0015\u0011Aq\u0001E\u0005\u000b\t!A\u0001#\u0002\u0006\u0005\u0011%\u0001\"B\u0003\u0003\t\u0015A1!B\u0002\u0005\f!\u001dA\u0002A\u0003\u0004\t\u000bAY\u0001\u0004\u0001\u0006\u0005\u0011!\u0001rB\u0003\u0003\t\u001dAi!B\u0002\u0005\u0010!9A\u0002A\u0003\u0003\t\u0011A\u0011\"\u0002\u0002\u0005\u0012!\u0019Qa\u0001\u0003\n\u0011#a\u0001!\u0002\u0002\u0005\u0010!9QA\u0001\u0003\n\u0011#)1\u0001B\u0002\t\u00151\u0001QA\u0001C\u0003\u0011+)!\u0001B\u0001\t\u001a\u0015\u0019A\u0001\u0004\u0005\r\u0019\u0001)!\u0001\u0002\u0007\t\u0019\u0015\u0011A\u0011\u0002E\u000f\u000b\r!Y\u0002\u0003\b\r\u0001\u0015\u0011Aq\u0001\u0005\u0011\u000b\t!i\u0002#\t\u0006\u0007\u0011y\u0001r\u0004\u0007\u0001\u000b\r!q\u0002c\t\r\u0001\u0015\t\u00012A\u0003\u0004\tCA!\u0003\u0004\u0001\u0006\u0005\u0011m\u0001BD\u0003\u0003\t=Ay\"\u0002\u0002\u0005\u001f!\rRA\u0001C\u000e\u0011S)1\u0001B\n\t)1\u0001QA\u0001\u0003\u0010\u0011U)1\u0001\u0002\u000b\t,1\u0001Qa\u0001C\u0011\u0011Ya\u0001!\u0002\u0002\u0005'!!RA\u0001\u0003\u0015\u0011W)!\u0001B\b\t0\u0015\u0019AQ\u0006\u0005\u0018\u0019\u0001)\u0011\u0001c\r\u0006\u0005\u0011=\u0002BG\u0003\u0004\taA\u0011\u0004\u0004\u0001\u0006\u0005\u0011%\u0001rG\u0003\u0004\teA1\u0004\u0004\u0001\u0006\u0005\u00115\u0002bF\u0003\u0003\taA\u0011$\u0002\u0002\u00053!YRA\u0001\u0003\b\u0011u)1\u0001b\u000e\t:1\u0001Qa\u0001C\u0006\u0011wa\u0001!\u0002\u0002\u00058!eR!\u0001E \u000b\t!Y\u0004\u0003\u0011\u0006\u0007\u0011q\u0002b\b\u0007\u0001\u000b\t!a\u0004C\u0010\u0006\u0007\u0011\u0005\u0002\"\t\u0007\u0001\u000b\t!\u0001\u0004C\u0011\u0006\u0005\u0011!\u0001\u0012D\u0003\u0004\t\u0003B!\u0005\u0004\u0001\u0006\u0005\u0011\u0005\u0003BI\u0003\u0004\tCAQ\u0005\u0004\u0001\u0006\u0005\u0011=\u0002\"H\u0003\u0003\t\u000bBQ%B\u0002\u0005\n!5C\u0002A\u0003\u0003\t\u0013Ai%B\u0002\u0005B!UC\u0002A\u0003\u0003\t\u0003B)\u0006B\u0002\r\u0007Aq\u0013\u0004C\u0003\u0002\u0011\u0019IA!C\u0002\u0006\u0003!5\u0001T\u0002\r\u0007;\u0005Qa&\f\u0007\u0005\u00034A\u001a\"I\u0002\u0006\u0003!Y\u0001dC+\u0004\t\u0015\u0019A1C\u0005\u0002\u0011/iS\u0003B\u0001\u0019\u0017u=A\u0001\u0001E\f\u001b\r)\u0011\u0001#\u0007\u0019\u001aA\u001b\u0001!I\u0002\u0006\u0003!Y\u0001dC)\u0004\u000b\u0011Y\u0011\"\u0001E\f\u001b\u0005AQ\"\f\u0016\u0005\u0003aiQt\u0002\u0003\u0001\u00117i1!B\u0001\t\u001daq\u0001k\u0001\u0001\u001e\u0010\u0011\u0001\u0001bD\u0007\u0004\u000b\u0005Ay\u0002g\bQ\u0007\u0003iz\u0001\u0002\u0001\t#5\u0019Q!\u0001\u0005\u00111A\u00016!A\u0011\u0004\u000b\u0005A\u0011\u0003G\tR\u0007%!Q\"C\u0001\u0005\u00015\t\u00012E\u0007\u0002\u0011Ii\u0011\u0001#\n.D\u0011Q\u0001TEO\t\t\u0001AY\"\u0004\u0003\u0006\u0003!qA\u0012\u0001\r\u000f!\u000e\u0001Q\u0014\u0003\u0003\u0001\u0011=iA!B\u0001\t 1\u0005\u0001t\u0004)\u0004\u0002\u0005\u001aQ!\u0001\u0005\u00121E\t6a\u0002C\u0013\u0013\u0005!\u0001!D\u0001\t$5\t\u0001BEW \t-A2#h\u0004\u0005\u0001!\u001dRbA\u0003\u0002\u0011OA:\u0003U\u0002\u0001;\u001f!\u0001\u0001C\u000b\u000e\u0007\u0015\t\u0001\u0012\u0006M\u0015!\u000e\u0005\u0011eA\u0003\u0002\u0011UAR#U\u0002\b\tMI\u0011\u0001\"\u0001\u000e\u0003!-R\"\u0001\u0005\u0017[i\"9!E\u0004\u0005\u0001!5B\u0012A\u000b\u0004\u000b\u0005Aq\u0003G\f\u00191u=A\u0001\u0001E\u000e\u001b\r)\u0011\u0001\u0003\b\u0019\u001dA\u001b\u0001!h\u0007\u0005\u0001!ER\"C\u0003\u0002\u0011cIQ!\u0003\u0003\u0006\u0005\u0011\u0005\u0001\u0002\u0001\u000f\u00011c\u00016\u0011AO\b\t\u0001A)$D\u0002\u0006\u0003!M\u00024\u0007)\u0004\u0003\u0005*QA\u0001C\u0001\u0011\u0001a\t\u0001\b\u0001R\u0007%!\u0001$C\u0001\t55\t\u00012E\u0007\u0002\u0011ki\u0011\u0001C\u000e. \u0011Y\u0001\u0004H\u0011\t\u000b\u0005AA$\u0003\u0003\n\u0007\u0015\t\u0001\u0012\bM\u001d1q\t6a\u0001\u0003\u001d\u0013\u0005AQ$L\u000b\u0005\u0015aqRt\u0002\u0003\u0001\u0011{i1!B\u0001\t+a)\u0002k\u0001\u0001\"\u0007\u0015\t\u0001R\bM\u001f#\u000e)AAH\u0005\u0002\u0011}i\u0011\u0001\"\u0001.\u0018\u0011Y\u0001\u0014I\u0011\u0005\u000b\u0005Ay\u0004$\u0001\u0019@E\u001b1\u0001\"\u0011\n\u0003!\u0001Sv\u0003\u0003\f1\u0007\nC!B\u0001\tC1\u0005\u0001$I)\u0004\u0007\u0011\r\u0013\"\u0001E\"[U!1\u0002'\u0012\u001e\u0010\u0011\u0001\u0001\"F\u0007\u0004\u000b\u0005AI\u0003'\u000bQ\u0007\u0001\t3!B\u0001\t@a}\u0012kA\u0003\u0005F%\t\u0001\u0002I\u0007\u0002\u0011Yi;\u0002B\u0002\u0019G\u0005\"Q!\u0001E\r\u0019\u0003AJ\"U\u0002\u0004\t\rJ\u0011\u0001C\u0007.\u0016\u0011\t\u0001tI\u0011\u0004\u000b\u0005Ay\u0004g\u0010R\u0007\r!9%C\u0001\tA5*BA\u0003\r%;\u001f!\u0001\u0001#\u0010\u000e\u0007\u0015\t\u0001\"\u0006\r\u0016!\u000e\u0001\u0011eA\u0003\u0002\u0011{Aj$U\u0002\u0006\t\u0011J\u0011\u0001C\u0010\u000e\u0003\u0011\u0005Qv\u0004\u0003\u00021\u0013\n\u0003\"B\u0001\tE%!\u0011bA\u0003\u0002\u0011\u007fAz\u0004\u0007\u0012R\u0007\r!I%C\u0001\tG5:B!\u0001M&;#!\u0001\u0001\u0003\u0014\u000e\t\u0015\t\u0001r\tG\u00011\u000f\u00026\u0001A\u0011\u0005\u000b\u0005AI\u0002$\u0001\u0019\u001aE\u001bQ\u0001b\u0013\n\u0003!iQ\"\u0001\u0005%[U!!\u0002G\u0014\u001e\u0010\u0011\u0001\u0001RH\u0007\u0004\u000b\u0005AQ\u0003G\u000bQ\u0007\u0001\t3!B\u0001\t>au\u0012kA\u0003\u0005O%\t\u0001bH\u0007\u0002\t\u0003iS\u0003\u0002\u0006\u0019Pu=A\u0001\u0001E\u001f\u001b\r)\u0011\u0001C\u000b\u0019+A\u001b\u0001!I\u0002\u0006\u0003!u\u0002TH)\u0004\u000b\u0011=\u0013\"\u0001\u0005 \u001b\u0005!\t!L\u000b\u0005\u0015aASt\u0002\u0003\u0001\u0011{i1!B\u0001\t+a)\u0002k\u0001\u0001\"\u0007\u0015\t\u0001R\bM\u001f#\u000e)A\u0001K\u0005\u0002\u0011}i\u0011\u0001\"\u0001.\u0016\u0011Y\u0001\u0014K\u0011\u0004\u000b\u0005AQ\u0003G\u000bR\u0007\r!\t&C\u0001\u0005\u00025*Ba\u0001\r*;\u001f!\u0001\u0001C\u000b\u000e\u0007\u0015\t\u0001\u0012\u0006M\u0015!\u000e\u0001\u0011eA\u0003\u0002\u0011UAR#U\u0002\u0006\t%J\u0011\u0001\"\u0001\u000e\u0003!1RF\u0006\u0003\u000b1'j\n\u0002\u0002\u0001\tU5!Q!\u0001E%\u0019\u0003AJ\u0005U\u0002\u0001C\r)\u0011\u0001C\t\u0019#E\u001bQ\u0001b\u0015\n\u0003\u0011\u0001Q\"\u0001\u0005&[U!1\u0001G\u0016\u001e\u0010\u0011\u0001\u0001rK\u0007\u0004\u000b\u0005Ay\u0004g\u0010Q\u0007\u0001\t3!B\u0001\t#a\t\u0012kA\u0003\u0005W%\tA\u0001A\u0007\u0002\u0011\u0001jS\u0003b\u0002\u0019Yu=A\u0001\u0001E-\u001b\r)\u0011\u0001C\u000b\u0019+A\u001b\u0001!I\u0002\u0006\u0003!\t\u0002$E)\u0004\u000b\u0011a\u0013\"\u0001\u0003\u0001\u001b\u0005!\t!L\u000b\u0005\baiSt\u0002\u0003\u0001\u00113j1!B\u0001\t+a)\u0002k\u0001\u0001\"\u0007\u0015\t\u0001\"\u0005\r\u0012#\u000e)A!L\u0005\u0002\t\u0001i\u0011\u0001\"\u0001.+\u0011\u001d\u00014LO\b\t\u0001AI&D\u0002\u0006\u0003!)\u0002$\u0006)\u0004\u0001\u0005\u001aQ!\u0001\u0005\u00121E\t6!\u0002C.\u0013\u0005!\u0001!D\u0001\u0005\u0002U2S!\n\u0003d\u0002a1Qt\u0002\u0003\u0001\u0011\u001bi1!B\u0001\t\u0011aA\u0001k\u0001\u0001\u001e\u001a\u0011\u0001\u0001\u0002C\u0007\t\u000b\u0005A\u0019\"\u0003\u0003\n\u0007\u0015\t\u0001R\u0002M\u00071'\u00016\u0011A\u0011\u0004\u000b\u0005A1\u0001G\u0002R\u0007\u001d!a!C\u0001\u0005\u00015\t\u0001BC\u0007\u0002\u0011+\u0001"})
public final class KotlinFieldBreakpoint
extends BreakpointWithHighlighter<KotlinPropertyBreakpointProperties> {
    public static final /* synthetic */ KClass $kotlinClass;
    private static final Logger LOG;
    private static final Key<FieldBreakpoint> CATEGORY;
    private BreakpointType breakpointType;
    public static final Companion Companion;

    static {
        $kotlinClass = Reflection.createKotlinClass(KotlinFieldBreakpoint.class);
        Companion companion = Companion = new Companion(null);
        LOG = Logger.getInstance((String)"#org.jetbrains.kotlin.idea.debugger.breakpoints.KotlinFieldBreakpoint");
        Key key = BreakpointCategory.lookup((String)"field_breakpoints");
        Intrinsics.checkExpressionValueIsNotNull((Object)key, (String)"BreakpointCategory.looku\u2026int>(\"field_breakpoints\")");
        CATEGORY = key;
    }

    public boolean isValid() {
        if (!BreakpointWithHighlighter.isPositionValid((XSourcePosition)this.getXBreakpoint().getSourcePosition())) {
            return false;
        }
        return (Boolean)ApplicationUtilsKt.runReadAction((Function0)new Function0<Boolean>(this){
            final /* synthetic */ KotlinFieldBreakpoint this$0;

            public final boolean invoke() {
                JetCallableDeclaration field2 = this.this$0.getField();
                return field2 != null && field2.isValid();
            }
            {
                this.this$0 = kotlinFieldBreakpoint;
                super(0);
            }
        });
    }

    @Nullable
    public final JetCallableDeclaration getField() {
        SourcePosition sourcePosition2 = this.getSourcePosition();
        return this.getProperty(sourcePosition2);
    }

    private final JetCallableDeclaration getProperty(SourcePosition sourcePosition2) {
        JetProperty property2 = (JetProperty)PositionUtil.getPsiElementAt((Project)this.getProject(), JetProperty.class, (SourcePosition)sourcePosition2);
        if (property2 != null) {
            return property2;
        }
        JetParameter parameter = (JetParameter)PositionUtil.getPsiElementAt((Project)this.getProject(), JetParameter.class, (SourcePosition)sourcePosition2);
        if (parameter != null) {
            return parameter;
        }
        return null;
    }

    protected void reload(@Nullable PsiFile psiFile) {
        JetCallableDeclaration property2 = this.getProperty(this.getSourcePosition());
        if (property2 != null) {
            String string = property2.getName();
            if (string == null) {
                Intrinsics.throwNpe();
            }
            Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"property.getName()!!");
            this.setFieldName(string);
            if (property2 instanceof JetProperty && ((JetProperty)property2).isTopLevel()) {
                KotlinPropertyBreakpointProperties kotlinPropertyBreakpointProperties = (KotlinPropertyBreakpointProperties)this.getProperties();
                String string2 = PackageClassUtils.getPackageClassFqName(((JetProperty)property2).getContainingJetFile().getPackageFqName()).asString();
                Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"PackageClassUtils.getPac\u2026ckageFqName()).asString()");
                kotlinPropertyBreakpointProperties.setMyClassName(string2);
            } else {
                FqName fqName2;
                JetClassOrObject jetClass = (JetClassOrObject)PsiTreeUtil.getParentOfType((PsiElement)property2, JetClassOrObject.class);
                if (jetClass instanceof JetClassOrObject && (fqName2 = jetClass.getFqName()) != null) {
                    KotlinPropertyBreakpointProperties kotlinPropertyBreakpointProperties = (KotlinPropertyBreakpointProperties)this.getProperties();
                    String string3 = fqName2.asString();
                    Intrinsics.checkExpressionValueIsNotNull((Object)string3, (String)"fqName.asString()");
                    kotlinPropertyBreakpointProperties.setMyClassName(string3);
                }
            }
            this.setInstanceFiltersEnabled(false);
        }
    }

    /*
     * WARNING - void declaration
     */
    protected void createRequestForPreparedClass(@Nullable DebugProcessImpl debugProcess, @Nullable ReferenceType refType) {
        if (debugProcess == null || refType == null) {
            return;
        }
        JetCallableDeclaration jetCallableDeclaration = this.getProperty(this.getSourcePosition());
        if (jetCallableDeclaration == null) {
            return;
        }
        JetCallableDeclaration property2 = jetCallableDeclaration;
        this.breakpointType = this.computeBreakpointType(property2);
        VirtualMachineProxyImpl vm = debugProcess.getVirtualMachineProxy();
        try {
            SourcePosition sourcePosition2;
            if (((KotlinPropertyBreakpointProperties)this.getProperties()).getWATCH_INITIALIZATION() && (sourcePosition2 = this.getSourcePosition()) != null) {
                void destination;
                Iterator $receiver;
                Iterable $receiver2;
                Iterable iterable = debugProcess.getPositionManager().locationsOfLine(refType, sourcePosition2);
                void var7_8 = $receiver2;
                Collection collection = new ArrayList();
                Iterator iterator2 = $receiver.iterator();
                while (iterator2.hasNext()) {
                    Object element2 = iterator2.next();
                    Location it = (Location)element2;
                    if (!(it.method().isConstructor() || it.method().isStaticInitializer())) continue;
                    destination.add(element2);
                }
                $receiver2 = (List)destination;
                for (Object element3 : $receiver2) {
                    Location it = (Location)element3;
                    BreakpointRequest request = debugProcess.getRequestsManager().createBreakpointRequest((FilteredRequestor)this, it);
                    debugProcess.getRequestsManager().enableRequest((EventRequest)request);
                    if (KotlinFieldBreakpoint.Companion.getLOG().isDebugEnabled()) {
                        KotlinFieldBreakpoint.Companion.getLOG().debug("Breakpoint request added");
                    }
                }
            }
            switch (KotlinFieldBreakpoint$WhenMappings.$EnumSwitchMapping$0[this.breakpointType.ordinal()]) {
                case 1: {
                    Field field2 = refType.fieldByName(this.getFieldName());
                    if (field2 != null) {
                        WatchpointRequest request;
                        RequestManagerImpl manager = debugProcess.getRequestsManager();
                        if (((KotlinPropertyBreakpointProperties)this.getProperties()).getWATCH_MODIFICATION() && vm.canWatchFieldModification()) {
                            request = manager.createModificationWatchpointRequest((FilteredRequestor)this, field2);
                            debugProcess.getRequestsManager().enableRequest((EventRequest)request);
                            if (KotlinFieldBreakpoint.Companion.getLOG().isDebugEnabled()) {
                                KotlinFieldBreakpoint.Companion.getLOG().debug("Modification request added");
                            }
                        }
                        if (((KotlinPropertyBreakpointProperties)this.getProperties()).getWATCH_ACCESS() && vm.canWatchFieldAccess()) {
                            request = manager.createAccessWatchpointRequest((FilteredRequestor)this, field2);
                            debugProcess.getRequestsManager().enableRequest((EventRequest)request);
                            if (KotlinFieldBreakpoint.Companion.getLOG().isDebugEnabled()) {
                                KotlinFieldBreakpoint.Companion.getLOG().debug("Field access request added (field = " + field2.name() + "; refType = " + refType.name() + ")");
                            }
                        }
                    }
                    break;
                }
                case 2: {
                    Method setter;
                    Method getter;
                    String fieldName = this.getFieldName();
                    if (((KotlinPropertyBreakpointProperties)this.getProperties()).getWATCH_ACCESS() && (getter = (Method)CollectionsKt.firstOrNull(refType.methodsByName(JvmAbi.getterName(fieldName)))) != null) {
                        this.createMethodBreakpoint(debugProcess, refType, getter);
                    }
                    if (!((KotlinPropertyBreakpointProperties)this.getProperties()).getWATCH_MODIFICATION() || (setter = (Method)CollectionsKt.firstOrNull(refType.methodsByName(JvmAbi.setterName(fieldName)))) == null) break;
                    this.createMethodBreakpoint(debugProcess, refType, setter);
                }
            }
        }
        catch (Exception ex) {
            KotlinFieldBreakpoint.Companion.getLOG().debug((Throwable)ex);
        }
    }

    private final BreakpointType computeBreakpointType(JetCallableDeclaration property2) {
        return (BreakpointType)((Object)ApplicationUtilsKt.runReadAction((Function0)new Function0<BreakpointType>(property2){
            final /* synthetic */ JetCallableDeclaration $property;

            @NotNull
            public final BreakpointType invoke() {
                BindingContext bindingContext2 = ResolutionUtils.analyze$default(this.$property, null, 1);
                DeclarationDescriptor descriptor2 = bindingContext2.get(BindingContext.DECLARATION_TO_DESCRIPTOR, this.$property);
                if (descriptor2 instanceof ValueParameterDescriptor) {
                    descriptor2 = (DeclarationDescriptor)bindingContext2.get(BindingContext.VALUE_PARAMETER_AS_PROPERTY, descriptor2);
                }
                DeclarationDescriptor declarationDescriptor = descriptor2;
                if (declarationDescriptor == null) {
                    throw new TypeCastException("null cannot be cast to non-null type org.jetbrains.kotlin.descriptors.PropertyDescriptor");
                }
                V v = bindingContext2.get(BindingContext.BACKING_FIELD_REQUIRED, (PropertyDescriptor)declarationDescriptor);
                if (v == null) {
                    Intrinsics.throwNpe();
                }
                return (Boolean)v != false ? BreakpointType.FIELD : BreakpointType.METHOD;
            }
            {
                this.$property = jetCallableDeclaration;
                super(0);
            }
        }));
    }

    /*
     * WARNING - void declaration
     */
    private final void createMethodBreakpoint(DebugProcessImpl debugProcess, ReferenceType refType, Method accessor) {
        RequestManagerImpl manager = debugProcess.getRequestsManager();
        Location line = (Location)CollectionsKt.firstOrNull(accessor.allLineLocations());
        if (line != null) {
            BreakpointRequest request = manager.createBreakpointRequest((FilteredRequestor)this, line);
            debugProcess.getRequestsManager().enableRequest((EventRequest)request);
            if (KotlinFieldBreakpoint.Companion.getLOG().isDebugEnabled()) {
                KotlinFieldBreakpoint.Companion.getLOG().debug("Breakpoint request added");
            }
        } else {
            EventRequest eventRequest;
            block9: {
                void requestor;
                KotlinFieldBreakpoint kotlinFieldBreakpoint = this;
                Class<MethodEntryRequest> clazz = MethodEntryRequest.class;
                Requestor requestor2 = (Requestor)this;
                Set requests = debugProcess.getRequestsManager().findRequests((Requestor)requestor);
                for (EventRequest eventRequest2 : requests) {
                    void requestClass;
                    if (!Intrinsics.areEqual(eventRequest2.getClass(), (Object)requestClass)) continue;
                    EventRequest eventRequest3 = eventRequest2;
                    if (eventRequest3 == null) {
                        throw new TypeCastException("null cannot be cast to non-null type T");
                    }
                    eventRequest = (MethodEntryRequest)eventRequest3;
                    break block9;
                }
                eventRequest = null;
            }
            MethodEntryRequest entryRequest = (MethodEntryRequest)eventRequest;
            if (entryRequest == null) {
                MethodEntryRequest methodEntryRequest = manager.createMethodEntryRequest((FilteredRequestor)this);
                if (methodEntryRequest == null) {
                    Intrinsics.throwNpe();
                }
                entryRequest = methodEntryRequest;
                if (KotlinFieldBreakpoint.Companion.getLOG().isDebugEnabled()) {
                    KotlinFieldBreakpoint.Companion.getLOG().debug("Method entry request added (method = " + accessor.name() + "; refType = " + refType.name() + ")");
                }
            } else {
                entryRequest.disable();
            }
            entryRequest.addClassFilter(refType);
            manager.enableRequest((EventRequest)entryRequest);
        }
    }

    @inline
    @Nullable
    public final <T extends EventRequest> T findRequest(@NotNull DebugProcessImpl debugProcess, @NotNull Class<T> requestClass, @NotNull Requestor requestor) {
        Intrinsics.checkParameterIsNotNull((Object)debugProcess, (String)"debugProcess");
        Intrinsics.checkParameterIsNotNull(requestClass, (String)"requestClass");
        Intrinsics.checkParameterIsNotNull((Object)requestor, (String)"requestor");
        Set requests = debugProcess.getRequestsManager().findRequests(requestor);
        for (EventRequest eventRequest : requests) {
            if (!Intrinsics.areEqual(eventRequest.getClass(), requestClass)) continue;
            EventRequest eventRequest2 = eventRequest;
            if (eventRequest2 == null) {
                throw new TypeCastException("null cannot be cast to non-null type T");
            }
            Intrinsics.reifyCheckcast((String)"T");
            return (T)eventRequest2;
        }
        return (T)((EventRequest)null);
    }

    public boolean evaluateCondition(@NotNull EvaluationContextImpl context, @NotNull LocatableEvent event) {
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        Intrinsics.checkParameterIsNotNull((Object)event, (String)"event");
        if (Intrinsics.areEqual((Object)((Object)this.breakpointType), (Object)((Object)BreakpointType.METHOD)) && !this.matchesEvent(event)) {
            return false;
        }
        return super.evaluateCondition(context, event);
    }

    public final boolean matchesEvent(@NotNull LocatableEvent event) {
        Intrinsics.checkParameterIsNotNull((Object)event, (String)"event");
        Method method = event.location().method();
        return method != null && this.getMethodsName().contains(method.name());
    }

    private final List<String> getMethodsName() {
        String fieldName = this.getFieldName();
        return CollectionsKt.listOf((Object[])new String[]{JvmAbi.getterName(fieldName), JvmAbi.setterName(fieldName)});
    }

    @NotNull
    public String getEventMessage(@NotNull LocatableEvent event) {
        String string;
        Intrinsics.checkParameterIsNotNull((Object)event, (String)"event");
        Location location2 = event.location();
        String locationQName = location2.declaringType().name() + "." + location2.method().name();
        try {
            string = location2.sourceName();
        }
        catch (AbsentInformationException e) {
            string = this.getFileName();
        }
        String locationFileName = string;
        int locationLine = location2.lineNumber();
        LocatableEvent locatableEvent = event;
        if (locatableEvent instanceof ModificationWatchpointEvent) {
            Field field2 = ((ModificationWatchpointEvent)event).field();
            String string2 = DebuggerBundle.message((String)"status.static.field.watchpoint.reached.access", (Object[])new Object[]{field2.declaringType().name(), field2.name(), locationQName, locationFileName, locationLine});
            Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"DebuggerBundle.message(\n\u2026            locationLine)");
            return string2;
        }
        if (locatableEvent instanceof AccessWatchpointEvent) {
            Field field3 = ((AccessWatchpointEvent)event).field();
            String string3 = DebuggerBundle.message((String)"status.static.field.watchpoint.reached.access", (Object[])new Object[]{field3.declaringType().name(), field3.name(), locationQName, locationFileName, locationLine});
            Intrinsics.checkExpressionValueIsNotNull((Object)string3, (String)"DebuggerBundle.message(\n\u2026            locationLine)");
            return string3;
        }
        if (locatableEvent instanceof MethodEntryEvent) {
            Method method = ((MethodEntryEvent)event).method();
            String string4 = DebuggerBundle.message((String)"status.method.entry.breakpoint.reached", (Object[])new Object[]{method.declaringType().name() + "." + method.name() + "()", locationQName, locationFileName, locationLine});
            Intrinsics.checkExpressionValueIsNotNull((Object)string4, (String)"DebuggerBundle.message(\n\u2026            locationLine)");
            return string4;
        }
        if (locatableEvent instanceof MethodExitEvent) {
            Method method = ((MethodExitEvent)event).method();
            String string5 = DebuggerBundle.message((String)"status.method.exit.breakpoint.reached", (Object[])new Object[]{method.declaringType().name() + "." + method.name() + "()", locationQName, locationFileName, locationLine});
            Intrinsics.checkExpressionValueIsNotNull((Object)string5, (String)"DebuggerBundle.message(\n\u2026            locationLine)");
            return string5;
        }
        String string6 = DebuggerBundle.message((String)"status.line.breakpoint.reached", (Object[])new Object[]{locationQName, locationFileName, locationLine});
        Intrinsics.checkExpressionValueIsNotNull((Object)string6, (String)"DebuggerBundle.message(\n\u2026            locationLine)");
        return string6;
    }

    public final void setFieldName(@NotNull String fieldName) {
        Intrinsics.checkParameterIsNotNull((Object)fieldName, (String)"fieldName");
        ((KotlinPropertyBreakpointProperties)this.getProperties()).setMyFieldName(fieldName);
    }

    public final void setWatchAccess(boolean value2) {
        ((KotlinPropertyBreakpointProperties)this.getProperties()).setWATCH_ACCESS(value2);
    }

    public final void setWatchModification(boolean value2) {
        ((KotlinPropertyBreakpointProperties)this.getProperties()).setWATCH_MODIFICATION(value2);
    }

    public final void setWatchInitialization(boolean value2) {
        ((KotlinPropertyBreakpointProperties)this.getProperties()).setWATCH_INITIALIZATION(value2);
    }

    @NotNull
    protected Icon getDisabledIcon(boolean isMuted) {
        Icon icon;
        Breakpoint master = DebuggerManagerEx.getInstanceEx((Project)((Breakpoint)this).myProject).getBreakpointManager().findMasterBreakpoint((Breakpoint)this);
        if (isMuted && master == null) {
            Icon icon2 = AllIcons.Debugger.Db_muted_disabled_field_breakpoint;
            icon = icon2;
            Intrinsics.checkExpressionValueIsNotNull((Object)icon2, (String)"AllIcons.Debugger.Db_mut\u2026disabled_field_breakpoint");
        } else if (isMuted && master != null) {
            Icon icon3 = AllIcons.Debugger.Db_muted_dep_field_breakpoint;
            icon = icon3;
            Intrinsics.checkExpressionValueIsNotNull((Object)icon3, (String)"AllIcons.Debugger.Db_muted_dep_field_breakpoint");
        } else if (master != null) {
            Icon icon4 = AllIcons.Debugger.Db_dep_field_breakpoint;
            icon = icon4;
            Intrinsics.checkExpressionValueIsNotNull((Object)icon4, (String)"AllIcons.Debugger.Db_dep_field_breakpoint");
        } else {
            Icon icon5 = AllIcons.Debugger.Db_disabled_field_breakpoint;
            icon = icon5;
            Intrinsics.checkExpressionValueIsNotNull((Object)icon5, (String)"AllIcons.Debugger.Db_disabled_field_breakpoint");
        }
        Intrinsics.checkExpressionValueIsNotNull((Object)icon, (String)"when {\n            isMut\u2026ield_breakpoint\n        }");
        return icon;
    }

    @NotNull
    protected Icon getSetIcon(boolean isMuted) {
        Icon icon;
        if (isMuted) {
            Icon icon2 = AllIcons.Debugger.Db_muted_field_breakpoint;
            icon = icon2;
            Intrinsics.checkExpressionValueIsNotNull((Object)icon2, (String)"AllIcons.Debugger.Db_muted_field_breakpoint");
        } else {
            Icon icon3 = AllIcons.Debugger.Db_field_breakpoint;
            icon = icon3;
            Intrinsics.checkExpressionValueIsNotNull((Object)icon3, (String)"AllIcons.Debugger.Db_field_breakpoint");
        }
        Intrinsics.checkExpressionValueIsNotNull((Object)icon, (String)"when {\n            isMut\u2026ield_breakpoint\n        }");
        return icon;
    }

    @NotNull
    protected Icon getInvalidIcon(boolean isMuted) {
        Icon icon;
        if (isMuted) {
            Icon icon2 = AllIcons.Debugger.Db_muted_invalid_field_breakpoint;
            icon = icon2;
            Intrinsics.checkExpressionValueIsNotNull((Object)icon2, (String)"AllIcons.Debugger.Db_mut\u2026_invalid_field_breakpoint");
        } else {
            Icon icon3 = AllIcons.Debugger.Db_invalid_field_breakpoint;
            icon = icon3;
            Intrinsics.checkExpressionValueIsNotNull((Object)icon3, (String)"AllIcons.Debugger.Db_invalid_field_breakpoint");
        }
        Intrinsics.checkExpressionValueIsNotNull((Object)icon, (String)"when {\n            isMut\u2026ield_breakpoint\n        }");
        return icon;
    }

    @NotNull
    protected Icon getVerifiedIcon(boolean isMuted) {
        Icon icon;
        if (isMuted) {
            Icon icon2 = AllIcons.Debugger.Db_muted_verified_field_breakpoint;
            icon = icon2;
            Intrinsics.checkExpressionValueIsNotNull((Object)icon2, (String)"AllIcons.Debugger.Db_mut\u2026verified_field_breakpoint");
        } else {
            Icon icon3 = AllIcons.Debugger.Db_verified_field_breakpoint;
            icon = icon3;
            Intrinsics.checkExpressionValueIsNotNull((Object)icon3, (String)"AllIcons.Debugger.Db_verified_field_breakpoint");
        }
        Intrinsics.checkExpressionValueIsNotNull((Object)icon, (String)"when {\n            isMut\u2026ield_breakpoint\n        }");
        return icon;
    }

    @NotNull
    protected Icon getVerifiedWarningsIcon(boolean isMuted) {
        Icon icon;
        if (isMuted) {
            Icon icon2 = AllIcons.Debugger.Db_muted_field_warning_breakpoint;
            icon = icon2;
            Intrinsics.checkExpressionValueIsNotNull((Object)icon2, (String)"AllIcons.Debugger.Db_mut\u2026_field_warning_breakpoint");
        } else {
            Icon icon3 = AllIcons.Debugger.Db_field_warning_breakpoint;
            icon = icon3;
            Intrinsics.checkExpressionValueIsNotNull((Object)icon3, (String)"AllIcons.Debugger.Db_field_warning_breakpoint");
        }
        Intrinsics.checkExpressionValueIsNotNull((Object)icon, (String)"when {\n            isMut\u2026ning_breakpoint\n        }");
        return icon;
    }

    @NotNull
    public Key<FieldBreakpoint> getCategory() {
        return KotlinFieldBreakpoint.Companion.getCATEGORY();
    }

    @Nullable
    public String getDisplayName() {
        if (!this.isValid()) {
            return DebuggerBundle.message((String)"status.breakpoint.invalid", (Object[])new Object[0]);
        }
        String className = this.getClassName();
        return className != null && !StringsKt.isEmpty((String)className) ? className + "." + this.getFieldName() : this.getFieldName();
    }

    private final String getFieldName() {
        JetCallableDeclaration declaration = this.getField();
        String string = (String)ApplicationUtilsKt.runReadAction((Function0)new Function0<String>(declaration){
            final /* synthetic */ JetCallableDeclaration $declaration;

            @Nullable
            public final String invoke() {
                JetCallableDeclaration jetCallableDeclaration = this.$declaration;
                return jetCallableDeclaration != null ? jetCallableDeclaration.getName() : null;
            }
            {
                this.$declaration = jetCallableDeclaration;
                super(0);
            }
        });
        if (string == null) {
            string = "unknown";
        }
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"runReadAction { declarat\u2026.getName() } ?: \"unknown\"");
        return string;
    }

    @Nullable
    public PsiElement getEvaluationElement() {
        return this.getField();
    }

    public KotlinFieldBreakpoint(@NotNull Project project, @NotNull XBreakpoint<KotlinPropertyBreakpointProperties> breakpoint) {
        Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
        Intrinsics.checkParameterIsNotNull(breakpoint, (String)"breakpoint");
        super(project, breakpoint);
        this.breakpointType = BreakpointType.FIELD;
    }

    @KotlinClass(version={0, 25, 0}, abiVersion=25, data={"f\u0004)I1i\\7qC:LwN\u001c\u0006\u0016\u0017>$H.\u001b8GS\u0016dGM\u0011:fC.\u0004x.\u001b8u\u0015\ry'o\u001a\u0006\nU\u0016$(M]1j]NTaa[8uY&t'\u0002B5eK\u0006T\u0001\u0002Z3ck\u001e<WM\u001d\u0006\fEJ,\u0017m\u001b9pS:$8OC\u0002B]fT\u0001bQ!U\u000b\u001e{%+\u0017\u0006\u0004\u0017\u0016L(bA2p[*A\u0011N\u001c;fY2L'NC\u0004pa\u0016t\u0017\r]5\u000b\tU$\u0018\u000e\u001c\u0006\u0010\r&,G\u000e\u001a\"sK\u0006\\\u0007o\\5oi*\u0011Q/\u001b\u0006\fO\u0016$8)\u0011+F\u000f>\u0013\u0016LC\u0002M\u001f\u001eSa\u0001T8hO\u0016\u0014(B\u00033jC\u001etwn\u001d;jG*92n\u001c;mS:t#N^7/!2\fGOZ8s[RK\b/\u001a\u0006\u0007O\u0016$HjT$\u0011\u0004)\u0011\u0001C\u0001\u0006\u0005\u0011\u0001\u00012A\u0003\u0003\t\u0003A!!\u0002\u0002\u0005\u0003!\u0015QA\u0001C\u0002\u0011\r)!\u0001\u0002\u0002\t\b\u0015\u0019AQ\u0001E\u0001\u0019\u0001)1\u0001B\u0002\t\u00011\u0001Q!\u0001\u0005\u0003\u000b\r!A\u0001\u0003\u0003\r\u0001\u0015\t\u00012B\u0003\u0003\t\u0015Aa!\u0002\u0002\u0005\f!5QA\u0001\u0003\u0007\u0011\u001d)1\u0001\"\u0004\t\u000b1\u0001QA\u0001C\u0006\u0011\r)!\u0001b\u0004\t\u0011\u0015\u0011A\u0001\u0003E\u0004\u000b\r!\t\u0002c\u0004\r\u0001\u0015\u0011AQ\u0002\u0005\u0006\u000b\t!a\u0001\u0003\u0006\u0006\u0007\u0011Q\u00012\u0003\u0007\u0001\u000b\t!!\u0002c\u0005\u0005\u0007\ba9!G\u0002\u0006\u0003!%\u0001\u0014B\u0017\u0017\t\u0005$\u0001\u0014B\u0011\t\u000b\u0005Aq!\u0003\u0003\n\u0007\u0015\t\u0001\"\u0003\r\n1\u001d)6!C\u0003\u0005\t\u0013I\u0011\u0001c\u0005\r\u00025\u0019A\u0011C\u0005\u0002\u0011'is\u0003B1\u00051%\t\u0013\"B\u0001\t\u0016AUQ\u0003B\u0003\u0002\u0011+a\t\u0001'\u0006\u0019\u0016U\u001b\u0011\"\u0002\u0003\u0005\u0013%\t\u0001b\u0003G\u0001\u001b\r!1\"C\u0001\t\u0017U\u0002\u0001"})
    public static final class Companion {
        public static final /* synthetic */ KClass $kotlinClass;

        static {
            $kotlinClass = Reflection.createKotlinClass(Companion.class);
        }

        private final Logger getLOG() {
            return LOG;
        }

        private final Key<FieldBreakpoint> getCATEGORY() {
            return CATEGORY;
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @KotlinClass(version={0, 25, 0}, abiVersion=25, data={"\u000e\u0004)q!I]3bWB|\u0017N\u001c;UsB,'\"F&pi2LgNR5fY\u0012\u0014%/Z1la>Lg\u000e\u001e\u0006\u0004_J<'\"\u00036fi\n\u0014\u0018-\u001b8t\u0015\u0019Yw\u000e\u001e7j]*!\u0011\u000eZ3b\u0015!!WMY;hO\u0016\u0014(b\u00032sK\u0006\\\u0007o\\5oiNTA!\u00128v[*1A(\u001b8jizRAA[1wC*!A.\u00198h\u0015\u0019\u0019FO]5oO*)a)S#M\t*1Q*\u0012+I\u001f\u0012s%B\u0001\t\u0003\u0015\u0011A\u0001\u0001E\u0002\u000b\t!\t\u0001\u0003\u0002\u0006\u0005\u0011\t\u0001RA\u0003\u0003\t\u0007A1!\u0002\u0002\u0005\u0005!\u001dQa\u0001C\u0003\u0011\u0003a\u0001!B\u0002\u0005\u0007!\u0001A\u0002A\u0003\u0002\u0011\t)1\u0001\u0002\u0003\t\t1\u0001Q!\u0001\u0005\u0006\u000b\t!Q\u0001c\u0003\u0006\u0005\u0011-\u0001B\u0002\u0003B\u00021\u001d\u0011\u0004C\u0003\u0002\u0011\u0013IA!C\u0002\u0006\u0003!\u001d\u0001t\u0001M\u0005c\u00055q!\u000e\t\u0006\u001f\u0011\t\u000f\u0001'\u0003\"\u0007\u0015\t\u0001r\u0001M\u0004#\u000e9A\u0011B\u0005\u0002\t\u0001i\u0011\u0001\u0003\u0004\u000e\u0003\u0011\u0015\u0001"})
    private static final class BreakpointType
    extends Enum<BreakpointType> {
        public static final /* synthetic */ KClass $kotlinClass;
        public static final /* enum */ BreakpointType FIELD;
        public static final /* enum */ BreakpointType METHOD;
        private static final /* synthetic */ BreakpointType[] $VALUES;

        static {
            $kotlinClass = Reflection.createKotlinClass(BreakpointType.class);
            BreakpointType[] breakpointTypeArray = new BreakpointType[2];
            BreakpointType[] breakpointTypeArray2 = breakpointTypeArray;
            breakpointTypeArray[0] = FIELD = new BreakpointType();
            breakpointTypeArray[1] = METHOD = new BreakpointType();
            $VALUES = breakpointTypeArray;
        }

        public static BreakpointType[] values() {
            return (BreakpointType[])$VALUES.clone();
        }

        public static BreakpointType valueOf(String string) {
            return Enum.valueOf(BreakpointType.class, string);
        }
    }
}

