/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.debugger.evaluate;

import com.intellij.debugger.engine.evaluation.EvaluateExceptionUtil;
import com.intellij.debugger.engine.evaluation.EvaluationContextImpl;
import com.intellij.debugger.jdi.StackFrameProxyImpl;
import com.intellij.openapi.project.Project;
import com.sun.jdi.ClassType;
import com.sun.jdi.Field;
import com.sun.jdi.InterfaceType;
import com.sun.jdi.InvalidStackFrameException;
import com.sun.jdi.LocalVariable;
import com.sun.jdi.Mirror;
import com.sun.jdi.ObjectReference;
import com.sun.jdi.ReferenceType;
import com.sun.jdi.StackFrame;
import com.sun.jdi.VirtualMachine;
import kotlin.StringsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.KotlinClass;
import kotlin.jvm.internal.Reflection;
import kotlin.reflect.KClass;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.eval4j.ObjectValue;
import org.jetbrains.eval4j.Value;
import org.jetbrains.eval4j.ValuesKt;
import org.jetbrains.eval4j.jdi.JdiValuesKt;
import org.jetbrains.kotlin.codegen.AsmUtil;
import org.jetbrains.kotlin.codegen.inline.InlineCodegenUtil;
import org.jetbrains.kotlin.descriptors.ClassDescriptor;
import org.jetbrains.kotlin.idea.debugger.evaluate.KotlinEvaluationBuilderKt;
import org.jetbrains.kotlin.idea.util.application.ApplicationUtilsKt;
import org.jetbrains.kotlin.resolve.DescriptorUtils;
import org.jetbrains.kotlin.resolve.jvm.AsmTypes;
import org.jetbrains.org.objectweb.asm.Type;

@KotlinClass(version={0, 25, 0}, abiVersion=25, data={"\u0001\f)aaI]1nKZK7/\u001b;pe*\u0019qN]4\u000b\u0013),GO\u0019:bS:\u001c(BB6pi2LgN\u0003\u0003jI\u0016\f'\u0002\u00033fEV<w-\u001a:\u000b\u0011\u00154\u0018\r\\;bi\u0016T1!\u00118z\u0015\u0019a\u0014N\\5u})91m\u001c8uKb$(\"F#wC2,\u0018\r^5p]\u000e{g\u000e^3yi&k\u0007\u000f\u001c\u0006\u0004G>l'\u0002C5oi\u0016dG.\u001b6\u000b\r\u0015tw-\u001b8f\u0015))g/\u00197vCRLwN\u001c\u0006\u0006MJ\fW.\u001a\u0006\u000b'R\f7m\u001b$sC6,'bA:v]*\u0019!\u000eZ5\u000b\u000fA\u0014xN[3di*9\u0001K]8kK\u000e$(bB8qK:\f\u0007/\u001b\u0006\u0018W>$H.\u001b8/UZlg\u0006\u00157bi\u001a|'/\u001c+za\u0016TAAZ1jY*9Q.Z:tC\u001e,'BB*ue&twM\u0003\u0006tQ>,H\u000e\u001a$bS2TqAQ8pY\u0016\fgNC\u0003WC2,XM\u0003\u0004fm\u0006dGG\u001b\u0006\u0005U\u00064\u0018M\u0003\u0003mC:<'\"\u00074j]\u0012\u001c\u0015\r\u001d;ve\u0016$Gj\\2bYZ\u000b'/[1cY\u0016TAA\\1nK*9\u0011m]7UsB,'\u0002\u0002+za\u0016T\u0011b\u001c2kK\u000e$x/\u001a2\u000b\u0007\u0005\u001cXNC\u0005dQ\u0016\u001c7\u000eV=qK*\tb-\u001b8e\u0019>\u001c\u0017\r\u001c,be&\f'\r\\3\u000b9\u0019Lg\u000e\u001a'pG\u0006dg+\u0019:jC\ndWMR8s\u0019>\u001c\u0017\r\u001c$v]*Aa-\u001b8e)\"L7OC\u0005gS:$g+\u00197vK*qa-Y5m\u0013\u001atu\u000e\u001e$pk:$'\u0002F4fi\u000e\u000b\u0007\u000f^;sK\u00124\u0015.\u001a7e\u001d\u0006lWM\u0003\u0005hKR4\u0015.\u001a7e\u0015\u0015ywO\\3s\u0015M9W\r\u001e,bYV,\u0017JZ*iCJ,GMV1s\u0015\u00151\u0018\r\\;f\u00151)\u0007\u0010]3di\u0016$G+\u001f9f\u00159I7OR;oGRLwN\u001c+za\u0016TA\u0001^=qK*!\u0012n\u001d,bYV,wJZ\"peJ,7\r\u001e+za\u0016Tqb\u001d5pk2$7\t[3dWRK\b/\u001a\u0006\fSN\u001c\u0006.\u0019:fIZ\u000b'O\u0003\u0006jgN+(m\u00197bgNTab];qKJ\u001cE.Y:t\u001d\u0006lWM~\u0001\u000b\u0005A\t!\u0002\u0002\u0005\u0001!\tQA\u0001C\u0001\u0011\u0007)!\u0001B\u0001\t\u0005\u0015\u0011A1\u0001E\u0003\u000b\t!!\u0001C\u0002\u0006\u0007\u0011\u0015\u0001\u0002\u0001\u0007\u0001\u000b\u0005A\u0019!B\u0002\u0005\b!\u001dA\u0002A\u0003\u0002\u0011\u0017)!\u0001\"\u0003\t\r\u0015\u0011A!\u0002E\u0003\u000b\t!Y\u0001#\u0004\u0006\u0005\u00111\u0001bB\u0003\u0004\t\u001bAQ\u0001\u0004\u0001\u0006\u0005\u00115\u0001\"B\u0003\u0003\t\u0013A\t\"\u0002\u0002\u0005\u0011!IQa\u0001C\t\u0011!a\u0001!\u0002\u0002\u0005\u0012!AQA\u0001\u0003\u0006\u0011+)!\u0001\u0002\u0006\t\u0014\u0015\u0019AQ\u0003\u0005\u000b\u0019\u0001)!\u0001\"\u0006\t\u0015\u0015\u0019Aq\u0001E\r\u0019\u0001)1\u0001b\u0002\t\u001c1\u0001QA\u0001C\u0001\u0011;)1\u0001B\u0007\t\u001d1\u0001QA\u0001\u0003\u000e\u00119)\u0011\u0001C\b\u0006\u0005\u0011u\u0001rD\u0003\u0003\t=AI\"\u0002\u0002\u0005\u0002!\u0005QA\u0001\u0003\u0011\u0011I)!\u0001\"\t\t&\u0015\u0019A!\u0005E\u0012\u0019\u0001)!\u0001B\t\t$\u0015\u0019A\u0011\u0003E\u0012\u0019\u0001)!\u0001\"\u0005\t$\u0011\u0019AbA\r\u0004\u000b\u0005AA\u0001\u0007\u0003.\u001b\u0011\tG\u0001g\u0004\"\t\u0015\t\u0001\"\u0003G\u00011%)6\u0001B\u0003\u0004\t\u001fI\u0011\u0001c\u0005.%\u0011\tG\u0001g\u0005\"\u0013\u0015\t\u0001b\u0003\t\f+\u0011)\u0011\u0001C\u0006\r\u0002aY\u0001dC+\u0004\t\u0015\u0019A1C\u0005\u0002\u0011/i\u000b\u0005B\u0001\u0019\u0018u=A\u0001\u0001\u0005\r\u001b\r)\u0011\u0001\u0003\u0007\u0019\u0019A\u001b\u0001!h\u0004\u0005\u0001!iQbA\u0003\u0002\u00113AJ\u0002UB\u0001C\u0011)\u0011\u0001c\u0007\r\u0002am\u0011kA\u0004\u0005\u0018%\t\u0001BD\u0007\u0002\u0011?i\u0011\u0001\"\u0001.Y\u0011\t\u0001\u0004EO\b\t\u0001A\t#D\u0002\u0006\u0003!a\u0001\u0004\u0004)\u0004\u0001uEA\u0001\u0001\u0005\u0012\u001b\u0011)\u0011\u0001c\t\r\u0002a\r\u0002k!\u0001\u001e\u0010\u0011\u0001\u0001bE\u0007\u0004\u000b\u0005AI\u0002'\u0007Q\u0007\u0005\tC!B\u0001\t\u001c1\u0005\u00014D)\u0004\u0013\u0011\u0001\u0012\"\u0001\u0005\u000f\u001b\u0005Ay\"D\u0001\t%5\tA\u0011A\u0017-\t\u0005A:#h\u0004\u0005\u0001!\u0005RbA\u0003\u0002\u00111AB\u0002U\u0002\u0001;#!\u0001\u0001C\t\u000e\t\u0015\t\u00012\u0005G\u00011G\u00016\u0011AO\b\t\u0001A1#D\u0002\u0006\u0003!e\u0001\u0014\u0004)\u0004\u0003\u0005\"Q!\u0001E\u000e\u0019\u0003AZ\"U\u0002\n\tOI\u0011\u0001\u0003\b\u000e\u0003!}Q\"\u0001\u0005\u0013\u001b\u0005!\t!\f\u0017\u0005\u0003a!Rt\u0002\u0003\u0001\u0011Ci1!B\u0001\t\u0019aa\u0001k\u0001\u0001\u001e\u0012\u0011\u0001\u0001\"E\u0007\u0005\u000b\u0005A\u0019\u0003$\u0001\u0019$A\u001b\t!h\u0004\u0005\u0001!\u0019RbA\u0003\u0002\u00113AJ\u0002U\u0002\u0002C\u0011)\u0011\u0001c\u0007\r\u0002am\u0011kA\u0005\u0005)%\t\u0001BD\u0007\u0002\u0011?i\u0011\u0001\u0003\n\u000e\u0003\u0011\u0005Qf\u0006\u0003\u00021Si\n\u0002\u0002\u0001\t#5!Q!\u0001E\u0012\u0019\u0003A\u001a\u0003U\u0002\u0001C\u0011)\u0011\u0001c\u0007\r\u0002am\u0011kA\u0003\u0005*%\t\u0001BD\u0007\u0002\u0011Iik\u0007B\u0002\u0019+u=A\u0001\u0001E\u0011\u001b\r)\u0011\u0001\u0003\u0007\u0019\u0019A\u001b\u0001!(\u0005\u0005\u0001!\tR\u0002B\u0003\u0002\u0011Ga\t\u0001g\tQ\u0007\u0003iz\u0001\u0002\u0001\t'5\u0019Q!\u0001E\r13\u00016!AO\b\t\u0001AY#D\u0002\u0006\u0003!e\u0001\u0014\u0004)\u0004\u0004\u0005\"Q!\u0001E\u000e\u0019\u0003AZ\"U\u0002\f\tUI\u0011\u0001\u0003\b\u000e\u0003!}Q\"\u0001\u0005\u0013\u001b\u0005!\t!D\u0001\u0005\u00025*B!\u0001\r\u0017;\u001f!\u0001\u0001#\t\u000e\u0007\u0015\t\u0001\u0002\u0004\r\r!\u000e\u0001\u0011eA\u0003\u0002\u00111AB\"U\u0002\u0006\tYI\u0011\u0001c\b\u000e\u0003!}QV\u000e\u0003\u00021[iz\u0001\u0002\u0001\t/5\u0019Q!\u0001E\u000e17\u00016\u0001AO\b\t\u0001A\t#D\u0002\u0006\u0003!a\u0001\u0004\u0004)\u0004\u0002uEA\u0001\u0001\u0005\u0012\u001b\u0011)\u0011\u0001c\t\r\u0002a\r\u0002kA\u0001\u001e\u0010\u0011\u0001\u0001bE\u0007\u0004\u000b\u0005AI\u0002'\u0007Q\u0007\u0007\tC!B\u0001\t\u001c1\u0005\u00014D)\u0004\u0017\u00115\u0012\"\u0001\u0005\u000f\u001b\u0005Aa\"D\u0001\t 5\t\u0001BE\u0007\u0002\t\u0003iC\u0006B\u0001\u00190u=A\u0001\u0001\u0005\u0019\u001b\r)\u0011\u0001c\u0007\u0019\u001cA\u001b\u0001!(\u0005\u0005\u0001!ER\u0002B\u0003\u0002\u0011Ga\t\u0001g\tQ\u0007\u0003iz\u0001\u0002\u0001\t'5\u0019Q!\u0001E\r13\u00016!A\u0011\u0005\u000b\u0005AY\u0002$\u0001\u0019\u001cE\u001b\u0011\u0002b\f\n\u0003!qQ\"\u0001\u0005\u000f\u001b\u0005A!#D\u0001\u0005\u000252B!\u0001\r\u001a;#!\u0001\u0001c\r\u000e\t\u0015\t\u00012\u0005G\u00011G\u00016\u0001A\u0011\u0004\u000b\u0005AI\u0002'\u0007R\u0007\u0015!\u0011$C\u0001\u0005\u00025\t\u0001BE\u0017,\t\u0005A\"$h\u0004\u0005\u0001!ARbA\u0003\u0002\u00117AZ\u0002U\u0002\u0001;#!\u0001\u0001C\t\u000e\t\u0015\t\u00012\u0005G\u00011G\u00016\u0011AO\b\t\u0001A)$D\u0002\u0006\u0003!e\u0001\u0014\u0004)\u0004\u0003\u0005\u001aQ!\u0001E\r13\t6!\u0003\u0003\u001b\u0013\u0005!\t!D\u0001\t\u001d5\t\u0001BE\u0007\u0002\t\u0003i\u000b\u0003B\u0001\u0016\u0007\u0015\t\u00012\u0004M\u000e1m\t3!B\u0001\t\u001aae\u0011kA\u0003\u00057%\tA\u0011A\u0007\u0002\u00119iC\u0004B\u0001\u0016\t\u0015\t\u0001R\u0005G\u00011KA:$h\u0004\u0005\u0001!aRbA\u0003\u0002\u00111AB\u0002UB\u0001C\r)\u0011\u0001#\u0007\u0019\u001aE\u001bq\u0001b\u000e\n\u0003\u0011\u0005Q\"\u0001\u0005\u0014\u001b\u0005Ay\".\f\u0006,\u0011\u0019\u000f\u0001\u0007\u0003\u001e\u0010\u0011\u0001\u0001\u0012B\u0007\u0004\u000b\u0005Aq\u0001G\u0004Q\u0007\u0001\t3!B\u0001\t\u0007a\u0019\u0011kA\u0003\u0005\t%\tA\u0001A\u0007\u0002\u0011\u001f\u0001"})
public final class FrameVisitor {
    public static final /* synthetic */ KClass $kotlinClass;
    private final Project project;
    private final StackFrame frame;

    static {
        $kotlinClass = Reflection.createKotlinClass(FrameVisitor.class);
    }

    @Nullable
    public final Value findValue(@NotNull String name2, @Nullable Type asmType, boolean checkType2, boolean failIfNotFound) {
        Intrinsics.checkParameterIsNotNull((Object)name2, (String)"name");
        if (this.frame == null) {
            return null;
        }
        try {
            String string = name2;
            if (Intrinsics.areEqual((Object)string, (Object)KotlinEvaluationBuilderKt.getTHIS_NAME())) {
                Value thisValue = this.findThis(asmType);
                if (thisValue != null) {
                    return thisValue;
                }
            } else {
                Value localVariable;
                Value value2 = localVariable = this.isFunctionType(asmType) ? this.findLocalVariableForLocalFun(name2, asmType, checkType2) : this.findLocalVariable(name2, asmType, checkType2);
                if (localVariable != null) {
                    return localVariable;
                }
                String capturedValName = this.getCapturedFieldName(name2);
                Value capturedVal = this.findCapturedLocalVariable(capturedValName, asmType, checkType2);
                if (capturedVal != null) {
                    return capturedVal;
                }
            }
            return this.fail("Cannot find local variable: name = " + name2 + (checkType2 ? ", type = " + String.valueOf(asmType) : ""), failIfNotFound);
        }
        catch (InvalidStackFrameException e) {
            Throwable throwable = EvaluateExceptionUtil.createEvaluateException((String)("Local variable " + name2 + " is unavailable in current frame"));
            Intrinsics.checkExpressionValueIsNotNull((Object)throwable, (String)"EvaluateExceptionUtil.cr\u2026ilable in current frame\")");
            throw throwable;
        }
    }

    private final Value fail(String message, boolean shouldFail) {
        if (shouldFail) {
            Throwable throwable = EvaluateExceptionUtil.createEvaluateException((String)message);
            Intrinsics.checkExpressionValueIsNotNull((Object)throwable, (String)"EvaluateExceptionUtil.cr\u2026valuateException(message)");
            throw throwable;
        }
        return null;
    }

    private final Value findThis(Type asmType) {
        ObjectValue eval4jValue;
        ObjectReference thisObject;
        StackFrame stackFrame = this.frame;
        if (stackFrame == null) {
            Intrinsics.throwNpe();
        }
        if ((thisObject = stackFrame.thisObject()) != null && this.isValueOfCorrectType(eval4jValue = JdiValuesKt.asValue(thisObject), asmType, true)) {
            return eval4jValue;
        }
        Value receiver = this.findValue(KotlinEvaluationBuilderKt.getRECEIVER_NAME(), asmType, true, false);
        if (receiver != null) {
            return receiver;
        }
        Value this0 = this.findValue(AsmUtil.CAPTURED_THIS_FIELD, asmType, true, false);
        if (this0 != null) {
            return this0;
        }
        Value $this = this.findValue("$this", asmType, false, false);
        if ($this != null) {
            return $this;
        }
        return null;
    }

    private final Value findLocalVariableForLocalFun(String name2, Type asmType, boolean checkType2) {
        return this.findLocalVariable(name2 + "$", asmType, checkType2);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final boolean isFunctionType(Type type2) {
        Type type3 = type2;
        if (!Intrinsics.areEqual((Object)(type3 != null ? Integer.valueOf(type3.getSort()) : null), (Object)Type.OBJECT)) return false;
        Type type4 = type2;
        if (type4 == null) {
            Intrinsics.throwNpe();
        }
        if (!StringsKt.startsWith$default((String)type4.getInternalName(), (String)InlineCodegenUtil.NUMBERED_FUNCTION_PREFIX, (boolean)false, (int)2)) return false;
        return true;
    }

    private final Value findLocalVariable(String name2, Type asmType, boolean checkType2) {
        LocalVariable localVariable;
        StackFrame stackFrame = this.frame;
        if (stackFrame == null) {
            Intrinsics.throwNpe();
        }
        if ((localVariable = stackFrame.visibleVariableByName(name2)) == null) {
            return null;
        }
        Value eval4jValue = JdiValuesKt.asValue(this.frame.getValue(localVariable));
        Value sharedVarValue = this.getValueIfSharedVar(eval4jValue, asmType, checkType2);
        if (sharedVarValue != null) {
            return sharedVarValue;
        }
        if (this.isValueOfCorrectType(eval4jValue, asmType, checkType2)) {
            return eval4jValue;
        }
        return null;
    }

    private final Value findCapturedLocalVariable(String name2, Type asmType, boolean checkType2) {
        Mirror mirror = this.frame;
        if (mirror == null || (mirror = mirror.thisObject()) == null) {
            return null;
        }
        Mirror thisObject = mirror;
        Value thisObj = JdiValuesKt.asValue((ObjectReference)thisObject);
        Value capturedVal = null;
        while (capturedVal == null && thisObj != null) {
            capturedVal = this.getField(thisObj, name2, asmType, checkType2);
            if (capturedVal != null) continue;
            thisObj = this.getField(thisObj, AsmUtil.CAPTURED_THIS_FIELD, null, false);
        }
        if (capturedVal != null) {
            Value sharedVarValue = this.getValueIfSharedVar(capturedVal, asmType, checkType2);
            if (sharedVarValue != null) {
                return sharedVarValue;
            }
            return capturedVal;
        }
        return null;
    }

    private final boolean isValueOfCorrectType(Value value2, Type asmType, boolean shouldCheckType) {
        if (!shouldCheckType || asmType == null || Intrinsics.areEqual((Object)value2.getAsmType(), (Object)asmType)) {
            return true;
        }
        if (this.project == null) {
            return false;
        }
        Object object = ValuesKt.obj$default(value2, null, 1);
        if (!(object instanceof ObjectReference)) {
            object = null;
        }
        ObjectReference objectReference = (ObjectReference)object;
        com.sun.jdi.Type type2 = objectReference != null ? objectReference.referenceType() : null;
        String string = asmType.getClassName();
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"asmType.getClassName()");
        if (this.isSubclass(type2, string)) {
            return true;
        }
        ClassDescriptor thisDesc = KotlinEvaluationBuilderKt.getClassDescriptor(value2.getAsmType(), this.project);
        ClassDescriptor expDesc = KotlinEvaluationBuilderKt.getClassDescriptor(asmType, this.project);
        return thisDesc != null && expDesc != null && (Boolean)ApplicationUtilsKt.runReadAction((Function0)new Function0<Boolean>(thisDesc, expDesc){
            final /* synthetic */ ClassDescriptor $thisDesc;
            final /* synthetic */ ClassDescriptor $expDesc;

            public final boolean invoke() {
                return DescriptorUtils.isSubclass(this.$thisDesc, this.$expDesc);
            }
            {
                this.$thisDesc = classDescriptor;
                this.$expDesc = classDescriptor2;
                super(0);
            }
        }) != false;
    }

    private final Value getField(Value owner, String name2, Type asmType, boolean checkType2) {
        try {
            StackFrame stackFrame = this.frame;
            if (stackFrame == null) {
                Intrinsics.throwNpe();
            }
            VirtualMachine virtualMachine = stackFrame.virtualMachine();
            Intrinsics.checkExpressionValueIsNotNull((Object)virtualMachine, (String)"frame!!.virtualMachine()");
            com.sun.jdi.Value obj = JdiValuesKt.asJdiValue(owner, virtualMachine, owner.getAsmType());
            if (!(obj instanceof ObjectReference)) {
                return null;
            }
            ReferenceType _class = ((ObjectReference)obj).referenceType();
            Field field2 = _class.fieldByName(name2);
            if (field2 == null) {
                return null;
            }
            Value fieldValue = JdiValuesKt.asValue(((ObjectReference)obj).getValue(field2));
            if (this.isValueOfCorrectType(fieldValue, asmType, checkType2)) {
                return fieldValue;
            }
            return null;
        }
        catch (Exception e) {
            return null;
        }
    }

    private final boolean isSharedVar(Value $receiver) {
        return $receiver.getAsmType().getSort() == Type.OBJECT && StringsKt.startsWith$default((String)$receiver.getAsmType().getInternalName(), (String)AsmTypes.REF_TYPE_PREFIX, (boolean)false, (int)2);
    }

    private final Value getValueIfSharedVar(Value value2, Type expectedType, boolean checkType2) {
        if (!this.isSharedVar(value2)) {
            return null;
        }
        Value sharedVarValue = this.getField(value2, "element", expectedType, checkType2);
        if (sharedVarValue != null && this.isValueOfCorrectType(sharedVarValue, expectedType, checkType2)) {
            return sharedVarValue;
        }
        return null;
    }

    private final String getCapturedFieldName(String name2) {
        String string = name2;
        return Intrinsics.areEqual((Object)string, (Object)KotlinEvaluationBuilderKt.getRECEIVER_NAME()) ? AsmUtil.CAPTURED_RECEIVER_FIELD : (Intrinsics.areEqual((Object)string, (Object)KotlinEvaluationBuilderKt.getTHIS_NAME()) ? AsmUtil.CAPTURED_THIS_FIELD : (Intrinsics.areEqual((Object)string, (Object)AsmUtil.CAPTURED_RECEIVER_FIELD) ? name2 : (Intrinsics.areEqual((Object)string, (Object)AsmUtil.CAPTURED_THIS_FIELD) ? name2 : "$" + name2)));
    }

    private final boolean isSubclass(com.sun.jdi.Type $receiver, String superClassName) {
        boolean bl;
        block4: {
            if (!($receiver instanceof ClassType)) {
                return false;
            }
            Iterable $receiver2 = ((ClassType)$receiver).allInterfaces();
            for (Object element2 : $receiver2) {
                InterfaceType it = (InterfaceType)element2;
                if (!Intrinsics.areEqual((Object)it.name(), (Object)superClassName)) continue;
                bl = true;
                break block4;
            }
            bl = false;
        }
        if (bl) {
            return true;
        }
        for (ClassType superClass = ((ClassType)$receiver).superclass(); superClass != null; superClass = superClass.superclass()) {
            if (!Intrinsics.areEqual((Object)superClass.name(), (Object)superClassName)) continue;
            return true;
        }
        return false;
    }

    public FrameVisitor(@NotNull EvaluationContextImpl context) {
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        this.project = context.getDebugProcess().getProject();
        StackFrameProxyImpl stackFrameProxyImpl = context.getFrameProxy();
        this.frame = stackFrameProxyImpl != null ? stackFrameProxyImpl.getStackFrame() : null;
    }
}

