/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.decompiler.navigation;

import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import kotlin.StringsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.KotlinClass;
import kotlin.jvm.internal.Reflection;
import kotlin.reflect.KClass;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.name.ClassId;
import org.jetbrains.kotlin.name.FqName;
import org.jetbrains.kotlin.serialization.js.KotlinJavascriptSerializedResourcePathsKt;

@KotlinClass(version={0, 25, 0}, abiVersion=25, data={"<\u0006)y!j]'fi\u00064\u0015\u000e\\3Vi&d7OC\u0002pe\u001eT\u0011B[3uEJ\f\u0017N\\:\u000b\r-|G\u000f\\5o\u0015\u0011IG-Z1\u000b\u0015\u0011,7m\\7qS2,'O\u0003\u0006oCZLw-\u0019;j_:T1!\u00118z\u001599W\r^\"mCN\u001ch)\u001d(b[\u0016TAAZ5mK*Ya+\u001b:uk\u0006dg)\u001b7f\u0015\r\u0019w.\u001c\u0006\tS:$X\r\u001c7jU*9q\u000e]3oCBL'b\u0001<gg*1a)\u001d(b[\u0016TAA\\1nK*9!/\u001a7QCRD'BB*ue&twM\u0003\u0003kCZ\f'\u0002\u00027b]\u001eT!bZ3u\u00072\f7o]%e\u0015\u001d\u0019E.Y:t\u0013\u0012T!cZ3u\u001b>$W\u000f\\3ESJ,7\r^8ss*iq-\u001a;N_\u0012,H.\u001a(b[\u0016T\u0001cZ3u!\u0006\u001c7.Y4f\rFt\u0015-\\3\u000b+\u001d,GOU3mCRLg/\u001a+p%>|G\u000fU1uQ*9q-\u001a;S_>$(bD5t!\u0006\u001c7.Y4f\u0011\u0016\fG-\u001a:\u000b\u000f\t{w\u000e\\3b]r\r!B\u0001\t\u0002\u0015\u0011A\u0001\u0001\u0005\u0002\u000b\t!\t\u0001c\u0001\u0006\u0005\u0011\t\u0001BA\u0003\u0003\t\u0007A)!\u0002\u0002\u0005\u0005!\u0019Qa\u0001C\u0003\u0011\u0001a\u0001!B\u0001\t\u0004\u0015\u0019Aq\u0001E\u0004\u0019\u0001)\u0011\u0001c\u0003\u0006\u0005\u0011%\u0001BB\u0003\u0003\t\u0015Ai!\u0002\u0002\u0005\f!9Qa\u0001\u0003\u0007\u0011\u0015a\u0001!\u0002\u0002\u0005\u0003!AQa\u0001\u0003\b\u0011\u001fa\u0001!\u0002\u0002\u0005\u000f!=QA\u0001\u0003\u0007\u0011\u0015)1\u0001b\u0002\t\u00131\u0001Q!\u0001E\n\u000b\t!\u0019\u0002\u0003\u0006\u0006\u0005\u0011Q\u0001\"C\u0003\u0004\t\u001dA1\u0002\u0004\u0001\u0006\u0005\u00119\u0001bC\u0003\u0004\t\u000fAi\u0002\u0004\u0001\u0005G\u0006a1!G\u0002\u0006\u0003!!\u0001\u0004B\u0017\u0016\t\rAB!h\u0004\u0005\u0001!%QbA\u0003\u0002\u0011\u001bAj\u0001U\u0002\u0001C\r)\u0011\u0001c\u0004\u0019\u0010E\u001bQ\u0001\u0002\u0003\n\u0003!AQ\"\u0001E\t[U!\u0011\u0001\u0007\u0003\u001e\u0010\u0011\u0001\u0001\u0012C\u0007\u0004\u000b\u0005A\u0011\u0002G\u0005Q\u0007\u0001\t3!B\u0001\t\u0010a=\u0011kA\u0003\u0005\t%\t\u0001\u0002C\u0007\u0002\u0011+iS\u0003B\u0002\u0019\u0016u=A\u0001\u0001E\u0005\u001b\r)\u0011\u0001#\u0004\u0019\u000eA\u001b\u0001!I\u0002\u0006\u0003!Y\u0001dC)\u0004\u000b\u0011U\u0011\"\u0001E\f\u001b\u0005A\t\"L\u000b\u0005\u0003aUQt\u0002\u0003\u0001\u0011#i1!B\u0001\t\u0013aI\u0001k\u0001\u0001\"\u0007\u0015\t\u0001b\u0003\r\f#\u000e)AQC\u0005\u0002\u0011/i\u0011\u0001#\u0006.+\u0011\u0019\u0001tCO\b\t\u0001AI!D\u0002\u0006\u0003!5\u0001T\u0002)\u0004\u0001\u0005\u001aQ!\u0001E\u00071\u001b\t6!\u0002C\f\u0013\u0005A\t\"D\u0001\t\u00125*B!\u0001\r\r;\u001f!\u0001\u0001#\u0005\u000e\u0007\u0015\t\u0001\"\u0003\r\n!\u000e\u0001\u0011eA\u0003\u0002\u0011%A\u0012\"U\u0002\u0006\t1I\u0011\u0001#\u0006\u000e\u0003!UQ&\u0006\u0003\u000413iz\u0001\u0002\u0001\t\n5\u0019Q!\u0001E\u00071\u001b\u00016\u0001A\u0011\u0004\u000b\u0005Ay\u0001g\u0004R\u0007\u0015!I\"C\u0001\t\u00115\t\u0001\u0012C\u0017\u0016\t\u0005AJ\"h\u0004\u0005\u0001!EQbA\u0003\u0002\u0011%A\u0012\u0002U\u0002\u0001C\r)\u0011\u0001c\u0004\u0019\u0010E\u001bQ\u0001\"\u0007\n\u0003!AQ\"\u0001E\u000b[U!\u0011\u0001G\u0007\u001e\u0010\u0011\u0001\u0001\u0012B\u0007\u0004\u000b\u0005Ai\u0001'\u0004Q\u0007\u0001\t3!B\u0001\t\u0013aI\u0011kA\u0003\u0005\u001b%\t\u0001RC\u0007\u0002\u0011#iS\u0003B\u0001\u0019\u001cu=A\u0001\u0001E\u0005\u001b\r)\u0011\u0001#\u0004\u0019\u000eA\u001b\u0001!I\u0002\u0006\u0003!5\u0001TB)\u0004\u000b\u0011m\u0011\"\u0001E\t\u001b\u0005A\t\"L\u000b\u0005\u0007aqQt\u0002\u0003\u0001\u0011\u0013i1!B\u0001\t\u000ea5\u0001k\u0001\u0001\"\u0007\u0015\t\u0001\u0002\u0004\r\r#\u000e)AAD\u0005\u0002\t\u0003i\u0011\u0001#\u0005.+\u0011\t\u0001DDO\b\t\u0001A\t\"D\u0002\u0006\u0003!I\u0001$\u0003)\u0004\u0001\u0005\u001aQ!\u0001\u0005\r11\t6!\u0002\u0003\u000f\u0013\u0005!\t!D\u0001\t\u0016U\u0002\u0001"})
public final class JsMetaFileUtils {
    public static final /* synthetic */ KClass $kotlinClass;
    public static final JsMetaFileUtils INSTANCE$;

    static {
        $kotlinClass = Reflection.createKotlinClass(JsMetaFileUtils.class);
        new JsMetaFileUtils();
    }

    @NotNull
    public final FqName getPackageFqName(@NotNull VirtualFile file) {
        Intrinsics.checkParameterIsNotNull((Object)file, (String)"file");
        return this.getPackageFqName(this.getRelativeToRootPath(file));
    }

    @NotNull
    public final FqName getClassFqName(@NotNull VirtualFile file) {
        Intrinsics.checkParameterIsNotNull((Object)file, (String)"file");
        return this.getClassFqName(this.getRelativeToRootPath(file));
    }

    @NotNull
    public final ClassId getClassId(@NotNull VirtualFile file) {
        Intrinsics.checkParameterIsNotNull((Object)file, (String)"file");
        return this.getClassId(this.getRelativeToRootPath(file));
    }

    public final boolean isPackageHeader(@NotNull VirtualFile file) {
        Intrinsics.checkParameterIsNotNull((Object)file, (String)"file");
        return this.isPackageHeader(this.getRelativeToRootPath(file));
    }

    @NotNull
    public final VirtualFile getModuleDirectory(@NotNull VirtualFile file) {
        Intrinsics.checkParameterIsNotNull((Object)file, (String)"file");
        VirtualFile virtualFile = this.getRoot(file).findChild(this.getModuleName(this.getRelativeToRootPath(file)));
        if (virtualFile == null) {
            Intrinsics.throwNpe();
        }
        return virtualFile;
    }

    private final String getRelativeToRootPath(VirtualFile file) {
        String string = VfsUtilCore.getRelativePath((VirtualFile)file, (VirtualFile)this.getRoot(file));
        if (string == null) {
            Intrinsics.throwNpe();
        }
        return string;
    }

    private final FqName getClassFqName(String relPath) {
        String pathToFile = StringsKt.substringAfter$default((String)relPath, (char)VfsUtilCore.VFS_SEPARATOR_CHAR, null, (int)2);
        return new FqName(StringsKt.replace$default((String)StringsKt.substringBeforeLast$default((String)pathToFile, (char)'.', null, (int)2), (char)VfsUtilCore.VFS_SEPARATOR_CHAR, (char)'.', (boolean)false, (int)4));
    }

    private final ClassId getClassId(String relPath) {
        FqName classFqName = this.getClassFqName(relPath);
        FqName packageFqName = this.getPackageFqName(relPath);
        String name2 = StringsKt.substringBeforeLast$default((String)classFqName.shortName().asString(), (char)'.', null, (int)2);
        return new ClassId(packageFqName, new FqName(name2), false);
    }

    private final FqName getPackageFqName(String relPath) {
        String pathToFile = StringsKt.substringAfter$default((String)relPath, (char)VfsUtilCore.VFS_SEPARATOR_CHAR, null, (int)2);
        if (KotlinJavascriptSerializedResourcePathsKt.isDefaultPackageMetafile(pathToFile)) {
            FqName fqName2 = FqName.ROOT;
            Intrinsics.checkExpressionValueIsNotNull((Object)fqName2, (String)"FqName.ROOT");
            return fqName2;
        }
        String name2 = StringsKt.substringBeforeLast$default((String)pathToFile, (char)VfsUtilCore.VFS_SEPARATOR_CHAR, null, (int)2);
        return new FqName(StringsKt.replace$default((String)name2, (char)VfsUtilCore.VFS_SEPARATOR_CHAR, (char)'.', (boolean)false, (int)4));
    }

    private final String getModuleName(String relPath) {
        return StringsKt.substringBefore$default((String)relPath, (char)VfsUtilCore.VFS_SEPARATOR_CHAR, null, (int)2);
    }

    private final boolean isPackageHeader(String relPath) {
        FqName classFqName = INSTANCE$.getClassFqName(relPath);
        return KotlinJavascriptSerializedResourcePathsKt.isPackageClassFqName(classFqName);
    }

    private final VirtualFile getRoot(VirtualFile file) {
        VirtualFile virtualFile;
        if (file.getParent() == null) {
            virtualFile = file;
        } else {
            VirtualFile virtualFile2 = file.getParent();
            Intrinsics.checkExpressionValueIsNotNull((Object)virtualFile2, (String)"file.getParent()");
            virtualFile = this.getRoot(virtualFile2);
        }
        return virtualFile;
    }

    JsMetaFileUtils() {
        INSTANCE$ = this;
    }
}

