/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.decompiler.stubBuilder;

import com.intellij.psi.PsiElement;
import com.intellij.psi.stubs.StubElement;
import com.intellij.util.io.StringRef;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.ListIterator;
import kotlin.ArraysKt;
import kotlin.CollectionsKt;
import kotlin.PreconditionsKt;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.KotlinFileFacade;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.builtins.KotlinBuiltIns;
import org.jetbrains.kotlin.descriptors.annotations.AnnotationUseSiteTarget;
import org.jetbrains.kotlin.idea.decompiler.stubBuilder.CallableClsStubBuilderKt;
import org.jetbrains.kotlin.idea.decompiler.stubBuilder.ClassClsStubBuilderKt;
import org.jetbrains.kotlin.idea.decompiler.stubBuilder.ClassIdWithTarget;
import org.jetbrains.kotlin.idea.decompiler.stubBuilder.ClsStubBuilderComponents;
import org.jetbrains.kotlin.idea.decompiler.stubBuilder.ClsStubBuilderContext;
import org.jetbrains.kotlin.idea.decompiler.stubBuilder.ClsStubBuildingKt$WhenMappings;
import org.jetbrains.kotlin.idea.decompiler.stubBuilder.FlagsToModifiers;
import org.jetbrains.kotlin.idea.stubindex.KotlinFileStubForIde;
import org.jetbrains.kotlin.lexer.JetModifierKeywordToken;
import org.jetbrains.kotlin.load.kotlin.KotlinJvmBinaryClass;
import org.jetbrains.kotlin.load.kotlin.header.KotlinClassHeader;
import org.jetbrains.kotlin.name.ClassId;
import org.jetbrains.kotlin.name.FqName;
import org.jetbrains.kotlin.name.FqNameBase;
import org.jetbrains.kotlin.name.Name;
import org.jetbrains.kotlin.psi.JetPackageDirective;
import org.jetbrains.kotlin.psi.stubs.KotlinUserTypeStub;
import org.jetbrains.kotlin.psi.stubs.elements.JetStubElementTypes;
import org.jetbrains.kotlin.psi.stubs.impl.KotlinAnnotationEntryStubImpl;
import org.jetbrains.kotlin.psi.stubs.impl.KotlinAnnotationUseSiteTargetStubImpl;
import org.jetbrains.kotlin.psi.stubs.impl.KotlinFileStubImpl;
import org.jetbrains.kotlin.psi.stubs.impl.KotlinModifierListStubImpl;
import org.jetbrains.kotlin.psi.stubs.impl.KotlinNameReferenceExpressionStubImpl;
import org.jetbrains.kotlin.psi.stubs.impl.KotlinPlaceHolderStubImpl;
import org.jetbrains.kotlin.psi.stubs.impl.KotlinStubBaseImpl;
import org.jetbrains.kotlin.psi.stubs.impl.KotlinUserTypeStubImpl;
import org.jetbrains.kotlin.psi.stubs.impl.ModifierMaskUtils;
import org.jetbrains.kotlin.serialization.Flags;
import org.jetbrains.kotlin.serialization.PackageData;
import org.jetbrains.kotlin.serialization.ProtoBuf;
import org.jetbrains.kotlin.serialization.deserialization.AnnotatedCallableKind;
import org.jetbrains.kotlin.serialization.deserialization.NameResolver;
import org.jetbrains.kotlin.serialization.deserialization.ProtoContainer;
import org.jetbrains.kotlin.serialization.jvm.JvmProtoBufUtil;

@KotlinFileFacade(version={0, 25, 0}, abiVersion=25, data={"\r\u0016)A1)\u00197mC\ndWM\u0003\u0005Qe>$xNQ;g\u0015\ry'o\u001a\u0006\nU\u0016$(M]1j]NTaa[8uY&t'\"D:fe&\fG.\u001b>bi&|gNC\u000bb]:|G/\u0019;fI\u000e\u000bG\u000e\\1cY\u0016\\\u0015N\u001c3\u000b+\u0005sgn\u001c;bi\u0016$7)\u00197mC\ndWmS5oI*yA-Z:fe&\fG.\u001b>bi&|gN\u0003\rhKR\feN\\8uCR,GmQ1mY\u0006\u0014G.Z&j]\u0012T\u0011\u0003\u0015:pi>\u0014UO\u001a\u0013DC2d\u0017M\u00197f\u0015E\u0019En]*uk\n\u0014U/\u001b7eS:<7\n\u001e\u0006\u0016GJ,\u0017\r^3B]:|G/\u0019;j_:\u001cF/\u001e2t\u00155\tgN\\8uCRLwN\\%eg*!A*[:u\u0015\u001d\u0019E.Y:t\u0013\u0012TAA\\1nK*1\u0001/\u0019:f]RT!cS8uY&t7\u000b^;c\u0005\u0006\u001cX-S7qY*\u0019\u0001o]5\u000b\u000bM$XOY:\u000b\t%l\u0007\u000f\u001c\u0006\u0005+:LGO\u0003\u0003kCZ\f'\u0002B;uS2TAc\u0019:fCR,g)\u001b7f\r\u0006\u001c\u0017\rZ3TiV\u0014'\u0002\u00049bG.\fw-\u001a)s_R|'b\u0002)bG.\fw-\u001a\u0006\rM\u0006\u001c\u0017\rZ3Gc:\u000bW.\u001a\u0006\u0007\rFt\u0015-\\3\u000b\u0003\rTQc\u00117t'R,(MQ;jY\u0012,'oQ8oi\u0016DHO\u0003\u0003jI\u0016\f'B\u00033fG>l\u0007/\u001b7fe*Y1\u000f^;c\u0005VLG\u000eZ3s\u0015IYu\u000e\u001e7j]\u001aKG.Z*uk\nLU\u000e\u001d7\u000b!A\u0013x\u000e^8Ck\u001a$\u0003+Y2lC\u001e,'BD2sK\u0006$XMR5mKN#XO\u0019\u0006\u000ea\u0006\u001c7.Y4f\rFt\u0015-\\3\u000bI\r\u0014X-\u0019;f\u0013:\u001cw.\u001c9bi&\u0014G.Z!cSZ+'o]5p]\u001aKG.Z*uk\nTac\u0019:fCR,Wj\u001c3jM&,'\u000fT5tiN#XO\u0019\u0006\f'R,(-\u00127f[\u0016tGOC\u0002d_6T\u0001\"\u001b8uK2d\u0017N\u001b\u0006\u000b!NLW\t\\3nK:$(\"C7pI&4\u0017.\u001a:t\u0015)\u0019u\u000e\u001c7fGRLwN\u001c\u0006\u0018\u0015\u0016$Xj\u001c3jM&,'oS3zo>\u0014H\rV8lK:TQ\u0001\\3yKJT!dS8uY&tWj\u001c3jM&,'\u000fT5tiN#XOY%na2TAe\u0019:fCR,Wj\u001c3jM&,'\u000fT5tiN#XO\u0019$pe\u0012+7\r\\1sCRLwN\u001c\u0006\u0006M2\fwm\u001d\u0006\u0004\u0013:$(\u0002\u00054mC\u001e\u001cHk\u001c+sC:\u001cH.\u0019;f\u0015A1E.Y4t)>lu\u000eZ5gS\u0016\u00148OC\nbI\u0012LG/[8oC2lu\u000eZ5gS\u0016\u00148O\u0003\rde\u0016\fG/Z'vYRLg-\u001b7f\u00072\f7o]*uk\nTa\"\\;mi&4\u0017\u000e\\3DY\u0006\u001c8O\u0003\u000bL_Rd\u0017N\u001c&w[\nKg.\u0019:z\u00072\f7o\u001d\u0006\u0005Y>\fGMC\u0005qCJ$h)\u001b7fg*Q1m\\7q_:,g\u000e^:\u000b1\rc7o\u0015;vE\n+\u0018\u000e\u001c3fe\u000e{W\u000e]8oK:$8OC\fde\u0016\fG/\u001a)bG.\fw-\u001a$bG\u0006$Wm\u0015;vE*A2M]3bi\u0016\u001cF/\u001e2G_J\u0004\u0016mY6bO\u0016t\u0015-\\3\u000b)A\f7m[1hK\u0012K'/Z2uSZ,7\u000b^;c\u0015eYu\u000e\u001e7j]Bc\u0017mY3I_2$WM]*uk\nLU\u000e\u001d7\u000b')+G\u000fU1dW\u0006<W\rR5sK\u000e$\u0018N^3\u000b+\r\u0014X-\u0019;f'R,(MR8s)f\u0004XMT1nK*YA/\u001f9f\u00072\f7o]%e\u0015IYu\u000e\u001e7j]V\u001bXM\u001d+za\u0016\u001cF/\u001e2\u000b;\r\u0014X-\u0019;f)\u0006\u0014x-\u001a;fI\u0006sgn\u001c;bi&|gn\u0015;vENT\u0011c\u00117bgNLEmV5uQR\u000b'oZ3u\u0015]\u0019'/Z1uKR{\u0007\u000fT3wK2\u001cE.Y:t'R,(MC\u0004dY\u0006\u001c8/\u00133\u000b\u0015\rd\u0017m]:Qe>$xNC\u0003DY\u0006\u001c8OC\u0004d_:$X\r\u001f;\u000b\u001dA\u0013x\u000e^8Ck\u001a$3\t\\1tg*i1/\u001a;va\u001aKG.Z*uk\nT\u0001BZ5mKN#XO\u0019\u0006\u0004e\u00164'\"C*ue&twMU3g\u0015\tIwN\u0003\u0005Ok2d\u0017M\u00197f\u0015-\tgN\\8uCRLwN\\:\u000b\t9\u000bW.\u001aq\u0004\u0015\t\u0001\"A\u0003\u0003\t\u0001A\u0019!\u0002\u0002\u0005\u0002!\u0011QA\u0001\u0003\u0002\u0011\u000b)1\u0001b\u0001\t\u00021\u0001Qa\u0001\u0003\u0003\u0011\u0001a\u0001!\u0002\u0002\u0005\u0004!!Qa\u0001\u0003\u0004\u0011\u000fa\u0001!\u0002\u0002\u0005\u0007!\u001dQA\u0001C\u0002\u0011\u0015)\u0011\u0001\u0003\u0002\u0006\u0007\u0011)\u0001b\u0002\u0007\u0001\u000b\t!\u0011\u0001\u0003\u0005\u0006\u0007\u00111\u0001r\u0002\u0007\u0001\u000b\t!\u0011\u0001c\u0005\u0006\u0005\u00119\u0001BC\u0003\u0003\t\u001fA)\"B\u0002\u0005\u0011!IA\u0002A\u0003\u0004\t\u0015A1\u0002\u0004\u0001\u0006\u0003!]QA\u0001C\n\u00111)!\u0001\u0002\u0006\t\u000f\u0015\u0011A\u0001\u0003\u0005\n\u000b\r!!\u0001c\u0007\r\u0001\u0015\u0019AA\u0002E\u000f\u0019\u0001)!\u0001B\u0001\t!\u0015\u0011A\u0011\u0004E\u0011\u000b\t!Q\u0002C\t\u0006\u0007\u0011m\u0001r\u0004\u0007\u0001\u000b\r!\u0001\u0002c\t\r\u0001\u0015\u0011A\u0001\u0003E\u0012\u000b\t!\u0019\u0001\u0003\n\u0006\u0005\u00111\u0001RD\u0003\u0003\t7Ay\"B\u0001\t+\u0015\u0011A!\u0005E\u0016\u000b\t!\u0019\u0003c\u0005\u0006\u0005\u0011\u0011\u0002BC\u0003\u0004\tKAI\u0003\u0004\u0001\u0006\u0007\u0011\u0011\u0002B\u0006\u0007\u0001\u000b\r!Q\u0001C\f\r\u0001\u0015\u0011A!\u0001\u0005\u0019\u000b\r!I\u0003c\f\r\u0001\u0015\u0019A\u0001\u0003E\u0019\u0019\u0001)!\u0001\u0002\u0005\t2\u0015\u0011AQ\u0005E\u0015\u000b\t!!\u0002C\f\u0006\u0007\u0011)\u0001B\u0007\u0007\u0001\u000b\r!Y\u0002C\u000e\r\u0001\u0015\u0011A!\u0001E\u001e\u000b\t!\t\u0004\u0003\u0002\u0006\u0007\u0011I\u0002\"\b\u0007\u0001\u000b\r!Y\u0002C\u0010\r\u0001\u0015\u0011A!\u0007\u0005\u001e\u000b\t!Y\u0002C\u0010\u0006\u0007\u0011A\u0001\"\t\u0007\u0001\u000b\r!q\u0001c\u0011\r\u0001\u0015\u0011A\u0001\u0003\u0005\"\u000b\r!y\u0001C\u0012\r\u0001\u0015\u0011Aq\u0002\u0005$\u000b\t!a\u0001c\u0004\u0006\u0007\u0011m\u0001\u0002\n\u0007\u0001\u000b\r!!\u0001\u0003\u0014\r\u0001\u0015\u0011A1\u0001\u0005(\u000b\t!\u0019\u0003\u0003\u0007\u0006\u0005\u0011\u0001\u00032K\u0003\u0004\t\u0003B\u0011\u0006\u0004\u0001\u0006\u0005\u0011\u0005\u0001RK\u0003\u0004\t\u0007B!\u0006\u0004\u0001\u0006\u0005\u0011\u0005\u0003\"K\u0003\u0004\t\u0019A1\u0006\u0004\u0001\u0006\u0005\u00111\u0001bKC\u0015\t\r$QcA\u0003\u0002\u0011\u000bA*\u0001G\u0002\"\u0007\u0015\t\u0001r\u0001M\u0004I\r*6AB\u0007\u0006\t\u0013I\u0011\u0001\u0003\u0003\u000e\u0003!%\u0001la\u0003\u0006Q\u0011\u0019\u0001DBO\r\t\u0001Ai!\u0004\u0005\u0006\u0003!-\u0011\u0002B\u0005\u0004\u000b\u0005Ai\u0001'\u0004\u0019\fA\u001b\u0001!h\u0005\u0005\u0001!EQ\"B\u0003\u0002\u0011#I\u0011\u0001b\u0001\u0019\u0012A\u001b\t!I\u0002\u0006\u0003!I\u0001$C)\u0004\u000f\u00111\u0011\"\u0001\u0003\u0001\u001b\u0005A)\"D\u0001\t\u0017a\u001bY!b\u0016\u0005\u0007aeQt\u0002\u0003\u0001\u00115i1!B\u0001\t\u0018a]\u0001k\u0001\u0001\u001e\u0010\u0011\u0001\u0001BD\u0007\u0004\u000b\u0005AA\u0002\u0007\u0007Q\u0007\u0003iz\u0001\u0002\u0001\t\u001f5\u0019Q!\u0001\u0005\u000f19\u00016!A\u0011\u0004\u000b\u0005Ai\u0002'\bR\u0007%!I\"C\u0001\t\u001f5\t\u0001rD\u0007\u0002\u0011Ai\u0011\u0001#\tY\u0007\u0017)i\u0003B\u0002\u0019&u=A\u0001\u0001\u0005\u0014\u001b\r)\u0011\u0001\u0003\u0007\u0019\u0019A\u001b\u0001!I\u0002\u0006\u0003!u\u0001TD)\u0004\u000b\u0011\u0015\u0012\"\u0001\u0005\u0010\u001b\u0005A\u0001\u0003WB\u0006\u000b1!1\u0001g\n\"\u0007\u0015\t\u0001R\u0004M\u000f#\u000e\u0019AqE\u0005\u0002\u0011=A61B\u0003.\t\rAB#h\u0007\u0005\u0001!EQ\"C\u0003\u0002\u0011MIQ\u0001\"\u0001\n\u0007\u0015\t\u0001r\u0005M\u00141M\u00016\u0001AO\r\t\u0001Ai#\u0004\u0005\u0006\u0003!!\u0012\u0002B\u0005\u0004\u000b\u0005AQ\u0003G\u000b\u0019)A\u001b\t!\t\u0003\u0006\u0003!-B\u0012\u0001M\u0016#\u000e9A\u0001F\u0005\u0002\u0011Yi\u0011\u0001#\f\u000e\u0003!9\u0002la\u0003\u0006\r\u0004!1\u0001G\r\u001e\u001c\u0011\u0001\u0001\u0012C\u0007\n\u000b\u0005A1#C\u0003\u0005\u0002%\u0019Q!\u0001E\u00141OA2\u0003U\u0002\u0001;\u001f!\u0001\u0001c\r\u000e\u0007\u0015\t\u0001r\u0006M\u0018!\u000e\u0005Q\u0014\u0004\u0003\u0002\u0011ki\u0001\"B\u0001\t\f%!\u0011bA\u0003\u0002\u0011aA\u0002\u0004g\u0003Q\u0007\u0005iJ\u0002B\u0001\t85AQ!\u0001E\u0006\u0013\u0011I1!B\u0001\t+a)\u00024\u0002)\u0004\u0004\u0005\u001aQ!\u0001E\u00161W\t6a\u0003\u0003\u001a\u0013\u0005Aa#D\u0001\t.5\tAQA\u0007\u0002\u0011+i\u0011\u0001#\u0006Y\u0007\u0017)1\bB\u0002\u00199u=A\u0001\u0001E\u001d\u001b\r)\u0011\u0001c\r\u00194A\u001b\u0001!(\u0007\u0005\u0001!qR\u0002C\u0003\u0002\u0011\u0017IA!C\u0002\u0006\u0003!M\u00024\u0007M\u0006!\u000e\u0005Qt\u0002\u0003\u0001\u00119i1!B\u0001\t\u0019aa\u0001kA\u0001\u001e\u0010\u0011\u0001\u0001RH\u0007\u0004\u000b\u0005A!\u0004\u0007\u000eQ\u0007\u0007\t3!B\u0001\t\u001eau\u0011kA\u0006\u00059%\t\u0001bD\u0007\u0002\u0011ki\u0011\u0001#\u0006\u000e\u0003!\u0001R\"\u0001\u0005\u001c1\u000e-Qq\u000b\u0003\u00041\u007fiz\u0001\u0002\u0001\t\u001b5\u0019Q!\u0001E\f1/\u00016\u0001AO\b\t\u0001A1#D\u0002\u0006\u0003!a\u0001\u0004\u0004)\u0004\u0002u=A\u0001\u0001\u0005\u0010\u001b\r)\u0011\u0001\u0003\b\u0019\u001dA\u001b\u0011!I\u0002\u0006\u0003!u\u0001TD)\u0004\u0013\u0011}\u0012\"\u0001\u0005\u0010\u001b\u0005Ay\"D\u0001\t!5\t\u0001\u0012\u0005-\u0004\f\u00151Ca\u0001\r!;3!\u0001\u0001#\u0011\u000e\u0011\u0015\t\u0001rG\u0005\u0005\u0013\r)\u0011\u0001\u0003\u000f\u00199a]\u0002k\u0001\u0001\u001e\u0010\u0011\u0001\u0001bE\u0007\u0004\u000b\u0005AA\u0002\u0007\u0007Q\u0007\u0003\t3!B\u0001\t\u0013aI\u0011kA\u0004\u0005A%\tA\u0001A\u0007\u0002\u0011si\u0011\u0001\u0003\tY\u0007\u0017)q\u0005B\u0002\u0019Eu=A\u0001\u0001E#\u001b\r)\u0011\u0001#\u0004\u0019\u000eA\u001b\u0001!h\u0007\u0005\u0001!EQ\"C\u0003\u0002\u0011MIQ\u0001\"\u0001\n\u0007\u0015\t\u0001r\u0005M\u00141M\u00016\u0011A\u0011\u0004\u000b\u0005AQ\u0004G\u000fR\u0007\u001d!!%C\u0001\t<5\t\u0001BH\u0007\u0002\u0011[A61B\u0003)\t\rA:%(\u0007\u0005\u0001!5Q\u0002C\u0003\u0002\u0011\u0017IA!C\u0002\u0006\u0003!u\u0002T\bM\u0006!\u000e\u0001Q4\u0003\u0003\u0001\u0011#iQ!B\u0001\t\u0012%\tA1\u0001M\t!\u000e\u0005\u0011eA\u0003\u0002\u0011%A\u0012\"U\u0002\b\t\u000fJ\u0011\u0001\u0002\u0001\u000e\u0003!UQ\"\u0001\u0005\f1\u000e-Qq\u000b\u0003\u00041\u0013jz\u0001\u0002\u0001\tK5\u0019Q!\u0001E\u00071\u001b\u00016\u0001AO\b\t\u0001AY%D\u0002\u0006\u0003!y\u0002d\b)\u0004\u0002u=A\u0001\u0001E'\u001b\r)\u0011\u0001\u0003\b\u0019\u001dA\u001b\u0011!I\u0002\u0006\u0003!u\u0001TD)\u0004\u0013\u0011%\u0013\"\u0001\u0005\u0010\u001b\u0005Aa$D\u0001\t@5\t\u0001\u0012\u0005-\u0004\f\u0015\tC!\u0001M(;\u001f!\u0001\u0001\u0003\u0015\u000e\u0007\u0015\t\u0001R\u0004M\u000f!\u000e\u0001Qt\u0002\u0003\u0001\u0011Mi1!B\u0001\t\u0019aa\u0001k!\u0001\"\u0007\u0015\t\u0001\"\u0003\r\n#\u000e9AqJ\u0005\u0002\t\u0001i\u0011\u0001C\b\u000e\u0003!\u0001\u0002la\u0003\u0006*\u0011\u0019QcA\u0003\u0002\u00111AB\u0002'\u0015\"\f\u0015\t\u0001\"\t\r\"#\u000e\tAAI)\u0004\u000b\u0011E\u0013\"\u0001E#\u001b\u0005A\u0001\u0003WB\u0006\u000bS!1!F\u0002\u0006\u0003!\u0019\u0003d\tM)C\u0017)\u0011\u0001C\u0011\u0019CE\u001b\u0011\u0001\u0002\u0012R\u0007\u0015!\t&C\u0001\tF5\t\u0001r\t-\u0004\f\u0001"})
public final class ClsStubBuildingKt {
    @NotNull
    public static final KotlinFileStubImpl createTopLevelClassStub(@NotNull ClassId classId, @NotNull ProtoBuf.Class classProto, @NotNull ClsStubBuilderContext context) {
        Intrinsics.checkParameterIsNotNull((Object)classId, (String)"classId");
        Intrinsics.checkParameterIsNotNull((Object)classProto, (String)"classProto");
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        FqName fqName2 = classId.getPackageFqName();
        Intrinsics.checkExpressionValueIsNotNull((Object)fqName2, (String)"classId.getPackageFqName()");
        KotlinFileStubImpl fileStub = ClsStubBuildingKt.createFileStub(fqName2);
        ClassClsStubBuilderKt.createClassStub((StubElement<? extends PsiElement>)((StubElement)fileStub), classProto, classId, context);
        return fileStub;
    }

    @NotNull
    public static final KotlinFileStubImpl createPackageFacadeStub(@NotNull ProtoBuf.Package packageProto, @NotNull FqName packageFqName, @NotNull ClsStubBuilderContext c) {
        Intrinsics.checkParameterIsNotNull((Object)packageProto, (String)"packageProto");
        Intrinsics.checkParameterIsNotNull((Object)packageFqName, (String)"packageFqName");
        Intrinsics.checkParameterIsNotNull((Object)c, (String)"c");
        KotlinFileStubImpl fileStub = KotlinFileStubForIde.Companion.forFile(packageFqName, packageFqName.isRoot());
        ClsStubBuildingKt.setupFileStub(fileStub, packageFqName);
        ProtoContainer container2 = new ProtoContainer(null, packageFqName);
        for (ProtoBuf.Callable callableProto : packageProto.getMemberList()) {
            StubElement stubElement = (StubElement)fileStub;
            ProtoBuf.Callable callable = callableProto;
            Intrinsics.checkExpressionValueIsNotNull((Object)callable, (String)"callableProto");
            CallableClsStubBuilderKt.createCallableStub((StubElement<? extends PsiElement>)stubElement, callable, c, container2);
        }
        return fileStub;
    }

    @NotNull
    public static final KotlinFileStubImpl createFileFacadeStub(@NotNull ProtoBuf.Package packageProto, @NotNull FqName facadeFqName, @NotNull ClsStubBuilderContext c) {
        Intrinsics.checkParameterIsNotNull((Object)packageProto, (String)"packageProto");
        Intrinsics.checkParameterIsNotNull((Object)facadeFqName, (String)"facadeFqName");
        Intrinsics.checkParameterIsNotNull((Object)c, (String)"c");
        FqName packageFqName = facadeFqName.parent();
        KotlinFileStubImpl fileStub = KotlinFileStubForIde.Companion.forFileFacadeStub(facadeFqName, packageFqName.isRoot());
        FqName fqName2 = packageFqName;
        Intrinsics.checkExpressionValueIsNotNull((Object)fqName2, (String)"packageFqName");
        ClsStubBuildingKt.setupFileStub(fileStub, fqName2);
        ProtoContainer container2 = new ProtoContainer(null, facadeFqName.parent());
        for (ProtoBuf.Callable callableProto : packageProto.getMemberList()) {
            StubElement stubElement = (StubElement)fileStub;
            ProtoBuf.Callable callable = callableProto;
            Intrinsics.checkExpressionValueIsNotNull((Object)callable, (String)"callableProto");
            CallableClsStubBuilderKt.createCallableStub((StubElement<? extends PsiElement>)stubElement, callable, c, container2);
        }
        return fileStub;
    }

    @NotNull
    public static final KotlinFileStubImpl createMultifileClassStub(@NotNull KotlinJvmBinaryClass multifileClass, @NotNull List<? extends KotlinJvmBinaryClass> partFiles, @NotNull FqName facadeFqName, @NotNull ClsStubBuilderComponents components) {
        Intrinsics.checkParameterIsNotNull((Object)multifileClass, (String)"multifileClass");
        Intrinsics.checkParameterIsNotNull(partFiles, (String)"partFiles");
        Intrinsics.checkParameterIsNotNull((Object)facadeFqName, (String)"facadeFqName");
        Intrinsics.checkParameterIsNotNull((Object)components, (String)"components");
        FqName packageFqName = facadeFqName.parent();
        String[] stringArray = multifileClass.getClassHeader().getFilePartClassNames();
        List partNames = stringArray != null ? ArraysKt.asList((Object[])stringArray) : null;
        KotlinFileStubImpl fileStub = KotlinFileStubForIde.Companion.forMultifileClassStub(facadeFqName, partNames, packageFqName.isRoot());
        FqName fqName2 = packageFqName;
        Intrinsics.checkExpressionValueIsNotNull((Object)fqName2, (String)"packageFqName");
        ClsStubBuildingKt.setupFileStub(fileStub, fqName2);
        ProtoContainer multifileClassContainer = new ProtoContainer(null, packageFqName);
        for (KotlinJvmBinaryClass kotlinJvmBinaryClass : partFiles) {
            KotlinClassHeader partHeader = kotlinJvmBinaryClass.getClassHeader();
            String[] stringArray2 = partHeader.getAnnotationData();
            if (stringArray2 == null) {
                Intrinsics.throwNpe();
            }
            PackageData partData = JvmProtoBufUtil.readPackageDataFrom(stringArray2);
            NameResolver nameResolver = partData.getNameResolver();
            FqName fqName3 = packageFqName;
            Intrinsics.checkExpressionValueIsNotNull((Object)fqName3, (String)"packageFqName");
            ClsStubBuilderContext partContext = components.createContext(nameResolver, fqName3);
            for (ProtoBuf.Callable partMember : partData.getPackageProto().getMemberList()) {
                StubElement stubElement = (StubElement)fileStub;
                ProtoBuf.Callable callable = partMember;
                Intrinsics.checkExpressionValueIsNotNull((Object)callable, (String)"partMember");
                CallableClsStubBuilderKt.createCallableStub((StubElement<? extends PsiElement>)stubElement, callable, partContext, multifileClassContainer);
            }
        }
        return fileStub;
    }

    @NotNull
    public static final KotlinFileStubImpl createIncompatibleAbiVersionFileStub() {
        FqName fqName2 = FqName.ROOT;
        Intrinsics.checkExpressionValueIsNotNull((Object)fqName2, (String)"FqName.ROOT");
        return ClsStubBuildingKt.createFileStub(fqName2);
    }

    @NotNull
    public static final KotlinFileStubImpl createFileStub(@NotNull FqName packageFqName) {
        Intrinsics.checkParameterIsNotNull((Object)packageFqName, (String)"packageFqName");
        KotlinFileStubImpl fileStub = KotlinFileStubForIde.Companion.forFile(packageFqName, packageFqName.isRoot());
        ClsStubBuildingKt.setupFileStub(fileStub, packageFqName);
        return fileStub;
    }

    public static final void setupFileStub(@NotNull KotlinFileStubImpl fileStub, @NotNull FqName packageFqName) {
        Intrinsics.checkParameterIsNotNull((Object)fileStub, (String)"fileStub");
        Intrinsics.checkParameterIsNotNull((Object)packageFqName, (String)"packageFqName");
        KotlinPlaceHolderStubImpl<JetPackageDirective> packageDirectiveStub = new KotlinPlaceHolderStubImpl<JetPackageDirective>((StubElement)fileStub, JetStubElementTypes.PACKAGE_DIRECTIVE);
        ClsStubBuildingKt.createStubForPackageName(packageDirectiveStub, packageFqName);
        new KotlinPlaceHolderStubImpl((StubElement)fileStub, JetStubElementTypes.IMPORT_LIST);
    }

    public static final void createStubForPackageName(@NotNull KotlinPlaceHolderStubImpl<JetPackageDirective> packageDirectiveStub, @NotNull FqName packageFqName) {
        Intrinsics.checkParameterIsNotNull(packageDirectiveStub, (String)"packageDirectiveStub");
        Intrinsics.checkParameterIsNotNull((Object)packageFqName, (String)"packageFqName");
        ArrayList segments = CollectionsKt.toArrayList((Collection)packageFqName.pathSegments());
        ListIterator iterator2 = segments.listIterator(segments.size());
        Function1<StubElement<? extends PsiElement>, Unit> recCreateStubForPackageName$ = new Function1<StubElement<? extends PsiElement>, Unit>(iterator2){
            final /* synthetic */ ListIterator $iterator;

            public final void invoke(@NotNull StubElement<? extends PsiElement> current) {
                Intrinsics.checkParameterIsNotNull(current, (String)"current");
                switch (this.$iterator.previousIndex()) {
                    case -1: {
                        return;
                    }
                    case 0: {
                        new KotlinNameReferenceExpressionStubImpl(current, ClsStubBuildingKt.ref((Name)this.$iterator.previous()));
                        return;
                    }
                }
                Name lastSegment = (Name)this.$iterator.previous();
                KotlinPlaceHolderStubImpl<T> receiver = new KotlinPlaceHolderStubImpl<T>((StubElement)current, JetStubElementTypes.DOT_QUALIFIED_EXPRESSION);
                this.invoke((StubElement<? extends PsiElement>)receiver);
                new KotlinNameReferenceExpressionStubImpl(receiver, ClsStubBuildingKt.ref(lastSegment));
            }
            {
                this.$iterator = listIterator;
                super(1);
            }
        };
        recCreateStubForPackageName$.invoke((StubElement<? extends PsiElement>)packageDirectiveStub);
    }

    @NotNull
    public static final KotlinUserTypeStub createStubForTypeName(@NotNull ClassId typeClassId, @NotNull StubElement<? extends PsiElement> parent2) {
        Intrinsics.checkParameterIsNotNull((Object)typeClassId, (String)"typeClassId");
        Intrinsics.checkParameterIsNotNull(parent2, (String)"parent");
        FqNameBase fqName2 = typeClassId.isLocal() ? (FqNameBase)KotlinBuiltIns.FQ_NAMES.any : (FqNameBase)typeClassId.asSingleFqName();
        ArrayList segments = CollectionsKt.toArrayList((Collection)fqName2.pathSegments());
        PreconditionsKt.assert((boolean)CollectionsKt.isNotEmpty((Collection)segments));
        ListIterator iterator2 = segments.listIterator(segments.size());
        Function1<StubElement<? extends PsiElement>, KotlinUserTypeStub> recCreateStubForType$ = new Function1<StubElement<? extends PsiElement>, KotlinUserTypeStub>(iterator2){
            final /* synthetic */ ListIterator $iterator;

            @NotNull
            public final KotlinUserTypeStub invoke(@NotNull StubElement<? extends PsiElement> current) {
                Intrinsics.checkParameterIsNotNull(current, (String)"current");
                Name lastSegment = (Name)this.$iterator.previous();
                KotlinUserTypeStubImpl userTypeStub = new KotlinUserTypeStubImpl(current, false);
                if (this.$iterator.hasPrevious()) {
                    this.invoke((StubElement<? extends PsiElement>)((StubElement)userTypeStub));
                }
                new KotlinNameReferenceExpressionStubImpl(userTypeStub, ClsStubBuildingKt.ref(lastSegment));
                return userTypeStub;
            }
            {
                this.$iterator = listIterator;
                super(1);
            }
        };
        return recCreateStubForType$.invoke(parent2);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final KotlinModifierListStubImpl createModifierListStubForDeclaration(@NotNull StubElement<? extends PsiElement> parent2, int flags, @NotNull List<? extends FlagsToModifiers> flagsToTranslate, @NotNull List<? extends JetModifierKeywordToken> additionalModifiers) {
        void destination;
        void $receiver;
        void $receiver2;
        Intrinsics.checkParameterIsNotNull(parent2, (String)"parent");
        Intrinsics.checkParameterIsNotNull(flagsToTranslate, (String)"flagsToTranslate");
        Intrinsics.checkParameterIsNotNull(additionalModifiers, (String)"additionalModifiers");
        PreconditionsKt.assert((boolean)CollectionsKt.isNotEmpty((Collection)flagsToTranslate));
        Iterable iterable = flagsToTranslate;
        void var6_5 = $receiver2;
        Collection collection = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$receiver2, (int)10));
        for (Object item : $receiver) {
            void it;
            FlagsToModifiers flagsToModifiers = (FlagsToModifiers)((Object)item);
            void var11_10 = destination;
            JetModifierKeywordToken jetModifierKeywordToken = it.getModifiers(flags);
            var11_10.add(jetModifierKeywordToken);
        }
        List modifiers = CollectionsKt.plus((Collection)CollectionsKt.filterNotNull((Iterable)((List)destination)), (Iterable)additionalModifiers);
        KotlinModifierListStubImpl kotlinModifierListStubImpl = ClsStubBuildingKt.createModifierListStub(parent2, modifiers);
        if (kotlinModifierListStubImpl == null) {
            Intrinsics.throwNpe();
        }
        return kotlinModifierListStubImpl;
    }

    @NotNull
    public static /* synthetic */ KotlinModifierListStubImpl createModifierListStubForDeclaration$default(StubElement stubElement, int n, List list, List list2, int n2) {
        if ((n2 & 4) != 0) {
            list = CollectionsKt.listOf();
        }
        if ((n2 & 8) != 0) {
            list2 = CollectionsKt.listOf();
        }
        return ClsStubBuildingKt.createModifierListStubForDeclaration((StubElement<? extends PsiElement>)stubElement, n, list, list2);
    }

    @Nullable
    public static final KotlinModifierListStubImpl createModifierListStub(@NotNull StubElement<? extends PsiElement> parent2, @NotNull Collection<? extends JetModifierKeywordToken> modifiers) {
        Intrinsics.checkParameterIsNotNull(parent2, (String)"parent");
        Intrinsics.checkParameterIsNotNull(modifiers, (String)"modifiers");
        if (modifiers.isEmpty()) {
            return null;
        }
        return new KotlinModifierListStubImpl(parent2, ModifierMaskUtils.computeMask((Function1<? super JetModifierKeywordToken, ? extends Boolean>)((Function1)new Function1<JetModifierKeywordToken, Boolean>(modifiers){
            final /* synthetic */ Collection $modifiers;

            public final boolean invoke(@NotNull JetModifierKeywordToken it) {
                Intrinsics.checkParameterIsNotNull((Object)((Object)it), (String)"it");
                return this.$modifiers.contains((Object)((Object)it));
            }
            {
                this.$modifiers = collection;
                super(1);
            }
        })), JetStubElementTypes.MODIFIER_LIST);
    }

    /*
     * WARNING - void declaration
     */
    public static final void createAnnotationStubs(@NotNull List<? extends ClassId> annotationIds, @NotNull KotlinStubBaseImpl<?> parent2) {
        void destination;
        void $receiver;
        Intrinsics.checkParameterIsNotNull(annotationIds, (String)"annotationIds");
        Intrinsics.checkParameterIsNotNull(parent2, (String)"parent");
        Iterable $receiver2 = annotationIds;
        Iterable iterable = $receiver2;
        Collection collection = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$receiver2, (int)10));
        for (Object item : $receiver) {
            void it;
            ClassId classId = (ClassId)item;
            void var8_8 = destination;
            ClassIdWithTarget classIdWithTarget = new ClassIdWithTarget((ClassId)it, null);
            var8_8.add(classIdWithTarget);
        }
        ClsStubBuildingKt.createTargetedAnnotationStubs((List)destination, parent2);
    }

    /*
     * WARNING - void declaration
     */
    public static final void createTargetedAnnotationStubs(@NotNull List<? extends ClassIdWithTarget> annotationIds, @NotNull KotlinStubBaseImpl<?> parent2) {
        Intrinsics.checkParameterIsNotNull(annotationIds, (String)"annotationIds");
        Intrinsics.checkParameterIsNotNull(parent2, (String)"parent");
        if (annotationIds.isEmpty()) {
            return;
        }
        Iterable $receiver = annotationIds;
        for (Object element2 : $receiver) {
            void target;
            void annotationClassId;
            ClassIdWithTarget annotation2;
            ClassIdWithTarget classIdWithTarget = annotation2 = (ClassIdWithTarget)element2;
            ClassId classId = classIdWithTarget.component1();
            AnnotationUseSiteTarget annotationUseSiteTarget = classIdWithTarget.component2();
            classIdWithTarget = null;
            StubElement stubElement = (StubElement)parent2;
            StringRef stringRef = ClsStubBuildingKt.ref(annotationClassId.getShortClassName());
            Intrinsics.checkExpressionValueIsNotNull((Object)stringRef, (String)"annotationClassId.getShortClassName().ref()");
            KotlinAnnotationEntryStubImpl annotationEntryStubImpl = new KotlinAnnotationEntryStubImpl((StubElement<? extends PsiElement>)stubElement, stringRef, false);
            if (target != null) {
                StubElement stubElement2 = annotationEntryStubImpl;
                StringRef stringRef2 = StringRef.fromString((String)target.name());
                if (stringRef2 == null) {
                    Intrinsics.throwNpe();
                }
                Intrinsics.checkExpressionValueIsNotNull((Object)stringRef2, (String)"StringRef.fromString(target.name())!!");
                new KotlinAnnotationUseSiteTargetStubImpl((StubElement<? extends PsiElement>)stubElement2, stringRef2);
            }
            KotlinPlaceHolderStubImpl constructorCallee = new KotlinPlaceHolderStubImpl(annotationEntryStubImpl, JetStubElementTypes.CONSTRUCTOR_CALLEE);
            KotlinPlaceHolderStubImpl typeReference = new KotlinPlaceHolderStubImpl(constructorCallee, JetStubElementTypes.TYPE_REFERENCE);
            ClsStubBuildingKt.createStubForTypeName((ClassId)annotationClassId, typeReference);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @NotNull
    public static final AnnotatedCallableKind getAnnotatedCallableKind(ProtoBuf.Callable $receiver) {
        ProtoBuf.Callable.CallableKind callableKind;
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        ProtoBuf.Callable.CallableKind callableKind2 = callableKind = Flags.CALLABLE_KIND.get($receiver.getFlags());
        if (callableKind2 == null) throw (Throwable)new IllegalStateException("Unsupported callable kind: " + (Object)((Object)callableKind));
        switch (ClsStubBuildingKt$WhenMappings.$EnumSwitchMapping$0[callableKind2.ordinal()]) {
            case 1: 
            case 2: {
                AnnotatedCallableKind annotatedCallableKind = AnnotatedCallableKind.PROPERTY;
                return annotatedCallableKind;
            }
            case 3: 
            case 4: {
                AnnotatedCallableKind annotatedCallableKind = AnnotatedCallableKind.FUNCTION;
                return annotatedCallableKind;
            }
            default: {
                throw (Throwable)new IllegalStateException("Unsupported callable kind: " + (Object)((Object)callableKind));
            }
        }
    }

    @NotNull
    public static final StringRef ref(Name $receiver) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        StringRef stringRef = StringRef.fromString((String)$receiver.asString());
        if (stringRef == null) {
            Intrinsics.throwNpe();
        }
        return stringRef;
    }

    @NotNull
    public static final StringRef ref(FqName $receiver) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        StringRef stringRef = StringRef.fromString((String)$receiver.asString());
        if (stringRef == null) {
            Intrinsics.throwNpe();
        }
        return stringRef;
    }
}

