/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.decompiler.stubBuilder;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.compiled.ClsStubBuilder;
import com.intellij.psi.impl.compiled.ClassFileStubBuilder;
import com.intellij.psi.stubs.PsiFileStub;
import com.intellij.util.indexing.FileContent;
import java.io.ByteArrayInputStream;
import kotlin.PreconditionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.KotlinClass;
import kotlin.jvm.internal.Reflection;
import kotlin.reflect.KClass;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.idea.decompiler.AnnotationLoaderForKotlinJavaScriptStubBuilder;
import org.jetbrains.kotlin.idea.decompiler.DecompiledUtilsKt;
import org.jetbrains.kotlin.idea.decompiler.navigation.JsMetaFileUtils;
import org.jetbrains.kotlin.idea.decompiler.stubBuilder.ClsStubBuilderComponents;
import org.jetbrains.kotlin.idea.decompiler.stubBuilder.ClsStubBuilderContext;
import org.jetbrains.kotlin.idea.decompiler.stubBuilder.ClsStubBuildingKt;
import org.jetbrains.kotlin.idea.decompiler.textBuilder.DirectoryBasedKotlinJavaScriptDataFinder;
import org.jetbrains.kotlin.idea.decompiler.textBuilder.DirectoryBasedKotlinJavaScriptMetaFileFinder;
import org.jetbrains.kotlin.name.ClassId;
import org.jetbrains.kotlin.name.FqName;
import org.jetbrains.kotlin.psi.JetFile;
import org.jetbrains.kotlin.serialization.ClassData;
import org.jetbrains.kotlin.serialization.PackageData;
import org.jetbrains.kotlin.serialization.deserialization.NameResolver;
import org.jetbrains.kotlin.serialization.js.JsProtoBufUtilKt;
import org.jetbrains.kotlin.serialization.js.KotlinJavascriptSerializedResourcePaths;

@KotlinClass(version={0, 25, 0}, abiVersion=25, data={"?\b)Y2j\u001c;mS:T\u0015M^1TGJL\u0007\u000f^*uk\n\u0014U/\u001b7eKJT1a\u001c:h\u0015%QW\r\u001e2sC&t7O\u0003\u0004l_Rd\u0017N\u001c\u0006\u0005S\u0012,\u0017M\u0003\u0006eK\u000e|W\u000e]5mKJT1b\u001d;vE\n+\u0018\u000e\u001c3fe*q1\t\\:TiV\u0014')^5mI\u0016\u0014(bA2p[*A\u0011N\u001c;fY2L'NC\u0002qg&T\u0001bY8na&dW\r\u001a\u0006\u0007y%t\u0017\u000e\u001e \u000b\u001b\t,\u0018\u000e\u001c3GS2,7\u000b^;c\u0015\u001d\u0019wN\u001c;f]RT1BR5mK\u000e{g\u000e^3oi*!Q\u000f^5m\u0015!Ig\u000eZ3yS:<'b\u0003)tS\u001aKG.Z*uk\nTQa\u001d;vENT1d\u0019:fCR,7\u000b^;c\u0005VLG\u000eZ3s\u0007>l\u0007o\u001c8f]R\u001c(\u0002\u00024jY\u0016T1BV5siV\fGNR5mK*9q\u000e]3oCBL'b\u0001<gg*i\u0001/Y2lC\u001e,g)\u001d(b[\u0016TaAR9OC6,'\u0002\u00028b[\u0016TAB\\1nKJ+7o\u001c7wKJTABT1nKJ+7o\u001c7wKJTQb]3sS\u0006d\u0017N_1uS>t'b\u00043fg\u0016\u0014\u0018.\u00197ju\u0006$\u0018n\u001c8\u000b1\rc7o\u0015;vE\n+\u0018\u000e\u001c3fe\u000e{W\u000e]8oK:$8OC\be_\n+\u0018\u000e\u001c3GS2,7\u000b^;c\u0015\u001dQU\r\u001e$jY\u0016TabZ3u'R,(MV3sg&|gNC\u0002J]RT\u0011bQ8na\u0006t\u0017n\u001c8g\u0004)\u0011\u0001#\u0001\u0006\u0005\u0011\u0001\u0001\"A\u0003\u0003\t\u0003A\u0019!\u0002\u0002\u0005\u0003!\u0011QA\u0001C\u0002\u0011\u000b)!\u0001\u0002\u0002\t\u0007\u0015\u0019AQ\u0001\u0005\u0001\u0019\u0001)\u0011\u0001\u0003\u0003\u0006\u0005\u0011\u001d\u0001\u0012B\u0003\u0003\t\u0011AQ!\u0002\u0002\u0005\n!-Qa\u0001\u0003\u0006\u0011\u000fa\u0001!\u0002\u0002\u0005\t!AQA\u0001\u0003\u0007\u0011#)1\u0001\"\u0004\t\u00101\u0001QA\u0001C\u0005\u0011')1\u0001b\u0004\t\u00131\u0001QA\u0001C\b\u0011%)!\u0001\"\u0004\t\u0010\u0015\u0011A\u0001\u0002E\f\u000b\t!\u0019\u0002\u0003\u0007\u0006\u0007\u0011Q\u0001b\u0003\u0007\u0001\u000b\t!\u0011\u0001c\u0007\u0006\u0007\u0011Y\u0001\"\u0004\u0007\u0001\u000b\t!\u0011\u0001C\b\u0006\u0005\u0011a\u0001rD\u0003\u0004\t3Ai\u0002\u0004\u0001\u0006\u0007\u0011\u0015\u0001\u0002\u0005\u0007\u0001\u000b\t!)\u0001\u0003\t\u0006\u0005\u0011Q\u0001bC\u0003\u0003\t-AQ\"\u0002\u0002\u0005\u001a!uQA\u0001\u0003\u0002\u0011\u0015)1\u0001\u0002\t\t#1\u0001Q!\u0001E\u0002\u000b\r!\u0011\u0003\u0003\n\r\u0001\u0011YAb\u0001I\u00133\r)\u0011\u0001c\u0003\u0019\fu\u0005)#\f\r\u0005\u0017a5Qt\u0002\u0003\u0001\u0011\u001di1!B\u0001\t\u000fa9\u0001k\u0001\u0001\"\r\u0015\t\u0001\u0002C\u0005\u0002\t\u0007a\t\u0001\u0007\u0005R\u0007\u0015!i!C\u0001\t\u00125\t\u0001\"C\u0017+\t\u0005A\"\"h\u0004\u0005\u0001!UQbA\u0003\u0002\u0011+A*\u0002U\u0002\u0001;\u001f!\u0001\u0001#\u0007\u000e\u0007\u0015\t\u0001r\u0003M\f!\u000e\u0005Qt\u0002\u0003\u0001\u00119i1!B\u0001\t\u001bai\u0001kA\u0001\"\u0007\u0015\t\u00012\u0004M\u000e#\u000eIAAC\u0005\u0002\u00119i\u0011\u0001#\b\u000e\u0003!yQ\"\u0001E\u0010[m!1\u0001'\t\u001e\u0010\u0011\u0001\u0001RC\u0007\u0004\u000b\u0005A)\u0002'\u0006Q\u0007\u0001\t\u0013\"B\u0001\t\u0011%!\u0011bA\u0003\u0002\u0011CA\n\u0003$\u0001\u0019\u0011E\u001bQ\u0001\"\t\n\u0003!EQ\"\u0001E\u000f[+!1\u0002g\t\"\u0007\u0015\t\u00012\u0005M\u0012#\u000e\u0019A1E\u0005\u0002\t\u000b)D\"B\u0006\u0005G\u0004Ab!I\u0002\u0006\u0003!\u0019\u0001dA)\u0004\u0007\u00111\u0011\"\u0001\u0003\u0001"})
public class KotlinJavaScriptStubBuilder
extends ClsStubBuilder {
    public static final /* synthetic */ KClass $kotlinClass;
    @NotNull
    public static final Logger LOG;
    public static final Companion Companion;

    static {
        $kotlinClass = Reflection.createKotlinClass(KotlinJavaScriptStubBuilder.class);
        Companion companion = Companion = new Companion(null);
        LOG = Logger.getInstance(KotlinJavaScriptStubBuilder.class);
    }

    public int getStubVersion() {
        return ClassFileStubBuilder.STUB_VERSION + 1;
    }

    @Nullable
    public PsiFileStub<?> buildFileStub(@NotNull FileContent content2) {
        VirtualFile file;
        Intrinsics.checkParameterIsNotNull((Object)content2, (String)"content");
        VirtualFile virtualFile = file = content2.getFile();
        Intrinsics.checkExpressionValueIsNotNull((Object)virtualFile, (String)"file");
        if (DecompiledUtilsKt.isKotlinJavaScriptInternalCompiledFile(virtualFile)) {
            return null;
        }
        VirtualFile virtualFile2 = file;
        Intrinsics.checkExpressionValueIsNotNull((Object)virtualFile2, (String)"file");
        return this.doBuildFileStub(virtualFile2);
    }

    /*
     * WARNING - void declaration
     */
    @Nullable
    public final PsiFileStub<JetFile> doBuildFileStub(@NotNull VirtualFile file) {
        NameResolver nameResolver;
        void value2;
        Intrinsics.checkParameterIsNotNull((Object)file, (String)"file");
        FqName packageFqName = JsMetaFileUtils.INSTANCE$.getPackageFqName(file);
        byte[] content2 = file.contentsToByteArray(false);
        boolean isPackageHeader = JsMetaFileUtils.INSTANCE$.isPackageHeader(file);
        VirtualFile moduleDirectory = JsMetaFileUtils.INSTANCE$.getModuleDirectory(file);
        String stringsFileName = KotlinJavascriptSerializedResourcePaths.INSTANCE$.getStringTableFilePath(packageFqName);
        VirtualFile stringsFile = moduleDirectory.findFileByRelativePath(stringsFileName);
        boolean bl = stringsFile != null;
        if (PreconditionsKt.getASSERTIONS_ENABLED() && value2 == false) {
            String message = "strings file not found: " + stringsFileName;
            throw (Throwable)((Object)new AssertionError((Object)message));
        }
        VirtualFile virtualFile = stringsFile;
        if (virtualFile == null) {
            Intrinsics.throwNpe();
        }
        NameResolver nameResolver2 = nameResolver = NameResolver.read(new ByteArrayInputStream(virtualFile.contentsToByteArray(false)));
        Intrinsics.checkExpressionValueIsNotNull((Object)nameResolver2, (String)"nameResolver");
        ClsStubBuilderComponents components = this.createStubBuilderComponents(file, packageFqName, nameResolver2);
        if (isPackageHeader) {
            NameResolver nameResolver3 = nameResolver;
            Intrinsics.checkExpressionValueIsNotNull((Object)nameResolver3, (String)"nameResolver");
            PackageData packageData = JsProtoBufUtilKt.toPackageData(content2, nameResolver3);
            ClsStubBuilderContext context = components.createContext(packageData.getNameResolver(), packageFqName);
            return ClsStubBuildingKt.createPackageFacadeStub(packageData.getPackageProto(), packageFqName, context);
        }
        NameResolver nameResolver4 = nameResolver;
        Intrinsics.checkExpressionValueIsNotNull((Object)nameResolver4, (String)"nameResolver");
        ClassData classData = JsProtoBufUtilKt.toClassData(content2, nameResolver4);
        ClsStubBuilderContext context = components.createContext(classData.getNameResolver(), packageFqName);
        ClassId classId = JsMetaFileUtils.INSTANCE$.getClassId(file);
        return ClsStubBuildingKt.createTopLevelClassStub(classId, classData.getClassProto(), context);
    }

    private final ClsStubBuilderComponents createStubBuilderComponents(VirtualFile file, FqName packageFqName, NameResolver nameResolver) {
        VirtualFile virtualFile = file.getParent();
        if (virtualFile == null) {
            Intrinsics.throwNpe();
        }
        DirectoryBasedKotlinJavaScriptMetaFileFinder metaFileFinder = new DirectoryBasedKotlinJavaScriptMetaFileFinder(virtualFile, packageFqName, nameResolver);
        Logger logger = Companion.getLOG();
        Intrinsics.checkExpressionValueIsNotNull((Object)logger, (String)"LOG");
        DirectoryBasedKotlinJavaScriptDataFinder classDataFinder = new DirectoryBasedKotlinJavaScriptDataFinder(metaFileFinder, logger);
        AnnotationLoaderForKotlinJavaScriptStubBuilder annotationLoader = new AnnotationLoaderForKotlinJavaScriptStubBuilder();
        return new ClsStubBuilderComponents(classDataFinder, annotationLoader);
    }

    @KotlinClass(version={0, 25, 0}, abiVersion=25, data={"4\u0004)I1i\\7qC:LwN\u001c\u0006\u001c\u0017>$H.\u001b8KCZ\f7k\u0019:jaR\u001cF/\u001e2Ck&dG-\u001a:\u000b\u0007=\u0014xMC\u0005kKR\u0014'/Y5og*11n\u001c;mS:TA!\u001b3fC*QA-Z2p[BLG.\u001a:\u000b\u0017M$XO\u0019\"vS2$WM\u001d\u0006\u0004\u0003:L(b\u0001'P\u000f*1Aj\\4hKJT1aY8n\u0015!Ig\u000e^3mY&T'bB8qK:\f\u0007/\u001b\u0006\u000bI&\fwM\\8ti&\u001c'b\u0002(pi:+H\u000e\u001c\u0006\fC:tw\u000e^1uS>t7O\u0003\u0004hKRduj\u00129\u000b\u0005A\u0011!\u0002\u0002\u0005\u0001!\rQA\u0001C\u0001\u0011\t)!\u0001B\u0001\t\u0006\u0015\u0011A1\u0001\u0005\u0004\u000b\t!!\u0001c\u0002\u0006\u0007\u0011\u0015\u0001\u0012\u0001\u0007\u0001\u000b\r!1\u0001\u0003\u0001\r\u0001\u0015\t\u0001BA\u0003\u0004\t\u0011AA\u0001\u0004\u0001\u0006\u0003!-QA\u0001\u0003\u0006\u0011\u0019)!\u0001b\u0003\t\u000e\u0015\u0011AA\u0002\u0005\b\u000b\r!i\u0001C\u0003\r\u0001\u0015\u0011A\u0011\u0001\u0005\t\u000b\r!y\u0001c\u0004\r\u0001\u0015\u0011AQ\u0002\u0005\u0006\t\r\u000fArA\r\u0004\u000b\u0005AI\u0001'\u0003.(\u0011\u0019G\u0001'\u0003\"\f\u0015\t\u0001b\u0002\r\b#\u000e\tA\u0001C+\u0004\u0013\u0015!A\u0011B\u0005\u0002\u0011#a\t!D\u0002\u0005\u0012%\t\u0001\u0012C\u001b\u0001"})
    public static final class Companion {
        public static final /* synthetic */ KClass $kotlinClass;

        static {
            $kotlinClass = Reflection.createKotlinClass(Companion.class);
        }

        @NotNull
        public final Logger getLOG() {
            return LOG;
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

