/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.decompiler.textBuilder;

import com.intellij.openapi.vfs.VirtualFile;
import kotlin.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.KotlinClass;
import kotlin.jvm.internal.Reflection;
import kotlin.reflect.KClass;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.idea.decompiler.DecompiledUtilsKt;
import org.jetbrains.kotlin.idea.decompiler.textBuilder.DirectoryBasedClassFinderKt;
import org.jetbrains.kotlin.load.java.structure.JavaClass;
import org.jetbrains.kotlin.load.kotlin.KotlinBinaryClassCache;
import org.jetbrains.kotlin.load.kotlin.KotlinClassFinder;
import org.jetbrains.kotlin.load.kotlin.KotlinJvmBinaryClass;
import org.jetbrains.kotlin.name.ClassId;
import org.jetbrains.kotlin.name.FqName;

@KotlinClass(version={0, 25, 0}, abiVersion=25, data={"f\u0006)IB)\u001b:fGR|'/\u001f\"bg\u0016$7\t\\1tg\u001aKg\u000eZ3s\u0015\ry'o\u001a\u0006\nU\u0016$(M]1j]NTaa[8uY&t'\u0002B5eK\u0006T!\u0002Z3d_6\u0004\u0018\u000e\\3s\u0015-!X\r\u001f;Ck&dG-\u001a:\u000b#-{G\u000f\\5o\u00072\f7o\u001d$j]\u0012,'O\u0003\u0003m_\u0006$'B\u0002\u001fj]&$hH\u0003\tqC\u000e\\\u0017mZ3ESJ,7\r^8ss*Ya+\u001b:uk\u0006dg)\u001b7f\u0015\r\u0019w.\u001c\u0006\tS:$X\r\u001c7jU*9q\u000e]3oCBL'b\u0001<gg*1B-\u001b:fGR|'/\u001f)bG.\fw-\u001a$r\u001d\u0006lWM\u0003\u0004Gc:\u000bW.\u001a\u0006\u0005]\u0006lWMC\rhKR$\u0015N]3di>\u0014\u0018\u0010U1dW\u0006<WMR9OC6,'bE4fiB\u000b7m[1hK\u0012K'/Z2u_JL(b\u00044j]\u0012\\u\u000e\u001e7j]\u000ec\u0017m]:\u000b\u0013)\fg/Y\"mCN\u001c(\"\u0003&bm\u0006\u001cE.Y:t\u0015\u0011Q\u0017M^1\u000b\u0013M$(/^2ukJ,'\u0002F&pi2LgN\u0013<n\u0005&t\u0017M]=DY\u0006\u001c8OC\u0004dY\u0006\u001c8/\u00133\u000b\u000f\rc\u0017m]:JI2\u000e!B\u0001\t\u0002\u0015\u0011A\u0001\u0001\u0005\u0002\u000b\t!\t\u0001c\u0001\u0006\u0005\u0011\t\u0001BA\u0003\u0003\t\u0007A)!\u0002\u0002\u0005\u0005!\u0019Qa\u0001C\u0003\u0011\u0001a\u0001!\u0002\u0002\u0005\u0003!!QA\u0001C\u0004\u0011\u0007)1\u0001\u0002\u0003\t\b1\u0001Q!\u0001\u0005\u0007\u000b\t!Q\u0001#\u0004\u0006\u0005\u0011-\u0001bB\u0003\u0003\t\u0019Ay!B\u0002\u0005\u000e!-A\u0002A\u0003\u0003\t\u0005A\u0011\"B\u0002\u0005\u0010!EA\u0002A\u0003\u0003\t\u001bAY!\u0002\u0002\u0005\u0010!EQA\u0001C\u0004\u00111)!\u0001b\u0005\t\u001a\u0015\u0019AA\u0003E\f\u0019\u0001)1\u0001\u0002\u0003\t\u001b1\u0001QA\u0001\u0003\u0005\u00115)!\u0001\u0002\u0006\t\u0018\u0015\u0019Aq\u0002\u0005\u000f\u0019\u0001)!\u0001b\u0004\t\u001d\u0011\u0019AbA\r\u0004\u000b\u0005AI\u0001'\u0003.!\u0011\u0019G\u0001\u0007\u0005\"\u0007\u0015\t\u0001\u0002\u0003\r\t+\u000eAQa\u0001\u0003\t\u0013\u0005A\u0011\"D\u0002\u0005\u0014%\t\u0001\"C\u0017\u0011\t\r$\u0001$B\u0011\u0004\u000b\u0005Aq\u0001G\u0004V\u0007!)1\u0001B\u0003\n\u0003!EQb\u0001\u0003\u000b\u0013\u0005A\t\"\f\f\u0005\u0017aUQt\u0002\u0003\u0001\u0011-i1!B\u0001\t\u0016aU\u0001k\u0001\u0001\"\t\u0015\t\u0001b\u0003G\u00011-\t6!\u0002C\u000b\u0013\u0005A9\"D\u0001\t\u001952Ba\u0003M\u000b;\u001f!\u0001\u0001c\u0007\u000e\u0007\u0015\t\u0001\u0012\u0004M\r!\u000e\u0001\u0011\u0005B\u0003\u0002\u0011-a\t\u0001G\u0006R\u0007\u0015!)\"C\u0001\t\u00185\t\u0001\"D\u001b\"\u000b\u0001\"1\u001d\u0001M\u0005;\u001f!\u0001\u0001C\u0003\u000e\u0007\u0015\t\u0001b\u0002\r\b!\u000e\u0001Qt\u0002\u0003\u0001\u0011!i1!B\u0001\t\u0011aA\u0001k!\u0001\"\u0007\u0015\t\u0001b\u0001\r\u0004#\u000e9A\u0011B\u0005\u0002\t\u0001i\u0011\u0001#\u0005\u000e\u0003!I\u0001"})
public final class DirectoryBasedClassFinder
implements KotlinClassFinder {
    public static final /* synthetic */ KClass $kotlinClass;
    @NotNull
    private final VirtualFile packageDirectory;
    @NotNull
    private final FqName directoryPackageFqName;

    static {
        $kotlinClass = Reflection.createKotlinClass(DirectoryBasedClassFinder.class);
    }

    @Override
    @Nullable
    public KotlinJvmBinaryClass findKotlinClass(@NotNull JavaClass javaClass) {
        Intrinsics.checkParameterIsNotNull((Object)javaClass, (String)"javaClass");
        return this.findKotlinClass(DirectoryBasedClassFinderKt.getClassId(javaClass));
    }

    @Override
    @Nullable
    public KotlinJvmBinaryClass findKotlinClass(@NotNull ClassId classId) {
        Intrinsics.checkParameterIsNotNull((Object)classId, (String)"classId");
        if (Intrinsics.areEqual((Object)classId.getPackageFqName(), (Object)this.directoryPackageFqName) ^ true) {
            return null;
        }
        String targetName = CollectionsKt.joinToString$default((Iterable)classId.getRelativeClassName().pathSegments(), (String)"$", null, (String)".class", (int)0, null, null, (int)58);
        VirtualFile virtualFile = this.packageDirectory.findChild(targetName);
        if (virtualFile != null && DecompiledUtilsKt.isKotlinWithCompatibleAbiVersion(virtualFile)) {
            return KotlinBinaryClassCache.getKotlinBinaryClass(virtualFile);
        }
        return null;
    }

    @NotNull
    public final VirtualFile getPackageDirectory() {
        return this.packageDirectory;
    }

    @NotNull
    public final FqName getDirectoryPackageFqName() {
        return this.directoryPackageFqName;
    }

    public DirectoryBasedClassFinder(@NotNull VirtualFile packageDirectory, @NotNull FqName directoryPackageFqName) {
        Intrinsics.checkParameterIsNotNull((Object)packageDirectory, (String)"packageDirectory");
        Intrinsics.checkParameterIsNotNull((Object)directoryPackageFqName, (String)"directoryPackageFqName");
        this.packageDirectory = packageDirectory;
        this.directoryPackageFqName = directoryPackageFqName;
    }
}

