/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.decompiler.textBuilder;

import com.intellij.openapi.diagnostic.Logger;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.KotlinClass;
import kotlin.jvm.internal.Reflection;
import kotlin.reflect.KClass;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.idea.decompiler.textBuilder.DirectoryBasedClassFinder;
import org.jetbrains.kotlin.load.kotlin.KotlinJvmBinaryClass;
import org.jetbrains.kotlin.name.ClassId;
import org.jetbrains.kotlin.serialization.ClassData;
import org.jetbrains.kotlin.serialization.ClassDataWithSource;
import org.jetbrains.kotlin.serialization.deserialization.ClassDataFinder;
import org.jetbrains.kotlin.serialization.jvm.JvmProtoBufUtil;

@KotlinClass(version={0, 25, 0}, abiVersion=25, data={"8\u0006)AB)\u001b:fGR|'/\u001f\"bg\u0016$G)\u0019;b\r&tG-\u001a:\u000b\u0007=\u0014xMC\u0005kKR\u0014'/Y5og*11n\u001c;mS:TA!\u001b3fC*QA-Z2p[BLG.\u001a:\u000b\u0017Q,\u0007\u0010\u001e\"vS2$WM\u001d\u0006\u0010\u00072\f7o\u001d#bi\u00064\u0015N\u001c3fe*i1/\u001a:jC2L'0\u0019;j_:Tq\u0002Z3tKJL\u0017\r\\5{CRLwN\u001c\u0006\u0007y%t\u0017\u000e\u001e \u000b\u0017\rd\u0017m]:GS:$WM\u001d\u0006\u001a\t&\u0014Xm\u0019;pef\u0014\u0015m]3e\u00072\f7o\u001d$j]\u0012,'OC\u0002m_\u001eTa\u0001T8hO\u0016\u0014(bA2p[*A\u0011N\u001c;fY2L'NC\u0004pa\u0016t\u0017\r]5\u000b\u0015\u0011L\u0017m\u001a8pgRL7M\u0003\bhKR\u001cE.Y:t\r&tG-\u001a:\u000b\r\u001d,G\u000fT8h\u001551\u0017N\u001c3DY\u0006\u001c8\u000fR1uC*91\r\\1tg&#'bB\"mCN\u001c\u0018\n\u001a\u0006\u0005]\u0006lWMC\nDY\u0006\u001c8\u000fR1uC^KG\u000f[*pkJ\u001cWMe\u0001\u000b\u0005A\t!\u0002\u0002\u0005\u0001!\tQA\u0001C\u0001\u0011\u0007)!\u0001B\u0001\t\u0005\u0015\u0011A1\u0001E\u0003\u000b\t!!\u0001C\u0002\u0006\u0007\u0011\u0015\u0001\u0002\u0001\u0007\u0001\u000b\t!\u0011\u0001\u0003\u0003\u0006\u0005\u0011\u001d\u0001\u0012B\u0003\u0004\t\u0011A9\u0001\u0004\u0001\u0006\u0007\u0011\u0015\u0001B\u0002\u0007\u0001\u000b\u0005Ay!\u0002\u0002\u0005\f!AQA\u0001\u0003\u0007\u0011#)!\u0001\"\u0004\t\u0013\u0015\u0019Aa\u0002\u0005\b\u0019\u0001)!\u0001\"\u0002\t\r\u0015\u0011Aa\u0002\u0005\b\u000b\t!\u0011\u0001\u0003\u0007\u0006\u0007\u0011I\u0001r\u0003\u0007\u0001\u000b\r!9\u0001#\u0007\r\u0001\u0015\u0011Aq\u0001E\r\u000b\t!\u0011\u0002c\u0006\u0005\u00071\u0019\u0011dA\u0003\u0002\u0011\u0013AJ!\f\t\u0005G\u0012AZ!I\u0002\u0006\u0003!)\u0001$B+\u0004\u0011\u0015\u0019A1B\u0005\u0002\u0011!i1\u0001b\u0005\n\u0003!AQ\u0006\u0005\u0003d\ta5\u0011eA\u0003\u0002\u0011\u001fAz!V\u0002\t\u000b\r!i!C\u0001\t\u00125\u0019AAC\u0005\u0002\u0011#ic\u0003B\u0006\u0019\u0016u=A\u0001\u0001\u0005\f\u001b\r)\u0011\u0001c\u0005\u0019\u0014A\u001b\u0001!\t\u0003\u0006\u0003!QA\u0012\u0001\r\u000b#\u000e)AQC\u0005\u0002\u0011+i\u0011\u0001C\u00066C\u0015\u0001Ca9\u0001\u0019\u000bu=A\u0001\u0001E\u0006\u001b\r)\u0011\u0001C\u0003\u0019\u000bA\u001b\u0001!h\u0004\u0005\u0001!5QbA\u0003\u0002\u0011\u001fAz\u0001UB\u0001C\r)\u0011\u0001C\u0002\u0019\u0007E\u001bq\u0001B\u0003\n\u0003\u0011\u0001Q\"\u0001\u0005\t\u001b\u0005A\t\u0002"})
public final class DirectoryBasedDataFinder
implements ClassDataFinder {
    public static final /* synthetic */ KClass $kotlinClass;
    @NotNull
    private final DirectoryBasedClassFinder classFinder;
    @NotNull
    private final Logger log;

    static {
        $kotlinClass = Reflection.createKotlinClass(DirectoryBasedDataFinder.class);
    }

    @Override
    @Nullable
    public ClassDataWithSource findClassData(@NotNull ClassId classId) {
        Intrinsics.checkParameterIsNotNull((Object)classId, (String)"classId");
        KotlinJvmBinaryClass kotlinJvmBinaryClass = this.classFinder.findKotlinClass(classId);
        if (kotlinJvmBinaryClass == null) {
            return null;
        }
        KotlinJvmBinaryClass binaryClass = kotlinJvmBinaryClass;
        String[] data2 = binaryClass.getClassHeader().getAnnotationData();
        if (data2 == null) {
            this.log.error("Annotation data missing for " + binaryClass.getClassId());
            return null;
        }
        ClassData classData = JvmProtoBufUtil.readClassDataFrom(data2);
        return new ClassDataWithSource(classData, null, 2, null);
    }

    @NotNull
    public final DirectoryBasedClassFinder getClassFinder() {
        return this.classFinder;
    }

    @NotNull
    public final Logger getLog() {
        return this.log;
    }

    public DirectoryBasedDataFinder(@NotNull DirectoryBasedClassFinder classFinder, @NotNull Logger log) {
        Intrinsics.checkParameterIsNotNull((Object)classFinder, (String)"classFinder");
        Intrinsics.checkParameterIsNotNull((Object)log, (String)"log");
        this.classFinder = classFinder;
        this.log = log;
    }
}

