/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.editor;

import com.intellij.codeInsight.editorActions.JavaBackspaceHandler;
import com.intellij.codeInsight.editorActions.JavaTypedHandler;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.ex.EditorEx;
import com.intellij.openapi.editor.highlighter.HighlighterIterator;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.tree.TokenSet;
import org.jetbrains.kotlin.lexer.JetTokens;

final class JetLtGtTypingUtils {
    private static final TokenSet INVALID_INSIDE_REFERENCE = TokenSet.create((IElementType[])new IElementType[]{JetTokens.SEMICOLON, JetTokens.LBRACE, JetTokens.RBRACE});

    private JetLtGtTypingUtils() {
    }

    static void handleJetAutoCloseLT(Editor editor) {
        JavaTypedHandler.handleAfterJavaLT((Editor)editor, (IElementType)JetTokens.LT, (IElementType)JetTokens.GT, (TokenSet)INVALID_INSIDE_REFERENCE);
    }

    static boolean handleJetGTInsert(Editor editor) {
        return JavaTypedHandler.handleJavaGT((Editor)editor, (IElementType)JetTokens.LT, (IElementType)JetTokens.GT, (TokenSet)INVALID_INSIDE_REFERENCE);
    }

    static void handleJetLTDeletion(Editor editor, int offset2) {
        JavaBackspaceHandler.handleLTDeletion((Editor)editor, (int)offset2, (IElementType)JetTokens.LT, (IElementType)JetTokens.GT, (TokenSet)INVALID_INSIDE_REFERENCE);
    }

    static boolean shouldAutoCloseAngleBracket(int offset2, Editor editor) {
        return JetLtGtTypingUtils.isAfterClassIdentifier(offset2, editor) || JetLtGtTypingUtils.isAfterFunKeyword(offset2, editor);
    }

    private static boolean isAfterClassIdentifier(int offset2, Editor editor) {
        HighlighterIterator iterator2 = ((EditorEx)editor).getHighlighter().createIterator(offset2);
        if (iterator2.atEnd()) {
            return false;
        }
        if (iterator2.getStart() > 0) {
            iterator2.retreat();
        }
        return JavaTypedHandler.isClassLikeIdentifier((int)offset2, (Editor)editor, (HighlighterIterator)iterator2, (IElementType)JetTokens.IDENTIFIER);
    }

    private static boolean isAfterFunKeyword(int offset2, Editor editor) {
        HighlighterIterator iterator2 = ((EditorEx)editor).getHighlighter().createIterator(offset2);
        if (iterator2.atEnd()) {
            return false;
        }
        if (iterator2.getStart() > 0) {
            iterator2.retreat();
        }
        if (iterator2.getTokenType() == JetTokens.WHITE_SPACE && iterator2.getStart() > 0) {
            iterator2.retreat();
        }
        return iterator2.getTokenType() == JetTokens.FUN_KEYWORD;
    }
}

