/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.findUsages.dialogs;

import com.intellij.find.FindBundle;
import com.intellij.find.findUsages.FindClassUsagesDialog;
import com.intellij.find.findUsages.FindUsagesHandler;
import com.intellij.find.findUsages.FindUsagesOptions;
import com.intellij.find.findUsages.JavaClassFindUsagesOptions;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.ui.SimpleColoredComponent;
import com.intellij.ui.StateRestoringCheckBox;
import javax.swing.JPanel;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.asJava.AsJavaPackage;
import org.jetbrains.kotlin.asJava.LightClassUtil;
import org.jetbrains.kotlin.idea.JetBundle;
import org.jetbrains.kotlin.idea.findUsages.KotlinClassFindUsagesOptions;
import org.jetbrains.kotlin.idea.findUsages.dialogs.Utils;
import org.jetbrains.kotlin.idea.refactoring.JetRefactoringUtil;
import org.jetbrains.kotlin.psi.JetClass;
import org.jetbrains.kotlin.psi.JetClassOrObject;
import org.jetbrains.kotlin.psi.psiUtil.PsiUtilPackage;

public class KotlinFindClassUsagesDialog
extends FindClassUsagesDialog {
    private StateRestoringCheckBox constructorUsages;
    private StateRestoringCheckBox derivedClasses;
    private StateRestoringCheckBox derivedTraits;
    private static final Key<JetClassOrObject> ORIGINAL_CLASS = Key.create((String)"ORIGINAL_CLASS");

    public KotlinFindClassUsagesDialog(JetClassOrObject classOrObject, Project project, FindUsagesOptions findUsagesOptions, boolean toShowInNewTab, boolean mustOpenInNewTab, boolean isSingleFile, FindUsagesHandler handler2) {
        super((PsiElement)KotlinFindClassUsagesDialog.getRepresentingPsiClass(classOrObject), project, findUsagesOptions, toShowInNewTab, mustOpenInNewTab, isSingleFile, handler2);
    }

    @NotNull
    private static PsiClass getRepresentingPsiClass(@NotNull JetClassOrObject classOrObject) {
        JetClass klass;
        if (classOrObject == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "classOrObject", "org/jetbrains/kotlin/idea/findUsages/dialogs/KotlinFindClassUsagesDialog", "getRepresentingPsiClass"));
        }
        PsiClass lightClass2 = LightClassUtil.INSTANCE$.getPsiClass(classOrObject);
        if (lightClass2 != null) {
            PsiClass psiClass = lightClass2;
            if (psiClass == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/idea/findUsages/dialogs/KotlinFindClassUsagesDialog", "getRepresentingPsiClass"));
            }
            return psiClass;
        }
        PsiElementFactory factory2 = PsiElementFactory.SERVICE.getInstance((Project)classOrObject.getProject());
        String name2 = classOrObject.getName();
        if (name2 == null || name2.isEmpty()) {
            name2 = "Anonymous";
        }
        PsiClass javaClass = classOrObject instanceof JetClass ? (!(klass = (JetClass)classOrObject).isInterface() ? factory2.createClass(name2) : (klass.isAnnotation() ? factory2.createAnnotationType(name2) : factory2.createInterface(name2))) : factory2.createClass(name2);
        javaClass.getModifierList().setModifierProperty("final", !(classOrObject instanceof JetClass) || !PsiUtilPackage.isInheritable((JetClass)classOrObject));
        javaClass.putUserData(ORIGINAL_CLASS, (Object)classOrObject);
        PsiClass psiClass = javaClass;
        if (psiClass == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/idea/findUsages/dialogs/KotlinFindClassUsagesDialog", "getRepresentingPsiClass"));
        }
        return psiClass;
    }

    protected JPanel createFindWhatPanel() {
        JPanel findWhatPanel = super.createFindWhatPanel();
        assert (findWhatPanel != null);
        Utils.renameCheckbox(findWhatPanel, FindBundle.message((String)"find.what.methods.usages.checkbox", (Object[])new Object[0]), JetBundle.message("find.what.functions.usages.checkbox", new Object[0]));
        Utils.renameCheckbox(findWhatPanel, FindBundle.message((String)"find.what.fields.usages.checkbox", (Object[])new Object[0]), JetBundle.message("find.what.properties.usages.checkbox", new Object[0]));
        Utils.removeCheckbox(findWhatPanel, FindBundle.message((String)"find.what.implementing.classes.checkbox", (Object[])new Object[0]));
        Utils.removeCheckbox(findWhatPanel, FindBundle.message((String)"find.what.derived.interfaces.checkbox", (Object[])new Object[0]));
        Utils.removeCheckbox(findWhatPanel, FindBundle.message((String)"find.what.derived.classes.checkbox", (Object[])new Object[0]));
        this.derivedClasses = this.addCheckboxToPanel(JetBundle.message("find.what.derived.classes.checkbox", new Object[0]), this.getFindUsagesOptions().isDerivedClasses, findWhatPanel, true);
        this.derivedTraits = this.addCheckboxToPanel(JetBundle.message("find.what.derived.interfaces.checkbox", new Object[0]), this.getFindUsagesOptions().isDerivedInterfaces, findWhatPanel, true);
        this.constructorUsages = this.addCheckboxToPanel(JetBundle.message("find.what.constructor.usages.checkbox", new Object[0]), this.getFindUsagesOptions().getSearchConstructorUsages(), findWhatPanel, true);
        return findWhatPanel;
    }

    @NotNull
    protected KotlinClassFindUsagesOptions getFindUsagesOptions() {
        KotlinClassFindUsagesOptions kotlinClassFindUsagesOptions = (KotlinClassFindUsagesOptions)super.getFindUsagesOptions();
        if (kotlinClassFindUsagesOptions == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/idea/findUsages/dialogs/KotlinFindClassUsagesDialog", "getFindUsagesOptions"));
        }
        return kotlinClassFindUsagesOptions;
    }

    public void configureLabelComponent(@NotNull SimpleColoredComponent coloredComponent) {
        JetClassOrObject originalClass;
        if (coloredComponent == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "coloredComponent", "org/jetbrains/kotlin/idea/findUsages/dialogs/KotlinFindClassUsagesDialog", "configureLabelComponent"));
        }
        PsiElement klass = AsJavaPackage.getUnwrapped(this.getPsiElement());
        JetClassOrObject jetClassOrObject = originalClass = klass instanceof JetClassOrObject ? (JetClassOrObject)klass : (JetClassOrObject)klass.getUserData(ORIGINAL_CLASS);
        if (originalClass != null) {
            coloredComponent.append(JetRefactoringUtil.formatClass(originalClass));
        }
    }

    protected void update() {
        super.update();
        if (!this.isOKActionEnabled() && (this.constructorUsages.isSelected() || this.derivedTraits.isSelected() || this.derivedClasses.isSelected())) {
            this.setOKActionEnabled(true);
        }
    }

    public void calcFindUsagesOptions(JavaClassFindUsagesOptions options) {
        super.calcFindUsagesOptions(options);
        KotlinClassFindUsagesOptions kotlinOptions = (KotlinClassFindUsagesOptions)options;
        kotlinOptions.setSearchConstructorUsages(this.constructorUsages.isSelected());
        kotlinOptions.isDerivedClasses = this.derivedClasses.isSelected();
        kotlinOptions.isDerivedInterfaces = this.derivedTraits.isSelected();
    }
}

