/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.framework;

import com.intellij.openapi.roots.OrderRootType;
import com.intellij.openapi.roots.libraries.Library;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.Processor;
import java.util.List;
import kotlin.ArraysKt;
import kotlin.StringsKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.KotlinClass;
import kotlin.jvm.internal.Reflection;
import kotlin.reflect.KClass;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.idea.caches.JarUserDataManager;
import org.jetbrains.kotlin.idea.framework.JavaRuntimeDetectionUtil;
import org.jetbrains.kotlin.js.JavaScript;
import org.jetbrains.kotlin.utils.KotlinJavascriptMetadataUtils;

@KotlinClass(version={0, 25, 0}, abiVersion=25, data={"\u001d\u0006)!3j\u001c;mS:T\u0015M^1TGJL\u0007\u000f\u001e'jEJ\f'/\u001f#fi\u0016\u001cG/[8o+RLGNC\u0002pe\u001eT\u0011B[3uEJ\f\u0017N\\:\u000b\r-|G\u000f\\5o\u0015\u0011IG-Z1\u000b\u0013\u0019\u0014\u0018-\\3x_J\\'bA!os*!\u0012n\u001d&t\r&dWmV5uQ6+G/\u00193bi\u0006TAAZ5mK*Ya+\u001b:uk\u0006dg)\u001b7f\u0015\r\u0019w.\u001c\u0006\tS:$X\r\u001c7jU*9q\u000e]3oCBL'b\u0001<gg*9!i\\8mK\u0006t'\"G5t\u0017>$H.\u001b8KCZ\f7k\u0019:jaRd\u0015N\u0019:befTq\u0001\\5ce\u0006\u0014\u0018PC\u0004MS\n\u0014\u0018M]=\u000b\u000bI|w\u000e^:\u000b\u00131L'M]1sS\u0016\u001c(\u0002D2mCN\u001cXm\u001d*p_R\u001c(\u0002\u0002'jgRTAA[1wC*!Q\u000f^5m\u0015aA\u0015m]&pi2LgNS*NKR\fG-\u0019;b\u0013:T\u0015M\u001dH\u0002\u0015\t\u0001\u0012A\u0003\u0003\t\u0001A\u0011!\u0002\u0002\u0005\u0002!\rQA\u0001\u0003\u0002\u0011\t)!\u0001b\u0001\t\u0006\u0015\u0019AA\u0001\u0005\u0001\u0019\u0001)\u0011\u0001c\u0001\u0006\u0007\u0011\u0019\u0001b\u0001\u0007\u0001\u000b\u0005AQ!\u0002\u0002\u0005\t!-QA\u0001C\u0005\u0011\u0019)!\u0001B\u0003\t\u000e\u0015\u0019A1\u0002E\u0005\u0019\u0001)1\u0001B\u0002\t\u000f1\u0001QA\u0001C\u0006\u0011\u0013)!\u0001B\u0003\t\u0013\u0015\u0011Aq\u0002E\n\u000b\r!\u0001\u0002#\u0005\r\u0001\u0015\u0011A\u0001\u0003E\t\u000b\r!1\u0001#\u0006\r\u0001\u0015\t\u0001bC\u0003\u0003\t)A9\"\u0002\u0002\u0005\u0016!UAaY\u0001\r\u0006e\u0019Q!\u0001E\u00041\u000fi\n\u0001D\u0017\u0016\t\u0005A:!h\u0004\u0005\u0001!!QbA\u0003\u0002\u0011\u0019Ab\u0001U\u0002\u0001C\r)\u0011\u0001#\u0004\u0019\u000eE\u001bQ\u0001b\u0002\n\u0003\u0011\u0005Q\"\u0001\u0005\b[U!9\u0001g\u0004\u001e\u0010\u0011\u0001\u0001\u0002C\u0007\u0004\u000b\u0005A\t\u0002'\u0005Q\u0007\u0001\t3!B\u0001\t\u000ea5\u0011kA\u0003\u0005\u0010%\tA\u0011A\u0007\u0002\u0011%i#\u0004b\u0002\u0019\u0010ueA\u0001\u0001\u0005\u000b\u001b!)\u0011\u0001c\u0005\n\t%\u0019Q!\u0001\u0005\u00071\u0019A\u001a\u0002U\u0002\u0001C\r)\u0011\u0001#\u0004\u0019\u000eE\u001bQ\u0001b\u0004\n\u0003\u0011\u0005Q\"\u0001\u0005\fk\u0001\u0001"})
public final class KotlinJavaScriptLibraryDetectionUtil {
    public static final /* synthetic */ KClass $kotlinClass;
    public static final KotlinJavaScriptLibraryDetectionUtil INSTANCE$;

    static {
        $kotlinClass = Reflection.createKotlinClass(KotlinJavaScriptLibraryDetectionUtil.class);
        new KotlinJavaScriptLibraryDetectionUtil();
    }

    @JvmStatic
    public static final boolean isKotlinJavaScriptLibrary(@NotNull Library library) {
        Intrinsics.checkParameterIsNotNull((Object)library, (String)"library");
        return KotlinJavaScriptLibraryDetectionUtil.isKotlinJavaScriptLibrary(ArraysKt.toList((Object[])library.getFiles(OrderRootType.CLASSES)));
    }

    @JvmStatic
    public static final boolean isKotlinJavaScriptLibrary(@NotNull List<? extends VirtualFile> classesRoots) {
        Intrinsics.checkParameterIsNotNull(classesRoots, (String)"classesRoots");
        if (JavaRuntimeDetectionUtil.getJavaRuntimeVersion(classesRoots) != null) {
            return false;
        }
        Iterable $receiver = classesRoots;
        for (Object element2 : $receiver) {
            VirtualFile root = (VirtualFile)element2;
            Boolean hasMetadata = HasKotlinJSMetadataInJar.INSTANCE$.hasMetadataFromCache(root);
            if (hasMetadata != null) {
                return hasMetadata;
            }
            if (VfsUtilCore.processFilesRecursively((VirtualFile)root, (Processor)((Processor)new Processor<VirtualFile>(root){
                final /* synthetic */ VirtualFile $root;

                public final boolean process(VirtualFile it) {
                    return KotlinJavaScriptLibraryDetectionUtil.access$isJsFileWithMetadata$0(KotlinJavaScriptLibraryDetectionUtil.INSTANCE$, this.$root);
                }
                {
                    this.$root = virtualFile;
                }
            }))) continue;
            return true;
        }
        return false;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final boolean isJsFileWithMetadata(VirtualFile file) {
        if (file.isDirectory()) return false;
        if (!Intrinsics.areEqual((Object)JavaScript.INSTANCE$.getEXTENSION(), (Object)file.getExtension())) return false;
        byte[] byArray = file.contentsToByteArray(false);
        Intrinsics.checkExpressionValueIsNotNull((Object)byArray, (String)"file.contentsToByteArray(false)");
        if (!KotlinJavascriptMetadataUtils.hasMetadata(StringsKt.String((byte[])byArray))) return false;
        return true;
    }

    KotlinJavaScriptLibraryDetectionUtil() {
        INSTANCE$ = this;
    }

    @KotlinClass(version={0, 25, 0}, abiVersion=25, data={"\u000f\u0006)A\u0002*Y:L_Rd\u0017N\u001c&T\u001b\u0016$\u0018\rZ1uC&s'*\u0019:\u000bI-{G\u000f\\5o\u0015\u00064\u0018mU2sSB$H*\u001b2sCJLH)\u001a;fGRLwN\\+uS2T1a\u001c:h\u0015%QW\r\u001e2sC&t7O\u0003\u0004l_Rd\u0017N\u001c\u0006\u0005S\u0012,\u0017MC\u0005ge\u0006lWm^8sW*I\"*\u0019:C_>dW-\u00198Qe>\u0004XM\u001d;z\u0007>,h\u000e^3s\u0015IQ\u0015M]+tKJ$\u0015\r^1NC:\fw-\u001a:\u000b\r\r\f7\r[3t\u0015QA\u0017m]'fi\u0006$\u0017\r^1Ge>l7)Y2iK*!!o\\8u\u0015-1\u0016N\u001d;vC24\u0015\u000e\\3\u000b\u0007\r|WN\u0003\u0005j]R,G\u000e\\5k\u0015\u001dy\u0007/\u001a8ba&T1A\u001e4t\u0015\u001d\u0011un\u001c7fC:TAA[1wC*!A.\u00198h\u0015-A\u0017m\u001d)s_B,'\u000f^=\u000b\t\u0019LG.\u001aB\u0002\u0015\t\u0001\"A\u0003\u0003\t\u0001A\u0019!\u0002\u0002\u0005\u0002!\u0011QA\u0001\u0003\u0002\u0011\u000b)!\u0001b\u0001\t\u0007\u0015\u0019AA\u0001E\u0001\u0019\u0001)1\u0001\"\u0002\t\u00011\u0001QA\u0001C\u0002\u0011\u0013)1\u0001b\u0002\t\t1\u0001Qa\u0001\u0003\u0005\u0011\u000fa\u0001!B\u0001\t\u000e\u0015\u0011A!\u0002\u0005\b\u000b\t!Y\u0001c\u0004\u0006\u0005\u00111\u0001\u0002C\u0003\u0004\t\u001bAa\u0001\u0004\u0001\u0006\u0003!\u0011Qa\u0001C\b\u0011#a\u0001!B\u0001\t\u0013\u0015\u0011A\u0011\u0003E\n\u000b\t!\u0011\u0002#\u0005\u0006\u0005\u00115\u0001B\u0002\u0003d\u00031\u0019\u0011dA\u0003\u0002\u0011\u0013AJ!\f\f\u0005\u0007a)Qt\u0002\u0003\u0001\u0011\u0017i1!B\u0001\t\u000fa9\u0001k\u0001\u0001\"\t\u0015\t\u0001\u0002\u0003G\u00011!\t6!\u0002\u0003\u0006\u0013\u0005A\u0019\"D\u0001\t\u00155*Ba\u0003\r\u000b;\u001f!\u0001\u0001#\u0006\u000e\u0007\u0015\t\u0001b\u0002\r\b!\u000e\u0001\u0011eA\u0003\u0002\u0011!A\u0002\"U\u0002\u0006\t)I\u0011\u0001\"\u0001\u000e\u0003!QQ\u0007\u0001"})
    public static final class HasKotlinJSMetadataInJar
    extends JarUserDataManager.JarBooleanPropertyCounter {
        public static final /* synthetic */ KClass $kotlinClass;
        public static final HasKotlinJSMetadataInJar INSTANCE$;

        static {
            $kotlinClass = Reflection.createKotlinClass(HasKotlinJSMetadataInJar.class);
            new HasKotlinJSMetadataInJar();
        }

        @Override
        public boolean hasProperty(@NotNull VirtualFile file) {
            Intrinsics.checkParameterIsNotNull((Object)file, (String)"file");
            return INSTANCE$.isJsFileWithMetadata(file);
        }

        @Nullable
        public final Boolean hasMetadataFromCache(@NotNull VirtualFile root) {
            Intrinsics.checkParameterIsNotNull((Object)root, (String)"root");
            return JarUserDataManager.INSTANCE$.hasFileWithProperty(INSTANCE$, root);
        }

        HasKotlinJSMetadataInJar() {
            String string = $kotlinClass.getSimpleName();
            if (string == null) {
                Intrinsics.throwNpe();
            }
            super(string);
            INSTANCE$ = this;
        }
    }
}

