/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.inspections;

import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiAnnotation;
import com.intellij.psi.PsiAnnotationMemberValue;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiJavaFile;
import com.intellij.psi.PsiLiteral;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiReference;
import com.intellij.psi.codeStyle.JavaCodeStyleManager;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.KotlinClass;
import kotlin.jvm.internal.Reflection;
import kotlin.reflect.KClass;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.idea.inspections.DeprecatedFacadeUsageInspectionKt;
import org.jetbrains.kotlin.idea.search.SearchUtilKt;
import org.jetbrains.kotlin.load.java.JvmAnnotationNames;

@KotlinClass(version={0, 25, 0}, abiVersion=25, data={"r\u0004)AB)\u001a9sK\u000e\fG/\u001a3GC\u000e\fG-Z+tC\u001e,g)\u001b=\u000b\u0007=\u0014xMC\u0005kKR\u0014'/Y5og*11n\u001c;mS:TA!\u001b3fC*Y\u0011N\\:qK\u000e$\u0018n\u001c8t\u00155aunY1m#VL7m\u001b$jq*\u00191m\\7\u000b\u0011%tG/\u001a7mS*TabY8eK&s7\u000f]3di&|gN\u0003\u0004=S:LGO\u0010\u0006\tCB\u0004H.\u001f$jq*9\u0001O]8kK\u000e$(b\u0002)s_*,7\r\u001e\u0006\b_B,g.\u00199j\u0015)!Wm]2sSB$xN\u001d\u0006\u0012!J|'\r\\3n\t\u0016\u001c8M]5qi>\u0014(\u0002B+oSRTQbZ3u\r\u0006l\u0017\u000e\\=OC6,'BB*ue&twM\u0003\u0003kCZ\f'\u0002\u00027b]\u001eTqaZ3u\u001d\u0006lW\rc\u0001\u000b\u0005A\t!\u0002\u0002\u0005\u0001!\tQA\u0001C\u0001\u0011\u0007)!\u0001B\u0001\t\u0005\u0015\u0011A1\u0001E\u0003\u000b\r!!\u0001\u0003\u0001\r\u0001\u0015\t\u0001rA\u0003\u0003\t\rAA!\u0002\u0002\u0005\b!%Qa\u0001\u0003\u0005\u0011\ra\u0001!\u0002\u0002\u0005\b!9QA\u0001\u0003\u0006\u0011\u0019)1\u0001b\u0003\t\u000e1\u0001Qa\u0001\u0003\u0005\u0011!a\u0001!B\u0001\t\u0004\u0015\u0019Aa\u0002E\t\u0019\u0001)!\u0001b\u0003\t\u000e\u0015\u0011A\u0001\u0002\u0005\t\u000b\r!q\u0001c\u0005\r\u0001\u0015\t\u0001BC\u0003\u0003\t'A)\"\u0002\u0002\u0005\u0015!MAa\u0001G\u00033\r)\u0011\u0001#\u0003\u0019\n5~Ba\u0003M\u0006;\u001f!\u0001\u0001\u0003\u0004\u000e\u0007\u0015\t\u0001B\u0002\r\u0007!\u000e\u0001Qt\u0002\u0003\u0001\u0011\u001fi1!B\u0001\t\u000ea5\u0001k!\u0001\"\u0007\u0015\t\u0001r\u0002M\b#\u000e9A1B\u0005\u0002\t\u0001i\u0011\u0001\u0003\u0005\u000e\u0003!EQV\u0003\u0003\f1%\t3!B\u0001\t\u0013aI\u0011kA\u0002\u0005\u0013%\t\u0001RCW\u000b\t-A2\"I\u0002\u0006\u0003!I\u0001$C)\u0004\u0007\u0011Y\u0011\"\u0001E\u000bk1)1\u0002Br\u00011\u0015\t3!B\u0001\t\u0006a\u0015\u0011kA\u0002\u0005\u000b%\tA\u0001\u0001"})
public final class DeprecatedFacadeUsageFix
implements LocalQuickFix {
    public static final /* synthetic */ KClass $kotlinClass;

    static {
        $kotlinClass = Reflection.createKotlinClass(DeprecatedFacadeUsageFix.class);
    }

    @NotNull
    public String getName() {
        return "Replace with new-style facade class";
    }

    @NotNull
    public String getFamilyName() {
        return this.getName();
    }

    public void applyFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor2) {
        PsiJavaFile javaFile;
        Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
        Intrinsics.checkParameterIsNotNull((Object)descriptor2, (String)"descriptor");
        PsiReference psiReference = descriptor2.getPsiElement().getReference();
        if (psiReference == null) {
            return;
        }
        PsiReference reference = psiReference;
        PsiElement psiElement2 = reference.resolve();
        if (!(psiElement2 instanceof PsiMethod)) {
            psiElement2 = null;
        }
        PsiMethod psiMethod = (PsiMethod)psiElement2;
        if (psiMethod == null) {
            return;
        }
        PsiMethod resolveResult = psiMethod;
        PsiAnnotation psiAnnotation = DeprecatedFacadeUsageInspectionKt.findDelegatedMethodAnnotation(resolveResult);
        if (psiAnnotation == null) {
            return;
        }
        PsiAnnotation delegatedMethod = psiAnnotation;
        PsiAnnotationMemberValue attr = delegatedMethod.findAttributeValue(JvmAnnotationNames.IMPLEMENTATION_CLASS_NAME_FIELD_NAME);
        PsiAnnotationMemberValue psiAnnotationMemberValue = attr;
        if (!(psiAnnotationMemberValue instanceof PsiLiteral)) {
            psiAnnotationMemberValue = null;
        }
        PsiLiteral psiLiteral = (PsiLiteral)psiAnnotationMemberValue;
        Object object = psiLiteral != null ? psiLiteral.getValue() : null;
        if (!(object instanceof String)) {
            object = null;
        }
        String string = (String)object;
        if (string == null) {
            return;
        }
        String targetClassName = string;
        PsiClass psiClass = JavaPsiFacade.getInstance((Project)project).findClass(targetClassName, SearchUtilKt.allScope(project));
        if (psiClass == null) {
            return;
        }
        PsiClass targetClass = psiClass;
        PsiMethod psiMethod2 = targetClass.findMethodBySignature(resolveResult, false);
        if (psiMethod2 == null) {
            return;
        }
        PsiMethod targetMethod = psiMethod2;
        PsiElement newReference = reference.bindToElement((PsiElement)targetMethod);
        JavaCodeStyleManager.getInstance((Project)project).shortenClassReferences(newReference);
        PsiFile psiFile = newReference.getContainingFile();
        if (!(psiFile instanceof PsiJavaFile)) {
            psiFile = null;
        }
        if ((javaFile = (PsiJavaFile)psiFile) != null) {
            JavaCodeStyleManager.getInstance((Project)project).removeRedundantImports(javaFile);
        }
    }
}

