/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.intentions;

import com.intellij.openapi.editor.Editor;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiWhiteSpace;
import kotlin.TypeCastException;
import kotlin.Unit;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.KotlinClass;
import kotlin.jvm.internal.Reflection;
import kotlin.reflect.KClass;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.idea.intentions.JetSelfTargetingIntention;
import org.jetbrains.kotlin.idea.intentions.UtilsKt;
import org.jetbrains.kotlin.psi.JetBlockExpression;
import org.jetbrains.kotlin.psi.JetContainerNode;
import org.jetbrains.kotlin.psi.JetDoWhileExpression;
import org.jetbrains.kotlin.psi.JetExpression;
import org.jetbrains.kotlin.psi.JetForExpression;
import org.jetbrains.kotlin.psi.JetIfExpression;
import org.jetbrains.kotlin.psi.JetPsiFactory;
import org.jetbrains.kotlin.psi.JetPsiFactoryKt;
import org.jetbrains.kotlin.psi.JetWhileExpression;
import org.jetbrains.kotlin.psi.psiUtil.PsiUtilsKt;

@KotlinClass(version={0, 25, 0}, abiVersion=25, data={"\u0005\u0006)\u0011\u0012\t\u001a3Ce\u0006\u001cWm]%oi\u0016tG/[8o\u0015\ry'o\u001a\u0006\nU\u0016$(M]1j]NTaa[8uY&t'\u0002B5eK\u0006T!\"\u001b8uK:$\u0018n\u001c8t\u0015eQU\r^*fY\u001a$\u0016M]4fi&tw-\u00138uK:$\u0018n\u001c8\u000b\u001b)+G/\u0012=qe\u0016\u001c8/[8o\u0015\r\u00018/\u001b\u0006\u0007y%t\u0017\u000e\u001e \u000b\u000f\u0005\u0004\b\u000f\\=U_*9Q\r\\3nK:$(BB3eSR|'O\u0003\u0004FI&$xN\u001d\u0006\u0004G>l'\u0002C5oi\u0016dG.\u001b6\u000b\u000f=\u0004XM\\1qS*!QK\\5u\u00159I7/\u00119qY&\u001c\u0017M\u00197f)>T1bY1sKR|eMZ:fi*\u0019\u0011J\u001c;\u000b\u000f\t{w\u000e\\3b]*\u0019r-\u001a;UCJ<W\r^#yaJ,7o]5p]*i1-\u0019:fi2{7-\u0019;j_:\u0004\u0019A\u0003\u0002\u0011\u0003)!\u0001\u0002\u0001\t\u0003\u0015\u0011A\u0011\u0001E\u0002\u000b\t!\u0011\u0001\u0003\u0002\u0006\u0005\u0011\r\u0001RA\u0003\u0004\t\tA\u0001\u0001\u0004\u0001\u0006\u0007\u0011\u0011\u0001b\u0001\u0007\u0001\u000b\t!\u0011\u0001\u0003\u0003\u0006\u0007\u0011\u001d\u0001r\u0001\u0007\u0001\u000b\u0005Aq!\u0002\u0002\u0005\n!=QA\u0001\u0003\u0006\u0011!)!\u0001b\u0003\t\r\u0015\u0019AA\u0002E\u0007\u0019\u0001)\u0011\u0001c\u0001\u0006\u0007\u00119\u0001\u0012\u0003\u0007\u0001\u000b\t!9\u0001c\u0002\u0006\u0005\u00111\u0001RB\u0003\u0004\t\u001dA!\u0002\u0004\u0001\u0006\u0007\u00119\u0001R\u0003\u0007\u0001\t\ra)!\u0007\u0005\u0006\u0003!\u0019\u0011\u0002B\u0005\u0004\u000b\u0005AA\u0001\u0007\u0003\u0019\u00075~Ba\u0003\r\u0006;\u001f!\u0001\u0001c\u0003\u000e\u0007\u0015\t\u0001\u0002\u0002\r\u0005!\u000e\u0001Qt\u0002\u0003\u0001\u0011\u0019i1!B\u0001\t\u000ea5\u0001k!\u0001\"\u0007\u0015\t\u0001r\u0002M\b#\u000e9A!B\u0005\u0002\t\u0001i\u0011\u0001\u0003\u0005\u000e\u0003!EQv\b\u0003\f1%iz\u0001\u0002\u0001\t\f5\u0019Q!\u0001\u0005\u00051\u0011\u00016\u0001AO\b\t\u0001A\u0019\"D\u0002\u0006\u0003!I\u0001$\u0003)\u0004\u0002\u0005\u001aQ!\u0001E\n1'\t6a\u0002\u0003\n\u0013\u0005!\t!D\u0001\t\u00115\tAQA\u0017\u001d\t\u0005)2!B\u0001\t\ta!\u0001dCO\b\t\u0001A9\"D\u0002\u0006\u0003!I\u0001$\u0003)\u0004\u0002\u0005\"Q!\u0001\u0005\u0005\u0019\u0003AB!U\u0002\b\t-I\u0011\u0001\u0003\u0005\u000e\u0003!AQ\"\u0001C\u0003k1)1\u0002Br\u00011\u0013\t3!B\u0001\t\u0006a\u0015\u0011kA\u0002\u0005\n%\tA\u0001\u0001"})
public final class AddBracesIntention
extends JetSelfTargetingIntention<JetExpression> {
    public static final /* synthetic */ KClass $kotlinClass;

    static {
        $kotlinClass = Reflection.createKotlinClass(AddBracesIntention.class);
    }

    @Override
    public boolean isApplicableTo(@NotNull JetExpression element2, int caretOffset) {
        Intrinsics.checkParameterIsNotNull((Object)element2, (String)"element");
        JetExpression jetExpression = this.getTargetExpression(element2, caretOffset);
        if (jetExpression == null) {
            return false;
        }
        JetExpression expression2 = jetExpression;
        if (expression2 instanceof JetBlockExpression) {
            return false;
        }
        PsiElement psiElement2 = expression2.getParent();
        if (psiElement2 == null) {
            throw new TypeCastException("null cannot be cast to non-null type org.jetbrains.kotlin.psi.JetContainerNode");
        }
        String string = UtilsKt.description((JetContainerNode)psiElement2);
        if (string == null) {
            Intrinsics.throwNpe();
        }
        String description = string;
        this.setText("Add braces to '" + description + "' statement");
        return true;
    }

    @Override
    public void applyTo(@NotNull JetExpression element2, @NotNull Editor editor) {
        Intrinsics.checkParameterIsNotNull((Object)element2, (String)"element");
        Intrinsics.checkParameterIsNotNull((Object)editor, (String)"editor");
        JetExpression jetExpression = this.getTargetExpression(element2, editor.getCaretModel().getOffset());
        if (jetExpression == null) {
            Intrinsics.throwNpe();
        }
        JetExpression expression2 = jetExpression;
        PsiElement psiElement2 = element2.getNextSibling();
        if (Intrinsics.areEqual((Object)(psiElement2 != null ? psiElement2.getText() : null), (Object)";")) {
            PsiElement psiElement3 = element2.getNextSibling();
            if (psiElement3 == null) {
                Intrinsics.throwNpe();
            }
            psiElement3.delete();
        }
        JetPsiFactory psiFactory = JetPsiFactoryKt.JetPsiFactory((PsiElement)element2);
        expression2.replace((PsiElement)psiFactory.createSingleStatementBlock(expression2));
        if (element2 instanceof JetDoWhileExpression) {
            Unit unit;
            PsiElement psiElement4;
            JetExpression jetExpression2 = ((JetDoWhileExpression)element2).getBody();
            if (jetExpression2 == null) {
                Intrinsics.throwNpe();
            }
            if (!((psiElement4 = jetExpression2.getParent().getNextSibling()) instanceof PsiWhiteSpace)) {
                psiElement4 = null;
            }
            PsiWhiteSpace psiWhiteSpace = (PsiWhiteSpace)psiElement4;
            if (psiWhiteSpace != null) {
                psiWhiteSpace.delete();
                unit = Unit.INSTANCE$;
            } else {
                unit = null;
            }
        }
    }

    private final JetExpression getTargetExpression(JetExpression $receiver, int caretLocation) {
        JetExpression jetExpression = $receiver;
        if (jetExpression instanceof JetIfExpression) {
            JetExpression jetExpression2 = ((JetIfExpression)$receiver).getThen();
            if (jetExpression2 == null) {
                return null;
            }
            JetExpression thenExpr = jetExpression2;
            JetExpression elseExpr = ((JetIfExpression)$receiver).getElse();
            if (elseExpr != null) {
                PsiElement psiElement2 = ((JetIfExpression)$receiver).getElseKeyword();
                if (psiElement2 == null) {
                    Intrinsics.throwNpe();
                }
                if (caretLocation >= PsiUtilsKt.getStartOffset(psiElement2)) {
                    return elseExpr;
                }
            }
            return thenExpr;
        }
        if (jetExpression instanceof JetWhileExpression) {
            return ((JetWhileExpression)$receiver).getBody();
        }
        if (jetExpression instanceof JetDoWhileExpression) {
            return ((JetDoWhileExpression)$receiver).getBody();
        }
        if (jetExpression instanceof JetForExpression) {
            return ((JetForExpression)$receiver).getBody();
        }
        return null;
    }

    public AddBracesIntention() {
        super(JetExpression.class, "Add braces", null, 4, null);
    }
}

