/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.intentions;

import com.intellij.openapi.editor.Editor;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiReference;
import com.intellij.psi.search.LocalSearchScope;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.search.searches.ReferencesSearch;
import com.intellij.psi.util.PsiTreeUtil;
import java.util.Iterator;
import kotlin.CollectionsKt;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.KotlinClass;
import kotlin.jvm.internal.Reflection;
import kotlin.reflect.KClass;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.descriptors.PropertyDescriptor;
import org.jetbrains.kotlin.descriptors.impl.SyntheticFieldDescriptor;
import org.jetbrains.kotlin.idea.caches.resolve.ResolutionUtils;
import org.jetbrains.kotlin.idea.intentions.IntroduceBackingPropertyIntention;
import org.jetbrains.kotlin.idea.intentions.JetSelfTargetingIntention;
import org.jetbrains.kotlin.idea.intentions.SpecifyTypeExplicitlyIntention;
import org.jetbrains.kotlin.lexer.JetTokens;
import org.jetbrains.kotlin.psi.BuilderByPattern;
import org.jetbrains.kotlin.psi.CreateByPatternKt;
import org.jetbrains.kotlin.psi.JetClassOrObject;
import org.jetbrains.kotlin.psi.JetDeclaration;
import org.jetbrains.kotlin.psi.JetElement;
import org.jetbrains.kotlin.psi.JetNameReferenceExpression;
import org.jetbrains.kotlin.psi.JetProperty;
import org.jetbrains.kotlin.psi.JetPropertyAccessor;
import org.jetbrains.kotlin.psi.JetPsiFactoryKt;
import org.jetbrains.kotlin.psi.JetSimpleNameExpression;
import org.jetbrains.kotlin.psi.JetTreeVisitorVoid;
import org.jetbrains.kotlin.resolve.BindingContext;
import org.jetbrains.kotlin.types.JetType;

@KotlinClass(version={0, 25, 0}, abiVersion=25, data={"y\u0004)\t\u0013J\u001c;s_\u0012,8-\u001a\"bG.Lgn\u001a)s_B,'\u000f^=J]R,g\u000e^5p]*\u0019qN]4\u000b\u0013),GO\u0019:bS:\u001c(BB6pi2LgN\u0003\u0003jI\u0016\f'BC5oi\u0016tG/[8og*I\"*\u001a;TK24G+\u0019:hKRLgnZ%oi\u0016tG/[8o\u0015-QU\r\u001e)s_B,'\u000f^=\u000b\u0007A\u001c\u0018N\u0003\u0004=S:LGO\u0010\u0006\bCB\u0004H.\u001f+p\u0015\u001d)G.Z7f]RTa!\u001a3ji>\u0014(BB#eSR|'OC\u0002d_6T\u0001\"\u001b8uK2d\u0017N\u001b\u0006\b_B,g.\u00199j\u0015\u0011)f.\u001b;\u000b\u001d%\u001c\u0018\t\u001d9mS\u000e\f'\r\\3U_*Y1-\u0019:fi>3gm]3u\u0015\rIe\u000e\u001e\u0006\b\u0005>|G.Z1o\u0015%\u0019u.\u001c9b]&|g\u000ea\u0001\u000b\u0005A\t!\u0002\u0002\u0005\u0001!\tQA\u0001C\u0001\u0011\u0007)!\u0001B\u0001\t\u0005\u0015\u0011A1\u0001E\u0003\u000b\r!!\u0001\u0003\u0001\r\u0001\u0015\u0019AA\u0001\u0005\u0004\u0019\u0001)!\u0001B\u0001\t\t\u0015\u0019Aq\u0001E\u0004\u0019\u0001)\u0011\u0001C\u0004\u0006\u0005\u0011%\u0001rB\u0003\u0003\t\u0015A\u0001\"\u0002\u0002\u0005\f!1Qa\u0001\u0003\u0007\u0011\u001ba\u0001!B\u0001\t\u0004\u0015\u0019Aa\u0002E\t\u0019\u0001)!\u0001b\u0002\t\b\u0015\u0011AA\u0002E\u0007\u000b\r!q\u0001\u0003\u0006\r\u0001\u0015\u0019Aa\u0002E\u000b\u0019\u0001!1\u0001$\u0002\u0011\u0017eAQ!\u0001\u0005\u0004\u0013\u0011I1!B\u0001\t\ta!\u0001dAO\u0001\u00175~Ba\u0003\r\u0006;\u001f!\u0001\u0001c\u0003\u000e\u0007\u0015\t\u0001\u0002\u0002\r\u0005!\u000e\u0001Qt\u0002\u0003\u0001\u0011\u0019i1!B\u0001\t\u000ea5\u0001k!\u0001\"\u0007\u0015\t\u0001r\u0002M\b#\u000e9A!B\u0005\u0002\t\u0001i\u0011\u0001\u0003\u0005\u000e\u0003!EQv\b\u0003\f1%iz\u0001\u0002\u0001\t\f5\u0019Q!\u0001\u0005\u00051\u0011\u00016\u0001AO\b\t\u0001A\u0019\"D\u0002\u0006\u0003!I\u0001$\u0003)\u0004\u0002\u0005\u001aQ!\u0001E\n1'\t6a\u0002\u0003\n\u0013\u0005!\t!D\u0001\t\u00115\tAQA\u001b\r\u000b-!1\u001d\u0001M\u0005C\r)\u0011\u0001#\u0002\u0019\u0006E\u001b1\u0001\"\u0003\n\u0003\u0011\u0001\u0001"})
public final class IntroduceBackingPropertyIntention
extends JetSelfTargetingIntention<JetProperty> {
    public static final /* synthetic */ KClass $kotlinClass;
    public static final Companion Companion;

    static {
        $kotlinClass = Reflection.createKotlinClass(IntroduceBackingPropertyIntention.class);
        Companion companion = Companion = new Companion(null);
    }

    @Override
    public boolean isApplicableTo(@NotNull JetProperty element2, int caretOffset) {
        Intrinsics.checkParameterIsNotNull((Object)element2, (String)"element");
        if (!Companion.canIntroduceBackingProperty(element2)) {
            return false;
        }
        PsiElement psiElement2 = element2.getNameIdentifier();
        return Intrinsics.areEqual(psiElement2 != null && (psiElement2 = psiElement2.getTextRange()) != null ? Boolean.valueOf(psiElement2.containsOffset(caretOffset)) : null, (Object)true);
    }

    @Override
    public void applyTo(@NotNull JetProperty element2, @NotNull Editor editor) {
        Intrinsics.checkParameterIsNotNull((Object)element2, (String)"element");
        Intrinsics.checkParameterIsNotNull((Object)editor, (String)"editor");
        Companion.introduceBackingProperty(element2);
    }

    public IntroduceBackingPropertyIntention() {
        super(JetProperty.class, "Introduce backing property", null, 4, null);
    }

    @KotlinClass(version={0, 25, 0}, abiVersion=25, data={"g\u0006)I1i\\7qC:LwN\u001c\u0006\"\u0013:$(o\u001c3vG\u0016\u0014\u0015mY6j]\u001e\u0004&o\u001c9feRL\u0018J\u001c;f]RLwN\u001c\u0006\u0004_J<'\"\u00036fi\n\u0014\u0018-\u001b8t\u0015\u0019Yw\u000e\u001e7j]*!\u0011\u000eZ3b\u0015)Ig\u000e^3oi&|gn\u001d\u0006\u0004\u0003:L(bG2b]&sGO]8ek\u000e,')Y2lS:<\u0007K]8qKJ$\u0018P\u0003\u0005qe>\u0004XM\u001d;z\u0015-QU\r\u001e)s_B,'\u000f^=\u000b\u0007A\u001c\u0018NC\u0004C_>dW-\u00198\u000b+\r\u0014X-\u0019;f\u0005\u0006\u001c7.\u001b8h!J|\u0007/\u001a:us*!QK\\5u\u00151\u0019'/Z1uK\u001e+G\u000f^3s\u0015\u001d)G.Z7f]RTAb\u0019:fCR,7+\u001a;uKJT\u0001$\u001b8ue>$WoY3CC\u000e\\\u0017N\\4Qe>\u0004XM\u001d;z\u0015u\u0011X\r\u001d7bG\u0016\u0014\u0015mY6j]\u001e4\u0015.\u001a7e%\u00164WM]3oG\u0016\u001c(\u0002\u00029s_BTaC]3qY\u0006\u001cWMR5fY\u0012\u0014VMZ3sK:\u001cWm\u001d\u0006\u000b\u0015\u0016$X\t\\3nK:$(\u0002\u00049s_B,'\u000f^=OC6,'BB*ue&twM\u0003\u0003kCZ\f'\u0002\u00027b]\u001e\u0014\u0019A\u0003\u0002\u0011\u0005)!\u0001\u0002\u0001\t\u0004\u0015\u0011A\u0011\u0001\u0005\u0003\u000b\t!\u0011\u0001#\u0002\u0006\u0005\u0011\r\u0001bA\u0003\u0004\t\tA\t\u0001\u0004\u0001\u0006\u0007\u0011\u0015\u0001\u0002\u0001\u0007\u0001\u000b\u0005A!!B\u0002\u0005\b!\u001dA\u0002A\u0003\u0003\t\u0005AY!B\u0002\u0005\n!)A\u0002A\u0003\u0004\t\u000fAa\u0001\u0004\u0001\u0006\u0005\u0011%\u0001\"B\u0003\u0004\t\u000fAq\u0001\u0004\u0001\u0006\u0007\u0011%\u0001b\u0003\u0007\u0001\u000b\r!9\u0001\u0003\u0007\r\u0001\u0015\u0011A\u0011\u0002\u0005\f\u000b\u0005AI\"\u0002\u0002\u0005\u0012!iQA\u0001\u0003\n\u00111!19\u0001\u0007\u00043\r)\u0011\u0001\u0003\u0003\u0019\t5*Ba\u0001\r\u0005;\u001f!\u0001\u0001#\u0003\u000e\u0007\u0015\t\u0001\"\u0002\r\u0006!\u000e\u0001\u0011eA\u0003\u0002\u0011\u0017AZ!U\u0002\u0006\t\u0011I\u0011\u0001\"\u0001\u000e\u0003!1Q&\u0006\u0003\u00021\u001biz\u0001\u0002\u0001\t\n5\u0019Q!\u0001\u0005\u00061\u0015\u00016\u0001A\u0011\u0004\u000b\u0005Ai\u0001'\u0004R\u0007\u0015!i!C\u0001\u0005\u00015\t\u0001BB\u0017\u0016\t\u0005Az!h\u0004\u0005\u0001!AQbA\u0003\u0002\u0011\u0015AR\u0001U\u0002\u0001C\r)\u0011\u0001#\u0004\u0019\u000eE\u001bQ\u0001b\u0004\n\u0003\u0011\u0001Q\"\u0001\u0005\u0007[U!\u0011\u0001'\u0005\u001e\u0010\u0011\u0001\u0001\u0002C\u0007\u0004\u000b\u0005AQ\u0001G\u0003Q\u0007\u0001\t3!B\u0001\t\u000ea5\u0011kA\u0003\u0005\u0012%\tA\u0001A\u0007\u0002\u0011\u0019iS\u0003B\u0002\u0019\u0013u=A\u0001\u0001E\u0005\u001b\r)\u0011\u0001C\u0003\u0019\u000bA\u001b\u0001!I\u0002\u0006\u0003!5\u0001TB)\u0004\u000b\u0011I\u0011\"\u0001\u0003\u0001\u001b\u0005Aa!L\u000b\u0005\u0003aMQt\u0002\u0003\u0001\u0011)i1!B\u0001\t\u000ba)\u0001k\u0001\u0001\"\u0007\u0015\t\u0001R\u0002M\u0007#\u000e)A1C\u0005\u0002\t\u0001i\u0011\u0001\u0003\u0004.@\u0011\t\u0001TCO\b\t\u0001A\u0001\"D\u0002\u0006\u0003!9\u0001d\u0002)\u0004\u0001u=A\u0001\u0001E\f\u001b\r)\u0011\u0001c\u0004\u0019\u0010A\u001b\t!I\u0002\u0006\u0003!5\u0001TB)\u0004\u000f\u0011U\u0011\"\u0001\u0003\u0001\u001b\u0005A\u0001\"D\u0001\t\u0014U\u0002\u0001"})
    public static final class Companion {
        public static final /* synthetic */ KClass $kotlinClass;

        static {
            $kotlinClass = Reflection.createKotlinClass(Companion.class);
        }

        public final boolean canIntroduceBackingProperty(@NotNull JetProperty property2) {
            boolean bl;
            block6: {
                Iterable $receiver;
                Intrinsics.checkParameterIsNotNull((Object)property2, (String)"property");
                String string = property2.getName();
                if (string == null) {
                    return false;
                }
                String name2 = string;
                BindingContext bindingContext2 = ResolutionUtils.getResolutionFacade(property2).analyzeFullyAndGetResult(CollectionsKt.listOf((Object)property2)).getBindingContext();
                DeclarationDescriptor declarationDescriptor = bindingContext2.get(BindingContext.DECLARATION_TO_DESCRIPTOR, property2);
                if (!(declarationDescriptor instanceof PropertyDescriptor)) {
                    declarationDescriptor = null;
                }
                PropertyDescriptor propertyDescriptor = (PropertyDescriptor)declarationDescriptor;
                if (propertyDescriptor == null) {
                    return false;
                }
                PropertyDescriptor descriptor2 = propertyDescriptor;
                if (Intrinsics.areEqual((Object)((Boolean)bindingContext2.get(BindingContext.BACKING_FIELD_REQUIRED, descriptor2)), (Object)false)) {
                    return false;
                }
                PsiElement psiElement2 = property2;
                JetClassOrObject jetClassOrObject = (JetClassOrObject)PsiTreeUtil.getParentOfType((PsiElement)$receiver, JetClassOrObject.class, (boolean)true);
                if (jetClassOrObject == null) {
                    return false;
                }
                JetClassOrObject containingClass = jetClassOrObject;
                $receiver = containingClass.getDeclarations();
                for (Object element2 : $receiver) {
                    JetDeclaration it = (JetDeclaration)element2;
                    if (!(it instanceof JetProperty && Intrinsics.areEqual((Object)((JetProperty)it).getName(), (Object)("_" + name2)))) continue;
                    bl = false;
                    break block6;
                }
                bl = true;
            }
            return bl;
        }

        public final void introduceBackingProperty(@NotNull JetProperty property2) {
            JetPropertyAccessor getter;
            Intrinsics.checkParameterIsNotNull((Object)property2, (String)"property");
            this.createBackingProperty(property2);
            if (property2.getTypeReference() == null) {
                JetType type2 = SpecifyTypeExplicitlyIntention.Companion.getTypeForDeclaration(property2);
                SpecifyTypeExplicitlyIntention.Companion.addTypeAnnotation(null, property2, type2);
            }
            if ((getter = property2.getGetter()) == null) {
                this.createGetter(property2);
            } else {
                JetElement jetElement = getter;
                String string = property2.getName();
                if (string == null) {
                    Intrinsics.throwNpe();
                }
                Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"property.name!!");
                this.replaceFieldReferences(jetElement, string);
            }
            if (property2.isVar()) {
                JetPropertyAccessor setter = property2.getSetter();
                if (setter == null) {
                    this.createSetter(property2);
                } else {
                    JetElement jetElement = setter;
                    String string = property2.getName();
                    if (string == null) {
                        Intrinsics.throwNpe();
                    }
                    Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"property.name!!");
                    this.replaceFieldReferences(jetElement, string);
                }
            }
            property2.setInitializer(null);
            this.replaceBackingFieldReferences(property2);
        }

        private final void createGetter(JetProperty element2) {
            String body2 = "get() = _" + element2.getName();
            JetPropertyAccessor jetPropertyAccessor = JetPsiFactoryKt.JetPsiFactory(element2).createProperty("val x " + body2).getGetter();
            if (jetPropertyAccessor == null) {
                Intrinsics.throwNpe();
            }
            JetPropertyAccessor newGetter = jetPropertyAccessor;
            element2.add(newGetter);
        }

        private final void createSetter(JetProperty element2) {
            String body2 = "set(value) { _" + element2.getName() + " = value }";
            JetPropertyAccessor jetPropertyAccessor = JetPsiFactoryKt.JetPsiFactory(element2).createProperty("val x " + body2).getSetter();
            if (jetPropertyAccessor == null) {
                Intrinsics.throwNpe();
            }
            JetPropertyAccessor newSetter = jetPropertyAccessor;
            element2.add(newSetter);
        }

        private final void createBackingProperty(JetProperty property2) {
            JetDeclaration backingProperty2 = CreateByPatternKt.buildDeclaration(JetPsiFactoryKt.JetPsiFactory(property2), (Function1<? super BuilderByPattern<JetDeclaration>, ? extends Unit>)((Function1)new Function1<BuilderByPattern<JetDeclaration>, Unit>(property2){
                final /* synthetic */ JetProperty $property;

                public final void invoke(BuilderByPattern<JetDeclaration> $receiver) {
                    Intrinsics.checkParameterIsNotNull($receiver, (String)"$receiver");
                    $receiver.appendFixedText("private ");
                    String string = this.$property.getValOrVarKeyword().getText();
                    Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"property.valOrVarKeyword.text");
                    $receiver.appendFixedText(string);
                    $receiver.appendFixedText(" _" + this.$property.getName());
                    if (this.$property.getTypeReference() != null) {
                        $receiver.appendFixedText(": ");
                        $receiver.appendTypeReference(this.$property.getTypeReference());
                    }
                    if (this.$property.getInitializer() != null) {
                        $receiver.appendFixedText(" = ");
                        $receiver.appendExpression(this.$property.getInitializer());
                    }
                }
                {
                    this.$property = jetProperty;
                    super(1);
                }
            }));
            property2.getParent().addBefore((PsiElement)backingProperty2, (PsiElement)property2);
        }

        private final void replaceFieldReferences(JetElement element2, String propertyName) {
            element2.acceptChildren(new JetTreeVisitorVoid(element2, propertyName){
                public static final /* synthetic */ KClass $kotlinClass;
                final /* synthetic */ JetElement $element;
                final /* synthetic */ String $propertyName;

                static {
                    $kotlinClass = Reflection.createKotlinClass(replaceFieldReferences.1.class);
                }

                public void visitSimpleNameExpression(@NotNull JetSimpleNameExpression expression2) {
                    Intrinsics.checkParameterIsNotNull((Object)expression2, (String)"expression");
                    BindingContext bindingContext2 = ResolutionUtils.analyze$default(expression2, null, 1);
                    DeclarationDescriptor target = (DeclarationDescriptor)bindingContext2.get(BindingContext.REFERENCE_TARGET, expression2);
                    if (target instanceof SyntheticFieldDescriptor) {
                        expression2.replace((PsiElement)JetPsiFactoryKt.JetPsiFactory((PsiElement)this.$element).createSimpleName("_" + this.$propertyName));
                    }
                }

                public void visitPropertyAccessor(@NotNull JetPropertyAccessor accessor) {
                    Intrinsics.checkParameterIsNotNull((Object)accessor, (String)"accessor");
                }
                {
                    this.$element = $captured_local_variable$0;
                    this.$propertyName = $captured_local_variable$1;
                }
            });
        }

        private final void replaceBackingFieldReferences(JetProperty prop) {
            Object $receiver = prop;
            PsiElement psiElement2 = PsiTreeUtil.getParentOfType((PsiElement)$receiver, JetClassOrObject.class, (boolean)true);
            if (psiElement2 == null) {
                Intrinsics.throwNpe();
            }
            JetClassOrObject containingClass = (JetClassOrObject)psiElement2;
            $receiver = (Iterable)ReferencesSearch.search((PsiElement)prop, (SearchScope)((SearchScope)new LocalSearchScope((PsiElement)containingClass)));
            Iterator iterator2 = $receiver.iterator();
            while (iterator2.hasNext()) {
                JetNameReferenceExpression element2;
                Object element3 = iterator2.next();
                PsiReference it = (PsiReference)element3;
                PsiElement psiElement3 = it.getElement();
                if (!(psiElement3 instanceof JetNameReferenceExpression)) {
                    psiElement3 = null;
                }
                if ((element2 = (JetNameReferenceExpression)psiElement3) == null || !Intrinsics.areEqual((Object)element2.getReferencedNameElementType(), (Object)((Object)JetTokens.FIELD_IDENTIFIER))) continue;
                element2.replace((PsiElement)JetPsiFactoryKt.JetPsiFactory((PsiElement)element2).createSimpleName("_" + prop.getName()));
            }
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

