/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.intentions;

import com.intellij.codeInsight.intention.PsiElementBaseIntentionAction;
import com.intellij.openapi.editor.CaretModel;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.codeStyle.CodeStyleManager;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.refactoring.rename.RenameProcessor;
import com.intellij.usageView.UsageInfo;
import kotlin.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.KotlinClass;
import kotlin.jvm.internal.Reflection;
import kotlin.reflect.KClass;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.descriptors.ParameterDescriptor;
import org.jetbrains.kotlin.descriptors.impl.AnonymousFunctionDescriptor;
import org.jetbrains.kotlin.idea.caches.resolve.ResolutionUtils;
import org.jetbrains.kotlin.idea.references.ReferenceUtilKt;
import org.jetbrains.kotlin.psi.JetBlockExpression;
import org.jetbrains.kotlin.psi.JetFunctionLiteral;
import org.jetbrains.kotlin.psi.JetParameter;
import org.jetbrains.kotlin.psi.JetParameterList;
import org.jetbrains.kotlin.psi.JetSimpleNameExpression;
import org.jetbrains.kotlin.psi.psiUtil.PsiUtilsKt;
import org.jetbrains.kotlin.resolve.DescriptorToSourceUtils;

@KotlinClass(version={0, 25, 0}, abiVersion=25, data={"\u000e\b)\u0011$+\u001a9mC\u000e,W\t\u001f9mS\u000eLGOR;oGRLwN\u001c'ji\u0016\u0014\u0018\r\u001c)be\u0006lw+\u001b;i\u0013RLe\u000e^3oi&|gNC\u0002pe\u001eT\u0011B[3uEJ\f\u0017N\\:\u000b\r-|G\u000f\\5o\u0015\u0011IG-Z1\u000b\u0015%tG/\u001a8uS>t7OC\u000fQg&,E.Z7f]R\u0014\u0015m]3J]R,g\u000e^5p]\u0006\u001bG/[8o\u0015\r\u0019w.\u001c\u0006\tS:$X\r\u001c7jU*Y1m\u001c3f\u0013:\u001c\u0018n\u001a5u\u0015%Ig\u000e^3oi&|gN\u0003\u0004=S:LGO\u0010\u0006\u000eO\u0016$h)Y7jYft\u0015-\\3\u000b\rM#(/\u001b8h\u0015\u0011Q\u0017M^1\u000b\t1\fgn\u001a\u0006\u0007S:4xn[3\u000b\u000fA\u0014xN[3di*9\u0001K]8kK\u000e$(bB8qK:\f\u0007/\u001b\u0006\u0007K\u0012LGo\u001c:\u000b\r\u0015#\u0017\u000e^8s\u0015\u001d)G.Z7f]RT!\u0002U:j\u000b2,W.\u001a8u\u0015\r\u00018/\u001b\u0006\u0005+:LGOC\u0006jg\u00063\u0018-\u001b7bE2,'b\u0002\"p_2,\u0017M\u001c\u0006\u0016i\u0006\u0014x-\u001a;Gk:\u001cG/[8o\u0019&$XM]1m\u0015-\u0019\u0017M]3u\u001f\u001a47/\u001a;\u000b\u0007%sGO\u0003\nKKR4UO\\2uS>tG*\u001b;fe\u0006d'B\u0006)be\u0006l'+\u001a8b[&tw\r\u0015:pG\u0016\u001c8o\u001c:M\u0004)\u0011\u0001#\u0001\u0006\u0005\u0011\u0001\u0001\"A\u0003\u0003\t\u0003A\u0019!\u0002\u0002\u0005\u0003!\u0011QA\u0001C\u0002\u0011\u000b)1\u0001\u0002\u0002\t\u00011\u0001Q!\u0001E\u0004\u000b\t!1\u0001\u0003\u0003\u0006\u0005\u0011\u001d\u0001\u0012B\u0003\u0003\t\u0011AQ!B\u0002\u0005\n!\u0019A\u0002A\u0003\u0002\u0011\u0007)1\u0001b\u0003\t\u000e1\u0001Q!\u0001\u0005\b\u000b\t!i\u0001c\u0004\u0006\u0005\u00119\u0001RB\u0003\u0003\t\u000fA\u0019\"\u0002\u0002\u0005\u0011!EQa\u0001C\t\u0011%a\u0001!\u0002\u0002\u0005\u0011!QQa\u0001C\n\u0011+a\u0001!\u0002\u0002\u0005\b!aQa\u0001C\u000b\u0011/a\u0001!B\u0002\u0005\f!eA\u0002A\u0003\u0003\t#A\u0011\"\u0002\u0002\u0005\u0014!UQA\u0001C\u000b\u0011/)1\u0001b\u0003\t\u001c1\u0001Qa\u0001C\u0006\u0011=a\u0001!\u0002\u0002\u0005\u0003!aQa\u0001C\u000f\u0011?a\u0001!\u0002\u0002\u0005\u001e!}Aa\u0001G\u00033\r)\u0011\u0001C\u0003\u0019\u000bu\u0005\u0001#,\u0006\u0005\u0017a1\u0011eA\u0003\u0002\u0011\u0019Ab!U\u0002\u0004\t\u0019I\u0011\u0001c\u0004.U\u0011Y\u0001\u0004CO\b\t\u0001A\t\"D\u0002\u0006\u0003!I\u0001$\u0003)\u0004\u0001u=A\u0001\u0001\u0005\u000b\u001b\r)\u0011\u0001\u0003\u0006\u0019\u0015A\u001b\t!h\u0004\u0005\u0001!YQbA\u0003\u0002\u0011-A2\u0002U\u0002\u0002C\r)\u0011\u0001c\u0006\u0019\u0018E\u001b\u0011\u0002\u0002\u0005\n\u0003\u0011\u0001Q\"\u0001\u0005\r\u001b\u0005AI\"D\u0001\t\u001b5RCa\u0003\r\u000e;\u001f!\u0001\u0001#\u0005\u000e\u0007\u0015\t\u0001\"\u0003\r\n!\u000e\u0001Qt\u0002\u0003\u0001\u0011)i1!B\u0001\t\u0015aQ\u0001k!\u0001\u001e\u0010\u0011\u0001\u0001bC\u0007\u0004\u000b\u0005A1\u0002G\u0006Q\u0007\u0005\t3!B\u0001\t\u001cam\u0011kA\u0005\u0005\u001b%\tA\u0011A\u0007\u0002\u00111i\u0011\u0001#\u0007\u000e\u0003!iQ\u0016\t\u0003\u000219iz\u0001\u0002\u0001\t\u00175\u0019Q!\u0001\u0005\f1-\u00016\u0001AO\b\t\u0001Ai\"D\u0002\u0006\u0003!q\u0001D\u0004)\u0004\u0002\u0005\"Q!\u0001\u0005\u0010\u0019\u0003Ar\"U\u0002\b\t9I\u0011\u0001c\b\u000e\u0003!iQ\"\u0001C\u0003k1)1\u0002Br\u00011\u0017\t3!B\u0001\t\u0006a\u0015\u0011kA\u0002\u0005\f%\tA\u0001\u0001"})
public final class ReplaceExplicitFunctionLiteralParamWithItIntention
extends PsiElementBaseIntentionAction {
    public static final /* synthetic */ KClass $kotlinClass;

    static {
        $kotlinClass = Reflection.createKotlinClass(ReplaceExplicitFunctionLiteralParamWithItIntention.class);
    }

    @NotNull
    public String getFamilyName() {
        return "Replace explicit lambda parameter with 'it'";
    }

    public boolean isAvailable(@NotNull Project project, @NotNull Editor editor, @NotNull PsiElement element2) {
        Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
        Intrinsics.checkParameterIsNotNull((Object)editor, (String)"editor");
        Intrinsics.checkParameterIsNotNull((Object)element2, (String)"element");
        JetFunctionLiteral jetFunctionLiteral = this.targetFunctionLiteral(element2, editor.getCaretModel().getOffset());
        if (jetFunctionLiteral == null) {
            return false;
        }
        JetFunctionLiteral functionLiteral = jetFunctionLiteral;
        JetParameter jetParameter = (JetParameter)CollectionsKt.singleOrNull(functionLiteral.getValueParameters());
        if (jetParameter == null) {
            return false;
        }
        JetParameter parameter = jetParameter;
        if (parameter.getTypeReference() != null) {
            return false;
        }
        this.setText("Replace explicit parameter '" + parameter.getName() + "' with 'it'");
        return true;
    }

    public void invoke(@NotNull Project project, @NotNull Editor editor, @NotNull PsiElement element2) {
        Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
        Intrinsics.checkParameterIsNotNull((Object)editor, (String)"editor");
        Intrinsics.checkParameterIsNotNull((Object)element2, (String)"element");
        int caretOffset = editor.getCaretModel().getOffset();
        JetFunctionLiteral jetFunctionLiteral = this.targetFunctionLiteral(element2, editor.getCaretModel().getOffset());
        if (jetFunctionLiteral == null) {
            Intrinsics.throwNpe();
        }
        JetFunctionLiteral functionLiteral = jetFunctionLiteral;
        JetParameterList jetParameterList = functionLiteral.getValueParameterList();
        if (jetParameterList == null) {
            Intrinsics.throwNpe();
        }
        boolean cursorInParameterList = jetParameterList.getTextRange().containsOffset(caretOffset);
        new ParamRenamingProcessor(editor, functionLiteral, cursorInParameterList).run();
    }

    /*
     * WARNING - void declaration
     */
    private final JetFunctionLiteral targetFunctionLiteral(PsiElement element2, int caretOffset) {
        void strict;
        void $receiver;
        void strict2;
        void $receiver2;
        PsiElement psiElement2 = element2;
        boolean bl = true;
        JetSimpleNameExpression expression2 = (JetSimpleNameExpression)PsiTreeUtil.getParentOfType((PsiElement)$receiver2, JetSimpleNameExpression.class, (boolean)strict2);
        if (expression2 != null) {
            Object object = CollectionsKt.singleOrNull((Iterable)ReferenceUtilKt.getMainReference(expression2).resolveToDescriptors(ResolutionUtils.analyze$default(expression2, null, 1)));
            if (!(object instanceof ParameterDescriptor)) {
                object = null;
            }
            ParameterDescriptor parameterDescriptor = (ParameterDescriptor)object;
            if (parameterDescriptor == null) {
                return null;
            }
            ParameterDescriptor target = parameterDescriptor;
            DeclarationDescriptor declarationDescriptor = target.getContainingDeclaration();
            if (!(declarationDescriptor instanceof AnonymousFunctionDescriptor)) {
                declarationDescriptor = null;
            }
            AnonymousFunctionDescriptor anonymousFunctionDescriptor = (AnonymousFunctionDescriptor)declarationDescriptor;
            if (anonymousFunctionDescriptor == null) {
                return null;
            }
            AnonymousFunctionDescriptor functionDescriptor = anonymousFunctionDescriptor;
            PsiElement psiElement3 = DescriptorToSourceUtils.descriptorToDeclaration(functionDescriptor);
            if (!(psiElement3 instanceof JetFunctionLiteral)) {
                psiElement3 = null;
            }
            return (JetFunctionLiteral)psiElement3;
        }
        PsiElement functionDescriptor = element2;
        boolean bl2 = true;
        JetFunctionLiteral jetFunctionLiteral = (JetFunctionLiteral)PsiTreeUtil.getParentOfType((PsiElement)$receiver, JetFunctionLiteral.class, (boolean)strict);
        if (jetFunctionLiteral == null) {
            return null;
        }
        JetFunctionLiteral functionLiteral = jetFunctionLiteral;
        PsiElement psiElement4 = functionLiteral.getArrow();
        if (psiElement4 == null) {
            return null;
        }
        PsiElement arrow = psiElement4;
        if (caretOffset > PsiUtilsKt.getEndOffset(arrow)) {
            return null;
        }
        return functionLiteral;
    }

    @KotlinClass(version={0, 25, 0}, abiVersion=25, data={"\u0015\b)1\u0002+\u0019:b[J+g.Y7j]\u001e\u0004&o\\2fgN|'O\u0003\u001aSKBd\u0017mY3FqBd\u0017nY5u\rVt7\r^5p]2KG/\u001a:bYB\u000b'/Y7XSRD\u0017\n^%oi\u0016tG/[8o\u0015\ry'o\u001a\u0006\nU\u0016$(M]1j]NTaa[8uY&t'\u0002B5eK\u0006T!\"\u001b8uK:$\u0018n\u001c8t\u0015=\u0011VM\\1nKB\u0013xnY3tg>\u0014(bA2p[*A\u0011N\u001c;fY2L'NC\u0006sK\u001a\f7\r^8sS:<'B\u0002:f]\u0006lWM\u0003\u0004=S:LGO\u0010\u0006\u0007K\u0012LGo\u001c:\u000b\r\u0015#\u0017\u000e^8s\u0015\u001dy\u0007/\u001a8ba&TqBZ;oGRLwN\u001c'ji\u0016\u0014\u0018\r\u001c\u0006\u0013\u0015\u0016$h)\u001e8di&|g\u000eT5uKJ\fGNC\u0002qg&T\u0001dY;sg>\u0014x+Y:J]B\u000b'/Y7fi\u0016\u0014H*[:u\u0015\u001d\u0011un\u001c7fC:T1dZ3u\u0007V\u00148o\u001c:XCNLe\u000eU1sC6,G/\u001a:MSN$(\"C4fi\u0016#\u0017\u000e^8s\u0015I9W\r\u001e$v]\u000e$\u0018n\u001c8MSR,'/\u00197\u000b%A,'OZ8s[J+g-Y2u_JLgn\u001a\u0006\u0007kN\fw-Z:\u000b\u000b\u0005\u0013(/Y=\u000b\u0013U\u001b\u0018mZ3J]\u001a|'\"C;tC\u001e,g+[3x\u0015\u0011)f.\u001b;)\u0004)\u0011\u0001C\u0001\u0006\u0005\u0011\u0001\u00012A\u0003\u0003\t\u0003A!!\u0002\u0002\u0005\u0003!\u0015QA\u0001C\u0002\u0011\r)1\u0001\u0002\u0002\t\u00021\u0001Qa\u0001C\u0003\u0011\u0001a\u0001!B\u0001\t\t\u0015\u0011Aq\u0001E\u0005\u000b\t!A\u0001C\u0003\u0006\u0005\u0011%\u00012B\u0003\u0004\t\u0015A9\u0001\u0004\u0001\u0006\u0005\u0011!\u0001rB\u0003\u0003\t\u0019Ai!B\u0002\u0005\u000e!9A\u0002A\u0003\u0003\t\u0005A\u0011\"B\u0002\u0005\u0010!EA\u0002A\u0003\u0002\u0011\t)1\u0001\"\u0005\t\u00151\u0001QA\u0001C\u0007\u0011\u001d)!\u0001b\u0004\t\u0012\u0015\u0019A\u0011\u0003\u0005\u000e\u0019\u0001)!\u0001\u0002\u0003\t\u001d\u0015\u0019Aa\u0003E\u000e\u0019\u0001)1\u0001\"\u0005\t\u001e1\u0001QA\u0001\u0003\f\u00117!\u0011\u0001D\u0002\u001a\u0007\u0015\t\u00012\u0002M\u0006[A!1\r\u0002M\nC\r)\u0011\u0001C\u0005\u0019\u0013U\u001b\u0001\"B\u0002\u0005\u0014%\tA\u0011A\u0007\u0004\t+I\u0011\u0001\"\u0001.!\u0011\u0019G\u0001'\u0004\"\u0007\u0015\t\u0001b\u0002\r\b+\u000eAQa\u0001C\u0007\u0013\u0005A\u0019\"D\u0002\u0005\u0017%\t\u00012C\u0017\u0011\t\r$\u0001\u0004C\u0011\u0004\u000b\u0005A\u0001\u0002\u0007\u0005V\u0007!)1\u0001\u0002\u0005\n\u0003!QQb\u0001C\f\u0013\u0005A!\"\f\u000f\u0005\u0017aaQ4\u0004\u0003\u0001\u00113i\u0011\"B\u0001\t\u0016%)A\u0011A\u0005\u0004\u000b\u0005A9\u0002g\u0006\u0019\u0016A\u001b\u0001!I\u0002\u0006\u0003!a\u0001\u0004D)\u0004\r\u0011a\u0011\"\u0001\u0003\u0001\u001b\tAI\u0002$\u00016X\u0015UCa9\u0001\u0019\ru=A\u0001\u0001E\u0007\u001b\r)\u0011\u0001C\u0004\u0019\u000fA\u001b\u0001!h\u0004\u0005\u0001!AQbA\u0003\u0002\u0011!A\u0002\u0002UB\u0001;\u001f!\u0001\u0001c\u0005\u000e\u0007\u0015\t\u0001\"\u0003\r\n!\u000e\t\u0011eA\u0003\u0002\u0011\rA2!U\u0002\n\t\u0019I\u0011\u0001\u0002\u0001\u000e\u0003!MQ\"\u0001\u0005\u000b\u001b\u0005!\t\u0001"})
    private static final class ParamRenamingProcessor
    extends RenameProcessor {
        public static final /* synthetic */ KClass $kotlinClass;
        @NotNull
        private final Editor editor;
        @NotNull
        private final JetFunctionLiteral functionLiteral;
        private final boolean cursorWasInParameterList;

        static {
            $kotlinClass = Reflection.createKotlinClass(ParamRenamingProcessor.class);
        }

        public void performRefactoring(@NotNull UsageInfo[] usages2) {
            Intrinsics.checkParameterIsNotNull((Object)usages2, (String)"usages");
            super.performRefactoring(usages2);
            PsiElement psiElement2 = (PsiElement)this.functionLiteral.getValueParameterList();
            PsiElement psiElement3 = this.functionLiteral.getArrow();
            if (psiElement3 == null) {
                Intrinsics.throwNpe();
            }
            this.functionLiteral.deleteChildRange(psiElement2, psiElement3);
            if (this.cursorWasInParameterList) {
                CaretModel caretModel = this.editor.getCaretModel();
                JetBlockExpression jetBlockExpression = this.functionLiteral.getBodyExpression();
                if (jetBlockExpression == null) {
                    Intrinsics.throwNpe();
                }
                caretModel.moveToOffset(jetBlockExpression.getTextOffset());
            }
            Project project = this.functionLiteral.getProject();
            PsiDocumentManager.getInstance((Project)project).doPostponedOperationsAndUnblockDocument(this.editor.getDocument());
            CodeStyleManager.getInstance((Project)project).adjustLineIndent(this.functionLiteral.getContainingFile(), this.functionLiteral.getTextRange());
        }

        @NotNull
        public final Editor getEditor() {
            return this.editor;
        }

        @NotNull
        public final JetFunctionLiteral getFunctionLiteral() {
            return this.functionLiteral;
        }

        public final boolean getCursorWasInParameterList() {
            return this.cursorWasInParameterList;
        }

        public ParamRenamingProcessor(@NotNull Editor editor, @NotNull JetFunctionLiteral functionLiteral, boolean cursorWasInParameterList) {
            Intrinsics.checkParameterIsNotNull((Object)editor, (String)"editor");
            Intrinsics.checkParameterIsNotNull((Object)functionLiteral, (String)"functionLiteral");
            super(editor.getProject(), (PsiElement)CollectionsKt.single(functionLiteral.getValueParameters()), "it", false, false);
            this.editor = editor;
            this.functionLiteral = functionLiteral;
            this.cursorWasInParameterList = cursorWasInParameterList;
        }
    }
}

