/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.joinLines;

import com.intellij.codeInsight.editorActions.JoinRawLinesHandlerDelegate;
import com.intellij.lang.ASTNode;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import kotlin.ArraysKt;
import kotlin.CollectionsKt;
import kotlin.StringsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.KotlinClass;
import kotlin.jvm.internal.Reflection;
import kotlin.reflect.KClass;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.lexer.JetTokens;
import org.jetbrains.kotlin.psi.CreateByPatternKt;
import org.jetbrains.kotlin.psi.JetBlockExpression;
import org.jetbrains.kotlin.psi.JetContainerNode;
import org.jetbrains.kotlin.psi.JetExpression;
import org.jetbrains.kotlin.psi.JetFile;
import org.jetbrains.kotlin.psi.JetIfExpression;
import org.jetbrains.kotlin.psi.JetPsiFactoryKt;
import org.jetbrains.kotlin.psi.JetWhenEntry;

@KotlinClass(version={0, 25, 0}, abiVersion=25, data={"\b\u0006)\u0019#j\\5o\u00052|7m[%oi>\u001c\u0016N\\4mKN#\u0018\r^3nK:$\b*\u00198eY\u0016\u0014(bA8sO*I!.\u001a;ce\u0006Lgn\u001d\u0006\u0007W>$H.\u001b8\u000b\t%$W-\u0019\u0006\nU>Lg\u000eT5oKNT1DS8j]J\u000bw\u000fT5oKND\u0015M\u001c3mKJ$U\r\\3hCR,'bA2p[*A\u0011N\u001c;fY2L'NC\u0006d_\u0012,\u0017J\\:jO\"$(\"D3eSR|'/Q2uS>t7O\u0003\u0004=S:LGO\u0010\u0006\riJL(j\\5o\u0019&tWm\u001d\u0006\tI>\u001cW/\\3oi*AAi\\2v[\u0016tGOC\u0004pa\u0016t\u0017\r]5\u000b\r\u0015$\u0017\u000e^8s\u0015\u00111\u0017\u000e\\3\u000b\u000fA\u001b\u0018NR5mK*\u0019\u0001o]5\u000b\u000bM$\u0018M\u001d;\u000b\u0007%sGOC\u0002f]\u0012Tq\u0002\u001e:z\u0015>LgNU1x\u0019&tWm\u001d?\u000b\u0005A\t!\u0002\u0002\u0005\u0001!\tQA\u0001C\u0001\u0011\u0007)!\u0001B\u0001\t\u0005\u0015\u0011A1\u0001E\u0003\u000b\r!!\u0001\u0003\u0001\r\u0001\u0015\t\u0001rA\u0003\u0003\t\rAA!\u0002\u0002\u0005\b!%QA\u0001\u0003\u0005\u0011\u0015)1\u0001\"\u0003\t\u00071\u0001QA\u0001C\u0004\u0011\u001f)!\u0001b\u0003\t\u0011\u0015\u0019AA\u0002\u0005\b\u0019\u0001)!\u0001b\u0002\t\u0014\u0015\u0019Aa\u0002\u0005\n\u0019\u0001)\u0011\u0001c\u0001\u0006\u0007\u0011A\u0001R\u0003\u0007\u0001\u000b\t!a\u0001C\u0004\u0006\u0005\u00119\u0001\"\u0003\u0003\u0004\u0019\u000bI2!B\u0001\t\u000ba)Q\u0016\u000e\u0003\f1\u0019iz\u0001\u0002\u0001\t\u000e5\u0019Q!\u0001E\u00071\u001b\u00016\u0001AO\b\t\u0001A\t\"D\u0002\u0006\u0003!=\u0001t\u0002)\u0004\u0002u=A\u0001\u0001\u0005\u000b\u001b\r)\u0011\u0001#\u0005\u0019\u0012A\u001b\u0011!h\u0004\u0005\u0001!YQbA\u0003\u0002\u0011#A\n\u0002UB\u0002C\r)\u0011\u0001#\u0005\u0019\u0012E\u001b1\u0002\u0002\u0004\n\u0003\u0011\u0015Q\"\u0001\u0005\n\u001b\u0005A\u0019\"D\u0001\u0005\u00065\tAQAW5\t-A:\"h\u0004\u0005\u0001!5QbA\u0003\u0002\u0011\u001bAj\u0001U\u0002\u0001;\u001f!\u0001\u0001#\u0005\u000e\u0007\u0015\t\u0001r\u0002M\b!\u000e\u0005Qt\u0002\u0003\u0001\u0011)i1!B\u0001\t\u0012aE\u0001kA\u0001\u001e\u0010\u0011\u0001\u0001bC\u0007\u0004\u000b\u0005A\t\u0002'\u0005Q\u0007\u0007\t3!B\u0001\t\u0012aE\u0011kA\u0006\u0005\u0018%\tAQA\u0007\u0002\u0011%i\u0011\u0001c\u0005\u000e\u0003\u0011\u0015Q\"\u0001C\u0003k1)1\u0002Br\u00011\u0017\t3!B\u0001\t\u0006a\u0015\u0011kA\u0002\u0005\f%\tA\u0001\u0001"})
public final class JoinBlockIntoSingleStatementHandler
implements JoinRawLinesHandlerDelegate {
    public static final /* synthetic */ KClass $kotlinClass;

    static {
        $kotlinClass = Reflection.createKotlinClass(JoinBlockIntoSingleStatementHandler.class);
    }

    public int tryJoinRawLines(@NotNull Document document, @NotNull PsiFile file, int start, int end) {
        Intrinsics.checkParameterIsNotNull((Object)document, (String)"document");
        Intrinsics.checkParameterIsNotNull((Object)file, (String)"file");
        if (!(file instanceof JetFile)) {
            return -1;
        }
        if (start == 0) {
            return -1;
        }
        char c = StringsKt.get((CharSequence)document.getCharsSequence(), (int)start);
        int index2 = c == '\n' ? start - 1 : start;
        PsiElement psiElement2 = ((JetFile)file).findElementAt(index2);
        if (psiElement2 == null) {
            Intrinsics.throwNpe();
        }
        PsiElement brace = psiElement2;
        ASTNode aSTNode = brace.getNode();
        if (aSTNode == null) {
            Intrinsics.throwNpe();
        }
        if (Intrinsics.areEqual((Object)aSTNode.getElementType(), (Object)((Object)JetTokens.LBRACE)) ^ true) {
            return -1;
        }
        PsiElement psiElement3 = brace.getParent();
        if (!(psiElement3 instanceof JetBlockExpression)) {
            psiElement3 = null;
        }
        JetBlockExpression jetBlockExpression = (JetBlockExpression)psiElement3;
        if (jetBlockExpression == null) {
            return -1;
        }
        JetBlockExpression block = jetBlockExpression;
        JetExpression jetExpression = (JetExpression)CollectionsKt.singleOrNull(block.getStatements());
        if (jetExpression == null) {
            return -1;
        }
        JetExpression statement = jetExpression;
        PsiElement parent2 = block.getParent();
        if (!(parent2 instanceof JetContainerNode) && !(parent2 instanceof JetWhenEntry)) {
            return -1;
        }
        if (ArraysKt.isNotEmpty((Object[])block.getNode().getChildren(JetTokens.COMMENTS))) {
            return -1;
        }
        PsiElement pparent = parent2.getParent();
        if (pparent instanceof JetIfExpression && Intrinsics.areEqual((Object)block, (Object)((JetIfExpression)pparent).getThen()) && statement instanceof JetIfExpression && ((JetIfExpression)statement).getElse() == null) {
            if (((JetIfExpression)pparent).getElse() != null) {
                return -1;
            }
            JetExpression condition1 = ((JetIfExpression)pparent).getCondition();
            JetExpression condition2 = ((JetIfExpression)statement).getCondition();
            JetExpression body2 = ((JetIfExpression)statement).getThen();
            if (condition1 != null && condition2 != null && body2 != null) {
                JetExpression newCondition = CreateByPatternKt.createExpressionByPattern(JetPsiFactoryKt.JetPsiFactory(pparent), "$0 && $1", condition1, condition2);
                condition1.replace((PsiElement)newCondition);
                PsiElement newBody = block.replace((PsiElement)body2);
                TextRange textRange = newBody.getTextRange();
                if (textRange == null) {
                    Intrinsics.throwNpe();
                }
                return textRange.getStartOffset();
            }
        }
        PsiElement newStatement = block.replace((PsiElement)statement);
        TextRange textRange = newStatement.getTextRange();
        if (textRange == null) {
            Intrinsics.throwNpe();
        }
        return textRange.getStartOffset();
    }

    public int tryJoinLines(@NotNull Document document, @NotNull PsiFile file, int start, int end) {
        Intrinsics.checkParameterIsNotNull((Object)document, (String)"document");
        Intrinsics.checkParameterIsNotNull((Object)file, (String)"file");
        return -1;
    }
}

