/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.liveTemplates.macro;

import com.intellij.codeInsight.template.Expression;
import com.intellij.codeInsight.template.ExpressionContext;
import com.intellij.codeInsight.template.JavaCodeContextType;
import com.intellij.codeInsight.template.ListResult;
import com.intellij.codeInsight.template.Macro;
import com.intellij.codeInsight.template.Result;
import com.intellij.codeInsight.template.TemplateContextType;
import com.intellij.codeInsight.template.TextResult;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import java.util.ArrayList;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.idea.JetBundle;
import org.jetbrains.kotlin.psi.JetFunction;
import org.jetbrains.kotlin.psi.JetParameter;

public class JetFunctionParametersMacro
extends Macro {
    public String getName() {
        return "functionParameters";
    }

    public String getPresentableName() {
        return JetBundle.message("macro.fun.parameters", new Object[0]);
    }

    public Result calculateResult(@NotNull Expression[] params2, ExpressionContext context) {
        if (params2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "params", "org/jetbrains/kotlin/idea/liveTemplates/macro/JetFunctionParametersMacro", "calculateResult"));
        }
        Project project = context.getProject();
        int templateStartOffset = context.getTemplateStartOffset();
        int offset2 = templateStartOffset > 0 ? context.getTemplateStartOffset() - 1 : context.getTemplateStartOffset();
        PsiDocumentManager.getInstance((Project)project).commitAllDocuments();
        PsiFile file = PsiDocumentManager.getInstance((Project)project).getPsiFile(context.getEditor().getDocument());
        if (file == null) {
            return null;
        }
        for (PsiElement place = file.findElementAt(offset2); place != null; place = place.getParent()) {
            if (!(place instanceof JetFunction)) continue;
            ArrayList<TextResult> result2 = new ArrayList<TextResult>();
            for (JetParameter param : ((JetFunction)place).getValueParameters()) {
                String name2 = param.getName();
                assert (name2 != null);
                result2.add(new TextResult(name2));
            }
            return new ListResult(result2);
        }
        return null;
    }

    public boolean isAcceptableInContext(TemplateContextType context) {
        return context instanceof JavaCodeContextType;
    }
}

