/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.projectView;

import com.intellij.ide.projectView.PresentationData;
import com.intellij.ide.projectView.ViewSettings;
import com.intellij.ide.projectView.impl.nodes.AbstractPsiBasedNode;
import com.intellij.ide.util.treeView.AbstractTreeNode;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.codeStyle.CodeStyleSettingsManager;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.jetbrains.kotlin.idea.core.formatter.JetCodeStyleSettings;
import org.jetbrains.kotlin.psi.JetClassInitializer;
import org.jetbrains.kotlin.psi.JetDeclaration;
import org.jetbrains.kotlin.psi.JetFunction;
import org.jetbrains.kotlin.psi.JetModifierListOwner;
import org.jetbrains.kotlin.psi.JetParameter;
import org.jetbrains.kotlin.psi.JetProperty;
import org.jetbrains.kotlin.psi.JetPsiUtil;
import org.jetbrains.kotlin.psi.JetTypeReference;

public class JetDeclarationTreeNode
extends AbstractPsiBasedNode<JetDeclaration> {
    public static final String CLASS_INITIALIZER = "<class initializer>";

    protected JetDeclarationTreeNode(Project project, JetDeclaration jetDeclaration, ViewSettings viewSettings) {
        super(project, (Object)jetDeclaration, viewSettings);
    }

    protected PsiElement extractPsiFromValue() {
        return (PsiElement)this.getValue();
    }

    protected Collection<AbstractTreeNode> getChildrenImpl() {
        return Collections.emptyList();
    }

    protected void updateImpl(PresentationData data2) {
        JetDeclaration declaration = (JetDeclaration)this.getValue();
        if (declaration != null) {
            String text;
            String string = text = declaration instanceof JetClassInitializer ? CLASS_INITIALIZER : declaration.getName();
            if (text == null) {
                return;
            }
            JetCodeStyleSettings settings = (JetCodeStyleSettings)CodeStyleSettingsManager.getInstance((Project)this.getProject()).getCurrentSettings().getCustomSettings(JetCodeStyleSettings.class);
            if (declaration instanceof JetProperty) {
                JetProperty property2 = (JetProperty)declaration;
                JetTypeReference ref = property2.getTypeReference();
                if (ref != null) {
                    if (settings.SPACE_BEFORE_TYPE_COLON) {
                        text = text + " ";
                    }
                    text = text + ":";
                    if (settings.SPACE_AFTER_TYPE_COLON) {
                        text = text + " ";
                    }
                    text = text + ref.getText();
                }
            } else if (declaration instanceof JetFunction) {
                JetFunction function2 = (JetFunction)declaration;
                JetTypeReference receiverTypeRef = function2.getReceiverTypeReference();
                if (receiverTypeRef != null) {
                    text = receiverTypeRef.getText() + "." + text;
                }
                text = text + "(";
                List<JetParameter> parameters2 = function2.getValueParameters();
                for (JetParameter parameter : parameters2) {
                    JetTypeReference typeReference;
                    if (parameter.getName() != null) {
                        text = text + parameter.getName();
                        if (settings.SPACE_BEFORE_TYPE_COLON) {
                            text = text + " ";
                        }
                        text = text + ":";
                        if (settings.SPACE_AFTER_TYPE_COLON) {
                            text = text + " ";
                        }
                    }
                    if ((typeReference = parameter.getTypeReference()) != null) {
                        text = text + typeReference.getText();
                    }
                    text = text + ", ";
                }
                if (parameters2.size() > 0) {
                    text = text.substring(0, text.length() - 2);
                }
                text = text + ")";
                JetTypeReference typeReference = function2.getTypeReference();
                if (typeReference != null) {
                    if (settings.SPACE_BEFORE_TYPE_COLON) {
                        text = text + " ";
                    }
                    text = text + ":";
                    if (settings.SPACE_AFTER_TYPE_COLON) {
                        text = text + " ";
                    }
                    text = text + typeReference.getText();
                }
            }
            data2.setPresentableText(text);
        }
    }

    protected boolean isDeprecated() {
        return JetPsiUtil.isDeprecated((JetModifierListOwner)this.getValue());
    }
}

