/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.quickfix;

import com.intellij.codeInsight.intention.IntentionAction;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.util.IncorrectOperationException;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.diagnostics.Diagnostic;
import org.jetbrains.kotlin.diagnostics.DiagnosticWithParameters2;
import org.jetbrains.kotlin.diagnostics.Errors;
import org.jetbrains.kotlin.idea.JetBundle;
import org.jetbrains.kotlin.idea.caches.resolve.ResolutionUtils;
import org.jetbrains.kotlin.idea.quickfix.JetIntentionAction;
import org.jetbrains.kotlin.idea.quickfix.JetSingleIntentionActionFactory;
import org.jetbrains.kotlin.idea.util.IdeDescriptorRenderers;
import org.jetbrains.kotlin.idea.util.ShortenReferences;
import org.jetbrains.kotlin.psi.JetBinaryExpressionWithTypeRHS;
import org.jetbrains.kotlin.psi.JetElement;
import org.jetbrains.kotlin.psi.JetExpression;
import org.jetbrains.kotlin.psi.JetFile;
import org.jetbrains.kotlin.psi.JetParenthesizedExpression;
import org.jetbrains.kotlin.psi.JetPsiFactory;
import org.jetbrains.kotlin.psi.JetPsiUtil;
import org.jetbrains.kotlin.psi.JetTypeReference;
import org.jetbrains.kotlin.psi.PsiPackage;
import org.jetbrains.kotlin.resolve.jvm.diagnostics.ErrorsJvm;
import org.jetbrains.kotlin.types.JetType;
import org.jetbrains.kotlin.types.TypesPackage;
import org.jetbrains.kotlin.types.checker.JetTypeChecker;

public class CastExpressionFix
extends JetIntentionAction<JetExpression> {
    private final JetType type;

    public CastExpressionFix(@NotNull JetExpression element2, @NotNull JetType type2) {
        if (element2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "org/jetbrains/kotlin/idea/quickfix/CastExpressionFix", "<init>"));
        }
        if (type2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "org/jetbrains/kotlin/idea/quickfix/CastExpressionFix", "<init>"));
        }
        super(element2);
        this.type = type2;
    }

    @NotNull
    public String getText() {
        String string = JetBundle.message("cast.expression.to.type", ((JetExpression)this.element).getText(), IdeDescriptorRenderers.SOURCE_CODE_SHORT_NAMES_IN_TYPES.renderType(this.type));
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/idea/quickfix/CastExpressionFix", "getText"));
        }
        return string;
    }

    @NotNull
    public String getFamilyName() {
        String string = JetBundle.message("cast.expression.family", new Object[0]);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/idea/quickfix/CastExpressionFix", "getFamilyName"));
        }
        return string;
    }

    @Override
    public boolean isAvailable(@NotNull Project project, Editor editor, PsiFile file) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "org/jetbrains/kotlin/idea/quickfix/CastExpressionFix", "isAvailable"));
        }
        if (!super.isAvailable(project, editor, file)) {
            return false;
        }
        JetType expressionType = ResolutionUtils.analyze((JetElement)this.element).getType((JetExpression)this.element);
        return expressionType != null && (JetTypeChecker.DEFAULT.isSubtypeOf(this.type, expressionType) || JetTypeChecker.DEFAULT.isSubtypeOf(expressionType, this.type));
    }

    @Override
    public void invoke(@NotNull Project project, Editor editor, JetFile file) throws IncorrectOperationException {
        JetParenthesizedExpression castExpressionInParentheses;
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "org/jetbrains/kotlin/idea/quickfix/CastExpressionFix", "invoke"));
        }
        String renderedType = IdeDescriptorRenderers.SOURCE_CODE.renderType(this.type);
        JetPsiFactory psiFactory = PsiPackage.JetPsiFactory((PsiElement)file);
        JetBinaryExpressionWithTypeRHS castExpression = (JetBinaryExpressionWithTypeRHS)psiFactory.createExpression("(" + ((JetExpression)this.element).getText() + ") as " + renderedType);
        if (JetPsiUtil.areParenthesesUseless((JetParenthesizedExpression)castExpression.getLeft())) {
            castExpression = (JetBinaryExpressionWithTypeRHS)psiFactory.createExpression(((JetExpression)this.element).getText() + " as " + renderedType);
        }
        if (JetPsiUtil.areParenthesesUseless(castExpressionInParentheses = (JetParenthesizedExpression)((JetExpression)this.element).replace((PsiElement)psiFactory.createExpression("(" + castExpression.getText() + ")")))) {
            castExpression = (JetBinaryExpressionWithTypeRHS)castExpressionInParentheses.replace((PsiElement)castExpression);
        } else {
            castExpression = (JetBinaryExpressionWithTypeRHS)castExpressionInParentheses.getExpression();
            assert (castExpression != null);
        }
        JetTypeReference typeRef = castExpression.getRight();
        assert (typeRef != null);
        ShortenReferences.DEFAULT.process(typeRef);
    }

    @NotNull
    public static JetSingleIntentionActionFactory createFactoryForSmartCastImpossible() {
        JetSingleIntentionActionFactory jetSingleIntentionActionFactory = new JetSingleIntentionActionFactory(){

            @Override
            @Nullable
            public IntentionAction createAction(@NotNull Diagnostic diagnostic) {
                if (diagnostic == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "diagnostic", "org/jetbrains/kotlin/idea/quickfix/CastExpressionFix$1", "createAction"));
                }
                DiagnosticWithParameters2 diagnosticWithParameters = (DiagnosticWithParameters2)Errors.SMARTCAST_IMPOSSIBLE.cast(diagnostic);
                return new CastExpressionFix((JetExpression)diagnosticWithParameters.getPsiElement(), (JetType)diagnosticWithParameters.getA());
            }
        };
        if (jetSingleIntentionActionFactory == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/idea/quickfix/CastExpressionFix", "createFactoryForSmartCastImpossible"));
        }
        return jetSingleIntentionActionFactory;
    }

    @NotNull
    public static JetSingleIntentionActionFactory createFactoryForGenericVarianceConversion() {
        JetSingleIntentionActionFactory jetSingleIntentionActionFactory = new JetSingleIntentionActionFactory(){

            @Override
            @Nullable
            public IntentionAction createAction(@NotNull Diagnostic diagnostic) {
                if (diagnostic == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "diagnostic", "org/jetbrains/kotlin/idea/quickfix/CastExpressionFix$2", "createAction"));
                }
                DiagnosticWithParameters2 diagnosticWithParameters = (DiagnosticWithParameters2)ErrorsJvm.JAVA_TYPE_MISMATCH.cast(diagnostic);
                return new CastExpressionFix((JetExpression)diagnosticWithParameters.getPsiElement(), TypesPackage.flexibility((JetType)diagnosticWithParameters.getB()).getUpperBound());
            }
        };
        if (jetSingleIntentionActionFactory == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/idea/quickfix/CastExpressionFix", "createFactoryForGenericVarianceConversion"));
        }
        return jetSingleIntentionActionFactory;
    }
}

