/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.quickfix;

import com.intellij.codeInsight.intention.IntentionAction;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.util.IncorrectOperationException;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.diagnostics.Diagnostic;
import org.jetbrains.kotlin.idea.JetBundle;
import org.jetbrains.kotlin.idea.core.quickfix.QuickFixUtil;
import org.jetbrains.kotlin.idea.quickfix.JetIntentionAction;
import org.jetbrains.kotlin.idea.quickfix.JetSingleIntentionActionFactory;
import org.jetbrains.kotlin.psi.JetBinaryExpressionWithTypeRHS;
import org.jetbrains.kotlin.psi.JetFile;
import org.jetbrains.kotlin.psi.JetTypeElement;
import org.jetbrains.kotlin.psi.JetTypeReference;
import org.jetbrains.kotlin.psi.PsiPackage;
import org.jetbrains.kotlin.types.expressions.TypeReconstructionUtil;

public class ChangeToStarProjectionFix
extends JetIntentionAction<JetTypeElement> {
    public ChangeToStarProjectionFix(@NotNull JetTypeElement element2) {
        if (element2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "org/jetbrains/kotlin/idea/quickfix/ChangeToStarProjectionFix", "<init>"));
        }
        super(element2);
    }

    @NotNull
    public String getText() {
        String stars = TypeReconstructionUtil.getTypeNameAndStarProjectionsString("", ((JetTypeElement)this.element).getTypeArgumentsAsTypes().size());
        String string = JetBundle.message("change.to.star.projection", stars);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/idea/quickfix/ChangeToStarProjectionFix", "getText"));
        }
        return string;
    }

    @NotNull
    public String getFamilyName() {
        String string = JetBundle.message("change.to.star.projection.family", new Object[0]);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/idea/quickfix/ChangeToStarProjectionFix", "getFamilyName"));
        }
        return string;
    }

    @Override
    public void invoke(@NotNull Project project, Editor editor, JetFile file) throws IncorrectOperationException {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "org/jetbrains/kotlin/idea/quickfix/ChangeToStarProjectionFix", "invoke"));
        }
        for (JetTypeReference typeReference : ((JetTypeElement)this.element).getTypeArgumentsAsTypes()) {
            if (typeReference == null) continue;
            typeReference.replace(PsiPackage.JetPsiFactory((PsiElement)file).createStar());
        }
    }

    public static JetSingleIntentionActionFactory createFactory() {
        return new JetSingleIntentionActionFactory(){

            @Override
            public IntentionAction createAction(Diagnostic diagnostic) {
                JetBinaryExpressionWithTypeRHS expression2 = QuickFixUtil.getParentElementOfType(diagnostic, JetBinaryExpressionWithTypeRHS.class);
                JetTypeReference typeReference = expression2 == null ? QuickFixUtil.getParentElementOfType(diagnostic, JetTypeReference.class) : expression2.getRight();
                if (typeReference == null) {
                    return null;
                }
                JetTypeElement typeElement = typeReference.getTypeElement();
                assert (typeElement != null);
                return new ChangeToStarProjectionFix(typeElement);
            }
        };
    }
}

