/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.quickfix;

import com.intellij.codeInspection.SuppressIntentionAction;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import kotlin.PreconditionsKt;
import kotlin.TypeCastException;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.KotlinClass;
import kotlin.jvm.internal.Reflection;
import kotlin.reflect.KClass;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.builtins.KotlinBuiltIns;
import org.jetbrains.kotlin.descriptors.annotations.AnnotationDescriptor;
import org.jetbrains.kotlin.diagnostics.DiagnosticFactory;
import org.jetbrains.kotlin.idea.JetBundle;
import org.jetbrains.kotlin.idea.caches.resolve.ResolutionUtils;
import org.jetbrains.kotlin.idea.quickfix.AnnotationHostKind;
import org.jetbrains.kotlin.idea.quickfix.CaretBox;
import org.jetbrains.kotlin.idea.quickfix.KotlinSuppressIntentionActionKt;
import org.jetbrains.kotlin.idea.util.JetPsiPrecedences;
import org.jetbrains.kotlin.psi.JetAnnotated;
import org.jetbrains.kotlin.psi.JetAnnotatedExpression;
import org.jetbrains.kotlin.psi.JetAnnotationEntry;
import org.jetbrains.kotlin.psi.JetDeclaration;
import org.jetbrains.kotlin.psi.JetExpression;
import org.jetbrains.kotlin.psi.JetModifierList;
import org.jetbrains.kotlin.psi.JetModifierListOwner;
import org.jetbrains.kotlin.psi.JetPsiFactory;
import org.jetbrains.kotlin.psi.JetPsiFactoryKt;
import org.jetbrains.kotlin.psi.JetPsiUtil;
import org.jetbrains.kotlin.psi.JetValueArgumentList;
import org.jetbrains.kotlin.resolve.BindingContext;

@KotlinClass(version={0, 25, 0}, abiVersion=25, data={"8\f)i2j\u001c;mS:\u001cV\u000f\u001d9sKN\u001c\u0018J\u001c;f]RLwN\\!di&|gNC\u0002pe\u001eT\u0011B[3uEJ\f\u0017N\\:\u000b\r-|G\u000f\\5o\u0015\u0011IG-Z1\u000b\u0011E,\u0018nY6gSbTqcU;qaJ,7o]%oi\u0016tG/[8o\u0003\u000e$\u0018n\u001c8\u000b\u0007\r|WN\u0003\u0005j]R,G\u000e\\5k\u00159\u0019w\u000eZ3J]N\u0004Xm\u0019;j_:Ta\u0001P5oSRt$BC:vaB\u0014Xm]:Bi*i!*\u001a;FqB\u0014Xm]:j_:T1\u0001]:j\u0015E!\u0017.Y4o_N$\u0018n\u0019$bGR|'/\u001f\u0006\u0012\t&\fwM\\8ti&\u001cg)Y2u_JL(b\u00033jC\u001etwn\u001d;jGNTAa[5oI*\u0011\u0012I\u001c8pi\u0006$\u0018n\u001c8I_N$8*\u001b8e\u0015}\tG\rZ!sOVlWM\u001c;U_N+\b\u000f\u001d:fgN\feN\\8uCRLwN\u001c\u0006\u0006K:$(/\u001f\u0006\u0013\u0015\u0016$\u0018I\u001c8pi\u0006$\u0018n\u001c8F]R\u0014\u0018P\u0003\u0002jI*11\u000b\u001e:j]\u001eTA!\u00168ji*!!.\u0019<b\u0015\u0011a\u0017M\\4\u000b-\u0019Lg\u000eZ*vaB\u0014Xm]:B]:|G/\u0019;j_:T\u0011\"\u00198o_R\fG/\u001a3\u000b\u0019)+G/\u00118o_R\fG/\u001a3\u000b\u001b\u001d,GOR1nS2Lh*Y7f\u0015\u001dqu\u000e\u001e(vY2T1\"\u00198o_R\fG/[8og*9q-\u001a;UKb$(BB5om>\\WMC\u0004qe>TWm\u0019;\u000b\u000fA\u0013xN[3di*9q\u000e]3oCBL'BB3eSR|'O\u0003\u0004FI&$xN\u001d\u0006\bK2,W.\u001a8u\u0015)\u00016/[#mK6,g\u000e\u001e\u0006\fSN\fe/Y5mC\ndWMC\u0004C_>dW-\u00198\u000b-M,\b\u000f\u001d:fgN\feN\\8uCRLwN\u001c+fqRTQd];qaJ,7o]!u\u0003:tw\u000e^1uK\u0012,\u0005\u0010\u001d:fgNLwN\u001c\u0006\t\u0007\u0006\u0014X\r\u001e\"pq*1\"*\u001a;B]:|G/\u0019;fI\u0016C\bO]3tg&|gN\u0003\u000btkB\u0004(/Z:t\u0003R,\u0005\u0010\u001d:fgNLwN\u001c\u0006\tG\u0006\u0014X\r\u001e\"pq*Y2/\u001e9qe\u0016\u001c8/\u0011;N_\u0012Lg-[3s\u0019&\u001cHoT<oKJTACS3u\u001b>$\u0017NZ5fe2K7\u000f^(x]\u0016\u0014hV\u0001\u0006\u0003!\u0005QA\u0001\u0003\u0001\u0011\u0005)!\u0001\"\u0001\t\u0004\u0015\u0011A!\u0001\u0005\u0003\u000b\t!\u0019\u0001#\u0002\u0006\u0007\u0011\u0011\u0001\u0002\u0001\u0007\u0001\u000b\u0005A9!\u0002\u0002\u0005\u0007!!QA\u0001C\u0004\u0011\u0013)1\u0001\u0002\u0003\t\u00071\u0001QA\u0001\u0003\u0002\u0011\u001b)1\u0001B\u0003\t\r1\u0001QA\u0001\u0003\u0002\u0011!)1\u0001\u0002\u0004\t\u00101\u0001Qa\u0001\u0003\u0003\u0011%a\u0001!\u0002\u0002\u0005\u000b!1QA\u0001\u0003\u0007\u0011\u001f)!\u0001\u0002\u0002\t\u0013\u0015\u0019A!\u0002E\u000b\u0019\u0001)\u0011\u0001c\u0001\u0006\u0007\u0011M\u0001r\u0003\u0007\u0001\u000b\r!\u0019\u0002\u0003\u0007\r\u0001\u0015\u0011A!\u0002E\u000b\u000b\u0005AI\"\u0002\u0002\u0005\u0018!iQA\u0001\u0003\r\u0011/)1\u0001B\u0003\t\u001e1\u0001QA\u0001\u0003\u0006\u0011;)!\u0001\"\u0001\t!\u0015\u0019AA\u0004E\u0010\u0019\u0001)!\u0001b\u0002\t&\u0015\u0011Aa\u0004E\u0012\u000b\r!y\u0002\u0003\n\r\u0001\u0015\u0011Aa\u0004\u0005\u0014\u000b\r!\t\u0003c\n\r\u0001\u0015\u0011Aq\u0001E\u0007\u000b\r!\u0019\u0003#\u000b\r\u0001\u0015\u0011Aq\u0004\u0005\u0013\u000b\t!\t\u0003c\n\u0006\u0005\u0011\r\u0002\u0012F\u0003\u0004\t'AY\u0003\u0004\u0001\u0006\u0007\u0011\u0011\u0001b\u0006\u0007\u0001\u000b\r!Q\u0001c\f\r\u0001\u0015\u0011AA\u0001\u0005\u0018\u000b\r!Q\u0001c\r\r\u0001\u0015\u0011A!\u0002E\u001a\t\ra)!G\u0002\u0006\u0003!%\u0001\u0014B\u0017\u000f\t\u0005$\u0001dB\u0011\u0006\u000b\u0005Ai!C\u0001\u0005\u0004a5Qk\u0001\u0003\u0006\u0007\u00119\u0011\"\u0001\u0005\t[1!\u0011\r\u0002M\tC\r)\u0011\u0001C\u0004\u0019\u000fU\u001bA!B\u0002\u0005\u0012%\t\u0001\u0012C\u0017\r\t\u0005$\u00014B\u0011\u0004\u000b\u0005AY\u0001g\u0003V\u0007\u0011)1\u0001b\u0003\n\u0003!=Qv\b\u0003\u00021'iz\u0001\u0002\u0001\t\u00155\u0019Q!\u0001\u0005\n1%\u00016\u0001AO\b\t\u0001A1\"D\u0002\u0006\u0003!Q\u0001D\u0003)\u0004\u0002\u0005\u001aQ!\u0001E\u000b1+\t6a\u0002C\n\u0013\u0005!\u0001!D\u0001\t\u00175\t\u0001\u0012D\u0017\u0017\t\u0005AZ\"h\u0004\u0005\u0001!qQbA\u0003\u0002\u00115AR\u0002U\u0002\u0001C\u0011)\u0011\u0001C\u0005\r\u0002aI\u0011kA\u0003\u0005\u001c%\t\u0001bC\u0007\u0002\u00117iS\u0002B\u0006\u0019\u001f\u0005.Q!\u0001\u0005\u000b1)\t6!\u0001C\u000f#\u000e\u0019AaD\u0005\u0002\u00113iS\u0002B\u0006\u0019\"\u0005.Q!\u0001\u0005\u000b1)\t6!\u0001C\u000f#\u000e\u0019A\u0011E\u0005\u0002\u00113i3\u0006B\u0006\u0019#u=A\u0001\u0001E\u0012\u001b\r)\u0011\u0001\u0003\t\u0019!A\u001b\u0001!(\u0005\u0005\u0001!\u0019R\u0002B\u0003\u0002\u0011Ea\t\u0001G\tQ\u0007\u0003iz\u0001\u0002\u0001\t)5\u0019Q!\u0001\u0005\u00131I\u00016!A\u0011\u0004\u000b\u0005A)\u0002'\u0006R\u0007%!\u0011#C\u0001\u0005\u00015\t\u0001RE\u0007\u0002\u0011Mi\u0011\u0001c\n.W\u0011Y\u0001$FO\b\t\u0001A\u0019#D\u0002\u0006\u0003!\u0001\u0002\u0004\u0005)\u0004\u0001uEA\u0001\u0001\u0005\u0014\u001b\u0011)\u0011\u0001C\t\r\u0002a\t\u0002k!\u0001\u001e\u0010\u0011\u0001\u0001\u0002F\u0007\u0004\u000b\u0005A!\u0003\u0007\nQ\u0007\u0005\t3!B\u0001\t)a!\u0012kA\u0005\u0005+%\tA\u0011A\u0007\u0002\u0011Ki\u0011\u0001C\n\u000e\u0003!\u001dR&\u0006\u0003\u00021Yiz\u0001\u0002\u0001\t\u00175\u0019Q!\u0001\u0005\u000b1)\u00016\u0001A\u0011\u0004\u000b\u0005A!\u0002\u0007\u0006R\u0007\u0015!a#C\u0001\t\u001a5\t\u0001\u0012DW%\t\u0005Aj#(\u0007\u0005\u0001!-Q\u0002C\u0003\u0002\u0011SIA!C\u0002\u0006\u0003!)\u0002$\u0006M\u0015!\u000e\u0001Qt\u0002\u0003\u0001\u0011-i1!B\u0001\t\u0015aQ\u0001k!\u0001\"\u0007\u0015\t\u0001R\u0003M\u000b#\u000e9AQF\u0005\u0002\t\u0001i\u0011\u0001c\u000b\u000e\u0003!eQ\u0016\n\u0003\u00021aiJ\u0002\u0002\u0001\t25AQ!\u0001E\u0015\u0013\u0011I1!B\u0001\t\fa-\u0001\u0014\u0006)\u0004\u0001u=A\u0001\u0001\u0005\f\u001b\r)\u0011\u0001\u0003\u0006\u0019\u0015A\u001b\t!I\u0002\u0006\u0003!U\u0001TC)\u0004\u000f\u0011A\u0012\"\u0001\u0003\u0001\u001b\u0005AY#D\u0001\t\u001a5~B!\u0001\r\u001a;\u001f!\u0001\u0001c\u0003\u000e\u0007\u0015\t\u0001B\u0006\r\u0017!\u000e\u0001Qt\u0002\u0003\u0001\u0011-i1!B\u0001\t\u0015aQ\u0001k!\u0001\"\u0007\u0015\t\u0001R\u0003M\u000b#\u000e9A!G\u0005\u0002\t\u0001i\u0011\u0001#\f\u000e\u0003!eQ7LC-\t\r\b\u0001$BO\b\t\u0001AY!D\u0002\u0006\u0003!-\u00014\u0002)\u0004\u0001uMA\u0001\u0001\u0005\b\u001b\u0015)\u0011\u0001#\u0004\n\u0003\u0011\r\u0001T\u0002)\u0004\u0002u=A\u0001\u0001E\t\u001b\r)\u0011\u0001C\u0004\u0019\u000fA\u001b\u0011!I\u0002\u0006\u0003!\u0015\u0001TA)\u0004\u0013\u0011)\u0011\"\u0001\u0003\u0001\u001b\u0005Ay!D\u0001\t\u00115\t\u0001\u0012\u0003"})
public final class KotlinSuppressIntentionAction
extends SuppressIntentionAction {
    public static final /* synthetic */ KClass $kotlinClass;
    private final JetExpression suppressAt;
    private final DiagnosticFactory<?> diagnosticFactory;
    private final AnnotationHostKind kind;

    static {
        $kotlinClass = Reflection.createKotlinClass(KotlinSuppressIntentionAction.class);
    }

    @NotNull
    public String getFamilyName() {
        return JetBundle.message("suppress.warnings.family", new Object[0]);
    }

    @NotNull
    public String getText() {
        return JetBundle.message("suppress.warning.for", this.diagnosticFactory.getName(), this.kind.getKind(), this.kind.getName());
    }

    public boolean isAvailable(@NotNull Project project, @Nullable Editor editor, @NotNull PsiElement element2) {
        Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
        Intrinsics.checkParameterIsNotNull((Object)element2, (String)"element");
        return element2.isValid();
    }

    public void invoke(@NotNull Project project, @Nullable Editor editor, @NotNull PsiElement element2) {
        Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
        Intrinsics.checkParameterIsNotNull((Object)element2, (String)"element");
        String id = "\"" + this.diagnosticFactory.getName() + "\"";
        if (this.suppressAt instanceof JetModifierListOwner) {
            this.suppressAtModifierListOwner((JetModifierListOwner)((Object)this.suppressAt), id);
        } else if (this.suppressAt instanceof JetAnnotatedExpression) {
            this.suppressAtAnnotatedExpression(new CaretBox<JetExpression>(this.suppressAt, editor), id);
        } else if (this.suppressAt instanceof JetExpression) {
            this.suppressAtExpression(new CaretBox<JetExpression>(this.suppressAt, editor), id);
        }
    }

    private final void suppressAtModifierListOwner(JetModifierListOwner suppressAt, String id) {
        JetModifierList modifierList = suppressAt.getModifierList();
        JetPsiFactory psiFactory = JetPsiFactoryKt.JetPsiFactory(suppressAt);
        if (modifierList == null) {
            JetModifierList newModifierList = psiFactory.createModifierList(this.suppressAnnotationText(id));
            JetModifierList replaced = JetPsiUtil.replaceModifierList(suppressAt, newModifierList);
            PsiElement whiteSpace = KotlinSuppressIntentionActionKt.createWhiteSpace(psiFactory, this.kind);
            suppressAt.addAfter(whiteSpace, (PsiElement)replaced);
        } else {
            JetAnnotationEntry entry = this.findSuppressAnnotation(suppressAt);
            if (entry == null) {
                JetAnnotationEntry newAnnotation = psiFactory.createAnnotationEntry(this.suppressAnnotationText(id));
                PsiElement addedAnnotation = modifierList.addBefore((PsiElement)newAnnotation, modifierList.getFirstChild());
                PsiElement whiteSpace = KotlinSuppressIntentionActionKt.createWhiteSpace(psiFactory, this.kind);
                modifierList.addAfter(whiteSpace, addedAnnotation);
            } else {
                this.addArgumentToSuppressAnnotation(entry, id);
            }
        }
    }

    private final void suppressAtAnnotatedExpression(CaretBox<? extends JetAnnotatedExpression> suppressAt, String id) {
        JetAnnotationEntry entry = this.findSuppressAnnotation(suppressAt.getExpression());
        if (entry != null) {
            this.addArgumentToSuppressAnnotation(entry, id);
        } else {
            this.suppressAtExpression(suppressAt, id);
        }
    }

    private final void suppressAtExpression(CaretBox<? extends JetExpression> caretBox, String id) {
        JetExpression suppressAt = caretBox.getExpression();
        PreconditionsKt.assert((!(suppressAt instanceof JetDeclaration) ? 1 : 0) != 0, (Object)"Declarations should have been checked for above");
        boolean parentheses = JetPsiPrecedences.INSTANCE$.getPrecedence(suppressAt) > JetPsiPrecedences.INSTANCE$.getPRECEDENCE_OF_PREFIX_EXPRESSION();
        String placeholderText = "PLACEHOLDER_ID";
        String inner = parentheses ? "(" + placeholderText + ")" : placeholderText;
        JetExpression annotatedExpression = JetPsiFactoryKt.JetPsiFactory((PsiElement)suppressAt).createExpression(this.suppressAnnotationText(id) + "\n" + inner);
        PsiElement psiElement2 = suppressAt.copy();
        if (psiElement2 == null) {
            Intrinsics.throwNpe();
        }
        PsiElement copy2 = psiElement2;
        PsiElement psiElement3 = suppressAt.replace((PsiElement)annotatedExpression);
        if (psiElement3 == null) {
            throw new TypeCastException("null cannot be cast to non-null type org.jetbrains.kotlin.psi.JetAnnotatedExpression");
        }
        JetAnnotatedExpression afterReplace = (JetAnnotatedExpression)psiElement3;
        PsiElement psiElement4 = afterReplace.findElementAt(afterReplace.getTextLength() - 2);
        if (psiElement4 == null) {
            Intrinsics.throwNpe();
        }
        PsiElement toReplace = psiElement4;
        PreconditionsKt.assert((boolean)Intrinsics.areEqual((Object)toReplace.getText(), (Object)placeholderText));
        PsiElement psiElement5 = toReplace.replace(copy2);
        if (psiElement5 == null) {
            Intrinsics.throwNpe();
        }
        PsiElement result2 = psiElement5;
        caretBox.positionCaretInCopy(result2);
    }

    private final void addArgumentToSuppressAnnotation(JetAnnotationEntry entry, String id) {
        JetValueArgumentList args = entry.getValueArgumentList();
        JetPsiFactory psiFactory = JetPsiFactoryKt.JetPsiFactory((PsiElement)entry);
        JetValueArgumentList newArgList = psiFactory.createCallArguments("(" + id + ")");
        if (args == null) {
            entry.addAfter((PsiElement)newArgList, entry.getLastChild());
        } else if (args.getArguments().isEmpty()) {
            args.replace((PsiElement)newArgList);
        } else {
            args.addArgument(newArgList.getArguments().get(0));
        }
    }

    private final String suppressAnnotationText(String id) {
        return "@Suppress(" + id + ")";
    }

    private final JetAnnotationEntry findSuppressAnnotation(JetAnnotated annotated) {
        BindingContext context = ResolutionUtils.analyze$default(annotated, null, 1);
        for (JetAnnotationEntry entry : annotated.getAnnotationEntries()) {
            AnnotationDescriptor annotationDescriptor = (AnnotationDescriptor)context.get(BindingContext.ANNOTATION, entry);
            if (annotationDescriptor == null || !KotlinBuiltIns.isSuppressAnnotation(annotationDescriptor)) continue;
            return entry;
        }
        return null;
    }

    public KotlinSuppressIntentionAction(@NotNull JetExpression suppressAt, @NotNull DiagnosticFactory<?> diagnosticFactory, @NotNull AnnotationHostKind kind2) {
        Intrinsics.checkParameterIsNotNull((Object)suppressAt, (String)"suppressAt");
        Intrinsics.checkParameterIsNotNull(diagnosticFactory, (String)"diagnosticFactory");
        Intrinsics.checkParameterIsNotNull((Object)kind2, (String)"kind");
        this.suppressAt = suppressAt;
        this.diagnosticFactory = diagnosticFactory;
        this.kind = kind2;
    }
}

