/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.quickfix;

import com.intellij.codeInsight.intention.IntentionAction;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.IncorrectOperationException;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.builtins.KotlinBuiltIns;
import org.jetbrains.kotlin.diagnostics.Diagnostic;
import org.jetbrains.kotlin.idea.JetBundle;
import org.jetbrains.kotlin.idea.core.quickfix.QuickFixUtil;
import org.jetbrains.kotlin.idea.quickfix.JetIntentionAction;
import org.jetbrains.kotlin.idea.quickfix.JetSingleIntentionActionFactory;
import org.jetbrains.kotlin.idea.references.JetSimpleNameReference;
import org.jetbrains.kotlin.idea.references.ReferencesPackage;
import org.jetbrains.kotlin.psi.JetAnnotationEntry;
import org.jetbrains.kotlin.psi.JetClass;
import org.jetbrains.kotlin.psi.JetFile;
import org.jetbrains.kotlin.psi.JetModifierList;
import org.jetbrains.kotlin.psi.JetPsiFactory;
import org.jetbrains.kotlin.psi.JetSimpleNameExpression;
import org.jetbrains.kotlin.psi.JetTypeReference;

public class MakeClassAnAnnotationClassFix
extends JetIntentionAction<JetAnnotationEntry> {
    private final JetAnnotationEntry annotationEntry;
    private JetClass annotationClass;

    public MakeClassAnAnnotationClassFix(@NotNull JetAnnotationEntry annotationEntry) {
        if (annotationEntry == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "annotationEntry", "org/jetbrains/kotlin/idea/quickfix/MakeClassAnAnnotationClassFix", "<init>"));
        }
        super(annotationEntry);
        this.annotationEntry = annotationEntry;
    }

    @Override
    public boolean isAvailable(@NotNull Project project, Editor editor, PsiFile file) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "org/jetbrains/kotlin/idea/quickfix/MakeClassAnAnnotationClassFix", "isAvailable"));
        }
        if (!super.isAvailable(project, editor, file)) {
            return false;
        }
        JetTypeReference typeReference = this.annotationEntry.getTypeReference();
        if (typeReference == null) {
            return false;
        }
        JetSimpleNameExpression referenceExpression = (JetSimpleNameExpression)PsiTreeUtil.findChildOfType((PsiElement)typeReference, JetSimpleNameExpression.class);
        if (referenceExpression == null) {
            return false;
        }
        JetSimpleNameReference reference = ReferencesPackage.getMainReference(referenceExpression);
        PsiElement target = reference.resolve();
        if (target instanceof JetClass) {
            this.annotationClass = (JetClass)target;
            return QuickFixUtil.canModifyElement(this.annotationClass);
        }
        return false;
    }

    @NotNull
    public String getText() {
        String string = JetBundle.message("make.class.annotation.class", this.annotationClass.getName());
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/idea/quickfix/MakeClassAnAnnotationClassFix", "getText"));
        }
        return string;
    }

    @NotNull
    public String getFamilyName() {
        String string = JetBundle.message("make.class.annotation.class.family", new Object[0]);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/idea/quickfix/MakeClassAnAnnotationClassFix", "getFamilyName"));
        }
        return string;
    }

    @Override
    public void invoke(@NotNull Project project, Editor editor, @NotNull JetFile file) throws IncorrectOperationException {
        PsiElement added;
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "org/jetbrains/kotlin/idea/quickfix/MakeClassAnAnnotationClassFix", "invoke"));
        }
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "org/jetbrains/kotlin/idea/quickfix/MakeClassAnAnnotationClassFix", "invoke"));
        }
        JetPsiFactory factory2 = new JetPsiFactory(this.annotationClass.getProject());
        JetModifierList list = this.annotationClass.getModifierList();
        String annotation2 = KotlinBuiltIns.FQ_NAMES.annotation.shortName().asString();
        if (list == null) {
            JetModifierList newModifierList = factory2.createModifierList(annotation2);
            added = this.annotationClass.addBefore((PsiElement)newModifierList, this.annotationClass.getClassOrInterfaceKeyword());
        } else {
            JetAnnotationEntry entry = factory2.createAnnotationEntry(annotation2);
            added = list.addBefore((PsiElement)entry, list.getFirstChild());
        }
        this.annotationClass.addAfter(factory2.createWhiteSpace(), added);
    }

    @NotNull
    public static JetSingleIntentionActionFactory createFactory() {
        JetSingleIntentionActionFactory jetSingleIntentionActionFactory = new JetSingleIntentionActionFactory(){

            @Override
            @Nullable
            public IntentionAction createAction(Diagnostic diagnostic) {
                JetAnnotationEntry annotation2 = QuickFixUtil.getParentElementOfType(diagnostic, JetAnnotationEntry.class);
                return annotation2 == null ? null : new MakeClassAnAnnotationClassFix(annotation2);
            }
        };
        if (jetSingleIntentionActionFactory == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/idea/quickfix/MakeClassAnAnnotationClassFix", "createFactory"));
        }
        return jetSingleIntentionActionFactory;
    }
}

