/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.quickfix;

import com.intellij.extapi.psi.ASTDelegatePsiElement;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.impl.source.tree.LeafPsiElement;
import com.intellij.util.IncorrectOperationException;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.diagnostics.Diagnostic;
import org.jetbrains.kotlin.idea.JetBundle;
import org.jetbrains.kotlin.idea.core.quickfix.QuickFixUtil;
import org.jetbrains.kotlin.idea.quickfix.JetIntentionAction;
import org.jetbrains.kotlin.idea.quickfix.JetSingleIntentionActionFactory;
import org.jetbrains.kotlin.lexer.JetTokens;
import org.jetbrains.kotlin.psi.JetExpression;
import org.jetbrains.kotlin.psi.JetFile;
import org.jetbrains.kotlin.psi.JetFunction;

public class RemoveFunctionBodyFix
extends JetIntentionAction<JetFunction> {
    public RemoveFunctionBodyFix(@NotNull JetFunction element2) {
        if (element2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "org/jetbrains/kotlin/idea/quickfix/RemoveFunctionBodyFix", "<init>"));
        }
        super(element2);
    }

    @NotNull
    public String getText() {
        String string = JetBundle.message("remove.function.body", new Object[0]);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/idea/quickfix/RemoveFunctionBodyFix", "getText"));
        }
        return string;
    }

    @NotNull
    public String getFamilyName() {
        String string = JetBundle.message("remove.function.body", new Object[0]);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/idea/quickfix/RemoveFunctionBodyFix", "getFamilyName"));
        }
        return string;
    }

    @Override
    public boolean isAvailable(@NotNull Project project, Editor editor, PsiFile file) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "org/jetbrains/kotlin/idea/quickfix/RemoveFunctionBodyFix", "isAvailable"));
        }
        return super.isAvailable(project, editor, file) && ((JetFunction)this.element).hasBody();
    }

    @Override
    public void invoke(@NotNull Project project, Editor editor, JetFile file) throws IncorrectOperationException {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "org/jetbrains/kotlin/idea/quickfix/RemoveFunctionBodyFix", "invoke"));
        }
        JetFunction function2 = (JetFunction)((JetFunction)this.element).copy();
        assert (function2 instanceof ASTDelegatePsiElement);
        ASTDelegatePsiElement functionElementWithAst = (ASTDelegatePsiElement)function2;
        JetExpression bodyExpression = function2.getBodyExpression();
        assert (bodyExpression != null);
        if (function2.hasBlockBody()) {
            PsiElement prevElement = bodyExpression.getPrevSibling();
            QuickFixUtil.removePossiblyWhiteSpace(functionElementWithAst, prevElement);
            functionElementWithAst.deleteChildInternal(bodyExpression.getNode());
        } else {
            PsiElement prevElement = bodyExpression.getPrevSibling();
            PsiElement prevPrevElement = prevElement.getPrevSibling();
            QuickFixUtil.removePossiblyWhiteSpace(functionElementWithAst, prevElement);
            RemoveFunctionBodyFix.removePossiblyEquationSign(functionElementWithAst, prevElement);
            RemoveFunctionBodyFix.removePossiblyEquationSign(functionElementWithAst, prevPrevElement);
            functionElementWithAst.deleteChildInternal(bodyExpression.getNode());
        }
        ((JetFunction)this.element).replace(function2);
    }

    private static boolean removePossiblyEquationSign(@NotNull ASTDelegatePsiElement element2, @Nullable PsiElement possiblyEq) {
        if (element2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "org/jetbrains/kotlin/idea/quickfix/RemoveFunctionBodyFix", "removePossiblyEquationSign"));
        }
        if (possiblyEq instanceof LeafPsiElement && ((LeafPsiElement)possiblyEq).getElementType() == JetTokens.EQ) {
            QuickFixUtil.removePossiblyWhiteSpace(element2, possiblyEq.getNextSibling());
            element2.deleteChildInternal(possiblyEq.getNode());
            return true;
        }
        return false;
    }

    public static JetSingleIntentionActionFactory createFactory() {
        return new JetSingleIntentionActionFactory(){

            @Override
            public JetIntentionAction<JetFunction> createAction(Diagnostic diagnostic) {
                JetFunction function2 = QuickFixUtil.getParentElementOfType(diagnostic, JetFunction.class);
                if (function2 == null) {
                    return null;
                }
                return new RemoveFunctionBodyFix(function2);
            }
        };
    }
}

