/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.quickfix;

import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.util.IncorrectOperationException;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.diagnostics.Diagnostic;
import org.jetbrains.kotlin.idea.JetBundle;
import org.jetbrains.kotlin.idea.core.quickfix.QuickFixUtil;
import org.jetbrains.kotlin.idea.quickfix.JetIntentionAction;
import org.jetbrains.kotlin.idea.quickfix.JetSingleIntentionActionFactory;
import org.jetbrains.kotlin.psi.JetFile;
import org.jetbrains.kotlin.psi.JetNullableType;
import org.jetbrains.kotlin.psi.JetTypeElement;

public class RemoveNullableFix
extends JetIntentionAction<JetNullableType> {
    private final NullableKind typeOfError;

    public RemoveNullableFix(@NotNull JetNullableType element2, @NotNull NullableKind type2) {
        if (element2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "org/jetbrains/kotlin/idea/quickfix/RemoveNullableFix", "<init>"));
        }
        if (type2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "org/jetbrains/kotlin/idea/quickfix/RemoveNullableFix", "<init>"));
        }
        super(element2);
        this.typeOfError = type2;
    }

    @NotNull
    public String getText() {
        switch (this.typeOfError) {
            case REDUNDANT: {
                String string = JetBundle.message("remove.redundant.nullable", new Object[0]);
                if (string == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/idea/quickfix/RemoveNullableFix", "getText"));
                }
                return string;
            }
            case SUPERTYPE: {
                String string = JetBundle.message("remove.supertype.nullable", new Object[0]);
                if (string == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/idea/quickfix/RemoveNullableFix", "getText"));
                }
                return string;
            }
        }
        String string = JetBundle.message("remove.useless.nullable", new Object[0]);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/idea/quickfix/RemoveNullableFix", "getText"));
        }
        return string;
    }

    @NotNull
    public String getFamilyName() {
        String string = JetBundle.message("remove.nullable.family", new Object[0]);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/idea/quickfix/RemoveNullableFix", "getFamilyName"));
        }
        return string;
    }

    @Override
    public void invoke(@NotNull Project project, Editor editor, JetFile file) throws IncorrectOperationException {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "org/jetbrains/kotlin/idea/quickfix/RemoveNullableFix", "invoke"));
        }
        JetTypeElement type2 = ((JetNullableType)this.element).getInnerType();
        assert (type2 != null) : "No inner type " + ((JetNullableType)this.element).getText() + ", should have been rejected in createFactory()";
        ((JetNullableType)this.element).replace((PsiElement)type2);
    }

    public static JetSingleIntentionActionFactory createFactory(final NullableKind typeOfError) {
        return new JetSingleIntentionActionFactory(){

            @Override
            public JetIntentionAction<JetNullableType> createAction(Diagnostic diagnostic) {
                JetNullableType nullType = QuickFixUtil.getParentElementOfType(diagnostic, JetNullableType.class);
                if (nullType == null || nullType.getInnerType() == null) {
                    return null;
                }
                return new RemoveNullableFix(nullType, typeOfError);
            }
        };
    }

    public static enum NullableKind {
        REDUNDANT,
        SUPERTYPE,
        USELESS;

    }
}

