/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.refactoring.changeSignature.usages;

import com.intellij.psi.PsiComment;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.usageView.UsageInfo;
import java.util.List;
import kotlin.KotlinPackage;
import kotlin.Pair;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.descriptors.CallableDescriptor;
import org.jetbrains.kotlin.descriptors.ClassDescriptor;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.descriptors.impl.AnonymousFunctionDescriptor;
import org.jetbrains.kotlin.idea.caches.resolve.JavaResolutionUtils;
import org.jetbrains.kotlin.idea.caches.resolve.ResolutionUtils;
import org.jetbrains.kotlin.idea.codeInsight.shorten.ShortenPackage;
import org.jetbrains.kotlin.idea.core.DescriptorUtilsKt;
import org.jetbrains.kotlin.idea.core.PsiModificationUtilsKt;
import org.jetbrains.kotlin.idea.core.refactoring.JetRefactoringUtilKt;
import org.jetbrains.kotlin.idea.refactoring.changeSignature.ChangeSignaturePackage;
import org.jetbrains.kotlin.idea.refactoring.changeSignature.JetChangeInfo;
import org.jetbrains.kotlin.idea.refactoring.changeSignature.JetParameterInfo;
import org.jetbrains.kotlin.idea.refactoring.changeSignature.JetValVar;
import org.jetbrains.kotlin.idea.refactoring.changeSignature.usages.JetUsageInfo;
import org.jetbrains.kotlin.idea.util.ShortenReferences;
import org.jetbrains.kotlin.lexer.JetModifierKeywordToken;
import org.jetbrains.kotlin.psi.JetCallableDeclaration;
import org.jetbrains.kotlin.psi.JetClass;
import org.jetbrains.kotlin.psi.JetConstructor;
import org.jetbrains.kotlin.psi.JetDeclaration;
import org.jetbrains.kotlin.psi.JetFunction;
import org.jetbrains.kotlin.psi.JetFunctionLiteral;
import org.jetbrains.kotlin.psi.JetFunctionLiteralExpression;
import org.jetbrains.kotlin.psi.JetNamedDeclaration;
import org.jetbrains.kotlin.psi.JetParameter;
import org.jetbrains.kotlin.psi.JetParameterList;
import org.jetbrains.kotlin.psi.JetPrimaryConstructor;
import org.jetbrains.kotlin.psi.JetProperty;
import org.jetbrains.kotlin.psi.JetPsiFactory;
import org.jetbrains.kotlin.psi.JetPsiUtil;
import org.jetbrains.kotlin.psi.JetTypeReference;
import org.jetbrains.kotlin.psi.PsiPackage;
import org.jetbrains.kotlin.psi.psiUtil.PsiUtilPackage;
import org.jetbrains.kotlin.psi.typeRefHelpers.TypeRefHelpersPackage;
import org.jetbrains.kotlin.resolve.BindingContext;
import org.jetbrains.kotlin.resolve.DescriptorToSourceUtils;
import org.jetbrains.kotlin.resolve.lazy.BodyResolveMode;
import org.jetbrains.kotlin.types.JetType;
import org.jetbrains.kotlin.types.TypeSubstitutor;
import org.jetbrains.kotlin.types.substitutions.SubstitutionUtilsKt;

public class JetCallableDefinitionUsage<T extends PsiElement>
extends JetUsageInfo<T> {
    @NotNull
    private final CallableDescriptor originalCallableDescriptor;
    private CallableDescriptor currentCallableDescriptor;
    @NotNull
    private final JetCallableDefinitionUsage<? extends PsiElement> baseFunction;
    private final boolean hasExpectedType;
    @Nullable
    private final JetType samCallType;
    @Nullable
    private TypeSubstitutor typeSubstitutor;

    public JetCallableDefinitionUsage(@NotNull T function2, @NotNull CallableDescriptor originalCallableDescriptor, @Nullable JetCallableDefinitionUsage<PsiElement> baseFunction, @Nullable JetType samCallType) {
        if (function2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "function", "org/jetbrains/kotlin/idea/refactoring/changeSignature/usages/JetCallableDefinitionUsage", "<init>"));
        }
        if (originalCallableDescriptor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "originalCallableDescriptor", "org/jetbrains/kotlin/idea/refactoring/changeSignature/usages/JetCallableDefinitionUsage", "<init>"));
        }
        super(function2);
        this.originalCallableDescriptor = originalCallableDescriptor;
        this.baseFunction = baseFunction != null ? baseFunction : this;
        this.hasExpectedType = JetCallableDefinitionUsage.checkIfHasExpectedType(originalCallableDescriptor, this.isInherited());
        this.samCallType = samCallType;
    }

    private static boolean checkIfHasExpectedType(@NotNull CallableDescriptor callableDescriptor, boolean isInherited) {
        if (callableDescriptor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "callableDescriptor", "org/jetbrains/kotlin/idea/refactoring/changeSignature/usages/JetCallableDefinitionUsage", "checkIfHasExpectedType"));
        }
        if (!(callableDescriptor instanceof AnonymousFunctionDescriptor) || !isInherited) {
            return false;
        }
        JetFunctionLiteral functionLiteral = (JetFunctionLiteral)DescriptorToSourceUtils.descriptorToDeclaration(callableDescriptor);
        assert (functionLiteral != null) : "No declaration found for " + callableDescriptor;
        PsiElement parent2 = functionLiteral.getParent();
        if (!(parent2 instanceof JetFunctionLiteralExpression)) {
            return false;
        }
        JetFunctionLiteralExpression expression2 = (JetFunctionLiteralExpression)parent2;
        return ResolutionUtils.analyze(expression2, BodyResolveMode.PARTIAL).get(BindingContext.EXPECTED_EXPRESSION_TYPE, expression2) != null;
    }

    @NotNull
    public JetCallableDefinitionUsage<?> getBaseFunction() {
        JetCallableDefinitionUsage<? extends PsiElement> jetCallableDefinitionUsage = this.baseFunction;
        if (jetCallableDefinitionUsage == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/idea/refactoring/changeSignature/usages/JetCallableDefinitionUsage", "getBaseFunction"));
        }
        return jetCallableDefinitionUsage;
    }

    @NotNull
    public PsiElement getDeclaration() {
        Object t = this.getElement();
        if (t == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/idea/refactoring/changeSignature/usages/JetCallableDefinitionUsage", "getDeclaration"));
        }
        return t;
    }

    @Nullable
    public TypeSubstitutor getOrCreateTypeSubstitutor() {
        if (!this.isInherited()) {
            return null;
        }
        if (this.typeSubstitutor == null) {
            if (this.samCallType == null) {
                this.typeSubstitutor = ChangeSignaturePackage.getCallableSubstitutor(this.baseFunction, this);
            } else {
                DeclarationDescriptor classDescriptor;
                CallableDescriptor currentBaseDescriptor = this.baseFunction.getCurrentCallableDescriptor();
                DeclarationDescriptor declarationDescriptor = classDescriptor = currentBaseDescriptor != null ? currentBaseDescriptor.getContainingDeclaration() : null;
                if (!(classDescriptor instanceof ClassDescriptor)) {
                    return null;
                }
                this.typeSubstitutor = SubstitutionUtilsKt.getTypeSubstitutor(((ClassDescriptor)classDescriptor).getDefaultType(), this.samCallType);
            }
        }
        return this.typeSubstitutor;
    }

    public final boolean isInherited() {
        return this.baseFunction != this;
    }

    public boolean hasExpectedType() {
        return this.hasExpectedType;
    }

    @NotNull
    public final CallableDescriptor getOriginalCallableDescriptor() {
        CallableDescriptor callableDescriptor = this.originalCallableDescriptor;
        if (callableDescriptor == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/idea/refactoring/changeSignature/usages/JetCallableDefinitionUsage", "getOriginalCallableDescriptor"));
        }
        return callableDescriptor;
    }

    @Nullable
    public final CallableDescriptor getCurrentCallableDescriptor() {
        if (this.currentCallableDescriptor == null) {
            PsiElement element2 = this.getDeclaration();
            if (element2 instanceof JetFunction || element2 instanceof JetProperty || element2 instanceof JetParameter) {
                this.currentCallableDescriptor = (CallableDescriptor)ResolutionUtils.resolveToDescriptor((JetDeclaration)element2);
            } else if (element2 instanceof JetClass) {
                this.currentCallableDescriptor = ((ClassDescriptor)ResolutionUtils.resolveToDescriptor((JetClass)element2)).getUnsubstitutedPrimaryConstructor();
            } else if (element2 instanceof PsiMethod) {
                this.currentCallableDescriptor = JavaResolutionUtils.getJavaMethodDescriptor((PsiMethod)element2);
            }
        }
        return this.currentCallableDescriptor;
    }

    @Override
    public boolean processUsage(@NotNull JetChangeInfo changeInfo, @NotNull PsiElement element2, @NotNull UsageInfo[] allUsages) {
        String receiverTypeText;
        JetTypeReference receiverTypeRef;
        JetTypeReference newReceiverTypeRef;
        PsiElement identifier;
        if (changeInfo == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "changeInfo", "org/jetbrains/kotlin/idea/refactoring/changeSignature/usages/JetCallableDefinitionUsage", "processUsage"));
        }
        if (element2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "org/jetbrains/kotlin/idea/refactoring/changeSignature/usages/JetCallableDefinitionUsage", "processUsage"));
        }
        if (allUsages == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "allUsages", "org/jetbrains/kotlin/idea/refactoring/changeSignature/usages/JetCallableDefinitionUsage", "processUsage"));
        }
        if (!(element2 instanceof JetNamedDeclaration)) {
            return true;
        }
        JetPsiFactory psiFactory = PsiPackage.JetPsiFactory(element2.getProject());
        if (changeInfo.isNameChanged() && (identifier = ((JetCallableDeclaration)element2).getNameIdentifier()) != null) {
            identifier.replace(psiFactory.createIdentifier(changeInfo.getNewName()));
        }
        this.changeReturnTypeIfNeeded(changeInfo, element2);
        JetParameterList parameterList2 = PsiUtilPackage.getValueParameterList((JetNamedDeclaration)element2);
        if (changeInfo.isParameterSetOrOrderChanged()) {
            this.processParameterListWithStructuralChanges(changeInfo, element2, parameterList2, psiFactory);
        } else if (parameterList2 != null) {
            int paramIndex = this.originalCallableDescriptor.getExtensionReceiverParameter() != null ? 1 : 0;
            for (JetParameter parameter : parameterList2.getParameters()) {
                JetParameterInfo parameterInfo = changeInfo.getNewParameters()[paramIndex];
                this.changeParameter(paramIndex, parameter, parameterInfo);
                ++paramIndex;
            }
            ShortenPackage.addToShorteningWaitSet(parameterList2, ShortenReferences.Options.DEFAULT);
        }
        if (element2 instanceof JetCallableDeclaration && changeInfo.isReceiverTypeChanged() && (newReceiverTypeRef = TypeRefHelpersPackage.setReceiverTypeReference((JetCallableDeclaration)element2, receiverTypeRef = (receiverTypeText = changeInfo.renderReceiverType(this)) != null ? psiFactory.createType(receiverTypeText) : null)) != null) {
            ShortenPackage.addToShorteningWaitSet(newReceiverTypeRef, ShortenReferences.Options.DEFAULT);
        }
        if (changeInfo.isVisibilityChanged() && !JetPsiUtil.isLocal((JetDeclaration)element2)) {
            JetCallableDefinitionUsage.changeVisibility(changeInfo, element2);
        }
        return true;
    }

    protected void changeReturnTypeIfNeeded(JetChangeInfo changeInfo, PsiElement element2) {
        boolean returnTypeIsNeeded;
        if (!(element2 instanceof JetCallableDeclaration)) {
            return;
        }
        if (element2 instanceof JetConstructor) {
            return;
        }
        JetCallableDeclaration callable = (JetCallableDeclaration)element2;
        if (element2 instanceof JetFunction) {
            returnTypeIsNeeded = !(callable instanceof JetFunctionLiteral) && (changeInfo.isRefactoringTarget(this.originalCallableDescriptor) || callable.getTypeReference() != null);
        } else {
            boolean bl = returnTypeIsNeeded = element2 instanceof JetProperty || element2 instanceof JetParameter;
        }
        if (changeInfo.isReturnTypeChanged() && returnTypeIsNeeded) {
            callable.setTypeReference(null);
            String returnTypeText = changeInfo.renderReturnType(this);
            if (!returnTypeText.equals("Unit") && !returnTypeText.equals("kotlin.Unit")) {
                ShortenPackage.addToShorteningWaitSet(callable.setTypeReference(PsiPackage.JetPsiFactory(callable).createType(returnTypeText)), ShortenReferences.Options.DEFAULT);
            }
        }
    }

    private void processParameterListWithStructuralChanges(JetChangeInfo changeInfo, PsiElement element2, JetParameterList parameterList2, JetPsiFactory psiFactory) {
        int parametersCount = changeInfo.getNonReceiverParametersCount();
        boolean isLambda = element2 instanceof JetFunctionLiteral;
        boolean canReplaceEntireList = false;
        JetParameterList newParameterList = null;
        if (isLambda) {
            if (parametersCount == 0) {
                if (parameterList2 != null) {
                    parameterList2.delete();
                    PsiElement arrow = ((JetFunctionLiteral)element2).getArrow();
                    if (arrow != null) {
                        arrow.delete();
                    }
                    parameterList2 = null;
                }
            } else {
                newParameterList = psiFactory.createFunctionLiteralParameterList(changeInfo.getNewParametersSignatureWithoutParentheses(this));
                canReplaceEntireList = true;
            }
        } else if (!(element2 instanceof JetProperty) && !(element2 instanceof JetParameter)) {
            newParameterList = psiFactory.createParameterList(changeInfo.getNewParametersSignature(this));
        }
        if (newParameterList == null) {
            return;
        }
        if (parameterList2 != null) {
            newParameterList = canReplaceEntireList ? (JetParameterList)parameterList2.replace((PsiElement)newParameterList) : JetCallableDefinitionUsage.replaceParameterListAndKeepDelimiters(parameterList2, newParameterList);
        } else if (element2 instanceof JetClass) {
            JetPrimaryConstructor constructor = JetRefactoringUtilKt.createPrimaryConstructorIfAbsent((JetClass)element2);
            JetParameterList oldParameterList = constructor.getValueParameterList();
            assert (oldParameterList != null) : "primary constructor from factory has parameter list";
            newParameterList = (JetParameterList)oldParameterList.replace((PsiElement)newParameterList);
        } else if (isLambda) {
            JetFunctionLiteral functionLiteral = (JetFunctionLiteral)element2;
            PsiElement anchor2 = functionLiteral.getLBrace();
            newParameterList = (JetParameterList)element2.addAfter((PsiElement)newParameterList, anchor2);
            if (functionLiteral.getArrow() == null) {
                Pair<PsiElement, PsiElement> whitespaceAndArrow = psiFactory.createWhitespaceAndArrow();
                element2.addRangeAfter((PsiElement)whitespaceAndArrow.getFirst(), (PsiElement)whitespaceAndArrow.getSecond(), (PsiElement)newParameterList);
            }
        }
        if (newParameterList != null) {
            ShortenPackage.addToShorteningWaitSet(newParameterList, ShortenReferences.Options.DEFAULT);
        }
    }

    private static JetParameterList replaceParameterListAndKeepDelimiters(JetParameterList parameterList2, JetParameterList newParameterList) {
        List<JetParameter> oldParameters = parameterList2.getParameters();
        List<JetParameter> newParameters = newParameterList.getParameters();
        int oldCount = oldParameters.size();
        int newCount = newParameters.size();
        int commonCount = Math.min(oldCount, newCount);
        for (int i = 0; i < commonCount; ++i) {
            oldParameters.set(i, (JetParameter)oldParameters.get(i).replace(newParameters.get(i)));
        }
        if (commonCount == 0) {
            return (JetParameterList)parameterList2.replace((PsiElement)newParameterList);
        }
        if (oldCount > commonCount) {
            parameterList2.deleteChildRange(oldParameters.get(commonCount - 1).getNextSibling(), (PsiElement)KotlinPackage.last(oldParameters));
        } else if (newCount > commonCount) {
            parameterList2.addRangeAfter(newParameters.get(commonCount - 1).getNextSibling(), newParameterList.getLastChild().getPrevSibling(), PsiTreeUtil.skipSiblingsBackward((PsiElement)parameterList2.getLastChild(), (Class[])new Class[]{PsiWhiteSpace.class, PsiComment.class}));
        }
        return parameterList2;
    }

    private static void changeVisibility(JetChangeInfo changeInfo, PsiElement element2) {
        JetModifierKeywordToken newVisibilityToken = DescriptorUtilsKt.toKeywordToken(changeInfo.getNewVisibility());
        if (element2 instanceof JetCallableDeclaration) {
            PsiModificationUtilsKt.setVisibility((JetCallableDeclaration)element2, newVisibilityToken);
        } else if (element2 instanceof JetClass) {
            PsiModificationUtilsKt.setVisibility(JetRefactoringUtilKt.createPrimaryConstructorIfAbsent((JetClass)element2), newVisibilityToken);
        } else {
            throw new AssertionError((Object)("Invalid element: " + PsiUtilPackage.getElementTextWithContext(element2)));
        }
    }

    private void changeParameter(int parameterIndex, JetParameter parameter, JetParameterInfo parameterInfo) {
        PsiElement identifier;
        PsiElement valOrVarKeyword = parameter.getValOrVarKeyword();
        JetValVar valOrVar = parameterInfo.getValOrVar();
        JetPsiFactory psiFactory = PsiPackage.JetPsiFactory(this.getProject());
        if (valOrVarKeyword != null) {
            PsiElement newKeyword = valOrVar.createKeyword(psiFactory);
            if (newKeyword != null) {
                valOrVarKeyword.replace(newKeyword);
            } else {
                valOrVarKeyword.delete();
            }
        } else if (valOrVar != JetValVar.None) {
            PsiElement firstChild = parameter.getFirstChild();
            parameter.addBefore(valOrVar.createKeyword(psiFactory), firstChild);
            parameter.addBefore(psiFactory.createWhiteSpace(), firstChild);
        }
        if (parameterInfo.getIsTypeChanged() && parameter.getTypeReference() != null) {
            String renderedType = parameterInfo.renderType(parameterIndex, this);
            parameter.setTypeReference(psiFactory.createType(renderedType));
        }
        if ((identifier = parameter.getNameIdentifier()) != null) {
            String newName = parameterInfo.getInheritedName(this);
            identifier.replace(psiFactory.createIdentifier(newName));
        }
    }
}

