/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.refactoring.introduce.extractFunction.ui;

import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.psi.PsiElement;
import com.intellij.refactoring.ui.NameSuggestionsField;
import com.intellij.ui.TitledSeparator;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.uiDesigner.core.Spacer;
import com.intellij.util.ArrayUtil;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.MultiMap;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.swing.BorderFactory;
import javax.swing.DefaultComboBoxModel;
import javax.swing.DefaultListCellRenderer;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.idea.JetFileType;
import org.jetbrains.kotlin.idea.core.KotlinNameSuggester;
import org.jetbrains.kotlin.idea.core.refactoring.RefactoringPackage;
import org.jetbrains.kotlin.idea.refactoring.JetRefactoringBundle;
import org.jetbrains.kotlin.idea.refactoring.introduce.extractFunction.ui.KotlinFunctionSignatureComponent;
import org.jetbrains.kotlin.idea.refactoring.introduce.extractFunction.ui.KotlinParameterTablePanel;
import org.jetbrains.kotlin.idea.refactoring.introduce.extractionEngine.ControlFlow;
import org.jetbrains.kotlin.idea.refactoring.introduce.extractionEngine.ExtractableCodeDescriptor;
import org.jetbrains.kotlin.idea.refactoring.introduce.extractionEngine.ExtractableCodeDescriptorWithConflicts;
import org.jetbrains.kotlin.idea.refactoring.introduce.extractionEngine.ExtractionEnginePackage;
import org.jetbrains.kotlin.idea.refactoring.introduce.extractionEngine.ExtractionGeneratorConfiguration;
import org.jetbrains.kotlin.idea.refactoring.introduce.extractionEngine.ExtractionGeneratorOptions;
import org.jetbrains.kotlin.idea.refactoring.introduce.extractionEngine.OutputValue;
import org.jetbrains.kotlin.idea.refactoring.introduce.extractionEngine.Parameter;
import org.jetbrains.kotlin.idea.refactoring.introduce.extractionEngine.ParameterReplacement;
import org.jetbrains.kotlin.idea.refactoring.introduce.extractionEngine.Replacement;
import org.jetbrains.kotlin.idea.util.IdeDescriptorRenderers;
import org.jetbrains.kotlin.types.JetType;

public class KotlinExtractFunctionDialog
extends DialogWrapper {
    private JPanel contentPane;
    private TitledSeparator inputParametersPanel;
    private JComboBox visibilityBox;
    private KotlinFunctionSignatureComponent signaturePreviewField;
    private JPanel functionNamePanel;
    private NameSuggestionsField functionNameField;
    private JLabel functionNameLabel;
    private JComboBox returnTypeBox;
    private JPanel returnTypePanel;
    private KotlinParameterTablePanel parameterTablePanel;
    private final Project project;
    private final ExtractableCodeDescriptorWithConflicts originalDescriptor;
    private ExtractableCodeDescriptor currentDescriptor;
    private final Function1<KotlinExtractFunctionDialog, Unit> onAccept;

    public KotlinExtractFunctionDialog(@NotNull Project project, @NotNull ExtractableCodeDescriptorWithConflicts originalDescriptor, @NotNull Function1<KotlinExtractFunctionDialog, Unit> onAccept) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "org/jetbrains/kotlin/idea/refactoring/introduce/extractFunction/ui/KotlinExtractFunctionDialog", "<init>"));
        }
        if (originalDescriptor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "originalDescriptor", "org/jetbrains/kotlin/idea/refactoring/introduce/extractFunction/ui/KotlinExtractFunctionDialog", "<init>"));
        }
        if (onAccept == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "onAccept", "org/jetbrains/kotlin/idea/refactoring/introduce/extractFunction/ui/KotlinExtractFunctionDialog", "<init>"));
        }
        super(project, true);
        this.project = project;
        this.originalDescriptor = originalDescriptor;
        this.$$$setupUI$$$();
        this.currentDescriptor = originalDescriptor.getDescriptor();
        this.onAccept = onAccept;
        this.setModal(true);
        this.setTitle(JetRefactoringBundle.message("extract.function", new Object[0]));
        this.init();
        this.update();
    }

    private void createUIComponents() {
        this.signaturePreviewField = new KotlinFunctionSignatureComponent("", this.project);
    }

    private boolean isVisibilitySectionAvailable() {
        return ExtractionEnginePackage.isVisibilityApplicable(this.originalDescriptor.getDescriptor().getExtractionData());
    }

    private String getFunctionName() {
        return this.functionNameField.getEnteredName();
    }

    private String getVisibility() {
        if (!this.isVisibilitySectionAvailable()) {
            return "";
        }
        String value2 = (String)this.visibilityBox.getSelectedItem();
        return "internal".equals(value2) ? "" : value2;
    }

    private boolean checkNames() {
        if (!KotlinNameSuggester.INSTANCE$.isIdentifier(this.getFunctionName())) {
            return false;
        }
        for (KotlinParameterTablePanel.ParameterInfo parameterInfo : this.parameterTablePanel.getParameterInfos()) {
            if (KotlinNameSuggester.INSTANCE$.isIdentifier(parameterInfo.getName())) continue;
            return false;
        }
        return true;
    }

    private void update() {
        this.currentDescriptor = this.createDescriptor();
        this.setOKActionEnabled(this.checkNames());
        this.signaturePreviewField.setText(ExtractionEnginePackage.getDeclarationText(this.getCurrentConfiguration(), false, IdeDescriptorRenderers.SOURCE_CODE_SHORT_NAMES_IN_TYPES));
    }

    protected void init() {
        super.init();
        ExtractableCodeDescriptor extractableCodeDescriptor = this.originalDescriptor.getDescriptor();
        this.functionNameField = new NameSuggestionsField(ArrayUtil.toStringArray(extractableCodeDescriptor.getSuggestedNames()), this.project, (FileType)JetFileType.INSTANCE);
        this.functionNameField.addDataChangedListener(new NameSuggestionsField.DataChanged(){

            public void dataChanged() {
                KotlinExtractFunctionDialog.this.update();
            }
        });
        this.functionNamePanel.add((Component)this.functionNameField, "Center");
        this.functionNameLabel.setLabelFor((Component)this.functionNameField);
        List<JetType> possibleReturnTypes = ExtractionEnginePackage.getPossibleReturnTypes(extractableCodeDescriptor.getControlFlow());
        if (possibleReturnTypes.size() > 1) {
            DefaultComboBoxModel<Object> returnTypeBoxModel = new DefaultComboBoxModel<Object>(possibleReturnTypes.toArray());
            this.returnTypeBox.setModel(returnTypeBoxModel);
            this.returnTypeBox.setRenderer(new DefaultListCellRenderer(){

                @Override
                @NotNull
                public Component getListCellRendererComponent(JList list, Object value2, int index2, boolean isSelected, boolean cellHasFocus) {
                    super.getListCellRendererComponent((JList<?>)list, value2, index2, isSelected, cellHasFocus);
                    this.setText(IdeDescriptorRenderers.SOURCE_CODE_SHORT_NAMES_IN_TYPES.renderType((JetType)value2));
                    2 v0 = this;
                    if (v0 == null) {
                        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/idea/refactoring/introduce/extractFunction/ui/KotlinExtractFunctionDialog$2", "getListCellRendererComponent"));
                    }
                    return v0;
                }
            });
            this.returnTypeBox.addItemListener(new ItemListener(){

                @Override
                public void itemStateChanged(@NotNull ItemEvent e) {
                    if (e == null) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "org/jetbrains/kotlin/idea/refactoring/introduce/extractFunction/ui/KotlinExtractFunctionDialog$3", "itemStateChanged"));
                    }
                    KotlinExtractFunctionDialog.this.update();
                }
            });
        } else {
            this.returnTypePanel.getParent().remove(this.returnTypePanel);
        }
        boolean enableVisibility = this.isVisibilitySectionAvailable();
        this.visibilityBox.setEnabled(enableVisibility);
        if (enableVisibility) {
            this.visibilityBox.setSelectedItem(extractableCodeDescriptor.getVisibility());
        }
        this.visibilityBox.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(@NotNull ItemEvent e) {
                if (e == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "org/jetbrains/kotlin/idea/refactoring/introduce/extractFunction/ui/KotlinExtractFunctionDialog$4", "itemStateChanged"));
                }
                KotlinExtractFunctionDialog.this.update();
            }
        });
        this.parameterTablePanel = new KotlinParameterTablePanel(){

            @Override
            protected void updateSignature() {
                KotlinExtractFunctionDialog.this.update();
            }

            @Override
            protected void onEnterAction() {
                KotlinExtractFunctionDialog.this.doOKAction();
            }

            @Override
            protected void onCancelAction() {
                KotlinExtractFunctionDialog.this.doCancelAction();
            }
        };
        this.parameterTablePanel.init(extractableCodeDescriptor.getReceiverParameter(), extractableCodeDescriptor.getParameters());
        this.inputParametersPanel.setText("&Parameters");
        this.inputParametersPanel.setLabelFor((Component)this.parameterTablePanel.getTable());
        this.inputParametersPanel.add((Component)this.parameterTablePanel);
    }

    protected void doOKAction() {
        MultiMap<PsiElement, String> conflicts2 = ExtractionEnginePackage.validate(this.currentDescriptor).getConflicts();
        conflicts2.values().removeAll(this.originalDescriptor.getConflicts().values());
        RefactoringPackage.checkConflictsInteractively(this.project, conflicts2, (Function0<? extends Unit>)new Function0<Unit>(){

            public Unit invoke() {
                KotlinExtractFunctionDialog.this.close(0);
                return Unit.INSTANCE$;
            }
        }, (Function0<? extends Unit>)new Function0<Unit>(){

            public Unit invoke() {
                KotlinExtractFunctionDialog.super.doOKAction();
                return (Unit)KotlinExtractFunctionDialog.this.onAccept.invoke((Object)KotlinExtractFunctionDialog.this);
            }
        });
    }

    public JComponent getPreferredFocusedComponent() {
        return this.functionNameField;
    }

    protected JComponent createCenterPanel() {
        return this.contentPane;
    }

    @NotNull
    protected JComponent createContentPane() {
        JPanel jPanel = this.contentPane;
        if (jPanel == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/idea/refactoring/introduce/extractFunction/ui/KotlinExtractFunctionDialog", "createContentPane"));
        }
        return jPanel;
    }

    @NotNull
    private ExtractableCodeDescriptor createDescriptor() {
        ExtractableCodeDescriptor extractableCodeDescriptor = KotlinExtractFunctionDialog.createNewDescriptor(this.originalDescriptor.getDescriptor(), this.getFunctionName(), this.getVisibility(), this.parameterTablePanel.getReceiverInfo(), this.parameterTablePanel.getParameterInfos(), (JetType)this.returnTypeBox.getSelectedItem());
        if (extractableCodeDescriptor == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/idea/refactoring/introduce/extractFunction/ui/KotlinExtractFunctionDialog", "createDescriptor"));
        }
        return extractableCodeDescriptor;
    }

    @NotNull
    public ExtractionGeneratorConfiguration getCurrentConfiguration() {
        ExtractionGeneratorConfiguration extractionGeneratorConfiguration = new ExtractionGeneratorConfiguration(this.currentDescriptor, ExtractionGeneratorOptions.DEFAULT);
        if (extractionGeneratorConfiguration == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/idea/refactoring/introduce/extractFunction/ui/KotlinExtractFunctionDialog", "getCurrentConfiguration"));
        }
        return extractionGeneratorConfiguration;
    }

    public static ExtractableCodeDescriptor createNewDescriptor(@NotNull ExtractableCodeDescriptor originalDescriptor, @NotNull String newName, @NotNull String newVisibility, @Nullable KotlinParameterTablePanel.ParameterInfo newReceiverInfo, @NotNull List<KotlinParameterTablePanel.ParameterInfo> newParameterInfos, @Nullable JetType returnType2) {
        Parameter newReceiver;
        if (originalDescriptor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "originalDescriptor", "org/jetbrains/kotlin/idea/refactoring/introduce/extractFunction/ui/KotlinExtractFunctionDialog", "createNewDescriptor"));
        }
        if (newName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "newName", "org/jetbrains/kotlin/idea/refactoring/introduce/extractFunction/ui/KotlinExtractFunctionDialog", "createNewDescriptor"));
        }
        if (newVisibility == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "newVisibility", "org/jetbrains/kotlin/idea/refactoring/introduce/extractFunction/ui/KotlinExtractFunctionDialog", "createNewDescriptor"));
        }
        if (newParameterInfos == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "newParameterInfos", "org/jetbrains/kotlin/idea/refactoring/introduce/extractFunction/ui/KotlinExtractFunctionDialog", "createNewDescriptor"));
        }
        LinkedHashMap oldToNewParameters = ContainerUtil.newLinkedHashMap();
        for (KotlinParameterTablePanel.ParameterInfo parameterInfo : newParameterInfos) {
            oldToNewParameters.put(parameterInfo.getOriginalParameter(), parameterInfo.toParameter());
        }
        ArrayList newParameters = ContainerUtil.newArrayList(oldToNewParameters.values());
        Parameter originalReceiver = originalDescriptor.getReceiverParameter();
        Parameter parameter = newReceiver = newReceiverInfo != null ? newReceiverInfo.toParameter() : null;
        if (originalReceiver != null && newReceiver != null) {
            oldToNewParameters.put(originalReceiver, newReceiver);
        }
        ControlFlow controlFlow = originalDescriptor.getControlFlow();
        ArrayList<OutputValue> outputValues = new ArrayList<OutputValue>(controlFlow.getOutputValues());
        for (int i = 0; i < outputValues.size(); ++i) {
            OutputValue outputValue = (OutputValue)outputValues.get(i);
            if (!(outputValue instanceof OutputValue.ParameterUpdate)) continue;
            OutputValue.ParameterUpdate parameterUpdate = (OutputValue.ParameterUpdate)outputValue;
            outputValues.set(i, new OutputValue.ParameterUpdate((Parameter)oldToNewParameters.get(parameterUpdate.getParameter()), parameterUpdate.getOriginalExpressions()));
        }
        controlFlow = new ControlFlow(outputValues, controlFlow.getBoxerFactory(), controlFlow.getDeclarationsToCopy());
        HashMap replacementMap = ContainerUtil.newHashMap();
        for (Map.Entry<Integer, Replacement> e : originalDescriptor.getReplacementMap().entrySet()) {
            Integer offset2 = e.getKey();
            Replacement replacement = e.getValue();
            if (replacement instanceof ParameterReplacement) {
                ParameterReplacement parameterReplacement = (ParameterReplacement)replacement;
                Parameter parameter2 = parameterReplacement.getParameter();
                Parameter newParameter = (Parameter)oldToNewParameters.get(parameter2);
                if (newParameter == null) continue;
                replacementMap.put(offset2, parameterReplacement.copy(newParameter));
                continue;
            }
            replacementMap.put(offset2, replacement);
        }
        return new ExtractableCodeDescriptor(originalDescriptor.getExtractionData(), originalDescriptor.getOriginalContext(), Collections.singletonList(newName), newVisibility, newParameters, newReceiver, originalDescriptor.getTypeParameters(), replacementMap, controlFlow, returnType2 != null ? returnType2 : originalDescriptor.getReturnType());
    }

    private /* synthetic */ void $$$setupUI$$$() {
        JComboBox jComboBox;
        JPanel jPanel;
        JComboBox jComboBox2;
        JPanel jPanel2;
        JLabel jLabel;
        TitledSeparator titledSeparator;
        JPanel jPanel3;
        this.createUIComponents();
        this.contentPane = jPanel3 = new JPanel();
        jPanel3.setLayout(new GridLayoutManager(4, 1, new Insets(0, 0, 0, 0), -1, -1, false, false));
        JPanel jPanel4 = new JPanel();
        jPanel4.setLayout(new GridLayoutManager(1, 1, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel3.add((Component)jPanel4, new GridConstraints(1, 0, 1, 1, 0, 3, 3, 6, null, null, null));
        JPanel jPanel5 = new JPanel();
        jPanel5.setLayout(new BorderLayout(0, 0));
        jPanel4.add((Component)jPanel5, new GridConstraints(0, 0, 1, 1, 0, 3, 3, 6, null, null, null));
        this.inputParametersPanel = titledSeparator = new TitledSeparator();
        titledSeparator.setLayout(new BorderLayout(0, 0));
        titledSeparator.setText("");
        jPanel5.add((Component)titledSeparator, "Center");
        titledSeparator.setBorder(BorderFactory.createTitledBorder(null, "Parameters", 0, 0, null, null));
        JPanel jPanel6 = new JPanel();
        jPanel6.setLayout(new GridLayoutManager(1, 1, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel3.add((Component)jPanel6, new GridConstraints(2, 0, 1, 1, 0, 3, 3, 0, null, new Dimension(-1, 200), null));
        JPanel jPanel7 = new JPanel();
        jPanel7.setLayout(new GridLayoutManager(1, 1, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel6.add((Component)jPanel7, new GridConstraints(0, 0, 1, 1, 0, 3, 3, 3, null, null, null));
        jPanel7.setBorder(BorderFactory.createTitledBorder(null, "Signature Preview", 0, 0, null, null));
        KotlinFunctionSignatureComponent kotlinFunctionSignatureComponent = this.signaturePreviewField;
        kotlinFunctionSignatureComponent.setText("");
        jPanel7.add((Component)((Object)kotlinFunctionSignatureComponent), new GridConstraints(0, 0, 1, 1, 0, 3, 3, 3, new Dimension(500, 100), new Dimension(500, 100), null));
        JPanel jPanel8 = new JPanel();
        jPanel8.setLayout(new GridLayoutManager(4, 2, new Insets(0, 0, 0, 0), -1, -1, false, false));
        ((Component)jPanel8).setVisible(true);
        ((Component)jPanel8).setEnabled(true);
        jPanel3.add((Component)jPanel8, new GridConstraints(0, 0, 1, 1, 0, 3, 3, 0, null, null, null));
        jPanel8.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEmptyBorder(), null, 0, 0, null, null));
        this.functionNameLabel = jLabel = new JLabel();
        jLabel.setText("Name:");
        jLabel.setDisplayedMnemonic('N');
        jLabel.setDisplayedMnemonicIndex(0);
        jPanel8.add((Component)jLabel, new GridConstraints(0, 1, 1, 1, 8, 0, 3, 0, null, null, null));
        JLabel jLabel2 = new JLabel();
        ((Component)jLabel2).setVisible(true);
        jLabel2.setText("Visibility:");
        jLabel2.setDisplayedMnemonic('V');
        jLabel2.setDisplayedMnemonicIndex(0);
        jPanel8.add((Component)jLabel2, new GridConstraints(0, 0, 1, 1, 8, 0, 3, 0, null, new Dimension(114, 16), null));
        this.functionNamePanel = jPanel2 = new JPanel();
        jPanel2.setLayout(new BorderLayout(0, 0));
        jPanel8.add((Component)jPanel2, new GridConstraints(1, 1, 1, 1, 8, 1, 6, 0, null, new Dimension(150, -1), null));
        this.visibilityBox = jComboBox2 = new JComboBox();
        DefaultComboBoxModel<String> defaultComboBoxModel = new DefaultComboBoxModel<String>();
        defaultComboBoxModel.addElement("private");
        defaultComboBoxModel.addElement("protected");
        defaultComboBoxModel.addElement("internal");
        defaultComboBoxModel.addElement("public");
        jComboBox2.setModel(defaultComboBoxModel);
        ((Component)jComboBox2).setVisible(true);
        jPanel8.add(jComboBox2, new GridConstraints(1, 0, 1, 1, 8, 0, 2, 0, null, new Dimension(114, 26), null));
        this.returnTypePanel = jPanel = new JPanel();
        jPanel.setLayout(new GridLayoutManager(2, 2, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel8.add((Component)jPanel, new GridConstraints(2, 1, 1, 1, 0, 3, 3, 3, null, null, null));
        JLabel jLabel3 = new JLabel();
        jLabel3.setText("Return type:");
        jLabel3.setDisplayedMnemonic('R');
        jLabel3.setDisplayedMnemonicIndex(0);
        jPanel.add((Component)jLabel3, new GridConstraints(0, 0, 1, 1, 8, 0, 3, 0, null, null, null));
        Spacer spacer = new Spacer();
        jPanel.add((Component)spacer, new GridConstraints(0, 1, 1, 1, 0, 1, 6, 1, null, null, null));
        this.returnTypeBox = jComboBox = new JComboBox();
        jPanel.add(jComboBox, new GridConstraints(1, 0, 1, 2, 8, 1, 2, 0, null, null, null));
        Spacer spacer2 = new Spacer();
        jPanel3.add((Component)spacer2, new GridConstraints(3, 0, 1, 1, 0, 2, 1, 0, null, null, null));
        jLabel2.setLabelFor(jComboBox2);
        jLabel3.setLabelFor(jComboBox);
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.contentPane;
    }
}

