/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.refactoring.rename;

import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.psi.PsiElement;
import com.intellij.psi.search.GlobalSearchScope;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.KotlinFileFacade;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.idea.stubindex.JetTopLevelFunctionFqnNameIndex;
import org.jetbrains.kotlin.name.FqName;
import org.jetbrains.kotlin.psi.JetClassBody;
import org.jetbrains.kotlin.psi.JetFile;
import org.jetbrains.kotlin.psi.JetNamedFunction;

@KotlinFileFacade(version={0, 25, 0}, abiVersion=25, data={"s\u0015AQU\r\u001e(b[\u0016$g)\u001e8di&|gNC\u0002pe\u001eT\u0011B[3uEJ\f\u0017N\\:\u000b\r-|G\u000f\\5o\u0015\r\u00018/\u001b\u0006\rO\u0016$xJ^3sY>\fGm\u001d\u0006\u000b\u0007>dG.Z2uS>t'\u0002\u00026bm\u0006TA!\u001e;jY*Y\u0012)\u001e;p[\u0006$\u0018nY(wKJdw.\u00193t%\u0016t\u0017-\\3s\u0017R\u0004%B\u0001\t\u0002\u0015\u0011A\u0001\u0001\u0005\u0002\u000b\t!\t\u0001c\u0001\u0006\u0005\u0011\t\u0001BA\u0003\u0004\t\u0007A\u0001\u0001\u0004\u0001\u0006\u0003!\rQa\u0001C\u0003\u0011\ra\u0001!B\u0001\t\b\u0015\u0011Aq\u0001\u0005\u0005\u000b\t!A\u0001C\u0002\u0006\u0005\u0011\r\u0001\u0002A\u0003\u0018\t\u0005)2!B\u0001\t\u0005a\u0011\u0001TA\u0011\t\u000b\u0005A1!\u0003\u0003\n\u0007\u0015\t\u0001B\u0001\r\u00031\r\t6!\u0002C\u0003\u0013\u0005AI!D\u0001\t\u000ba\u001bI\u0001"})
public final class AutomaticOverloadsRenamerKt {
    @NotNull
    public static final Collection<JetNamedFunction> getOverloads(JetNamedFunction $receiver) {
        PsiElement parent2;
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        PsiElement psiElement2 = parent2 = $receiver.getParent();
        if (psiElement2 instanceof JetFile) {
            Module module = ModuleUtilCore.findModuleForPsiElement((PsiElement)$receiver);
            if (module != null) {
                GlobalSearchScope searchScope2 = GlobalSearchScope.moduleScope((Module)module);
                FqName fqName2 = $receiver.getFqName();
                if (fqName2 != null) {
                    Collection<JetNamedFunction> collection = JetTopLevelFunctionFqnNameIndex.getInstance().get(fqName2.asString(), $receiver.getProject(), searchScope2);
                    Intrinsics.checkExpressionValueIsNotNull(collection, (String)"JetTopLevelFunctionFqnNa\u2026etProject(), searchScope)");
                    return collection;
                }
            }
        } else if (psiElement2 instanceof JetClassBody) {
            Collection destination;
            Iterable $receiver2;
            Iterable $receiver3 = ((JetClassBody)parent2).getDeclarations();
            Iterable searchScope2 = $receiver3;
            Collection fqName2 = new ArrayList();
            for (Object element2 : $receiver2) {
                if (!(element2 instanceof JetNamedFunction)) continue;
                destination.add(element2);
            }
            $receiver3 = (List)destination;
            $receiver2 = $receiver3;
            destination = new ArrayList();
            for (Object element2 : $receiver2) {
                JetNamedFunction it = (JetNamedFunction)element2;
                if (!Intrinsics.areEqual((Object)it.getName(), (Object)$receiver.getName())) continue;
                destination.add(element2);
            }
            return (List)destination;
        }
        return CollectionsKt.emptyList();
    }
}

