/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.refactoring.rename;

import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiNamedElement;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.refactoring.RefactoringBundle;
import com.intellij.refactoring.rename.naming.AutomaticRenamer;
import com.intellij.usageView.UsageInfo;
import java.util.ArrayList;
import java.util.Collection;
import kotlin.TypeCastException;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.KotlinClass;
import kotlin.jvm.internal.Reflection;
import kotlin.reflect.KClass;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.descriptors.VariableDescriptor;
import org.jetbrains.kotlin.idea.caches.resolve.ResolutionUtils;
import org.jetbrains.kotlin.idea.refactoring.rename.AutomaticVariableRenamerKt;
import org.jetbrains.kotlin.psi.JetCallableDeclaration;
import org.jetbrains.kotlin.psi.JetNamedDeclaration;
import org.jetbrains.kotlin.psi.JetParameter;
import org.jetbrains.kotlin.psi.JetTypeReference;
import org.jetbrains.kotlin.psi.JetVariableDeclaration;
import org.jetbrains.kotlin.psi.psiUtil.PsiUtilsKt;
import org.jetbrains.kotlin.types.JetType;

@KotlinClass(version={0, 25, 0}, abiVersion=25, data={"0\b)A\u0012)\u001e;p[\u0006$\u0018n\u0019,be&\f'\r\\3SK:\fW.\u001a:\u000b\u0007=\u0014xMC\u0005kKR\u0014'/Y5og*11n\u001c;mS:TA!\u001b3fC*Y!/\u001a4bGR|'/\u001b8h\u0015\u0019\u0011XM\\1nK*\u0001\u0012)\u001e;p[\u0006$\u0018n\u0019*f]\u0006lWM\u001d\u0006\u0004G>l'\u0002C5oi\u0016dG.\u001b6\u000b\r9\fW.\u001b8h\u0015\u0019a\u0014N\\5u}))1\u000e\\1tg*y\u0001k]5OC6,G-\u00127f[\u0016tGOC\u0002qg&TAB\\3x\u00072\f7o\u001d(b[\u0016Taa\u0015;sS:<'BB;tC\u001e,7O\u0003\u0006D_2dWm\u0019;j_:T\u0011\"V:bO\u0016LeNZ8\u000b\u0013U\u001c\u0018mZ3WS\u0016<(\u0002\u00026bm\u0006TA\u0001\\1oO*!Q\u000f^5m\u00155!x.\u00168qYV\u0014\u0018\r\\5{K*I\u0011I\u001d:bs2K7\u000f\u001e\u0006\u0014\u0015\u0016$h*Y7fI\u0012+7\r\\1sCRLwN\u001c\u0006\u0014G\u0006twN\\5dC2t\u0015-\\3U_:\u000bW.\u001a\u0006\u000eG\u0006twN\\5dC2t\u0015-\\3\u000b\u000f\u0015dW-\\3oi*QQM\u001c;jift\u0015-\\3\u000b/-|G\u000f\\5o])4XN\f)mCR4wN]7UsB,'\u0002F4fi\u0012K\u0017\r\\8h\t\u0016\u001c8M]5qi&|gN\u0003\bhKR$\u0015.\u00197pORKG\u000f\\3\u000b'9\fW.\u001a+p\u0007\u0006twN\\5dC2t\u0015-\\3\u000b\t9\fW.\u001a_\u0002\u0015\t\u0001\u0012A\u0003\u0003\t\u0001A\u0011!\u0002\u0002\u0005\u0002!\rQA\u0001\u0003\u0002\u0011\t)!\u0001b\u0001\t\u0006\u0015\u0011AA\u0001\u0005\u0004\u000b\r!)\u0001\u0003\u0001\r\u0001\u0015\t\u0001\u0002B\u0003\u0003\t\u000fAI!\u0002\u0002\u0005\t!\u0015QA\u0001C\u0005\u0011\r)!\u0001B\u0003\t\u000b\u0015\u0019A1\u0002E\u0004\u0019\u0001)!\u0001\u0002\u0003\t\u000f\u0015\u0019AQ\u0002E\u0007\u0019\u0001)\u0011\u0001c\u0001\u0006\u0007\u0011=\u0001\u0002\u0003\u0007\u0001\u000b\r!y\u0001C\u0005\r\u0001\u0015\u0011A\u0001\u0002\u0005\u000b\u000b\r!\u0011\u0002c\u0005\r\u0001\u0015\u0011AQ\u0002E\u0007\u000b\u0005A)\"\u0002\u0002\u0005\u0016!YQA\u0001\u0003\f\u0011!)!\u0001\"\u0006\t\u0018\u0015\u0011A\u0001\u0004\u0005\n\u000b\r!A\u0002#\u0007\r\u0001\u0015\u0011A!\u0001\u0005\b\u000b\r!Y\u0002C\u0007\r\u0001\u0015\u0011A\u0001\u0004E\r\t\ra1!G\u0002\u0006\u0003!1\u0001DB\u0017\u0012\t\u0005$\u0001\u0004D\u0011\t\u000b\u0005AQ\"\u0003\u0003\n\u0007\u0015\t\u0001B\u0004\r\u000f15)6\u0001B\u0003\u0004\t1I\u0011\u0001#\b.B\u0011Q\u00014DO\b\t\u0001Aa\"D\u0002\u0006\u0003!A\u0001\u0004\u0003)\u0004\u0001u=A\u0001\u0001E\u000f\u001b\r)\u0011\u0001C\u0004\u0019\u000fA\u001b\t!\t\u0003\u0006\u0003!AA\u0012\u0001\r\t#\u000e9A1D\u0005\u0002\u0011/i\u0011\u0001c\u0006\u000e\u0003!QQ\u0016\u0005\u0003\f1=\t\u0013\"B\u0001\t\u0011A}Q\u0003B\u0003\u0002\u0011!a\t\u0001\u0007\u0005\u0019\u0011E\u001b1\u0001B\b\n\u0003!]Q\u0016\u0005\u0003\f1A\t\u0013\"B\u0001\t\u0011A}Q\u0003B\u0003\u0002\u0011!a\t\u0001\u0007\u0005\u0019\u0011E\u001b1\u0001\u0002\t\n\u0003!]Q\u0016\u0005\u0003\f1C\t\u0013\"B\u0001\t\u0011A}Q\u0003B\u0003\u0002\u0011!a\t\u0001\u0007\u0005\u0019\u0011E\u001b1\u0001\"\t\n\u0003!]Q\u0016\t\u0003\u000b1Eiz\u0001\u0002\u0001\t$5\u0019Q!\u0001\u0005\t1!\u00016\u0001AO\b\t\u0001Ai\"D\u0002\u0006\u0003!9\u0001d\u0002)\u0004\u0002\u0005\"Q!\u0001\u0005\t\u0019\u0003A\u0002\"U\u0002\b\tEI\u0011\u0001c\u0006\u000e\u0003!]Q\"\u0001\u0005\u000bkC*y\u0006Br\u00011\u0017iz\u0001\u0002\u0001\t\r5\u0019Q!\u0001\u0005\b1\u001d\u00016\u0001AO\b\t\u0001Ay!D\u0002\u0006\u0003!A\u0001\u0004\u0003)\u0004\u0002ueA\u0001\u0001E\t\u001b!)\u0011\u0001#\u0005\n\t%\u0019Q!\u0001E\n1'A\n\u0002U\u0002\u0002C\r)\u0011\u0001C\u0002\u0019\u0007E\u001b\u0011\u0002b\u0003\n\u0003\u0011\u0001Q\"\u0001\u0005\u000b\u001b\u0005A9\"D\u0001\t\u001a\u0001"})
public final class AutomaticVariableRenamer
extends AutomaticRenamer {
    public static final /* synthetic */ KClass $kotlinClass;
    private final ArrayList<JetNamedDeclaration> toUnpluralize;

    static {
        $kotlinClass = Reflection.createKotlinClass(AutomaticVariableRenamer.class);
    }

    public String getDialogTitle() {
        return RefactoringBundle.message((String)"rename.variables.title");
    }

    public String getDialogDescription() {
        return RefactoringBundle.message((String)"rename.variables.with.the.following.names.to");
    }

    public String entityName() {
        return RefactoringBundle.message((String)"entity.name.variable");
    }

    @Nullable
    protected String nameToCanonicalName(@NotNull String name2, @NotNull PsiNamedElement element2) {
        Intrinsics.checkParameterIsNotNull((Object)name2, (String)"name");
        Intrinsics.checkParameterIsNotNull((Object)element2, (String)"element");
        if (this.toUnpluralize.contains(element2)) {
            String singular = StringUtil.unpluralize((String)name2);
            if (singular != null) {
                return singular;
            }
            this.toUnpluralize.remove(element2);
        }
        return name2;
    }

    @Nullable
    protected String canonicalNameToName(@NotNull String canonicalName, @NotNull PsiNamedElement element2) {
        Intrinsics.checkParameterIsNotNull((Object)canonicalName, (String)"canonicalName");
        Intrinsics.checkParameterIsNotNull((Object)element2, (String)"element");
        return this.toUnpluralize.contains(element2) ? StringUtil.pluralize((String)canonicalName) : canonicalName;
    }

    public AutomaticVariableRenamer(@NotNull PsiNamedElement klass, @NotNull String newClassName, @NotNull Collection<? extends UsageInfo> usages2) {
        Intrinsics.checkParameterIsNotNull((Object)klass, (String)"klass");
        Intrinsics.checkParameterIsNotNull((Object)newClassName, (String)"newClassName");
        Intrinsics.checkParameterIsNotNull(usages2, (String)"usages");
        this.toUnpluralize = new ArrayList();
        for (UsageInfo usageInfo : usages2) {
            Boolean bl;
            JetCallableDeclaration parameterOrVariable;
            PsiElement usageElement;
            if (usageInfo.getElement() == null) {
                continue;
            }
            if ((JetCallableDeclaration)PsiTreeUtil.getParentOfType((PsiElement)usageElement, (Class[])new Class[]{JetVariableDeclaration.class, JetParameter.class}) == null) {
                continue;
            }
            JetTypeReference jetTypeReference = parameterOrVariable.getTypeReference();
            if (jetTypeReference != null) {
                PsiElement psiElement2 = (PsiElement)jetTypeReference;
                PsiElement psiElement3 = usageElement;
                Intrinsics.checkExpressionValueIsNotNull((Object)psiElement3, (String)"usageElement");
                bl = PsiUtilsKt.isAncestor$default(psiElement2, psiElement3, false, 2);
            } else {
                bl = null;
            }
            if (Intrinsics.areEqual(bl, (Object)true) ^ true) continue;
            DeclarationDescriptor declarationDescriptor = ResolutionUtils.resolveToDescriptor(parameterOrVariable);
            if (declarationDescriptor == null) {
                throw new TypeCastException("null cannot be cast to non-null type org.jetbrains.kotlin.descriptors.VariableDescriptor");
            }
            JetType type2 = ((VariableDescriptor)declarationDescriptor).getType();
            if (AutomaticVariableRenamerKt.isCollectionLikeOf(type2, klass)) {
                this.toUnpluralize.add(parameterOrVariable);
            }
            this.myElements.add(parameterOrVariable);
        }
        this.suggestAllNames(klass.getName(), newClassName);
    }
}

