/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.refactoring.rename;

import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiReference;
import com.intellij.refactoring.util.MoveRenameUsageInfo;
import com.intellij.usageView.UsageInfo;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.KotlinFileFacade;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.idea.refactoring.rename.UnresolvableConventionViolationUsageInfo;
import org.jetbrains.kotlin.idea.references.AbstractJetReference;

@KotlinFileFacade(version={0, 25, 0}, abiVersion=25, data={"\r\u0004)\u00113\r[3dW\u000e{gN\u001a7jGR\u001c\u0018I\u001c3SKBd\u0017mY3Vg\u0006<W-\u00138g_NTaA]3tk2$(bC'vi\u0006\u0014G.\u001a'jgRTaa[8uY&t'\"C+tC\u001e,\u0017J\u001c4p\u0015\r\u0019w.\u001c\u0006\tS:$X\r\u001c7jU*IQo]1hKZKWm\u001e\u0006\u0005+:LGO\u0003\u0003kCZ\f'\u0002B;uS2TA\u0001T5ti*a!+\u001a8b[\u0016,F/\u001b7LirR!\u0001E\u0002\u000b\r!\u0001\u0001C\u0001\r\u0001\u0015\t\u0001RA\u0003\u0003\t\u0005A1!\u0002\u0002\u0005\u0004!\u001dQa\u0001\u0003\u0003\u0011\ta\u0001!B\u0002\u0005\u0001!!A\u0002A\u0003\u0002\u0011\u0013)!\u0001b\u0002\t\u000b\u0015\u0011A\u0001\u0002E\u0006\u000bo!1\u0001\u0007\u0001\u001e\u001a\u0011\u0001\u0001\u0012A\u0007\t\u000b\u0005A\t!\u0003\u0003\n\u0007\u0015\t\u0001R\u0001M\u00031\u0003\u00016\u0001A\u0011\u0004\u000b\u0005A1\u0001G\u0002R\u0007\u0015!\u0001!C\u0001\u0005\u00015\t\u0001\u0012\u0002-\u0004\r\u0001"})
public final class RenameUtilKt {
    public static final void checkConflictsAndReplaceUsageInfos(@NotNull List<UsageInfo> result2) {
        Intrinsics.checkParameterIsNotNull(result2, (String)"result");
        ArrayList<UnresolvableConventionViolationUsageInfo> usagesToAdd = new ArrayList<UnresolvableConventionViolationUsageInfo>();
        ArrayList<UsageInfo> usagesToRemove = new ArrayList<UsageInfo>();
        for (UsageInfo usageInfo : result2) {
            PsiReference ref = usageInfo.getReference();
            if (!(usageInfo instanceof MoveRenameUsageInfo) || !(ref instanceof AbstractJetReference) || ((AbstractJetReference)ref).canRename()) continue;
            PsiElement refElement = ((MoveRenameUsageInfo)usageInfo).getElement();
            PsiElement referencedElement = ((MoveRenameUsageInfo)usageInfo).getReferencedElement();
            if (refElement == null || referencedElement == null) continue;
            usagesToAdd.add(new UnresolvableConventionViolationUsageInfo(refElement, referencedElement));
            usagesToRemove.add(usageInfo);
        }
        result2.removeAll((Collection)usagesToRemove);
        result2.addAll((Collection<UsageInfo>)usagesToAdd);
    }
}

