/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.refactoring.safeDelete;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.help.HelpManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.openapi.ui.Splitter;
import com.intellij.openapi.util.Disposer;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiMethod;
import com.intellij.ui.BooleanTableCellRenderer;
import com.intellij.ui.ScrollPaneFactory;
import com.intellij.ui.table.JBTable;
import com.intellij.usageView.UsageInfo;
import com.intellij.usages.UsageViewPresentation;
import com.intellij.usages.impl.UsagePreviewPanel;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.ActionMap;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.InputMap;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.KeyStroke;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumnModel;
import javax.swing.table.TableModel;
import jet.runtime.typeinfo.KotlinSignature;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.descriptors.CallableMemberDescriptor;
import org.jetbrains.kotlin.descriptors.ClassDescriptor;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.idea.JetBundle;
import org.jetbrains.kotlin.idea.caches.resolve.ResolutionUtils;
import org.jetbrains.kotlin.idea.refactoring.JetRefactoringUtil;
import org.jetbrains.kotlin.idea.refactoring.safeDelete.KotlinSafeDeleteOverridingUsageInfo;
import org.jetbrains.kotlin.idea.util.IdeDescriptorRenderers;
import org.jetbrains.kotlin.psi.JetElement;
import org.jetbrains.kotlin.psi.JetNamedFunction;
import org.jetbrains.kotlin.psi.JetProperty;
import org.jetbrains.kotlin.psi.JetPsiUtil;
import org.jetbrains.kotlin.renderer.DescriptorRenderer;
import org.jetbrains.kotlin.resolve.BindingContext;
import org.jetbrains.kotlin.resolve.lazy.BodyResolveMode;

class KotlinOverridingDialog
extends DialogWrapper {
    private final List<UsageInfo> myOverridingMethods;
    private final String[] myMethodText;
    private final boolean[] myChecked;
    private static final int CHECK_COLUMN = 0;
    private JBTable myTable;
    private final UsagePreviewPanel myUsagePreviewPanel;

    public KotlinOverridingDialog(Project project, List<UsageInfo> overridingMethods) {
        super(project, true);
        int i;
        this.myOverridingMethods = overridingMethods;
        this.myChecked = new boolean[this.myOverridingMethods.size()];
        for (i = 0; i < this.myChecked.length; ++i) {
            this.myChecked[i] = true;
        }
        this.myMethodText = new String[this.myOverridingMethods.size()];
        for (i = 0; i < this.myMethodText.length; ++i) {
            this.myMethodText[i] = KotlinOverridingDialog.formatElement(((KotlinSafeDeleteOverridingUsageInfo)this.myOverridingMethods.get(i)).getOverridingElement());
        }
        this.myUsagePreviewPanel = new UsagePreviewPanel(project, new UsageViewPresentation());
        this.setTitle(JetBundle.message("unused.overriding.methods.title", new Object[0]));
        this.init();
    }

    private static String formatElement(PsiElement element2) {
        DeclarationDescriptor containingDescriptor;
        BindingContext bindingContext2;
        DeclarationDescriptor declarationDescriptor;
        if (((element2 = JetPsiUtil.ascendIfPropertyAccessor(element2)) instanceof JetNamedFunction || element2 instanceof JetProperty) && (declarationDescriptor = (bindingContext2 = ResolutionUtils.analyze((JetElement)element2, BodyResolveMode.FULL)).get(BindingContext.DECLARATION_TO_DESCRIPTOR, element2)) instanceof CallableMemberDescriptor && (containingDescriptor = declarationDescriptor.getContainingDeclaration()) instanceof ClassDescriptor) {
            return JetBundle.message("x.in.y", DescriptorRenderer.COMPACT.render(declarationDescriptor), IdeDescriptorRenderers.SOURCE_CODE_SHORT_NAMES_IN_TYPES.render(containingDescriptor));
        }
        assert (element2 instanceof PsiMethod) : "Method accepts only kotlin functions/properties and java methods, but '" + element2.getText() + "' was found";
        return JetRefactoringUtil.formatPsiMethod((PsiMethod)element2, true, false);
    }

    protected String getDimensionServiceKey() {
        return "#org.jetbrains.kotlin.idea.refactoring.safeDelete.KotlinOverridingDialog";
    }

    @KotlinSignature(value="fun getSelected(): ArrayList<UsageInfo>")
    public ArrayList<UsageInfo> getSelected() {
        ArrayList<UsageInfo> result2 = new ArrayList<UsageInfo>();
        for (int i = 0; i < this.myChecked.length; ++i) {
            if (!this.myChecked[i]) continue;
            result2.add(this.myOverridingMethods.get(i));
        }
        return result2;
    }

    @NotNull
    protected Action[] createActions() {
        Action[] actionArray = new Action[]{this.getOKAction(), this.getCancelAction()};
        if (actionArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/idea/refactoring/safeDelete/KotlinOverridingDialog", "createActions"));
        }
        return actionArray;
    }

    protected void doHelpAction() {
        HelpManager.getInstance().invokeHelp("refactoring.safeDelete.overridingMethods");
    }

    protected JComponent createNorthPanel() {
        JPanel panel = new JPanel();
        panel.setLayout(new BoxLayout(panel, 1));
        panel.add(new JLabel(JetBundle.message("there.are.unused.methods.that.override.methods.you.delete", new Object[0])));
        panel.add(new JLabel(JetBundle.message("choose.the.ones.you.want.to.be.deleted", new Object[0])));
        return panel;
    }

    public JComponent getPreferredFocusedComponent() {
        return this.myTable;
    }

    protected void dispose() {
        Disposer.dispose((Disposable)this.myUsagePreviewPanel);
        super.dispose();
    }

    protected JComponent createCenterPanel() {
        JPanel panel = new JPanel(new BorderLayout());
        panel.setBorder(BorderFactory.createEmptyBorder(8, 0, 4, 0));
        final MyTableModel tableModel = new MyTableModel();
        this.myTable = new JBTable((TableModel)tableModel);
        this.myTable.setShowGrid(false);
        TableColumnModel columnModel = this.myTable.getColumnModel();
        int checkBoxWidth = new JCheckBox().getPreferredSize().width;
        columnModel.getColumn(0).setCellRenderer((TableCellRenderer)new BooleanTableCellRenderer());
        columnModel.getColumn(0).setMaxWidth(checkBoxWidth);
        columnModel.getColumn(0).setMinWidth(checkBoxWidth);
        InputMap inputMap = this.myTable.getInputMap();
        inputMap.put(KeyStroke.getKeyStroke(32, 0), "enable_disable");
        ActionMap actionMap = this.myTable.getActionMap();
        actionMap.put("enable_disable", new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (KotlinOverridingDialog.this.myTable.isEditing()) {
                    return;
                }
                int[] rows = KotlinOverridingDialog.this.myTable.getSelectedRows();
                if (rows.length > 0) {
                    boolean valueToBeSet = false;
                    for (int row : rows) {
                        if (KotlinOverridingDialog.this.myChecked[row]) continue;
                        valueToBeSet = true;
                        break;
                    }
                    for (int row : rows) {
                        ((KotlinOverridingDialog)KotlinOverridingDialog.this).myChecked[row] = valueToBeSet;
                    }
                    tableModel.updateData();
                }
            }
        });
        panel.setLayout(new BorderLayout());
        JScrollPane scrollPane = ScrollPaneFactory.createScrollPane((Component)this.myTable);
        panel.add((Component)scrollPane, "Center");
        ListSelectionListener selectionListener = new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                int index2 = KotlinOverridingDialog.this.myTable.getSelectionModel().getLeadSelectionIndex();
                if (index2 != -1) {
                    UsageInfo usageInfo = (UsageInfo)KotlinOverridingDialog.this.myOverridingMethods.get(index2);
                    KotlinOverridingDialog.this.myUsagePreviewPanel.updateLayout(Collections.singletonList(usageInfo));
                } else {
                    KotlinOverridingDialog.this.myUsagePreviewPanel.updateLayout(null);
                }
            }
        };
        this.myTable.getSelectionModel().addListSelectionListener(selectionListener);
        final Splitter splitter = new Splitter(true, 0.3f);
        splitter.setFirstComponent((JComponent)panel);
        splitter.setSecondComponent((JComponent)this.myUsagePreviewPanel);
        this.myUsagePreviewPanel.updateLayout(null);
        Disposer.register((Disposable)this.myDisposable, (Disposable)new Disposable(){

            public void dispose() {
                splitter.dispose();
            }
        });
        if (tableModel.getRowCount() != 0) {
            this.myTable.getSelectionModel().addSelectionInterval(0, 0);
        }
        return splitter;
    }

    class MyTableModel
    extends AbstractTableModel {
        MyTableModel() {
        }

        @Override
        public int getRowCount() {
            return KotlinOverridingDialog.this.myChecked.length;
        }

        @Override
        public String getColumnName(int column) {
            switch (column) {
                case 0: {
                    return " ";
                }
            }
            return JetBundle.message("method.column", new Object[0]);
        }

        public Class getColumnClass(int columnIndex) {
            switch (columnIndex) {
                case 0: {
                    return Boolean.class;
                }
            }
            return String.class;
        }

        @Override
        public int getColumnCount() {
            return 2;
        }

        @Override
        public Object getValueAt(int rowIndex, int columnIndex) {
            if (columnIndex == 0) {
                return KotlinOverridingDialog.this.myChecked[rowIndex];
            }
            return KotlinOverridingDialog.this.myMethodText[rowIndex];
        }

        @Override
        public void setValueAt(Object aValue, int rowIndex, int columnIndex) {
            if (columnIndex == 0) {
                ((KotlinOverridingDialog)KotlinOverridingDialog.this).myChecked[rowIndex] = (Boolean)aValue;
            }
        }

        @Override
        public boolean isCellEditable(int rowIndex, int columnIndex) {
            return columnIndex == 0;
        }

        void updateData() {
            this.fireTableDataChanged();
        }
    }
}

