/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.stubindex;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ProjectFileIndex;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.search.DelegatingGlobalSearchScope;
import com.intellij.psi.search.GlobalSearchScope;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.idea.caches.resolve.JsProjectDetector;
import org.jetbrains.kotlin.idea.util.ProjectRootsUtil;

public class JetSourceFilterScope
extends DelegatingGlobalSearchScope {
    private final ProjectFileIndex index;
    private final Project project;
    private final boolean includeProjectSourceFiles;
    private final boolean includeLibrarySourceFiles;
    private final boolean includeClassFiles;
    private final boolean isJsProject;

    @NotNull
    public static GlobalSearchScope kotlinSourcesAndLibraries(@NotNull GlobalSearchScope delegate2, @NotNull Project project) {
        if (delegate2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "delegate", "org/jetbrains/kotlin/idea/stubindex/JetSourceFilterScope", "kotlinSourcesAndLibraries"));
        }
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "org/jetbrains/kotlin/idea/stubindex/JetSourceFilterScope", "kotlinSourcesAndLibraries"));
        }
        GlobalSearchScope globalSearchScope = JetSourceFilterScope.create(delegate2, true, true, true, project);
        if (globalSearchScope == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/idea/stubindex/JetSourceFilterScope", "kotlinSourcesAndLibraries"));
        }
        return globalSearchScope;
    }

    @NotNull
    public static GlobalSearchScope kotlinSourceAndClassFiles(@NotNull GlobalSearchScope delegate2, @NotNull Project project) {
        if (delegate2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "delegate", "org/jetbrains/kotlin/idea/stubindex/JetSourceFilterScope", "kotlinSourceAndClassFiles"));
        }
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "org/jetbrains/kotlin/idea/stubindex/JetSourceFilterScope", "kotlinSourceAndClassFiles"));
        }
        GlobalSearchScope globalSearchScope = JetSourceFilterScope.create(delegate2, true, false, true, project);
        if (globalSearchScope == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/idea/stubindex/JetSourceFilterScope", "kotlinSourceAndClassFiles"));
        }
        return globalSearchScope;
    }

    @NotNull
    public static GlobalSearchScope kotlinSources(@NotNull GlobalSearchScope delegate2, @NotNull Project project) {
        if (delegate2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "delegate", "org/jetbrains/kotlin/idea/stubindex/JetSourceFilterScope", "kotlinSources"));
        }
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "org/jetbrains/kotlin/idea/stubindex/JetSourceFilterScope", "kotlinSources"));
        }
        GlobalSearchScope globalSearchScope = JetSourceFilterScope.create(delegate2, true, false, false, project);
        if (globalSearchScope == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/idea/stubindex/JetSourceFilterScope", "kotlinSources"));
        }
        return globalSearchScope;
    }

    @NotNull
    public static GlobalSearchScope kotlinLibrarySources(@NotNull GlobalSearchScope delegate2, @NotNull Project project) {
        if (delegate2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "delegate", "org/jetbrains/kotlin/idea/stubindex/JetSourceFilterScope", "kotlinLibrarySources"));
        }
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "org/jetbrains/kotlin/idea/stubindex/JetSourceFilterScope", "kotlinLibrarySources"));
        }
        GlobalSearchScope globalSearchScope = JetSourceFilterScope.create(delegate2, false, true, false, project);
        if (globalSearchScope == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/idea/stubindex/JetSourceFilterScope", "kotlinLibrarySources"));
        }
        return globalSearchScope;
    }

    @NotNull
    public static GlobalSearchScope kotlinLibraryClassFiles(@NotNull GlobalSearchScope delegate2, @NotNull Project project) {
        if (delegate2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "delegate", "org/jetbrains/kotlin/idea/stubindex/JetSourceFilterScope", "kotlinLibraryClassFiles"));
        }
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "org/jetbrains/kotlin/idea/stubindex/JetSourceFilterScope", "kotlinLibraryClassFiles"));
        }
        GlobalSearchScope globalSearchScope = JetSourceFilterScope.create(delegate2, false, false, true, project);
        if (globalSearchScope == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/idea/stubindex/JetSourceFilterScope", "kotlinLibraryClassFiles"));
        }
        return globalSearchScope;
    }

    @NotNull
    private static GlobalSearchScope create(@NotNull GlobalSearchScope delegate2, boolean includeProjectSourceFiles, boolean includeLibrarySourceFiles, boolean includeClassFiles, @NotNull Project project) {
        if (delegate2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "delegate", "org/jetbrains/kotlin/idea/stubindex/JetSourceFilterScope", "create"));
        }
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "org/jetbrains/kotlin/idea/stubindex/JetSourceFilterScope", "create"));
        }
        if (delegate2 == GlobalSearchScope.EMPTY_SCOPE) {
            GlobalSearchScope globalSearchScope = delegate2;
            if (globalSearchScope == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/idea/stubindex/JetSourceFilterScope", "create"));
            }
            return globalSearchScope;
        }
        if (delegate2 instanceof JetSourceFilterScope) {
            JetSourceFilterScope wrappedDelegate = (JetSourceFilterScope)delegate2;
            boolean doIncludeProjectSourceFiles = wrappedDelegate.includeProjectSourceFiles && includeProjectSourceFiles;
            boolean doIncludeLibrarySourceFiles = wrappedDelegate.includeLibrarySourceFiles && includeLibrarySourceFiles;
            boolean doIncludeClassFiles = wrappedDelegate.includeClassFiles && includeClassFiles;
            JetSourceFilterScope jetSourceFilterScope = new JetSourceFilterScope(wrappedDelegate.myBaseScope, doIncludeProjectSourceFiles, doIncludeLibrarySourceFiles, doIncludeClassFiles, project);
            if (jetSourceFilterScope == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/idea/stubindex/JetSourceFilterScope", "create"));
            }
            return jetSourceFilterScope;
        }
        JetSourceFilterScope jetSourceFilterScope = new JetSourceFilterScope(delegate2, includeProjectSourceFiles, includeLibrarySourceFiles, includeClassFiles, project);
        if (jetSourceFilterScope == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/idea/stubindex/JetSourceFilterScope", "create"));
        }
        return jetSourceFilterScope;
    }

    private JetSourceFilterScope(@NotNull GlobalSearchScope delegate2, boolean includeProjectSourceFiles, boolean includeLibrarySourceFiles, boolean includeClassFiles, @NotNull Project project) {
        if (delegate2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "delegate", "org/jetbrains/kotlin/idea/stubindex/JetSourceFilterScope", "<init>"));
        }
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "org/jetbrains/kotlin/idea/stubindex/JetSourceFilterScope", "<init>"));
        }
        super(delegate2);
        this.project = project;
        this.includeProjectSourceFiles = includeProjectSourceFiles;
        this.includeLibrarySourceFiles = includeLibrarySourceFiles;
        this.includeClassFiles = includeClassFiles;
        this.index = ProjectRootManager.getInstance((Project)project).getFileIndex();
        this.isJsProject = JsProjectDetector.isJsProject(project);
    }

    public Project getProject() {
        return this.project;
    }

    public boolean contains(@NotNull VirtualFile file) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "org/jetbrains/kotlin/idea/stubindex/JetSourceFilterScope", "contains"));
        }
        if (!super.contains(file)) {
            return false;
        }
        return ProjectRootsUtil.isInContent(this.project, file, this.includeProjectSourceFiles, this.includeLibrarySourceFiles, this.includeClassFiles, this.index, this.isJsProject);
    }
}

