/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.util.psi.patternMatching;

import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiElement;
import java.util.Collections;
import java.util.List;
import kotlin.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.KotlinClass;
import kotlin.jvm.internal.Reflection;
import kotlin.reflect.KClass;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.idea.util.psi.patternMatching.JetPsiRange$$TImpl;
import org.jetbrains.kotlin.idea.util.psi.patternMatching.JetPsiUnifier;
import org.jetbrains.kotlin.idea.util.psi.patternMatching.UnificationResult;

@KotlinClass(version={0, 25, 0}, abiVersion=25, data={"\"\u0006)Y!*\u001a;Qg&\u0014\u0016M\\4f\u0015\ry'o\u001a\u0006\nU\u0016$(M]1j]NTaa[8uY&t'\u0002B5eK\u0006TA!\u001e;jY*\u0019\u0001o]5\u000b\u001fA\fG\u000f^3s]6\u000bGo\u00195j]\u001eT1!\u00118z\u0015!)G.Z7f]R\u001c(\u0002\u0002'jgRT!\u0002U:j\u000b2,W.\u001a8u\u0015\r\u0019w.\u001c\u0006\tS:$X\r\u001c7jU*Yq-\u001a;FY\u0016lWM\u001c;t\u0015\u0011Q\u0017M^1\u000b\u000b\u0015l\u0007\u000f^=\u000b\u000f\t{w\u000e\\3b]*Aq-\u001a;F[B$\u0018P\u0003\u0005d_:$\u0018-\u001b8t\u0015\u001d)G.Z7f]RTAbZ3u)\u0016DHOU1oO\u0016T\u0011\u0002V3yiJ\u000bgnZ3\u000b\u000f=\u0004XM\\1qS*9\u0011n\u001d,bY&$'\"B7bi\u000eD'\"B:d_B,'bB;oS\u001aLWM\u001d\u0006\u000e\u0015\u0016$\bk]5V]&4\u0017.\u001a:\u000b\u000b5\u000bGo\u00195\u000b\u000b\u0015k\u0007\u000f^=\u000b\u00131K7\u000f\u001e*b]\u001e,'6\u0001\u0006\u0003!\u0005QA\u0001\u0003\u0001\u0011\u0005)!\u0001\"\u0001\t\u0004\u0015\u0011A!\u0001\u0005\u0003\u000b\t!\u0019\u0001#\u0002\u0006\u0005\u0011\u0011\u0001bA\u0003\u0003\t\u000bA9!B\u0002\u0005\u0007!\u0001A\u0002A\u0003\u0002\u0011\u0007)1\u0001\u0002\u0003\t\t1\u0001Qa\u0001\u0003\u0005\u0011\u0015a\u0001!B\u0001\t\r\u0015\u0011A1\u0002E\u0007\u000b\t!a\u0001C\u0002\u0006\u0007\u00115\u00012\u0002\u0007\u0001\u000b\u0005Ay!\u0002\u0002\u0005\u0010!\u0015QA\u0001\u0003\t\u0011\u0015)1\u0001\u0002\u0003\t\u00121\u0001QA\u0001C\u0007\u0011\u0017)!\u0001\u0002\u0004\t\u0018\u0015\u0011AA\u0003E\u0003\u000b\r!)\u0002C\u0006\r\u0001\u0015\u0011AQ\u0003\u0005\f\u000b\r!1\u0001\u0003\b\r\u0001\u0015\u0019Aq\u0001E\u000f\u0019\u0001)!\u0001B\u0002\t\u001d\u0011\u0019DrA\r\u0004\u000b\u0005AI\u0001'\u0003\u001e\u0004=}i\"L\t\u0005g\u0012AJ!\t\u0005\u0006\u0003!)\u0011\u0002B\u0005\u0004\u000b\u0005Aq\u0001G\u0004\u0019\u000bU\u001bA!D\u0002\u0005\u000f%\t\u0001\u0012C\u0017\u000e\t-$\u0001\u0004C\u0011\u0004\u000b\u0005A\u0011\u0002G\u0005%WU\u001bA!D\u0002\u0005\u0013%\tA\u0011A\u0017\u0016\t-A\u001a\"h\u0004\u0005\u0001!QQbA\u0003\u0002\u0011\u001dAr\u0001U\u0002\u0001C\r)\u0011\u0001C\u0005\u0019\u0013E\u001bQ\u0001b\u0005\n\u0003\u0011\u0005Q\"\u0001E\n[+!1\u0003'\u0006\"\u0007\u0015\t\u0001b\u0003\r\f#\u000e\u0019AQC\u0005\u0002\u0011/i+\u0002B\u0006\u0019\u0019\u0005\u001aQ!\u0001\u0005\n1%\t6a\u0001\u0003\r\u0013\u0005!\t!,\u0013\u0005\u0017aeQt\u0002\u0003\u0001\u00115i1!B\u0001\t\u000fa9\u0001k\u0001\u0001\u001e\u0010\u0011\u0001\u00012D\u0007\u0004\u000b\u0005AA\u0002\u0007\u0007Q\u0007\u0003\t\u0003\"B\u0001\t\u000b%!\u0011bA\u0003\u0002\u00113AJ\u0002G\u0003R\u0007\u001d!I\"C\u0001\t\u00125\t\u00012C\u0007\u0002\u00115\u0001"})
public interface JetPsiRange {
    public static final /* synthetic */ KClass $kotlinClass;

    static {
        $kotlinClass = Reflection.createKotlinClass(JetPsiRange.class);
    }

    @NotNull
    public List<PsiElement> getElements();

    @NotNull
    public TextRange getTextRange();

    public boolean isValid();

    public boolean getEmpty();

    public boolean contains(@NotNull PsiElement var1);

    @NotNull
    public List<Match> match(@NotNull PsiElement var1, @NotNull JetPsiUnifier var2);

    @KotlinClass(version={0, 25, 0}, abiVersion=25, data={"/\u0004))Q)\u001c9us*Y!*\u001a;Qg&\u0014\u0016M\\4f\u0015\ry'o\u001a\u0006\nU\u0016$(M]1j]NTaa[8uY&t'\u0002B5eK\u0006TA!\u001e;jY*\u0019\u0001o]5\u000b\u001fA\fG\u000f^3s]6\u000bGo\u00195j]\u001eT\u0001\"\u001a7f[\u0016tGo\u001d\u0006\u0005\u0019&\u001cHO\u0003\u0006Qg&,E.Z7f]RT1aY8n\u0015!Ig\u000e^3mY&T'bC4fi\u0016cW-\\3oiNTAA[1wC*aq-\u001a;UKb$(+\u00198hK*IA+\u001a=u%\u0006tw-\u001a\u0006\b_B,g.\u00199j\r\u0007Q!\u0001\u0005\u0002\u000b\t!\u0001\u0001c\u0001\u0006\u0005\u0011\u0005\u0001BA\u0003\u0003\t\u0005A)!\u0002\u0002\u0005\u0004!\u0019QA\u0001\u0003\u0003\u0011\u000f)!\u0001\"\u0002\t\t\u0015\u0019Aa\u0001E\u0001\u0019\u0001)1\u0001b\u0002\t\u00011\u0001Q!\u0001\u0005\u0003\u000b\r!I\u0001C\u0003\r\u0001\u0015\t\u0001BB\u0003\u0003\t\u0017Ai!\u0002\u0002\u0005\r!\u001dQa\u0001C\u0007\u0011\u0017a\u0001!B\u0001\t\u0010\u0015\u0011Aq\u0002\u0005\u0004\u000b\t!\u0001\u0002C\u0003\u0006\u0005\u00111\u0001\"C\u0003\u0003\t%A1!B\u0002\u0005\u0014!EA\u0002A\u0003\u0003\t'A\t\u0002B2\u0002\u0019\u0011I2!B\u0001\t\ba\u001dQF\u0005\u0003l\ta%\u0011\u0005C\u0003\u0002\u0011\u0015IA!C\u0002\u0006\u0003!9\u0001d\u0002\r\u0006I-*6\u0001B\u0007\u0004\t\u001dI\u0011\u0001#\u0005.\u0016\u0011Y\u0001\u0004C\u0011\u0004\u000b\u0005A!\u0002\u0007\u0006R\u0007\r!\u0001\"C\u0001\t\u0016U\u0002\u0001"})
    public static final class Empty
    implements JetPsiRange {
        public static final /* synthetic */ KClass $kotlinClass;
        public static final Empty INSTANCE$;

        static {
            $kotlinClass = Reflection.createKotlinClass(Empty.class);
            new Empty();
        }

        @Override
        @NotNull
        public List<PsiElement> getElements() {
            List<PsiElement> list = Collections.emptyList();
            Intrinsics.checkExpressionValueIsNotNull(list, (String)"Collections.emptyList<PsiElement>()");
            return list;
        }

        @Override
        @NotNull
        public TextRange getTextRange() {
            TextRange textRange = TextRange.EMPTY_RANGE;
            Intrinsics.checkExpressionValueIsNotNull((Object)textRange, (String)"TextRange.EMPTY_RANGE");
            return textRange;
        }

        Empty() {
            INSTANCE$ = this;
        }

        @Override
        public boolean isValid() {
            return JetPsiRange$$TImpl.isValid(this);
        }

        @Override
        public boolean getEmpty() {
            return JetPsiRange$$TImpl.getEmpty(this);
        }

        @Override
        public boolean contains(@NotNull PsiElement element2) {
            Intrinsics.checkParameterIsNotNull((Object)element2, (String)"element");
            return JetPsiRange$$TImpl.contains(this, element2);
        }

        @Override
        @NotNull
        public List<Match> match(@NotNull PsiElement scope2, @NotNull JetPsiUnifier unifier) {
            Intrinsics.checkParameterIsNotNull((Object)scope2, (String)"scope");
            Intrinsics.checkParameterIsNotNull((Object)unifier, (String)"unifier");
            return JetPsiRange$$TImpl.match(this, scope2, unifier);
        }
    }

    @KotlinClass(version={0, 25, 0}, abiVersion=25, data={"u\u0004)IA*[:u%\u0006tw-\u001a\u0006\f\u0015\u0016$\bk]5SC:<WMC\u0002pe\u001eT\u0011B[3uEJ\f\u0017N\\:\u000b\r-|G\u000f\\5o\u0015\u0011IG-Z1\u000b\tU$\u0018\u000e\u001c\u0006\u0004aNL'b\u00049biR,'O\\'bi\u000eD\u0017N\\4\u000b\rqJg.\u001b;?\u0015!)G.Z7f]R\u001c(\u0002\u0002'jgRT!\u0002U:j\u000b2,W.\u001a8u\u0015\r\u0019w.\u001c\u0006\tS:$X\r\u001c7jU*!!.\u0019<b\u0015-9W\r^#mK6,g\u000e^:\u000b\u0015\u0015tG-\u00127f[\u0016tGOC\u0007hKR,e\u000eZ#mK6,g\u000e\u001e\u0006\rgR\f'\u000f^#mK6,g\u000e\u001e\u0006\u0010O\u0016$8\u000b^1si\u0016cW-\\3oi*aq-\u001a;UKb$(+\u00198hK*IA+\u001a=u%\u0006tw-\u001a\u0006\b_B,g.\u00199j\u0019\u0007Q!\u0001\u0005\u0002\u000b\t!\u0001\u0001c\u0001\u0006\u0005\u0011\u0005\u0001BA\u0003\u0003\t\u0005A)!\u0002\u0002\u0005\u0004!\u0019QA\u0001\u0003\u0003\u0011\u000f)!\u0001\"\u0002\t\t\u0015\u0019Aa\u0001E\u0001\u0019\u0001)1\u0001b\u0002\t\u00011\u0001Q!\u0001\u0005\u0003\u000b\r!I\u0001c\u0003\r\u0001\u0015\t\u0001RB\u0003\u0003\t\u0017Aq!\u0002\u0002\u0005\r!\u001dQa\u0001C\u0007\u0011\u0019a\u0001!B\u0001\t\u0010\u0015\u0011Aq\u0002\u0005\u0004\u000b\t!\u0001\u0002c\u0003\u0006\u0005\u00115\u0001BB\u0003\u0003\t\u0019A9\"\u0002\u0002\u0005\u0014!\u0019Qa\u0001\u0003\u000b\u0011-a\u0001!\u0002\u0002\u0005\u0015!YAa\u0001\u0007\u00053\r)\u0011\u0001c\u0002\u0019\b5*Ba\u001b\u0003\u0019\u000b\u0005BQ!\u0001\u0005\u0006\u0013\u0011I1!B\u0001\t\u000fa9\u0001$B+\u0004\u0011\u0015\u0019A!B\u0005\u0002\u0011#i1\u0001\u0002\u0005\n\u0003!EQ\u0006\u0005\u0003d\taE\u0011eA\u0003\u0002\u0011\u001dAr!V\u0002\t\u000b\r!\t\"C\u0001\t\u00135\u0019A!C\u0005\u0002\u0011%i\u0003\u0003B2\u00051'\t3!B\u0001\t\u000fa9Qk\u0001\u0005\u0006\u0007\u0011M\u0011\"\u0001\u0005\n\u001b\r!!\"C\u0001\t\u00135VAa\u0003M\u000bC\r)\u0011\u0001#\u0006\u0019\u0016E\u001b1\u0001\"\u0006\n\u0003!YQwGC\u001b\t\r\b\u0001\u0014BO\r\t\u0001AQ!\u0004\u0005\u0006\u0003!)\u0011\u0002B\u0005\u0004\u000b\u0005Aq\u0001G\u0004\u0019\u000bA\u001b\u0001!I\u0002\u0006\u0003!!\u0001\u0004B)\u0004\u000b\u0011%\u0011\"\u0001\u0003\u0001\u001b\u0005A\t\u0002"})
    public static final class ListRange
    implements JetPsiRange {
        public static final /* synthetic */ KClass $kotlinClass;
        @NotNull
        private final PsiElement startElement;
        @NotNull
        private final PsiElement endElement;
        @NotNull
        private final List<? extends PsiElement> elements;

        static {
            $kotlinClass = Reflection.createKotlinClass(ListRange.class);
        }

        @NotNull
        public final PsiElement getStartElement() {
            return this.startElement;
        }

        @NotNull
        public final PsiElement getEndElement() {
            return this.endElement;
        }

        @Override
        @NotNull
        public TextRange getTextRange() {
            TextRange startRange = this.startElement.getTextRange();
            TextRange endRange = this.endElement.getTextRange();
            if (startRange == null || endRange == null) {
                TextRange textRange = TextRange.EMPTY_RANGE;
                Intrinsics.checkExpressionValueIsNotNull((Object)textRange, (String)"TextRange.EMPTY_RANGE");
                return textRange;
            }
            return new TextRange(startRange.getStartOffset(), endRange.getEndOffset());
        }

        @Override
        @NotNull
        public List<PsiElement> getElements() {
            return this.elements;
        }

        public ListRange(@NotNull List<? extends PsiElement> elements) {
            Intrinsics.checkParameterIsNotNull(elements, (String)"elements");
            this.elements = elements;
            this.startElement = (PsiElement)CollectionsKt.first(this.getElements());
            this.endElement = (PsiElement)CollectionsKt.last(this.getElements());
        }

        @Override
        public boolean isValid() {
            return JetPsiRange$$TImpl.isValid(this);
        }

        @Override
        public boolean getEmpty() {
            return JetPsiRange$$TImpl.getEmpty(this);
        }

        @Override
        public boolean contains(@NotNull PsiElement element2) {
            Intrinsics.checkParameterIsNotNull((Object)element2, (String)"element");
            return JetPsiRange$$TImpl.contains(this, element2);
        }

        @Override
        @NotNull
        public List<Match> match(@NotNull PsiElement scope2, @NotNull JetPsiUnifier unifier) {
            Intrinsics.checkParameterIsNotNull((Object)scope2, (String)"scope");
            Intrinsics.checkParameterIsNotNull((Object)unifier, (String)"unifier");
            return JetPsiRange$$TImpl.match(this, scope2, unifier);
        }
    }

    @KotlinClass(version={0, 25, 0}, abiVersion=25, data={"7\u0004))Q*\u0019;dQ*Y!*\u001a;Qg&\u0014\u0016M\\4f\u0015\ry'o\u001a\u0006\nU\u0016$(M]1j]NTaa[8uY&t'\u0002B5eK\u0006TA!\u001e;jY*\u0019\u0001o]5\u000b\u001fA\fG\u000f^3s]6\u000bGo\u00195j]\u001eT1!\u00118z\u0015\u0019a\u0014N\\5u}))!/\u00198hK*1!/Z:vYRTq!T1uG\",GMC\tV]&4\u0017nY1uS>t'+Z:vYRT\u0011$\u00168jM&\u001c\u0017\r^5p]J+7/\u001e7uI5\u000bGo\u00195fI*Aq-\u001a;SC:<WMC\u0005hKR\u0014Vm];mi\u0002T!\u0001\u0005\u0002\u000b\t!\u0001\u0001c\u0001\u0006\u0005\u0011\u0005\u0001BA\u0003\u0003\t\u0005A)!\u0002\u0002\u0005\u0004!\u0019QA\u0001\u0003\u0003\u0011\u000f)!\u0001\"\u0002\t\t\u0015\u0019Aa\u0001E\u0001\u0019\u0001)1\u0001b\u0002\t\u00011\u0001Q!\u0001\u0005\u0003\u000b\r!I\u0001#\u0003\r\u0001\u0015\u0019Aa\u0001\u0005\b\u0019\u0001)1\u0001b\u0003\t\u000e1\u0001QA\u0001\u0003\u0004\u0011\u0003)!\u0001B\u0002\t\u0010\u0011\u0019A\u0002B\r\u0004\u000b\u0005AQ\u0001G\u0003.!\u0011\u0019G\u0001g\u0003\"\u0007\u0015\t\u0001r\u0001M\u0004+\u000eAQa\u0001C\u0006\u0013\u0005Ai!D\u0002\u0005\u0011%\t\u0001RB\u0017\u0011\t\r$\u0001DB\u0011\u0004\u000b\u0005Aa\u0001\u0007\u0004V\u0007!)1\u0001\u0002\u0004\n\u0003!9Qb\u0001C\t\u0013\u0005Aq!N\u0011\u0006A\u0011\u0019\u000f\u0001G\u0003\u001e\u0010\u0011\u0001\u00012B\u0007\u0004\u000b\u0005A9\u0001g\u0002Q\u0007\u0001iz\u0001\u0002\u0001\t\r5\u0019Q!\u0001\u0005\u00071\u0019\u00016\u0011A\u0011\u0004\u000b\u0005AA\u0001\u0007\u0003R\u0007\u001d!Q!C\u0001\u0005\u00015\t\u0001RB\u0007\u0002\u0011\u001d\u0001"})
    public static final class Match {
        public static final /* synthetic */ KClass $kotlinClass;
        @NotNull
        private final JetPsiRange range;
        @NotNull
        private final UnificationResult.Matched result;

        static {
            $kotlinClass = Reflection.createKotlinClass(Match.class);
        }

        @NotNull
        public final JetPsiRange getRange() {
            return this.range;
        }

        @NotNull
        public final UnificationResult.Matched getResult() {
            return this.result;
        }

        public Match(@NotNull JetPsiRange range, @NotNull UnificationResult.Matched result2) {
            Intrinsics.checkParameterIsNotNull((Object)range, (String)"range");
            Intrinsics.checkParameterIsNotNull((Object)result2, (String)"result");
            this.range = range;
            this.result = result2;
        }
    }
}

