/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.j2k.ast;

import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.KotlinClass;
import kotlin.jvm.internal.Reflection;
import kotlin.reflect.KClass;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.j2k.CodeBuilder;
import org.jetbrains.kotlin.j2k.ast.Annotations;
import org.jetbrains.kotlin.j2k.ast.Block;
import org.jetbrains.kotlin.j2k.ast.DeferredElement;
import org.jetbrains.kotlin.j2k.ast.Function;
import org.jetbrains.kotlin.j2k.ast.FunctionLike;
import org.jetbrains.kotlin.j2k.ast.Identifier;
import org.jetbrains.kotlin.j2k.ast.Modifier;
import org.jetbrains.kotlin.j2k.ast.ModifierKt;
import org.jetbrains.kotlin.j2k.ast.Modifiers;
import org.jetbrains.kotlin.j2k.ast.ParameterList;
import org.jetbrains.kotlin.j2k.ast.Type;
import org.jetbrains.kotlin.j2k.ast.TypeParameterList;
import org.jetbrains.kotlin.j2k.ast.TypesKt;
import org.jetbrains.kotlin.j2k.ast.UtilKt;

@KotlinClass(version={0, 25, 0}, abiVersion=25, data={"\u0012\b)Aa)\u001e8di&|gNC\u0002pe\u001eT\u0011B[3uEJ\f\u0017N\\:\u000b\r-|G\u000f\\5o\u0015\rQ'g\u001b\u0006\u0004CN$(\u0002\u0004$v]\u000e$\u0018n\u001c8MS.,'B\u0002\u001fj]&$hH\u0003\u0003oC6,'BC%eK:$\u0018NZ5fe*Y\u0011M\u001c8pi\u0006$\u0018n\u001c8t\u0015-\teN\\8uCRLwN\\:\u000b\u00135|G-\u001b4jKJ\u001c(\"C'pI&4\u0017.\u001a:t\u0015)\u0011X\r^;s]RK\b/\u001a\u0006\u0005)f\u0004XMC\tusB,\u0007+\u0019:b[\u0016$XM\u001d'jgRT\u0011\u0003V=qKB\u000b'/Y7fi\u0016\u0014H*[:u\u00155\u0001\u0018M]1nKR,'\u000fT5ti*i\u0001+\u0019:b[\u0016$XM\u001d'jgRTAAY8es*yA)\u001a4feJ,G-\u00127f[\u0016tGOC\u0003CY>\u001c7NC\u0007jg&s\u0017J\u001c;fe\u001a\f7-\u001a\u0006\b\u0005>|G.Z1o\u0015\u001d9W\r\u001e(b[\u0016T\u0001cZ3u!\u0006\u0014\u0018-\\3uKJd\u0015n\u001d;\u000b\u001b\u001d,GOU3ukJtG+\u001f9f\u0015Q9W\r\u001e+za\u0016\u0004\u0016M]1nKR,'\u000fT5ti*aq-\u001a8fe\u0006$XmQ8eK*9!-^5mI\u0016\u0014(bC\"pI\u0016\u0014U/\u001b7eKJTA!\u00168ji*)\u0002O]3tK:$\u0018\r^5p]6{G-\u001b4jKJ\u001c\b8\u0001\u0006\u0003!\u0005QA\u0001\u0003\u0001\u0011\u0005)!\u0001\"\u0001\t\u0004\u0015\u0011A!\u0001\u0005\u0003\u000b\t!\u0019\u0001#\u0002\u0006\u0007\u0011\u0011\u0001\u0002\u0001\u0007\u0001\u000b\r!!\u0001C\u0002\r\u0001\u0015\u0019AA\u0001E\u0005\u0019\u0001)1\u0001\u0002\u0002\t\f1\u0001Qa\u0001\u0003\u0003\u0011\u001ba\u0001!B\u0002\u0005\u0005!=A\u0002A\u0003\u0004\t\tA\t\u0002\u0004\u0001\u0006\u0007\u0011\u0011\u00012\u0003\u0007\u0001\u000b\r!!\u0001#\u0006\r\u0001\u0015\u0019AA\u0001\u0005\f\u0019\u0001)\u0011\u0001c\u0001\u0006\u0007\u0011=\u0001\u0002\u0004\u0007\u0001\u000b\t!!\u0001#\u0003\u0006\u0005\u0011\u0011\u00012B\u0003\u0003\t\tAi!\u0002\u0002\u0005\u0005!=QA\u0001\u0003\u0003\u0011#)!\u0001\u0002\u0002\t\u0014\u0015\u0011AA\u0001E\u000b\u000b\r!\u0019\u0001c\b\r\u0001\u0015\u0019Aq\u0002\u0005\u0011\u0019\u0001)!\u0001b\u0001\t \u0011\u0019ARA\r\u0004\u000b\u0005A1\u0001G\u0002.\u0019\u0011\tG\u0001g\u0006\"\u0007\u0015\t\u0001\u0002\u0003\r\t+\u000e!Qa\u0001C\f\u0013\u0005!\t!\f\t\u0005G\u0012AB!I\u0002\u0006\u0003!\u001d\u0001tA+\u0004\u0011\u0015\u0019A\u0001B\u0005\u0002\u0011#i1\u0001\"\u0007\n\u0003!EQ&\u0004\u0003l\taI\u0011eA\u0003\u0002\u0011\u0019Ab\u0001J\u0016V\u0007\u0011i1\u0001B\u0007\n\u0003!YQ\u0006\u0005\u0003d\ta9\u0011eA\u0003\u0002\u0011\u0015AR!V\u0002\t\u000b\r!q!C\u0001\t\u00155\u0019A1D\u0005\u0002\u0011)i\u0003\u0003B2\u00051!\t3!B\u0001\t\fa-Qk\u0001\u0005\u0006\u0007\u0011A\u0011\"\u0001E\u000b\u001b\r!a\"C\u0001\t\u00165*Ba\u0003M\u000f;\u001f!\u0001\u0001C\b\u000e\u0007\u0015\t\u0001\u0002\u0004\r\r!\u000e\u0001\u0011eA\u0003\u0002\u00113AJ\"U\u0002\u0006\t;I\u0011\u0001\u0002\u0001\u000e\u0003!iQV\u0003\u0003\u000b1C\t3!B\u0001\t\na%\u0011kA\u0002\u0005\"%\t\u00012C[g\u0002\u0015)\u000f\u0001Br\u00011\u000fiz\u0001\u0002\u0001\t\t5\u0019Q!\u0001E\u00041\u000f\u00016\u0001AO\b\t\u0001AQ!D\u0002\u0006\u0003!!\u0001\u0004\u0002)\u0004\u0002u=A\u0001\u0001\u0005\u0007\u001b\r)\u0011\u0001#\u0003\u0019\nA\u001b\u0011!h\u0004\u0005\u0001!9QbA\u0003\u0002\u0011\u0015AR\u0001UB\u0002;\u001f!\u0001\u0001\u0003\u0005\u000e\u0007\u0015\t\u00012\u0002M\u0006!\u000e\u0011Qt\u0002\u0003\u0001\u0011%i1!B\u0001\t\ra1\u0001k!\u0002\u001e\u001c\u0011\u0001\u0001BC\u0007\n\u000b\u0005Ai!\u0003\u0003\n\u0007\u0015\t\u0001b\u0002\r\b\u0019\u0003Aj\u0001U\u0002\u0004;\u001f!\u0001\u0001c\u0006\u000e\u0007\u0015\t\u0001\u0002\u0003\r\t!\u000e\u001d\u0011eA\u0003\u0002\u0011\u000bA*!U\u0002\u0014\t\u000fI\u0011\u0001\u0002\u0001\u000e\u0003!EQ\"\u0001\u0005\n\u001b\u0005A\u0019\"D\u0001\t\u00155\t\u0001RC\u0007\u0002\u0011-i\u0011\u0001c\u0006\u000e\u0003\u0011\u0005\u0001"})
public final class Function
extends FunctionLike {
    public static final /* synthetic */ KClass $kotlinClass;
    @NotNull
    private final Identifier name;
    @NotNull
    private final Type returnType;
    @NotNull
    private final TypeParameterList typeParameterList;
    private final boolean isInInterface;

    static {
        $kotlinClass = Reflection.createKotlinClass(Function.class);
    }

    @Override
    @NotNull
    public ParameterList getParameterList() {
        ParameterList parameterList2 = super.getParameterList();
        if (parameterList2 == null) {
            Intrinsics.throwNpe();
        }
        return parameterList2;
    }

    @Override
    @NotNull
    protected Modifiers presentationModifiers() {
        Modifiers modifiers = this.getModifiers();
        if (this.isInInterface) {
            modifiers = modifiers.without(Modifier.ABSTRACT);
        }
        if (modifiers.contains(Modifier.OVERRIDE)) {
            modifiers = ModifierKt.filter(modifiers, (Function1<? super Modifier, ? extends Boolean>)((Function1)presentationModifiers.1.INSTANCE$));
        }
        return modifiers;
    }

    @Override
    public void generateCode(@NotNull CodeBuilder builder) {
        Intrinsics.checkParameterIsNotNull((Object)builder, (String)"builder");
        UtilKt.appendWithSuffix(ModifierKt.appendWithSpaceAfter(builder.append(this.getAnnotations()), this.presentationModifiers()).append("fun "), this.typeParameterList, " ").append(this.name).append("(").append(this.getParameterList()).append(")");
        if (!TypesKt.isUnit(this.returnType)) {
            builder.append(":").append(this.returnType);
        }
        this.typeParameterList.appendWhere(builder);
        if (this.getBody() != null) {
            builder.append(" ").append(this.getBody());
        }
    }

    @NotNull
    public final Identifier getName() {
        return this.name;
    }

    @NotNull
    public final Type getReturnType() {
        return this.returnType;
    }

    @NotNull
    public final TypeParameterList getTypeParameterList() {
        return this.typeParameterList;
    }

    public Function(@NotNull Identifier name2, @NotNull Annotations annotations2, @NotNull Modifiers modifiers, @NotNull Type returnType2, @NotNull TypeParameterList typeParameterList, @NotNull ParameterList parameterList2, @Nullable DeferredElement<Block> body2, boolean isInInterface) {
        Intrinsics.checkParameterIsNotNull((Object)name2, (String)"name");
        Intrinsics.checkParameterIsNotNull((Object)annotations2, (String)"annotations");
        Intrinsics.checkParameterIsNotNull((Object)modifiers, (String)"modifiers");
        Intrinsics.checkParameterIsNotNull((Object)returnType2, (String)"returnType");
        Intrinsics.checkParameterIsNotNull((Object)typeParameterList, (String)"typeParameterList");
        Intrinsics.checkParameterIsNotNull((Object)parameterList2, (String)"parameterList");
        super(annotations2, modifiers, parameterList2, body2);
        this.name = name2;
        this.returnType = returnType2;
        this.typeParameterList = typeParameterList;
        this.isInInterface = isInInterface;
    }
}

